/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.base.impl.FlowInstance;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TradeDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.StdTradeEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TradeEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TradeServiceImpl
implements ITradeService {
    private static Logger logger = LoggerFactory.getLogger(TradeServiceImpl.class);
    @Resource
    private TradeDas tradeDas;

    @Override
    public TradeEo getRootTrade(String tradeNo) {
        TradeEo result = this.getByTradeNo(tradeNo);
        if (result != null) {
            if (result.getTradeNo().equals(result.getRootTradeNo())) {
                return result;
            }
            return this.getByTradeNo(result.getRootTradeNo());
        }
        return null;
    }

    @Override
    public TradeEo getRootTrade(String tradeNo, Long tenantId, Long instanceId) {
        TradeEo result = this.getByTradeNo(tradeNo, tenantId, instanceId);
        if (result != null) {
            if (result.getTradeNo().equals(result.getRootTradeNo())) {
                return result;
            }
            return this.getByTradeNo(result.getRootTradeNo(), tenantId, instanceId);
        }
        return null;
    }

    @Override
    public TradeEo getPayTrade(String rootTradeNo) {
        TradeEo tradeEo = new TradeEo();
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        filters.add(SqlFilter.eq((String)"root_trade_no", (Object)rootTradeNo));
        ArrayList<String> flowTypeCode = new ArrayList<String>();
        flowTypeCode.add("PAY");
        flowTypeCode.add("INTEGRAL_PAY");
        filters.add(SqlFilter.in((String)"flow_type_code", (Object)StringUtils.join(flowTypeCode, (String)",")));
        tradeEo.setSqlFilters(filters);
        List tradeEos = this.tradeDas.select((BaseEo)tradeEo);
        if (tradeEos != null && tradeEos.size() > 0) {
            return (TradeEo)tradeEos.get(0);
        }
        return null;
    }

    @Override
    public List<TradeEo> getChildrenTrade(String tradeNo, String flowTypeCode) {
        TradeEo tradeEo = new TradeEo();
        tradeEo.setParentTradeNo(tradeNo);
        tradeEo.setFlowTypeCode(flowTypeCode);
        return this.tradeDas.select((BaseEo)tradeEo);
    }

    @Override
    public List<TradeEo> getCompChildrenTrade(String tradeNo, String flowTypeCode) {
        TradeEo tradeEo = new TradeEo();
        tradeEo.setParentTradeNo(tradeNo);
        tradeEo.setCompFlowCode(flowTypeCode);
        return this.tradeDas.select((BaseEo)tradeEo);
    }

    @Override
    public List<TradeEo> getChildrenTradeByCompCode(String tradeNo, String compCode) {
        TradeEo tradeEo = new TradeEo();
        tradeEo.setParentTradeNo(tradeNo);
        tradeEo.setCompFlowCode(compCode);
        return this.tradeDas.select((BaseEo)tradeEo);
    }

    @Override
    public List<TradeEo> getChildrenTrade(Set<String> tradeNos, Set<String> flowTypeCodes) {
        TradeEo tradeEo = new TradeEo();
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        filters.add(SqlFilter.in((String)"parent_trade_no", (Object)StringUtils.join(tradeNos, (String)",")));
        filters.add(SqlFilter.in((String)"flow_type_code", (Object)StringUtils.join(flowTypeCodes, (String)",")));
        tradeEo.setSqlFilters(filters);
        List tradeEos = this.tradeDas.select((BaseEo)tradeEo);
        return tradeEos;
    }

    @Override
    public int countChildrenTradeNo(String tradeNo, Set<String> flowTypeCodes) {
        TradeEo tradeEo = new TradeEo();
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        filters.add(SqlFilter.eq((String)"parent_trade_no", (Object)tradeNo));
        filters.add(SqlFilter.in((String)"flow_type_code", (Object)StringUtils.join(flowTypeCodes, (String)",")));
        tradeEo.setSqlFilters(filters);
        return this.tradeDas.count((BaseEo)tradeEo);
    }

    @Override
    public Set<String> getChildrenTradeNosByStatus(String tradeNo, String flowStatus) {
        List<TradeEo> tradeEos = this.getChildrenTradeByStatus(tradeNo, flowStatus);
        if (CollectionUtils.isEmpty(tradeEos)) {
            return null;
        }
        return tradeEos.stream().map(StdTradeEo::getTradeNo).collect(Collectors.toSet());
    }

    @Override
    public List<TradeEo> getChildrenTradeByStatus(String tradeNo, String flowStatus) {
        TradeEo tradeEo = new TradeEo();
        tradeEo.setParentTradeNo(tradeNo);
        tradeEo.setParentStartStatus(flowStatus);
        return this.tradeDas.select((BaseEo)tradeEo);
    }

    @Override
    public int countChildrenTradeNoEnd(String tradeNo, Set<String> flowTypeCodes) {
        TradeEo tradeEo = new TradeEo();
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        filters.add(SqlFilter.eq((String)"parent_trade_no", (Object)tradeNo));
        filters.add(SqlFilter.in((String)"flow_type_code", (Object)StringUtils.join(flowTypeCodes, (String)",")));
        tradeEo.setSqlFilters(filters);
        List tradeEos = this.tradeDas.select((BaseEo)tradeEo);
        int i = 0;
        for (TradeEo subTrade : tradeEos) {
            if (subTrade.getFlowEndTime() != null) continue;
            ++i;
        }
        return i;
    }

    @Override
    public List<TradeEo> getChildrenTrade(String tradeNo, Set<String> flowTypeCodes) {
        TradeEo tradeEo = new TradeEo();
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        filters.add(SqlFilter.eq((String)"parent_trade_no", (Object)tradeNo));
        filters.add(SqlFilter.in((String)"flow_type_code", (Object)StringUtils.join(flowTypeCodes, (String)",")));
        tradeEo.setSqlFilters(filters);
        return this.tradeDas.select((BaseEo)tradeEo);
    }

    @Override
    public Set<String> getChildrenTradeNos(String tradeNo, Set<String> flowTypeCodes) {
        TradeEo tradeEo = new TradeEo();
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        filters.add(SqlFilter.eq((String)"parent_trade_no", (Object)tradeNo));
        filters.add(SqlFilter.in((String)"flow_type_code", (Object)StringUtils.join(flowTypeCodes, (String)",")));
        tradeEo.setSqlFilters(filters);
        List tradeEos = this.tradeDas.select((BaseEo)tradeEo);
        if (CollectionUtils.isNotEmpty((Collection)tradeEos)) {
            return tradeEos.stream().map(StdTradeEo::getTradeNo).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }

    @Override
    public Set<String> getChildrenTradeNosByType(String tradeNo, String type) {
        TradeEo tradeEo = new TradeEo();
        tradeEo.setParentTradeNo(tradeNo);
        tradeEo.setTradeType(type);
        List tradeEos = this.tradeDas.select((BaseEo)tradeEo);
        if (CollectionUtils.isNotEmpty((Collection)tradeEos)) {
            return tradeEos.stream().map(StdTradeEo::getTradeNo).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }

    @Override
    public int countChildrenTradeByType(String tradeNo, String type) {
        TradeEo tradeEo = new TradeEo();
        tradeEo.setParentTradeNo(tradeNo);
        tradeEo.setTradeType(type);
        return this.tradeDas.count((BaseEo)tradeEo);
    }

    @Override
    public Set<String> queryChildrenTradeNosByTradeType(String tradeNo, Set<String> tradeTypeList) {
        TradeEo tradeEo = new TradeEo();
        tradeEo.setParentTradeNo(tradeNo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"trade_type", tradeTypeList));
        tradeEo.setSqlFilters(sqlFilters);
        List tradeEos = this.tradeDas.select((BaseEo)tradeEo);
        if (CollectionUtils.isNotEmpty((Collection)tradeEos)) {
            return tradeEos.stream().map(StdTradeEo::getTradeNo).collect(Collectors.toSet());
        }
        return null;
    }

    @Override
    public Set<String> getChildrenTradeNos(String tradeNo, String flowTypeCode) {
        TradeEo tradeEo = new TradeEo();
        tradeEo.setParentTradeNo(tradeNo);
        tradeEo.setFlowTypeCode(flowTypeCode);
        List tradeEos = this.tradeDas.select((BaseEo)tradeEo);
        if (!CollectionUtils.isEmpty((Collection)tradeEos)) {
            HashSet<String> tradeNos = new HashSet<String>();
            for (TradeEo trade : tradeEos) {
                tradeNos.add(trade.getTradeNo());
            }
            return tradeNos;
        }
        return null;
    }

    @Override
    public String getChildrenTradeNo(String tradeNo, String flowTypeCode) {
        TradeEo tradeEo = new TradeEo();
        tradeEo.setParentTradeNo(tradeNo);
        tradeEo.setFlowTypeCode(flowTypeCode);
        TradeEo tradeResult = (TradeEo)this.tradeDas.selectOne((BaseEo)tradeEo);
        if (tradeResult != null) {
            return tradeResult.getTradeNo();
        }
        return null;
    }

    @Override
    public Set<String> getParentNosByTradeNos(Set<String> tradeNos) {
        TradeEo tradeEo = new TradeEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"trade_no", tradeNos));
        tradeEo.setSqlFilters(sqlFilters);
        List list = this.tradeDas.select((BaseEo)tradeEo);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return list.stream().map(trade -> trade.getParentTradeNo()).collect(Collectors.toSet());
        }
        return null;
    }

    @Override
    public int countChildrenStatus(String tradeNo, String flowTypeCode, String status) {
        TradeEo tradeEo = new TradeEo();
        tradeEo.setParentTradeNo(tradeNo);
        tradeEo.setFlowTypeCode(flowTypeCode);
        tradeEo.setFlowStatus(status);
        return this.tradeDas.count((BaseEo)tradeEo);
    }

    @Override
    public int countChildrenTradeNo(String tradeNo, String flowTypeCode) {
        TradeEo tradeEo = new TradeEo();
        tradeEo.setParentTradeNo(tradeNo);
        tradeEo.setFlowTypeCode(flowTypeCode);
        return this.tradeDas.count((BaseEo)tradeEo);
    }

    @Override
    public int countChildrenTradeNoByComp(String tradeNo, String compCode) {
        TradeEo tradeEo = new TradeEo();
        tradeEo.setParentTradeNo(tradeNo);
        tradeEo.setCompFlowCode(compCode);
        return this.tradeDas.count((BaseEo)tradeEo);
    }

    @Override
    public TradeEo getByTradeNo(String tradeNo) {
        TradeEo tradeEo = new TradeEo();
        ArrayList<SqlFilter> filters = new ArrayList<SqlFilter>();
        filters.add(SqlFilter.eq((String)"trade_no", (Object)tradeNo));
        tradeEo.setSqlFilters(filters);
        TradeEo result = (TradeEo)this.tradeDas.selectOne((BaseEo)tradeEo);
        return result;
    }

    @Override
    public TradeEo getByTradeNo(String tradeNo, Long tenantId, Long instanceId) {
        TradeEo tradeEo = new TradeEo();
        tradeEo.setTradeNo(tradeNo);
        TradeEo result = (TradeEo)this.tradeDas.selectOne((BaseEo)tradeEo);
        return result;
    }

    @Override
    public TradeEo addTrade(TradeEo tradeEo) {
        this.tradeDas.insert((BaseEo)tradeEo);
        return tradeEo;
    }

    @Override
    public void modifyTrade(FlowInstance flowContext, TradeEo tradeEo) {
        this.tradeDas.updateSelective((BaseEo)tradeEo);
    }

    @Override
    public void modifyTradeParentActStatus(Long id, String status) {
        TradeEo tradeEo = new TradeEo();
        tradeEo.setId(id);
        tradeEo.setParentActStatus(status);
        this.tradeDas.updateSelective((BaseEo)tradeEo);
    }

    @Override
    public void modifyTradeContext(FlowInstance flowContext, Long tradeId) {
        TradeEo tradeEo = new TradeEo();
        tradeEo.setId(tradeId);
        this.tradeDas.updateSelective((BaseEo)tradeEo);
    }

    @Override
    public PageInfo<TradeRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        TradeEo tradeEo = (TradeEo)JSON.parseObject((String)filter, TradeEo.class);
        PageInfo pageInfo = this.tradeDas.selectPage((BaseEo)tradeEo, pageNum, pageSize);
        ArrayList tradeRespDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), tradeRespDtoList, TradeRespDto.class);
        pageInfo.setList(tradeRespDtoList);
        return pageInfo;
    }

    @Override
    public List<TradeRespDto> queryByList(String filter) {
        TradeEo tradeEo = (TradeEo)JSON.parseObject((String)filter, TradeEo.class);
        List tradeEos = this.tradeDas.select((BaseEo)tradeEo, false);
        ArrayList<TradeRespDto> tradeRespDtos = new ArrayList<TradeRespDto>();
        DtoHelper.eoList2DtoList((Collection)tradeEos, tradeRespDtos, TradeRespDto.class);
        return tradeRespDtos;
    }

    @Override
    public TradeDetailRespDto queryTradeDetail(String tradeNo, String filter) {
        TradeEo temp = (TradeEo)JSON.parseObject((String)filter, TradeEo.class);
        temp.setTradeNo(tradeNo);
        TradeEo tradeEo = (TradeEo)this.tradeDas.selectOne((BaseEo)temp);
        TradeDetailRespDto tradeDetailRespDto = new TradeDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)tradeEo, (BaseVo)tradeDetailRespDto);
        return tradeDetailRespDto;
    }
}

