/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TrolleyItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TrolleyReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TrolleyItemRepDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITrolleyItemService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITrolleyService;
import com.dtyunxi.yundt.cube.center.trade.biz.util.ObjectUtil;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TrolleyDas;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TrolleyItemDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TrolleyEo;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TrolleyItemEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class TrolleyItemServiceImpl
implements ITrolleyItemService {
    private static Logger logger = LoggerFactory.getLogger(TrolleyItemServiceImpl.class);
    @Resource
    private TrolleyItemDas trolleyItemItemDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ITrolleyService trolleyService;
    @Resource
    private TrolleyDas trolleyDas;

    @Override
    public TrolleyItemEo addTrolleyItem(TrolleyItemEo trolleyItemEo) {
        String cacheKey = ObjectUtil.objectToString(trolleyItemEo);
        boolean isSuccess = this.cacheService.add(cacheKey, (Object)1, 3);
        if (isSuccess) {
            try {
                TrolleyItemEo result;
                TrolleyItemEo queryItem = new TrolleyItemEo();
                queryItem.setTrolleyId(trolleyItemEo.getTrolleyId());
                queryItem.setTenantId(trolleyItemEo.getTenantId());
                queryItem.setInstanceId(trolleyItemEo.getInstanceId());
                queryItem.setItemSrc(trolleyItemEo.getItemSrc());
                queryItem.setGroupKey(trolleyItemEo.getGroupKey());
                queryItem.setItemSerial(trolleyItemEo.getItemSerial());
                queryItem.setSkuSerial(trolleyItemEo.getSkuSerial());
                TrolleyItemEo trolleyItem = (TrolleyItemEo)this.trolleyItemItemDas.selectOne((BaseEo)queryItem);
                if (trolleyItem != null) {
                    result = trolleyItem;
                    TrolleyItemEo updateItem = new TrolleyItemEo();
                    updateItem.setId(result.getId());
                    updateItem.setItemNum(Integer.valueOf(result.getItemNum() + trolleyItemEo.getItemNum()));
                    this.trolleyItemItemDas.updateSelective((BaseEo)updateItem);
                } else {
                    this.trolleyItemItemDas.insert((BaseEo)trolleyItemEo);
                }
                result = (TrolleyItemEo)this.trolleyItemItemDas.selectOne((BaseEo)queryItem);
                this.cacheService.delCache(cacheKey);
                TrolleyItemEo trolleyItemEo2 = result;
                return trolleyItemEo2;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            finally {
                this.cacheService.delCache(cacheKey);
            }
        }
        throw new BizException("\u4f60\u7684\u70b9\u51fb\u6b21\u6570\u592a\u5feb\u4e86");
    }

    @Override
    public void modifyTrolleyItem(TrolleyItemEo trolleyItemEo) {
        if (trolleyItemEo.getItemNum() == null || trolleyItemEo.getItemNum().equals(0)) {
            this.trolleyItemItemDas.deleteById(trolleyItemEo.getId());
        } else {
            this.trolleyItemItemDas.updateSelective((BaseEo)trolleyItemEo);
        }
    }

    @Override
    public PageInfo<TrolleyItemRepDto> queryTrolleyItems(Long trolleyId, Integer pageNum, Integer pageSize) {
        TrolleyItemEo trolleyItemEo = new TrolleyItemEo();
        trolleyItemEo.setTrolleyId(trolleyId);
        PageInfo trolleyItemEoPageInfo = this.trolleyItemItemDas.selectPage((BaseEo)trolleyItemEo, pageNum, pageSize);
        if (trolleyItemEoPageInfo != null) {
            PageInfo trolleyItemRepDtoPageInfo = new PageInfo();
            BeanUtils.copyProperties((Object)trolleyItemEoPageInfo, (Object)trolleyItemRepDtoPageInfo);
            ArrayList trolleyItemRepDtos = new ArrayList();
            if (trolleyItemEoPageInfo.getList() != null) {
                CubeBeanUtils.copyCollection(trolleyItemRepDtos, (Collection)trolleyItemEoPageInfo.getList(), TrolleyItemRepDto.class);
            }
            return trolleyItemRepDtoPageInfo;
        }
        return new PageInfo();
    }

    @Override
    public void removeTrolleyItem(Long id) {
        this.trolleyItemItemDas.deleteById(id);
    }

    @Override
    public List<TrolleyItemRepDto> queryTrolleyItems(TrolleyItemReqDto trolleyItemReqDto) {
        TrolleyItemEo trolleyItemEo = new TrolleyItemEo();
        DtoHelper.dto2Eo((BaseVo)trolleyItemReqDto, (BaseEo)trolleyItemEo);
        List trolleyItemEos = this.trolleyItemItemDas.select((BaseEo)trolleyItemEo);
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)trolleyItemEos, TrolleyItemRepDto.class);
        return list;
    }

    @Override
    public TrolleyItemRepDto queryTrolleyItem(Long id) {
        TrolleyItemRepDto dto = new TrolleyItemRepDto();
        TrolleyItemEo eo = (TrolleyItemEo)this.trolleyItemItemDas.selectByPrimaryKey(id);
        BeanUtils.copyProperties((Object)eo, (Object)dto);
        return dto;
    }

    @Override
    public List<TrolleyItemRepDto> queryTrolleyItems(TrolleyReqDto trolleyReqDto) {
        logger.info("\u67e5\u8be2\u8d2d\u7269\u8f66\u7684\u8bf7\u6c42\u53c2\u6570\u67e5\u8be2trolley\uff1a{}", (Object)JSON.toJSONString((Object)trolleyReqDto));
        logger.info("\u8d2d\u7269\u8f66\u7c7b\u578b={}", (Object)trolleyReqDto.getTrolleyItemType());
        TrolleyEo trolleyEo = new TrolleyEo();
        BeanUtils.copyProperties((Object)trolleyReqDto, (Object)trolleyEo);
        Long trolleyId = this.trolleyService.getTrolleyIdByCache(trolleyEo);
        if (trolleyId == null) {
            return null;
        }
        TrolleyItemReqDto trolleyItemReqDto = new TrolleyItemReqDto();
        trolleyItemReqDto.setTrolleyId(trolleyId);
        trolleyItemReqDto.setType(trolleyReqDto.getTrolleyItemType());
        if (trolleyReqDto.getShopId() != null) {
            trolleyItemReqDto.setGroupKey(String.valueOf(trolleyReqDto.getShopId()));
        }
        logger.info("\u67e5\u8be2\u8d2d\u7269\u8f66\u7684\u8bf7\u6c42\u53c2\u6570\u67e5\u8be2trolleyItem\uff1a{}", (Object)JSON.toJSONString((Object)trolleyItemReqDto));
        return this.queryTrolleyItems(trolleyItemReqDto);
    }

    @Override
    public List<Long> batchAddTrolleyItem(List<TrolleyItemReqDto> trolleyItemList) {
        if (CollectionUtils.isEmpty(trolleyItemList)) {
            return Lists.newArrayList();
        }
        TrolleyItemEo queryParams = new TrolleyItemEo();
        queryParams.setTrolleyId(trolleyItemList.get(0).getTrolleyId());
        queryParams.setTenantId(trolleyItemList.get(0).getTenantId());
        queryParams.setInstanceId(trolleyItemList.get(0).getInstanceId());
        queryParams.setItemSrc(trolleyItemList.get(0).getItemSrc());
        queryParams.setGroupKey(trolleyItemList.get(0).getGroupKey());
        List exitsList = this.trolleyItemItemDas.select((BaseEo)queryParams);
        ArrayList addList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        TrolleyItemEo addEo = null;
        TrolleyItemEo updateEo = null;
        boolean isExist = false;
        for (TrolleyItemReqDto trolleyItemReqDto : trolleyItemList) {
            for (TrolleyItemEo exitsEo : exitsList) {
                if (!Objects.equals(trolleyItemReqDto.getItemSerial(), exitsEo.getItemSerial()) || !Objects.equals(trolleyItemReqDto.getSkuSerial(), exitsEo.getSkuSerial())) continue;
                isExist = true;
                updateEo = new TrolleyItemEo();
                updateEo.setId(exitsEo.getId());
                updateEo.setItemNum(trolleyItemReqDto.getItemNum());
                updateList.add(updateEo);
            }
            if (!isExist) {
                addEo = new TrolleyItemEo();
                BeanUtil.copyProperties((Object)trolleyItemReqDto, (Object)addEo, (String[])new String[0]);
                addList.add(addEo);
            }
            isExist = false;
        }
        logger.info("\u52a0\u8d2d\u7269\u8f66\u6570\u636e\uff1aexitsList = {} --> {}, addList = {} --> {}, updateList = {} --> {}", new Object[]{exitsList.size(), JSONObject.toJSON((Object)exitsList), addList.size(), JSONObject.toJSON((Object)addList), updateList.size(), JSONObject.toJSON((Object)updateList)});
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            this.trolleyItemItemDas.insertBatch((List)addList);
        }
        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
            this.trolleyItemItemDas.updateBatch((List)updateList);
        }
        List list = this.trolleyItemItemDas.select((BaseEo)queryParams);
        logger.info("\u52a0\u8d2d\u7269\u8f66\u6570\u636e\u8fd4\u56de: list = {}", JSONObject.toJSON((Object)list));
        return list.stream().map(s -> s.getId()).collect(Collectors.toList());
    }

    @Override
    public void batchRemoveTrolleyItem(List<Long> ids) {
        this.trolleyItemItemDas.deleteBatch(ids);
        this.trolleyItemItemDas.removeCache(ids.stream().collect(Collectors.toSet()));
    }
}

