/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TrolleyRepDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.TradeExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITrolleyService;
import com.dtyunxi.yundt.cube.center.trade.dao.das.TrolleyDas;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.TrolleyEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TrolleyServiceImpl
implements ITrolleyService {
    private static Logger logger = LoggerFactory.getLogger(TrolleyServiceImpl.class);
    @Resource
    private TrolleyDas trolleyDas;
    private static final String CACHE_TROLLEY_ID_PREFIX = "TROLLEY_ID";

    @Override
    public Long addTrolley(TrolleyEo trolley) {
        TrolleyEo result = (TrolleyEo)this.trolleyDas.selectOne((BaseEo)trolley);
        if (result != null) {
            throw new BizException(TradeExceptionCode.TROLLEY_EXIST_FAIL.getCode(), TradeExceptionCode.TROLLEY_EXIST_FAIL.getMsg());
        }
        this.trolleyDas.insert((BaseEo)trolley);
        return trolley.getId();
    }

    @Override
    public TrolleyEo get(TrolleyEo trolley) {
        return (TrolleyEo)this.trolleyDas.selectOne((BaseEo)trolley);
    }

    @Override
    @Cacheable(value={"TROLLEY_ID"}, key="#trolleyEo.userSrc +'_'+ #trolleyEo.userSerial + '_'+#trolleyEo.trolleyType", unless="#result == null")
    public Long getTrolleyIdByCache(TrolleyEo trolleyEo) {
        List select = this.trolleyDas.select((BaseEo)trolleyEo);
        if (!CollectionUtils.isEmpty((Collection)select)) {
            return ((TrolleyEo)select.get(0)).getId();
        }
        return null;
    }

    @Override
    public TrolleyEo get(TrolleyEo trolley, Integer isCreate) {
        TrolleyEo result = this.get(trolley);
        if (result == null) {
            if (isCreate.equals(1)) {
                this.trolleyDas.insert((BaseEo)trolley);
                TrolleyEo query = TrolleyEo.newInstance();
                query.setId(trolley.getId());
                result = this.get(query);
            }
        } else {
            return result;
        }
        return result;
    }

    @Override
    public List<TrolleyRepDto> getTrolleyList(TrolleyEo trolley, Integer isCreate) {
        List trolleyEos = this.trolleyDas.select((BaseEo)trolley);
        if (CollectionUtils.isEmpty((Collection)trolleyEos) && isCreate.equals(1)) {
            this.trolleyDas.insert((BaseEo)trolley);
            TrolleyEo trolleyEo = this.get(trolley);
            trolleyEos.add(trolleyEo);
        }
        ArrayList<TrolleyRepDto> repDtos = new ArrayList<TrolleyRepDto>();
        DtoHelper.eoList2DtoList((Collection)trolleyEos, repDtos, TrolleyRepDto.class);
        return repDtos;
    }
}

