/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.util;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.trade.ext.api.constants.CouponRangeEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.CalcItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponCategoryEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouponCalcUtil {
    private static Logger logger = LoggerFactory.getLogger(CouponCalcUtil.class);

    public static <T extends CalcItemVo, U extends CouponTemplateExtRespDto> BigDecimal calculate(List<T> items, U couponTemplate) {
        BigDecimal totalAmount = items.stream().map(CalcItemVo::getItemTotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalDiscountAmount = BigDecimal.ZERO;
        BigDecimal couponAmount = BigDecimal.ZERO;
        for (CalcItemVo itemVo : items) {
            BigDecimal itemNum = BigDecimal.valueOf(itemVo.getNum());
            BigDecimal skuTotalAmount = itemVo.getItemTotalAmount();
            BigDecimal shareAmount = BigDecimal.ZERO;
            BigDecimal actualAmount = BigDecimal.ZERO;
            if (CouponCategoryEnum.QUOTA_CASH.getCategory().equals(couponTemplate.getCouponCategory())) {
                BigDecimal rate = skuTotalAmount.divide(totalAmount, 4, 1);
                shareAmount = rate.multiply(couponTemplate.getCouponValue()).setScale(2, 1);
                couponAmount = couponTemplate.getCouponValue();
            } else if (CouponCategoryEnum.DISCOUNT.getCategory().equals(couponTemplate.getCouponCategory())) {
                BigDecimal discountRate = BigDecimal.ONE.subtract(couponTemplate.getCouponValue().divide(BigDecimal.TEN, 4, 1));
                shareAmount = skuTotalAmount.multiply(discountRate).setScale(2, 1);
                couponAmount = couponAmount.add(shareAmount);
            } else {
                throw new BizException("\u4e0d\u652f\u6301\u7684\u4f18\u60e0\u7c7b\u578b\uff01");
            }
            BigDecimal eachShareAmount = shareAmount.divide(itemNum, 2, 1);
            actualAmount = eachShareAmount.multiply(itemNum);
            BigDecimal discountPrice = itemVo.getPrice().subtract(eachShareAmount);
            if (BigDecimal.ZERO.compareTo(discountPrice) == 1) {
                discountPrice = BigDecimal.ZERO;
                actualAmount = itemVo.getPrice().multiply(itemNum);
            }
            itemVo.setDiscountPrice(discountPrice);
            if (CouponRangeEnum.PLATFORM.getKey().equals(couponTemplate.getCouponRange())) {
                itemVo.setPlatformDiscountAmount(actualAmount);
            } else {
                itemVo.setShopDiscountAmount(actualAmount);
            }
            totalDiscountAmount = totalDiscountAmount.add(actualAmount);
        }
        if (couponAmount.compareTo(totalDiscountAmount) == 1) {
            CalcItemVo marginItemVo = items.stream().sorted(Comparator.comparing(CalcItemVo::getItemTotalAmount).reversed()).findFirst().get();
            BigDecimal discountAmount = null;
            BigDecimal marginAmount = couponAmount.subtract(totalDiscountAmount);
            if (CouponRangeEnum.PLATFORM.getKey().equals(couponTemplate.getCouponRange())) {
                BigDecimal platformAmount = marginItemVo.getPlatformDiscountAmount();
                discountAmount = platformAmount == null ? marginAmount : platformAmount.add(marginAmount);
                marginItemVo.setPlatformDiscountAmount(discountAmount);
            } else {
                BigDecimal shopAmount = marginItemVo.getShopDiscountAmount();
                discountAmount = shopAmount == null ? marginAmount : shopAmount.add(marginAmount);
                marginItemVo.setShopDiscountAmount(discountAmount);
            }
            logger.info("\u4f18\u60e0\u5dee\u989d={}\uff0c\u8ffd\u52a0\u5230sku={}", (Object)marginAmount, (Object)marginItemVo.getSkuId());
            totalDiscountAmount = couponAmount;
            BigDecimal price = marginItemVo.getItemTotalAmount().subtract(discountAmount).divide(BigDecimal.valueOf(marginItemVo.getNum()), 2, 1);
            marginItemVo.setDiscountPrice(price);
        }
        logger.info("\u4f18\u60e0\u5238\u540d\u79f0\uff1a{}\uff0c\u4f18\u60e0\u91d1\u989d:{}", (Object)couponTemplate.getCouponName(), (Object)totalDiscountAmount);
        return totalDiscountAmount;
    }

    public static void main(String[] args) {
        ArrayList items = Lists.newArrayList();
        CalcItemVo itemVo = new CalcItemVo();
        itemVo.setPrice(BigDecimal.valueOf(5L));
        itemVo.setItemTotalAmount(BigDecimal.valueOf(15L));
        itemVo.setNum(3);
        itemVo.setSkuId("1");
        itemVo.setItemId("1");
        items.add(itemVo);
        CalcItemVo itemVo2 = new CalcItemVo();
        itemVo2 = new CalcItemVo();
        itemVo2.setPrice(BigDecimal.valueOf(4L));
        itemVo2.setItemTotalAmount(BigDecimal.valueOf(8L));
        itemVo2.setNum(2);
        itemVo2.setSkuId("2");
        itemVo2.setItemId("2");
        items.add(itemVo2);
        CouponTemplateExtRespDto couponTemplate = new CouponTemplateExtRespDto();
        couponTemplate.setCouponCategory(CouponCategoryEnum.QUOTA_CASH.getCategory());
        couponTemplate.setCouponRange(CouponRangeEnum.SELLER.getKey());
        couponTemplate.setCouponValue(BigDecimal.valueOf(10L));
        CouponCalcUtil.calculate(items, couponTemplate);
    }
}

