/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.biz.util;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.dada.DaDaOrderCallbackReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.dada.DaDaReqDto;
import com.dtyunxi.yundt.cube.center.trade.biz.util.DtoUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaDaSignUtils {
    private static Logger logger = LoggerFactory.getLogger(DaDaSignUtils.class);

    private static Map<String, String> generateParams(String appKey, String sourceId, Object body) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", appKey);
        params.put("timestamp", System.currentTimeMillis() / 1000L + "");
        params.put("format", "json");
        params.put("v", "1.0");
        params.put("source_id", sourceId);
        if (body == null) {
            params.put("body", "");
        } else {
            params.put("body", JSONObject.toJSONString((Object)body));
        }
        return params;
    }

    public static DaDaReqDto generateReqDto(String appKey, String appSecret, String sourceId, Object body) {
        Map<String, String> params = DaDaSignUtils.generateParams(appKey, sourceId, body);
        Map<String, String> sortMap = DaDaSignUtils.sortStringMapByKey(params);
        String signStr = DaDaSignUtils.covertToStringAppendAppSecret(appSecret, sortMap);
        String sign = DigestUtils.md5Hex((String)signStr).toUpperCase();
        params.put("signature", sign);
        HashMap<String, Object> covertParams = new HashMap<String, Object>();
        covertParams.putAll(params);
        return (DaDaReqDto)DtoUtils.populate(covertParams, DaDaReqDto.class);
    }

    public static Map<String, String> sortStringMapByKey(Map<String, String> params) {
        ArrayList keys = Lists.newArrayList(params.keySet());
        Collections.sort(keys);
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (String key : keys) {
            result.put(key, params.get(key));
        }
        return result;
    }

    public static String covertToStringAppendAppSecret(String appSecret, Map<String, String> sortMap) {
        StringBuilder builder = new StringBuilder();
        builder.append(appSecret);
        for (Map.Entry<String, String> entry : sortMap.entrySet()) {
            builder.append(entry.getKey());
            builder.append(entry.getValue());
        }
        builder.append(appSecret);
        return builder.toString();
    }

    public static boolean validCallbackSignature(DaDaOrderCallbackReqDto callbackDto) {
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.add(callbackDto.getClient_id());
        valueList.add(callbackDto.getOrder_id());
        valueList.add(callbackDto.getUpdate_time() + "");
        Collections.sort(valueList);
        StringBuilder builder = new StringBuilder();
        for (String value : valueList) {
            builder.append(value);
        }
        String sign = DigestUtils.md5Hex((String)builder.toString());
        logger.info("\u751f\u6210\u7684\u7b7e\u540d\u4e3a\uff1a{}\uff0c\u53c2\u6570\u4e2d\u4f20\u8fc7\u6765\u7684\u7b7e\u540d\u503c\u4e3a\uff1a{}", (Object)sign, (Object)callbackDto.getSignature());
        return sign.equals(callbackDto.getSignature());
    }
}

