/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.engine;

import com.dtyunxi.yundt.cube.center.trade.engine.ActionNodeConvertInfo;
import com.dtyunxi.yundt.cube.center.trade.engine.ActionNodeService;
import com.dtyunxi.yundt.cube.center.trade.engine.TradeEngine;
import com.dtyunxi.yundt.cube.center.trade.engine.TradeEngineUtil;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ActionNodeAfterReturnAspect {
    private static Logger logger = LoggerFactory.getLogger(ActionNodeAfterReturnAspect.class);
    @Autowired
    private ActionNodeService actionNodeService;

    @Pointcut(value="@annotation(com.dtyunxi.cube.enhance.flow.ActionNode)")
    private void actionNodeMethodPointCut() {
    }

    @AfterReturning(value="actionNodeMethodPointCut()", returning="actionResp")
    public void afterReturning(JoinPoint jp, Object actionResp) {
        logger.info("\u6d41\u7a0bid={} \u8fdb\u5165\u5207\u9762", (Object)TradeEngineUtil.getFLowDefId());
        String actionNodeName = jp.getSignature().getDeclaringTypeName() + "#" + jp.getSignature().getName();
        if (actionResp == null) {
            logger.info("\u5904\u7406\u8282\u70b9{},\u54cd\u5e94\u4e3anull\u6216\u7f3a\u5c11\u5355\u636e\u4fe1\u606f,\u8df3\u8fc7\u6d41\u7a0b\u7684\u81ea\u52a8\u8c03\u7528", (Object)actionNodeName);
        } else {
            List<ActionNodeConvertInfo> autoActionList = this.actionNodeService.findActionNodeConvert(TradeEngineUtil.getFLowDefId(), actionNodeName, TradeEngineUtil.getFlowCurrentActionResult());
            logger.info("\u6d41\u7a0bid={}\u67e5\u8be2\u8f6c\u6362\u5668\u5217\u8868{}", (Object)TradeEngineUtil.getFLowDefId(), autoActionList);
            TradeEngine.autoProcess(actionResp, actionNodeName, autoActionList);
        }
    }
}

