/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.engine;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.enhance.flow.IFlowEntity;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.dao.eo.OrderEo;
import java.lang.reflect.Method;

public class TradeEngineUtil {
    public static String FLOW_ID_HEADER = "cube-flow-id";
    public static String FLOW_CURRENT_ACTION_RESULT = "FLOW_CURRENT_ACTION_RESULT";
    public static String FLOW_ENTITY = "FLOW_ENTITY";

    public static Method getMethod(String className, String methodName) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Method method = null;
        for (Method declaredMethod : clazz.getDeclaredMethods()) {
            if (!declaredMethod.getName().equals(methodName)) continue;
            method = declaredMethod;
            break;
        }
        return method;
    }

    public static boolean runWithV3engine(BaseVo input) {
        Object flowId = ServiceContext.getContext().get(FLOW_ID_HEADER);
        return flowId != null;
    }

    public static boolean runWithV3engine(String orderNo, IOrderService orderService) {
        OrderEo orderEo = orderService.getByOrderNo(orderNo);
        return orderEo != null && orderEo.getFlowDefId() != null;
    }

    public static Long getFLowDefId() {
        Long flowId = (Long)ServiceContext.getContext().get(FLOW_ID_HEADER);
        if (flowId == null && TradeEngineUtil.getFlowEntity() != null) {
            flowId = TradeEngineUtil.getFlowEntity().getFlowDefId();
        }
        return flowId;
    }

    public static void setFlowDefId(long flowDefId) {
        ServiceContext.getContext().set(FLOW_ID_HEADER, (Object)flowDefId);
    }

    public static String getFlowCurrentActionResult() {
        String result = (String)ServiceContext.getContext().get(FLOW_CURRENT_ACTION_RESULT);
        if (result == null) {
            return "succ";
        }
        return result;
    }

    public static void setFlowCurrentActionResult(String result) {
        ServiceContext.getContext().set(FLOW_CURRENT_ACTION_RESULT, (Object)result);
    }

    public static IFlowEntity getFlowEntity() {
        Object flowEntity = ServiceContext.getContext().get(FLOW_ENTITY);
        if (flowEntity == null) {
            return null;
        }
        return (IFlowEntity)flowEntity;
    }

    public static void setFlowEntity(IFlowEntity flowEntity) {
        ServiceContext.getContext().set(FLOW_ENTITY, (Object)flowEntity);
    }
}

