/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.ext.biz.apiimpl;

import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.tob.AuditTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.constants.OrderDeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.OrderBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.OrderDeliveryCompleteBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.dto.OrderDeliveryConfirmBo;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.AuditOrderFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.DeliveryFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.OrderFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.extl.IExtlOrderDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.ext.api.IOrderBizApi;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.OrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.OrderDeliveryExtReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.response.DeliveryOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IOrderCreateActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.IOrderDeliveryCreateActionExtPt;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderAuditBo;
import com.dtyunxi.yundt.cube.center.trade.ext.order.domain.OrderRefactorBo;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="orderBizApiImpl")
public class IOrderBizApiImpl
implements IOrderBizApi {
    @Autowired
    IExtlOrderDeliveryService extlOrderDeliveryService;
    @Resource
    AuditOrderFlowAction auditOrderFlowAction;
    @Resource
    private OrderFlowAction orderFlowAction;
    @Resource
    private DeliveryFlowAction deliveryFlowAction;
    @Resource
    private IOrderDeliveryService orderDeliveryService;
    @CubeResource
    private IOrderCreateActionExtPt orderCreateActionExtPt;
    @CubeResource
    private IOrderDeliveryCreateActionExtPt orderDeliveryCreateActionExtPt;

    public RestResponse<DeliveryOrderRespDto> deliveryOrder(String tradeNo, OrderDeliveryExtReqDto orderDelivery) {
        OrderDeliveryCompleteBo orderDeliveryCompleteBo = new OrderDeliveryCompleteBo();
        orderDeliveryCompleteBo.setOrderDeliveryExtReqDto(orderDelivery);
        orderDeliveryCompleteBo.setDriveFlowParam(this.orderCreateActionExtPt.getFlowDefId(), this.orderCreateActionExtPt.getFlowDefName(), tradeNo);
        this.orderFlowAction.deliveryOrder(orderDeliveryCompleteBo);
        DeliveryOrderRespDto deliveryOrderRespDto = new DeliveryOrderRespDto();
        return new RestResponse((Object)deliveryOrderRespDto);
    }

    public RestResponse<Void> confirmOrder(String tradeNo) {
        OrderBo orderBo = new OrderBo();
        orderBo.setOrderNo(tradeNo);
        orderBo.setDriveFlowParam(this.orderCreateActionExtPt.getFlowDefId(), this.orderCreateActionExtPt.getFlowDefName(), tradeNo);
        this.orderFlowAction.receiptOrder(orderBo);
        List orderDeliveryRespDtos = this.orderDeliveryService.queryOrderDeliveryByOrderNo(tradeNo);
        for (OrderDeliveryRespDto orderDeliveryRespDto : orderDeliveryRespDtos) {
            String deliveryStatus = orderDeliveryRespDto.getDeliveryStatus();
            if (OrderDeliveryStatusEnum.SIGNED.getStatus().equals(deliveryStatus)) continue;
            OrderDeliveryConfirmBo orderDeliveryConfirmBo = new OrderDeliveryConfirmBo();
            orderDeliveryConfirmBo.setDriveFlowParam(this.orderDeliveryCreateActionExtPt.getFlowDefId(), this.orderDeliveryCreateActionExtPt.getFlowDefName(), orderDeliveryRespDto.getDeliveryNo());
            this.deliveryFlowAction.confirm(orderDeliveryConfirmBo);
        }
        return new RestResponse();
    }

    public RestResponse<Void> completeOrder(String tradeNo, String toStatus) {
        OrderRefactorBo orderBo = new OrderRefactorBo();
        orderBo.setIfOrderComplete(Boolean.valueOf(true));
        orderBo.setDriveFlowParam(this.orderCreateActionExtPt.getFlowDefId(), this.orderCreateActionExtPt.getFlowDefName(), tradeNo);
        this.orderFlowAction.completeOrder(orderBo);
        return new RestResponse();
    }

    public RestResponse<Void> auditOrder(String tradeNo, OrderAuditReqDto orderAuditReqDto) {
        OrderAuditBo orderAuditBo = new OrderAuditBo();
        orderAuditBo.setOrderAuditReqDto(orderAuditReqDto);
        orderAuditBo.setDriveFlowParam(this.orderCreateActionExtPt.getFlowDefId(), this.orderCreateActionExtPt.getFlowDefName(), orderAuditReqDto.getTradeNo());
        if (StringUtils.isEmpty((CharSequence)orderAuditReqDto.getAuditType()) || AuditTypeEnum.CS_AUDIT.getType().equals(orderAuditReqDto.getAuditType())) {
            this.auditOrderFlowAction.auditOrder(orderAuditBo);
            this.auditOrderFlowAction.changeOrderDeliveryType(orderAuditBo);
        }
        if (AuditTypeEnum.FINANCE_AUDIT.getType().equals(orderAuditReqDto.getAuditType())) {
            this.auditOrderFlowAction.auditFinanceOrder(orderAuditBo);
        }
        if (AuditTypeEnum.ORDER_REFUND_AUDIT.getType().equals(orderAuditReqDto.getAuditType())) {
            this.auditOrderFlowAction.orderReturnAudit(orderAuditBo);
        }
        if (AuditTypeEnum.ORDER_CS_REFUND_AUDIT.getType().equals(orderAuditReqDto.getAuditType())) {
            this.auditOrderFlowAction.orderCsReturnAudit(orderAuditBo);
        }
        return new RestResponse();
    }
}

