/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.ext.biz.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderCountTobRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.biz.apiimpl.PayApiImpl;
import com.dtyunxi.yundt.cube.center.trade.biz.flow.newaction.PayNotifyFlowAction;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderActivityService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderDeliveryService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IOrderService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IPayService;
import com.dtyunxi.yundt.cube.center.trade.biz.service.ITradeItemService;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.CountItemSalesReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.response.CountItemSalesRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.response.OrderBizRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.enums.OrderQueryEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="orderQueryBizApiImpl")
public class OrderQueryBizApiImpl
implements IOrderBizQueryApi {
    private static Logger logger = LoggerFactory.getLogger(OrderQueryBizApiImpl.class);
    @Resource(name="orderQueryApiImpl")
    private IOrderQueryApi orderQueryApi;
    @Resource
    private IOrderDeliveryService orderDeliveryService;
    @Resource
    private ITradeItemService tradeItemService;
    @Resource
    private IOrderActivityService orderActivityService;
    @Resource(name="orderServiceImpl")
    private IOrderService orderService;
    @Resource
    private IPayService payService;
    @Resource
    private PayNotifyFlowAction payNotifyFlowAction;
    @Resource
    private PayApiImpl payApiImpl;

    public RestResponse<OrderDetailRespDto> getOrderDetail(String tradeNo) {
        logger.info("===\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5===");
        OrderDetailRespDto orderDetailRespDto = this.orderService.getDetail(tradeNo, OrderQueryEnum.ALL.name());
        if (null == orderDetailRespDto) {
            return new RestResponse();
        }
        if (orderDetailRespDto.getOrderTradeStatus().equals("CANCEL")) {
            logger.info("\u8ba2\u5355\u53f7tradeNo={}\u51fa\u73b0\u53d6\u6d88\u8ba2\u5355\uff0c\u9700\u8981\u4fee\u6b63\u4ee3\u7801", (Object)tradeNo);
        }
        return new RestResponse((Object)orderDetailRespDto);
    }

    public RestResponse<List<OrderBizRespDto>> queryAllList(String filter) {
        RestResponse restResponse = this.orderQueryApi.queryAllList(filter);
        if (restResponse.getData() == null) {
            return new RestResponse(null);
        }
        ArrayList bizRespDtos = new ArrayList();
        CubeBeanUtils.copyCollection(bizRespDtos, (Collection)((Collection)restResponse.getData()), OrderBizRespDto.class);
        return new RestResponse(bizRespDtos);
    }

    public RestResponse<List<OrderBizRespDto>> queryList(Long tenantId, Long instanceId, String userSrc, String userId, String bizStatus) {
        RestResponse restResponse = this.orderQueryApi.queryList(tenantId, instanceId, userSrc, userId, bizStatus);
        if (restResponse.getData() == null) {
            return new RestResponse(null);
        }
        ArrayList bizRespDtos = new ArrayList();
        CubeBeanUtils.copyCollection(bizRespDtos, (Collection)((Collection)restResponse.getData()), OrderBizRespDto.class);
        return new RestResponse(bizRespDtos);
    }

    public RestResponse<PageInfo<OrderBizRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        OrderQueryReqDto orderQueryReq = (OrderQueryReqDto)JSON.parseObject((String)filter, OrderQueryReqDto.class);
        return new RestResponse((Object)this.orderService.queryByPageForBizResp(orderQueryReq, pageNum, pageSize));
    }

    public RestResponse<PageInfo<OrderBizRespDto>> queryByPageOnPost(OrderQueryReqDto orderQueryReq, Integer pageNum, Integer pageSize) {
        return new RestResponse((Object)this.orderService.queryByPageForBizResp(orderQueryReq, pageNum, pageSize));
    }

    public RestResponse<OrderCountTobRespDto> queryByPageOnPostCount(OrderQueryReqDto orderQueryReq) {
        return new RestResponse((Object)this.orderService.queryByPageOnPostCount(orderQueryReq));
    }

    public RestResponse<List<OrderBizRespDto>> queryExportByPage(String filter, Long maxOrderId, Integer pageSize) {
        OrderQueryReqDto orderQueryReq = (OrderQueryReqDto)JSON.parseObject((String)filter, OrderQueryReqDto.class);
        return new RestResponse((Object)this.orderService.queryByPageForExportBizResp(orderQueryReq, maxOrderId, pageSize));
    }

    public RestResponse<List<CountItemSalesRespDto>> countItemSales(String filter) {
        CountItemSalesReqDto countItemSalesReqDto = (CountItemSalesReqDto)JSON.parseObject((String)filter, CountItemSalesReqDto.class);
        return new RestResponse((Object)this.tradeItemService.countItemSales(countItemSalesReqDto));
    }

    public RestResponse<List<CountItemSalesRespDto>> countItemSalesForUser(String filter) {
        CountItemSalesReqDto countItemSalesReqDto = (CountItemSalesReqDto)JSON.parseObject((String)filter, CountItemSalesReqDto.class);
        return new RestResponse((Object)this.tradeItemService.countItemSalesForUser(countItemSalesReqDto));
    }

    public RestResponse<OrderDetailRespDto> getOrderDetail(String tradeNo, String attrs) {
        OrderDetailRespDto orderDetailRespDto = this.orderService.getDetail(tradeNo, attrs);
        if (null == orderDetailRespDto) {
            return new RestResponse();
        }
        return new RestResponse((Object)orderDetailRespDto);
    }
}

