/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.ext.biz.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.biz.service.IProblemOrderService;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.response.OrderBizRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.enums.OrderQueryEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IProblemOrderBizQueryApi;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProblemOrderQueryBizApiImpl
implements IProblemOrderBizQueryApi {
    private static Logger logger = LoggerFactory.getLogger(ProblemOrderQueryBizApiImpl.class);
    @Autowired
    private IProblemOrderService problemOrderService;

    public RestResponse<PageInfo<OrderBizRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        OrderQueryReqDto orderQueryReq = (OrderQueryReqDto)JSON.parseObject((String)filter, OrderQueryReqDto.class);
        return new RestResponse((Object)this.problemOrderService.queryByPageForBizResp(orderQueryReq, pageNum, pageSize));
    }

    public RestResponse<OrderDetailRespDto> getOrderDetail(String tradeNo) {
        logger.info("===\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5===");
        OrderDetailRespDto orderDetailRespDto = this.problemOrderService.getDetail(tradeNo, OrderQueryEnum.ALL.name());
        if (orderDetailRespDto.getOrderTradeStatus().equals("CANCEL")) {
            logger.info("\u8ba2\u5355\u53f7tradeNo={}\u51fa\u73b0\u53d6\u6d88\u8ba2\u5355\uff0c\u9700\u8981\u4fee\u6b63\u4ee3\u7801", (Object)tradeNo);
        }
        if (null == orderDetailRespDto) {
            return new RestResponse();
        }
        return new RestResponse((Object)orderDetailRespDto);
    }
}

