/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.ext.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderCountTobRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.IOrderBizApi;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.OrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.OrderDeliveryExtReqDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.response.CountItemSalesRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.response.DeliveryOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.response.OrderBizRespDto;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/biz/order"})
public class OrderBizRest
implements IOrderBizQueryApi,
IOrderBizApi {
    private static final Logger logger = LoggerFactory.getLogger(OrderBizRest.class);
    @Resource(name="orderQueryBizApiImpl")
    private IOrderBizQueryApi orderQueryApi;
    @Resource(name="orderBizApiImpl")
    private IOrderBizApi orderBizApi;
    @Resource(name="orderQueryBizApiImpl")
    private IOrderBizQueryApi orderBizQueryApi;

    public RestResponse<List<OrderBizRespDto>> queryList(@NotNull(message="tenantId is not null") @RequestParam(value="tenantId") @NotNull(message="tenantId is not null") Long tenantId, @RequestParam(value="instanceId", required=false) Long instanceId, @RequestParam(value="userSrc", required=false) String userSrc, @RequestParam(value="userId", required=false) String userId, @RequestParam(value="bizStatus", required=false) String bizStatus) {
        return this.orderQueryApi.queryList(tenantId, instanceId, userSrc, userId, bizStatus);
    }

    public RestResponse<List<OrderBizRespDto>> queryAllList(@RequestParam(name="filter") String filter) {
        return this.orderQueryApi.queryAllList(filter);
    }

    public RestResponse<OrderDetailRespDto> getOrderDetail(@PathVariable(value="tradeNo") String tradeNo) {
        return this.orderQueryApi.getOrderDetail(tradeNo);
    }

    public RestResponse<PageInfo<OrderBizRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return this.orderQueryApi.queryByPage(filter, pageNum, pageSize);
    }

    public RestResponse<PageInfo<OrderBizRespDto>> queryByPageOnPost(OrderQueryReqDto orderQueryReq, Integer pageNum, Integer pageSize) {
        return this.orderQueryApi.queryByPageOnPost(orderQueryReq, pageNum, pageSize);
    }

    public RestResponse<OrderCountTobRespDto> queryByPageOnPostCount(OrderQueryReqDto orderQueryReq) {
        return this.orderQueryApi.queryByPageOnPostCount(orderQueryReq);
    }

    public RestResponse<List<OrderBizRespDto>> queryExportByPage(String filter, Long maxOrderId, Integer pageSize) {
        return this.orderQueryApi.queryExportByPage(filter, maxOrderId, pageSize);
    }

    public RestResponse<DeliveryOrderRespDto> deliveryOrder(@PathVariable(value="tradeNo") String tradeNo, @RequestBody OrderDeliveryExtReqDto orderDeliveryExtReqDto) {
        logger.info("\u53d1\u8d27\u4f20\u53c2{}", (Object)orderDeliveryExtReqDto);
        return this.orderBizApi.deliveryOrder(tradeNo, orderDeliveryExtReqDto);
    }

    public RestResponse<Void> confirmOrder(@PathVariable(value="tradeNo") String tradeNo) {
        return this.orderBizApi.confirmOrder(tradeNo);
    }

    public RestResponse<Void> completeOrder(@PathVariable(value="tradeNo") String tradeNo, @RequestParam(value="toStatus") String toStatus) {
        return this.orderBizApi.completeOrder(tradeNo, toStatus);
    }

    public RestResponse<Void> auditOrder(@PathVariable(value="tradeNo") String tradeNo, @RequestBody @Valid OrderAuditReqDto orderAuditReqDto) {
        return this.orderBizApi.auditOrder(tradeNo, orderAuditReqDto);
    }

    public RestResponse<List<CountItemSalesRespDto>> countItemSales(String filter) {
        return this.orderQueryApi.countItemSales(filter);
    }

    public RestResponse<List<CountItemSalesRespDto>> countItemSalesForUser(String filter) {
        return this.orderQueryApi.countItemSalesForUser(filter);
    }

    public RestResponse<OrderDetailRespDto> getOrderDetail(String tradeNo, String attrs) {
        return this.orderBizQueryApi.getOrderDetail(tradeNo, attrs);
    }
}

