/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.svr.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.IOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CancelReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderAddressReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderModReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderPreviewReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderStockBatchDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.RemarkOrderTagsReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TradeItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.DeliverysItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderCountRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderCountTobRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryInfoRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryLogisticRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.order.OrderPreviewRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IOrderQueryApi;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="orderRest")
@RequestMapping(value={"/v1/order"})
public class OrderRest
implements IOrderApi,
IOrderQueryApi {
    @Resource(name="orderApiImpl")
    private IOrderApi orderApi;
    @Resource(name="orderQueryApiImpl")
    private IOrderQueryApi orderQueryApi;

    public RestResponse<String> addOrder(@RequestBody OrderReqDto order) {
        return this.orderApi.addOrder(order);
    }

    public RestResponse<OrderRespDto> addOrderReturnEo(@RequestBody OrderReqDto order) {
        return this.orderApi.addOrderReturnEo(order);
    }

    public RestResponse<String> addVirtualOrder(@RequestBody OrderReqDto order) {
        return this.orderApi.addVirtualOrder(order);
    }

    public RestResponse<Long> addStockBatch(OrderStockBatchDto orderStockBatch) {
        return this.orderApi.addStockBatch(orderStockBatch);
    }

    public RestResponse<Void> logicDeleteOrder(Long orderId) {
        return this.orderApi.logicDeleteOrder(orderId);
    }

    public RestResponse<List<OrderRespDto>> queryAllList(@RequestParam(name="filter") String filter) {
        return this.orderQueryApi.queryAllList(filter);
    }

    public RestResponse<List<TradeItemReqDto>> queryOrderItemsByTradeNo(String orderNo) {
        return this.orderQueryApi.queryOrderItemsByTradeNo(orderNo);
    }

    public RestResponse<List<OrderRespDto>> queryList(@NotNull(message="tenantId is not null") @RequestParam(value="tenantId") @NotNull(message="tenantId is not null") Long tenantId, @RequestParam(value="instanceId", required=false) Long instanceId, @RequestParam(value="userSrc", required=false) String userSrc, @RequestParam(value="userId", required=false) String userId, @RequestParam(value="bizStatus", required=false) String bizStatus) {
        return this.orderQueryApi.queryList(tenantId, instanceId, userSrc, userId, bizStatus);
    }

    public RestResponse<OrderDetailRespDto> getOrderDetail(@PathVariable(value="tradeNo") String tradeNo) {
        return this.orderQueryApi.getOrderDetail(tradeNo);
    }

    public RestResponse<Void> cancelOrder(@PathVariable(value="tradeNo") String tradeNo, @Valid @RequestBody CancelReqDto cancelOrder) {
        return this.orderApi.cancelOrder(tradeNo, cancelOrder);
    }

    public RestResponse<Void> closeOrder(String tradeNo) {
        return this.orderApi.closeOrder(tradeNo);
    }

    public RestResponse<Void> cancelByOrder(@RequestParam(value="orderNo") String orderNo, @Valid @RequestBody CancelReqDto cancelOrder) {
        return this.orderApi.cancelByOrder(orderNo, cancelOrder);
    }

    public RestResponse<Void> confirmOrder(@PathVariable(value="tradeNo") String tradeNo) {
        return this.orderApi.confirmOrder(tradeNo);
    }

    public RestResponse<Void> modifyOrderAddress(@PathVariable(value="tradeNo") String tradeNo, @Valid @RequestBody OrderAddressReqDto deliveryAddress) {
        return this.orderApi.modifyOrderAddress(tradeNo, deliveryAddress);
    }

    public RestResponse<Void> modifyOrderBizStatus(@PathVariable(value="tradeNo") String tradeNo, @PathVariable(value="status") String status) {
        return this.orderApi.modifyOrderBizStatus(tradeNo, status);
    }

    public RestResponse<PageInfo<OrderRespDto>> queryByPage(@RequestParam(name="filter") String filter, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        return this.orderQueryApi.queryByPage(filter, pageNum, pageSize);
    }

    public RestResponse<Void> modifyOrder(@PathVariable(value="tradeNo") String tradeNo, @RequestBody OrderModReqDto order) {
        return this.orderApi.modifyOrder(tradeNo, order);
    }

    public RestResponse<Void> modifyOrderTradeStatus(String tradeNo, String orderNo, String status) {
        return this.orderApi.modifyOrderTradeStatus(tradeNo, orderNo, status);
    }

    public RestResponse<Void> modifyOrderStatus(String orderNo, String status) {
        return this.orderApi.modifyOrderStatus(orderNo, status);
    }

    public RestResponse<Integer> count(String filter) {
        return this.orderQueryApi.count(filter);
    }

    public RestResponse<List<TradeItemRespDto>> countItem(@RequestBody OrderItemReqDto orderItemReqDto) {
        return this.orderQueryApi.countItem(orderItemReqDto);
    }

    public RestResponse<BigDecimal> sumPayAmount(String filter) {
        return this.orderQueryApi.sumPayAmount(filter);
    }

    public RestResponse<Set<String>> queryRefererIdNoReply(String filter) {
        return this.orderQueryApi.queryRefererIdNoReply(filter);
    }

    public RestResponse<OrderPreviewRespDto> previewOrder(@Valid @RequestBody OrderPreviewReqDto order) {
        return this.orderApi.previewOrder(order);
    }

    public RestResponse<OrderPreviewRespDto> previewSeckillOrder(@Valid @RequestBody OrderPreviewReqDto order) {
        return this.orderApi.previewSeckillOrder(order);
    }

    public RestResponse<Boolean> isFirstPurchase(@PathVariable(value="userId") Long userId, @PathVariable(value="tradeNo") String tradeNo) {
        return this.orderQueryApi.isFirstPurchase(userId, tradeNo);
    }

    public RestResponse<OrderCountRespDto> queryOrderCount(String filter) {
        return this.orderQueryApi.queryOrderCount(filter);
    }

    public RestResponse<OrderCountTobRespDto> queryOrderCountTob(String filter) {
        return this.orderQueryApi.queryOrderCountTob(filter);
    }

    public RestResponse<Integer> countUserOrderItem(OrderItemReqDto orderItemReqDto) {
        return this.orderQueryApi.countUserOrderItem(orderItemReqDto);
    }

    public RestResponse<OrderDeliveryInfoRespDto> queryOrderDeliveryInfo(@RequestParam(name="orderNo") String orderNo) {
        return this.orderQueryApi.queryOrderDeliveryInfo(orderNo);
    }

    public RestResponse<String> submitOrder(OrderReqDto orderReq) {
        return this.orderApi.submitOrder(orderReq);
    }

    public RestResponse<List<DeliverysItemRespDto>> queryByDeliveryNoAndSkuSerial(String tradeNo) {
        return this.orderApi.queryByDeliveryNoAndSkuSerial(tradeNo);
    }

    public RestResponse<List<DeliverysItemRespDto>> queryDeliveryItemsByOrderNo(String orderNo) {
        return this.orderQueryApi.queryDeliveryItemsByOrderNo(orderNo);
    }

    public RestResponse<List<OrderDeliveryLogisticRespDto>> queryOrderDeliveryLogistic(String orderNo) {
        return this.orderQueryApi.queryOrderDeliveryLogistic(orderNo);
    }

    public RestResponse<Void> importExcelOrder(String filePath) {
        return this.orderApi.importExcelOrder(filePath);
    }

    public RestResponse<Void> batchRemarkOrderTags(RemarkOrderTagsReqDto remarkOrderTagsReqDto) {
        return this.orderApi.batchRemarkOrderTags(remarkOrderTagsReqDto);
    }

    public RestResponse<Date> getFirstPlaceOrderByCustomerId(Long customerId) {
        return this.orderQueryApi.getFirstPlaceOrderByCustomerId(customerId);
    }

    public RestResponse<Void> clearTradeItemBatch(@PathVariable(value="orderNo") String orderNo) {
        return this.orderApi.clearTradeItemBatch(orderNo);
    }

    public RestResponse<OrderCountTobRespDto> queryOrderCountTobPost(OrderQueryReqDto orderQueryReq) {
        return this.orderQueryApi.queryOrderCountTobPost(orderQueryReq);
    }
}

