/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.svr.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.IPayApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayIntegralOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayMethodReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.RefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.PayRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IPayQueryApi;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/pay"})
public class PayRest
implements IPayApi,
IPayQueryApi {
    @Resource(name="payApiImpl")
    private IPayApi payApi;
    @Resource(name="payQueryApiImpl")
    private IPayQueryApi payQueryApi;

    public String handleNotify(@PathVariable(value="tradeNo") String tradeNo, @PathVariable(value="appKey") String appKey, HttpServletRequest request) {
        return this.payApi.handleNotify(tradeNo, appKey, request);
    }

    public String handleRefundNotify(@PathVariable(value="tradeNo") String tradeNo, @PathVariable(value="appKey") String appKey, HttpServletRequest request) {
        return this.payApi.handleRefundNotify(tradeNo, appKey, request);
    }

    public RestResponse<String> modifyPayMethod(@PathVariable(value="tradeNo") String tradeNo, @RequestBody PayMethodReqDto payMethodReqDto) {
        return this.payApi.modifyPayMethod(tradeNo, payMethodReqDto);
    }

    public RestResponse<String> addOfflinePayRecord(@RequestBody PayMethodReqDto payMethodReqDto) {
        return this.payApi.addOfflinePayRecord(payMethodReqDto);
    }

    public RestResponse<String> addRefund(@RequestBody RefundReqDto refundReqDto) {
        return this.payApi.addRefund(refundReqDto);
    }

    public RestResponse<PayRecordRespDto> queryPayRecordByTradeNo(@PathVariable(value="tradeNo") String tradeNo) {
        return this.payQueryApi.queryPayRecordByTradeNo(tradeNo);
    }

    public RestResponse<PageInfo<PayRecordRespDto>> queryByPage(@RequestParam(name="filter") String filter, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        return this.payQueryApi.queryByPage(filter, pageNum, pageSize);
    }

    public RestResponse<PageInfo<PayRecordRespDto>> queryPayByPage(@RequestParam(name="filter") String filter, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        return this.payQueryApi.queryPayByPage(filter, pageNum, pageSize);
    }

    public RestResponse<Void> payIntegralOrder(@PathVariable(value="tradeNo") String tradeNo, @RequestBody PayIntegralOrderReqDto payIntegralOrderReqDto) {
        return this.payApi.payIntegralOrder(tradeNo, payIntegralOrderReqDto);
    }

    public RestResponse<List<PayRecordRespDto>> queryPayRecordByOrderNo(@PathVariable(value="orderNo") String orderNo, String filter) {
        return this.payQueryApi.queryPayRecordByOrderNo(orderNo, filter);
    }

    public RestResponse modifyPayMethod(@RequestBody PayMethodReqDto payMethodReqDto) {
        return this.payApi.modifyPayMethod(payMethodReqDto);
    }
}

