/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.svr.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.IPickupApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PickupCodeReplyReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PickupCodeUseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.PickupCodeRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.PickupRecordDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.IPickupQueryApi;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/pickup"})
public class PickupRest
implements IPickupApi,
IPickupQueryApi {
    @Resource(name="pickupApi")
    IPickupApi pickupApi;
    @Resource(name="pickupQueryApi")
    IPickupQueryApi pickupQueryApi;

    public RestResponse<Void> pickup(@RequestBody @Valid PickupCodeUseReqDto pickupCodeUseReq) {
        return this.pickupApi.pickup(pickupCodeUseReq);
    }

    public RestResponse<PickupCodeRespDto> pickupRepeat(@RequestBody @Valid PickupCodeReplyReqDto pickupCodeReqDto) {
        return this.pickupApi.pickupRepeat(pickupCodeReqDto);
    }

    public RestResponse<PickupCodeRespDto> queryPickupCodeDetail(@PathVariable(name="pickupCode", required=true) String pickupCode, @RequestParam(name="warehouseSerial", required=true) String warehouseSerial) {
        return this.pickupQueryApi.queryPickupCodeDetail(pickupCode, warehouseSerial);
    }

    public RestResponse<PickupCodeRespDto> queryById(@PathVariable(value="id") Long id, @RequestParam(name="filter") String filter) {
        return this.pickupQueryApi.queryById(id, filter);
    }

    public RestResponse<PageInfo<PickupCodeRespDto>> queryByPage(@RequestParam(name="filter") String filter, @RequestParam(name="pageNum", defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        return this.pickupQueryApi.queryByPage(filter, pageNum, pageSize);
    }

    public RestResponse<PickupRecordDetailRespDto> queryDetailByPickupRecordNo(@PathVariable(value="pickupRecordNo") String pickupRecordNo) {
        return this.pickupQueryApi.queryDetailByPickupRecordNo(pickupRecordNo);
    }

    public RestResponse<List<PickupRecordDetailRespDto>> queryDetailByDeliveryNo(@PathVariable(value="deliveryNo") String deliveryNo) {
        return this.pickupQueryApi.queryDetailByDeliveryNo(deliveryNo);
    }
}

