/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.svr.rest;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.ITrolleyApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TrolleyItemModReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TrolleyItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.TrolleyReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TrolleyItemRepDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TrolleyRepDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ITrolleyQueryApi;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/trolley"})
public class TrolleyRest
implements ITrolleyApi,
ITrolleyQueryApi {
    @Resource(name="trolleyApiImpl")
    private ITrolleyApi trolleyApi;
    @Resource(name="trolleyQueryApiImpl")
    private ITrolleyQueryApi trolleyQueryApi;

    public RestResponse<Long> addTrolley(@RequestBody TrolleyReqDto trolley) {
        return this.trolleyApi.addTrolley(trolley);
    }

    public RestResponse<TrolleyItemRepDto> addTrolleyItem(@RequestBody TrolleyItemReqDto trolleyItem) {
        return this.trolleyApi.addTrolleyItem(trolleyItem);
    }

    public RestResponse<Void> modifyTrolleyItem(@RequestBody TrolleyItemModReqDto trolleyItem) {
        return this.trolleyApi.modifyTrolleyItem(trolleyItem);
    }

    public RestResponse<Void> removeTrolleyItem(@PathVariable(value="id") Long id) {
        return this.trolleyApi.removeTrolleyItem(id);
    }

    public RestResponse<List<Long>> batchAddTrolleyItem(@Valid @RequestBody List<TrolleyItemReqDto> trolleyItemList) {
        return this.trolleyApi.batchAddTrolleyItem(trolleyItemList);
    }

    public RestResponse<Void> batchRemoveTrolleyItem(@Valid @RequestBody List<Long> ids) {
        return this.trolleyApi.batchRemoveTrolleyItem(ids);
    }

    public RestResponse<List<TrolleyRepDto>> getTrolleyList(@RequestParam(name="tenantId") Long tenantId, @RequestParam(name="instanceId", required=false) Long instanceId, @RequestParam(name="userSrc") String userSrc, @RequestParam(name="userSerial") String userSerial, @RequestParam(name="trolleyType") String trolleyType, @RequestParam(name="isCreate") Integer isCreate) {
        return this.trolleyQueryApi.getTrolleyList(tenantId, instanceId, userSrc, userSerial, trolleyType, isCreate);
    }

    public RestResponse<List<TrolleyItemRepDto>> queryTrolleyItems(TrolleyReqDto trolleyReqDto) {
        return this.trolleyQueryApi.queryTrolleyItems(trolleyReqDto);
    }

    public RestResponse<PageInfo<TrolleyItemRepDto>> queryTrolleyItems(@PathVariable(value="trolleyId") Long trolleyId, Integer pageNum, Integer pageSize) {
        return this.trolleyQueryApi.queryTrolleyItems(trolleyId, pageNum, pageSize);
    }

    public RestResponse<TrolleyRepDto> getTrolley(@RequestParam(name="tenantId") Long tenantId, @RequestParam(name="instanceId") Long instanceId, @RequestParam(name="userSrc") String userSrc, @RequestParam(name="userSerial") String userSerial, @RequestParam(name="trolleyType") String trolleyType, @RequestParam(name="isCreate") Integer isCreate) {
        return this.trolleyQueryApi.getTrolley(tenantId, instanceId, userSrc, userSerial, trolleyType, isCreate);
    }

    public RestResponse<List<TrolleyItemRepDto>> queryTrolleyItems(@ModelAttribute(value="trolleyItemReqDto") TrolleyItemReqDto trolleyItemReqDto) {
        return this.trolleyQueryApi.queryTrolleyItems(trolleyItemReqDto);
    }

    public RestResponse<TrolleyItemRepDto> queryTrolleyItem(@RequestParam(value="id") Long id) {
        return this.trolleyQueryApi.queryTrolleyItem(id);
    }
}

