/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.service.impl;

import cn.hutool.core.lang.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.enums.SortOrder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ContactsInfoAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ContactsInfoModifyReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ContactsInfoQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.ContactsInfoRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IContactsInfoService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerExtService;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.ContactsInfoDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.ContactsInfoEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContactsInfoServiceImpl
implements IContactsInfoService {
    @Resource
    private ContactsInfoDas contactsInfoDas;
    @Resource
    private ICustomerExtService customerExtService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addContactsInfo(ContactsInfoAddReqDto reqDto) {
        Assert.notNull((Object)reqDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ContactsInfoEo contactsInfoEo = new ContactsInfoEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)contactsInfoEo);
        this.contactsInfoDas.insert((BaseEo)contactsInfoEo);
        if (null != reqDto.getStatus() && reqDto.getStatus() == 1) {
            this.contactsInfoDas.updateStatusByOrgInfoId(contactsInfoEo.getOrgInfoId(), contactsInfoEo.getId());
        }
        return contactsInfoEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyContactsInfo(ContactsInfoModifyReqDto reqDto) {
        Assert.notNull((Object)reqDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ContactsInfoEo contactsInfoEo = new ContactsInfoEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)contactsInfoEo);
        this.contactsInfoDas.updateSelective((BaseEo)contactsInfoEo);
        if (null != reqDto.getStatus() && reqDto.getStatus() == 1) {
            this.contactsInfoDas.updateStatusByOrgInfoId(contactsInfoEo.getOrgInfoId(), contactsInfoEo.getId());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeContactsInfo(Long id) {
        this.contactsInfoDas.deleteById(id);
    }

    @Override
    public ContactsInfoRespDto queryContactsInfoById(Long id) {
        ContactsInfoEo contactsInfoEo = (ContactsInfoEo)this.contactsInfoDas.selectByPrimaryKey(id);
        if (contactsInfoEo == null) {
            return null;
        }
        ContactsInfoRespDto contactsInfoRespDto = new ContactsInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)contactsInfoEo, (BaseVo)contactsInfoRespDto);
        return contactsInfoRespDto;
    }

    @Override
    public PageInfo<ContactsInfoRespDto> queryContactsInfoByPage(ContactsInfoQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        ContactsInfoEo contactsInfoEo = new ContactsInfoEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)contactsInfoEo);
        contactsInfoEo.addSqlOrderBy("create_time", SortOrder.DESC);
        PageInfo eoPageInfo = this.contactsInfoDas.selectPage((BaseEo)contactsInfoEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ContactsInfoRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ContactsInfoRespDto> queryContactsInfoListByOrgInfoId(Long orgInfoId) {
        ContactsInfoEo contactsInfoEo = new ContactsInfoEo();
        contactsInfoEo.setOrgInfoId(orgInfoId);
        List contactsInfoEoList = this.contactsInfoDas.select((BaseEo)contactsInfoEo);
        ArrayList<ContactsInfoRespDto> contactsInfoDtoList = new ArrayList<ContactsInfoRespDto>();
        DtoHelper.eoList2DtoList((Collection)contactsInfoEoList, contactsInfoDtoList, ContactsInfoRespDto.class);
        return contactsInfoDtoList;
    }
}

