/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.apiimpl.query;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerImportLogSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerImportLogRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerStatusQueryApi;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.apiimpl.ICustomerImportLogQueryService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerStatusService;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerImportLogDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerTypeDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerImportLogEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerImportLogQueryQueryServiceImpl
implements ICustomerImportLogQueryService {
    private final Logger logger = LoggerFactory.getLogger(CustomerImportLogQueryQueryServiceImpl.class);
    @Autowired
    CustomerImportLogDas customerImportLogDas;
    @Autowired
    private CustomerTypeDas customerTypeDas;
    @Resource
    private ICustomerStatusQueryApi customerStatusQueryApi;
    @Autowired
    private ICustomerStatusService customerStatusService;

    @Override
    public PageInfo<CustomerImportLogRespDto> queryMemberImportLogPage(CustomerImportLogSearchReqDto customerImportLogSearchReqDto) {
        ArrayList list = Lists.newArrayList();
        CustomerImportLogEo eo = new CustomerImportLogEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)customerImportLogSearchReqDto.getOperator())) {
            eo.setCreatePerson(customerImportLogSearchReqDto.getOperator());
        }
        eo.setImportType(customerImportLogSearchReqDto.getImportType());
        Integer pageNo = customerImportLogSearchReqDto.getPageNum() == null ? 1 : customerImportLogSearchReqDto.getPageNum();
        Integer size = customerImportLogSearchReqDto.getPageSize() == null ? 10 : customerImportLogSearchReqDto.getPageSize();
        if (!StringUtils.isEmpty((CharSequence)customerImportLogSearchReqDto.getStartTime()) && !StringUtils.isEmpty((CharSequence)customerImportLogSearchReqDto.getEndTime())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date startDate = sdf.parse(customerImportLogSearchReqDto.getStartTime());
                Date endDate = sdf.parse(customerImportLogSearchReqDto.getEndTime());
                sqlFilters.add(SqlFilter.ge((String)"createTime", (Object)sdf.format(startDate)));
                sqlFilters.add(SqlFilter.le((String)"createTime", (Object)sdf.format(endDate)));
                eo.setSqlFilters(sqlFilters);
            }
            catch (Exception e) {
                this.logger.error("\u65f6\u95f4\u8f6c\u6362\u51fa\u9519");
            }
        }
        eo.setOrderByDesc("create_time");
        PageInfo pageInfo = this.customerImportLogDas.selectPage((BaseEo)eo, pageNo, size);
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), (Collection)list, CustomerImportLogRespDto.class);
        PageInfo dtoPageInfo = new PageInfo((List)list);
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        return dtoPageInfo;
    }
}

