/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.dao.customer.das;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchBaseReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CertificationCountRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerNameSimpleRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class CustomerDas
extends AbstractBaseDas<CustomerEo, String> {
    @Resource
    private CustomerMapper customerMapper;

    public PageInfo<CustomerRespDto> queryPageBySearchCon(Integer pageNum, Integer pageSize, CustomerSearchReqDto searchReqDto) {
        pageNum = null == pageNum ? DEFAULT_PAGE_NUMBER : pageNum;
        pageSize = null == pageSize ? DEFAULT_PAGE_SIZE : pageSize;
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List<CustomerRespDto> customerRespDtos = this.customerMapper.queryBySearchCon(searchReqDto);
        return new PageInfo(customerRespDtos);
    }

    public PageInfo<CustomerRespDto> queryPageBySearchConExt(Integer pageNum, Integer pageSize, CustomerSearchReqDto searchReqDto) {
        pageNum = null == pageNum ? DEFAULT_PAGE_NUMBER : pageNum;
        pageSize = null == pageSize ? DEFAULT_PAGE_SIZE : pageSize;
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List<CustomerRespDto> customerRespDtos = this.customerMapper.queryBySearchConExt(searchReqDto);
        return new PageInfo(customerRespDtos);
    }

    public List<CustomerRespDto> queryListBySearchCon(CustomerSearchReqDto searchReqDto) {
        return this.customerMapper.queryBySearchCon(searchReqDto);
    }

    public Integer countByCustomerTypeId(Long customerTypeId) {
        CustomerEo customerEo = new CustomerEo();
        customerEo.setCustomerTypeId(customerTypeId);
        return this.count((BaseEo)customerEo);
    }

    public void updateCustomerByRegionCode(String sourceRegionCode, String targetRegionCode) {
        this.customerMapper.updateCustomerByRegionCode(sourceRegionCode, targetRegionCode);
    }

    public void updateByRegionCodeAndOutCustomerId(String sourceRegionCode, String targetRegionCode, List<Long> outCustomerIds) {
        this.customerMapper.updateByRegionCodeAndOutCustomerId(sourceRegionCode, targetRegionCode, outCustomerIds);
    }

    public Long insertById(CustomerEo customerEo) {
        long id = IdGenrator.getDistributedId();
        customerEo.setId(Long.valueOf(id));
        if (customerEo.getOrgInfoId() == null) {
            customerEo.setOrgInfoId(Long.valueOf(id));
        }
        this.insert((BaseEo)customerEo);
        return id;
    }

    public List<CustomerNameSimpleRespDto> queryListByIds(List<Long> ids) {
        List<CustomerNameSimpleRespDto> customerNameSimpleRespDtos = this.customerMapper.queryListByIds(ids);
        return customerNameSimpleRespDtos;
    }

    public List<CustomerNameSimpleRespDto> queryListByParentIds(List<Long> ids) {
        return this.customerMapper.queryListByParentIds(ids);
    }

    public List<CustomerNameSimpleRespDto> queryListByNotIds(Long instanceId, Long tenantId, List<Long> ids, Integer type, Long merchantId) {
        return this.customerMapper.queryListByNotIds(instanceId, tenantId, ids, type, merchantId);
    }

    public List<Long> queryUpstreamOrgIdsByOrgId(Long userOrgId) {
        return this.customerMapper.queryUpstreamOrgIdsByOrgId(userOrgId);
    }

    public List<Long> queryIdsBySingleFilter(CustomerSearchBaseReqDto customerSearchReqDto) {
        return this.customerMapper.queryIdsBySingleFilter(customerSearchReqDto);
    }

    public List<CustomerRespDto> queryByList(CustomerSearchReqDto searchReqDto) {
        return this.customerMapper.queryByList(searchReqDto);
    }

    public List<CustomerRespDto> queryCustomerByOrgIdAndUpstreamOrgId(Long orgId, Long merchId) {
        List customerEos = this.customerMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_info_id", (Object)orgId)).eq((Object)"merchant_id", (Object)merchId)).eq((Object)"dr", (Object)0));
        return customerEos.stream().map(data -> {
            CustomerRespDto newData = new CustomerRespDto();
            BeanUtils.copyProperties((Object)data, (Object)newData);
            return newData;
        }).collect(Collectors.toList());
    }

    public List<CertificationCountRespDto> queryCertificationCount(CustomerSearchReqDto searchReqDto) {
        List<CertificationCountRespDto> certificationCountRespDtos = this.customerMapper.queryCertificationCount(searchReqDto);
        return certificationCountRespDtos;
    }

    public void updateCertificationDeadline(List<Long> customerIds, Date deadline) {
        this.customerMapper.updateCertificationDeadline(customerIds, deadline);
    }

    public void modifyCustomerUserIdByThirdPartyId(List<CustomerReqDto> reqDtos) {
        this.customerMapper.modifyCustomerUserIdByThirdPartyId(reqDtos);
    }

    public void updateAccountorsDate(List<CustomerEo> eos) {
        this.customerMapper.updateAccountorsDate(eos);
    }

    public void updateCustomerEoByOrgInfoId(CustomerEo customerEo) {
    }

    public void updateCustomerEoByOrgInfoId(Long orgInfoId, Integer status) {
        this.customerMapper.updateCustomerEoByOrgInfoId(orgInfoId, status);
    }

    public List<CustomerRespDto> queryByEffectiveEnd() {
        return this.customerMapper.queryByEffectiveEnd();
    }

    public List<Long> queryRelEmployeeIdsByCustomerId(Long id) {
        return this.customerMapper.queryRelEmployeeIdsByCustomerId(id);
    }

    public List<Long> queryRelEmployeeIdsByUserId(Long id, Long orgId) {
        return this.customerMapper.queryRelEmployeeIdsByUserId(id, orgId);
    }

    public List<Long> queryRelEmployeeIdsByEmpIdsAndIds(List<Long> ids, Long userId) {
        return this.customerMapper.queryRelEmployeeIdsByEmpIdsAndIds(ids, userId);
    }

    public List<CustomerRespDto> queryByEffectiveStart() {
        return this.customerMapper.queryByEffectiveStart();
    }
}

