/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.excel.impl;

import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.constants.ExcelUseTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.BaseExcelDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.ExcelImportDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.ItemSkuPriceLimitQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemSkuPriceInfoRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemSkuPriceLimitRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.constant.PriceExceptionCode;
import com.dtyunxi.yundt.cube.center.price.biz.helper.SkuHelper;
import com.dtyunxi.yundt.cube.center.price.biz.service.IBasePriceApplyItemService;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.IImportSevice;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.impl.BaseImportImpl;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.vo.DealerRetailPriceImportVo;
import com.dtyunxi.yundt.cube.center.price.biz.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DealerRetailPriceImportImpl
extends BaseImportImpl
implements IImportSevice<DealerRetailPriceImportVo> {
    private static final String SHOP_ID = "shopId";
    @Resource
    private SkuHelper skuHelper;
    @Resource
    private IBasePriceApplyItemService basePriceApplyItemService;

    @Override
    public boolean needVerfiy() {
        return Boolean.TRUE;
    }

    @Override
    public Class<DealerRetailPriceImportVo> pojoClass() {
        return DealerRetailPriceImportVo.class;
    }

    @Override
    public ImportParams importParams() {
        ImportParams importParams = new ImportParams();
        importParams.setNeedVerfiy(this.needVerfiy());
        return importParams;
    }

    @Override
    public ExcelUseTypeEnum excelUseType() {
        return ExcelUseTypeEnum.IMPORT_DEALER_RETAIL_PRICE;
    }

    @Override
    public void importData(ExcelImportDto excelImportDto, BaseExcelDto baseExcelDto, List<DealerRetailPriceImportVo> successList, List<DealerRetailPriceImportVo> failList) {
        if (CollUtil.isNotEmpty(failList)) {
            baseExcelDto.setErrorMsgList(this.getErrorList(failList));
            return;
        }
        Long shopId = (Long)excelImportDto.popValue(SHOP_ID, Long.class);
        AssertUtils.isNonNull(shopId, PriceExceptionCode.ERROR.setParamValue("\u5e97\u94faid\u4e3a\u7a7a"));
        Map<String, List<DealerRetailPriceImportVo>> itemMap = successList.stream().collect(Collectors.groupingBy(DealerRetailPriceImportVo::getItemCode));
        itemMap.forEach((itemCode, itemList) -> {
            if (itemList.size() > 1) {
                String err = itemList.stream().map(item -> this.serialNumberStr(item.getSerialNumber())).collect(Collectors.joining(",")) + "\u5546\u54c1\u7f16\u7801[" + itemCode + "]\u51fa\u73b0\u91cd\u590d";
                baseExcelDto.addErrorMsg(err);
            }
        });
        ArrayList itemCodeList = ListUtil.toList(itemMap.keySet());
        Map<String, ItemSkuQueryRespDto> skuQueryRespDtoMap = this.skuHelper.querySkuMapByItemCodeListAndShopId(itemCodeList, shopId);
        if (CollUtil.isEmpty(skuQueryRespDtoMap)) {
            return;
        }
        List skuIdList = skuQueryRespDtoMap.values().stream().map(ItemSkuQueryRespDto::getSkuId).distinct().collect(Collectors.toList());
        ItemSkuPriceLimitQueryReqDto itemSkuPriceLimitQueryReqDto = new ItemSkuPriceLimitQueryReqDto();
        itemSkuPriceLimitQueryReqDto.setShopId(shopId);
        itemSkuPriceLimitQueryReqDto.setSkuIdList(skuIdList);
        ItemSkuPriceLimitRespDto itemSkuPriceLimitRespDto = this.basePriceApplyItemService.queryItemPriceList(itemSkuPriceLimitQueryReqDto);
        for (DealerRetailPriceImportVo importVo : successList) {
            this.buildSkuInfo(baseExcelDto, skuQueryRespDtoMap, itemSkuPriceLimitRespDto, importVo);
        }
        if (baseExcelDto.isImportStatus()) {
            baseExcelDto.setSuccessDataList(successList);
        }
    }

    private void buildSkuInfo(BaseExcelDto baseExcelDto, Map<String, ItemSkuQueryRespDto> skuQueryRespDtoMap, ItemSkuPriceLimitRespDto itemSkuPriceLimitRespDto, DealerRetailPriceImportVo importVo) {
        String itemCode = importVo.getItemCode();
        ItemSkuQueryRespDto itemSkuQueryRespDto = skuQueryRespDtoMap.get(itemCode);
        if (itemSkuQueryRespDto == null || !Objects.equals(itemSkuQueryRespDto.getItemCode(), itemCode)) {
            baseExcelDto.addErrorMsg(this.serialNumberStr(importVo.getSerialNumber()) + " \u5546\u54c1\u7f16\u7801[" + itemCode + "]\u4e0d\u5b58\u5728");
            return;
        }
        if (importVo.getDealerRetailPrice() != null) {
            if (BigDecimal.ZERO.compareTo(importVo.getDealerRetailPrice()) >= 0) {
                baseExcelDto.addErrorMsg(this.serialNumberStr(importVo.getSerialNumber()) + " \u5546\u54c1\u7f16\u7801[" + itemCode + "],\u81ea\u5b9a\u4e49\u96f6\u552e\u4ef7\u53ea\u80fd\u586b\u5199\u6b63\u6570\uff0c\u6700\u591a\u586b\u4e24\u4f4d\u5c0f\u6570");
                return;
            }
            if (importVo.getDealerRetailPrice().stripTrailingZeros().scale() > 2) {
                baseExcelDto.addErrorMsg(this.serialNumberStr(importVo.getSerialNumber()) + " \u5546\u54c1\u7f16\u7801[" + itemCode + "],\u81ea\u5b9a\u4e49\u96f6\u552e\u4ef7\u53ea\u80fd\u586b\u5199\u6b63\u6570\uff0c\u6700\u591a\u586b\u4e24\u4f4d\u5c0f\u6570");
                return;
            }
        }
        importVo.setGiftBox(Objects.isNull(itemSkuQueryRespDto.getGiftBox()) ? null : String.valueOf(itemSkuQueryRespDto.getGiftBox()));
        importVo.setBrandName(itemSkuQueryRespDto.getBrandName());
        importVo.setDirName(itemSkuQueryRespDto.getDirName());
        importVo.setItemName(itemSkuQueryRespDto.getItemName());
        importVo.setSkuAttr(itemSkuQueryRespDto.getSkuAttr());
        importVo.setShopId(itemSkuQueryRespDto.getShopId());
        importVo.setSubType(itemSkuQueryRespDto.getSubType());
        importVo.setItemOrgName(itemSkuQueryRespDto.getItemOrgName());
        importVo.setSkuId(itemSkuQueryRespDto.getSkuId());
        importVo.setSkuCode(itemSkuQueryRespDto.getSkuCode());
        ItemSkuPriceInfoRespDto itemSkuPriceInfoRespDto = (ItemSkuPriceInfoRespDto)itemSkuPriceLimitRespDto.getSkuPriceInfo().get(itemSkuQueryRespDto.getSkuId());
        if (Objects.nonNull(itemSkuPriceInfoRespDto)) {
            importVo.setRetailPrice(itemSkuPriceInfoRespDto.getRetailPrice());
            importVo.setControlType(itemSkuPriceInfoRespDto.getControlType());
            importVo.setLowerLimitPrice(itemSkuPriceInfoRespDto.getLowerLimitPrice());
            importVo.setUpperLimitPrice(itemSkuPriceInfoRespDto.getUpperLimitPrice());
            importVo.setExchangePrice(itemSkuPriceInfoRespDto.getExchangePrice());
        }
    }

    public static void main(String[] args) {
        System.out.println(BigDecimal.ZERO.stripTrailingZeros().scale());
        System.out.println(new BigDecimal("0.0").stripTrailingZeros().scale());
        System.out.println(new BigDecimal("0.01").stripTrailingZeros().scale());
        System.out.println(new BigDecimal("1").stripTrailingZeros().scale());
        System.out.println(new BigDecimal("1.0").stripTrailingZeros().scale());
        System.out.println(new BigDecimal("1.01").stripTrailingZeros().scale());
        System.out.println(new BigDecimal("1.000").stripTrailingZeros().scale());
    }
}

