/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerGroupQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerGroupRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerGroupQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaGroupQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirectoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.CustomerDimensionEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.GeneralRuleTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.ItemDimensionEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.AttachementModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.AuditReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CustomerConditionAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.LimitCustomerReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.LimitItemModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceItemConditionAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceLimitAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceLimitQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceRejectCustomerAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceRejectItemAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.AuditRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.CustomerConditionRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.LimitCustomerRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.LimitItemRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceBasicConfigRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceItemConditionRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceLimitRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceRejectCustomerRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceRejectItemRespDto;
import com.dtyunxi.yundt.cube.center.price.api.exception.BusinessException;
import com.dtyunxi.yundt.cube.center.price.api.exception.PriceExceptionCode;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceBasicConfigService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceLimitService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceRejectCustomerService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceRejectItemService;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.IPriceLimitPolicyEsService;
import com.dtyunxi.yundt.cube.center.price.biz.utils.GenerateCode;
import com.dtyunxi.yundt.cube.center.price.dao.das.AttachementDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.AuditDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.CustomerConditionDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.LimitCustomerDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.LimitItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceItemConditionDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceLimitDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceRejectCustomerDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceRejectItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.AttachementEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.AuditEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.CustomerConditionEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.LimitCustomerEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.LimitItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceItemConditionEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceLimitEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceRejectCustomerEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceRejectItemEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PriceLimitServiceImpl
implements IPriceLimitService {
    @Resource
    private IPriceRejectItemService priceRejectItemService;
    @Resource
    private IPriceRejectCustomerService priceRejectCustomerService;
    @Resource
    private IPriceLimitPolicyEsService priceLimitPolicyEsService;
    @Resource
    private PriceLimitDas priceLimitDas;
    @Resource
    private LimitItemDas limitItemDas;
    @Resource
    private CustomerConditionDas customerConditionDas;
    @Resource
    private GenerateCode<PriceLimitEo> generateCode;
    @Resource
    private IContext iContext;
    @Resource
    private ICustomerGroupQueryApi customerGroupQueryApi;
    @Resource
    private IAreaGroupQueryApi areaGroupQueryApi;
    @Resource
    private IDirectoryQueryApi directoryQueryApi;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Resource
    private AttachementDas attachementDas;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private PriceRejectCustomerDas rejectCustomerDas;
    @Resource
    private PriceRejectItemDas rejectItemDas;
    @Resource
    private LimitCustomerDas limitCustomerDas;
    @Resource
    private PriceItemConditionDas itemConditionDas;
    @Resource
    private AuditDas auditDas;
    @Resource
    private IPriceBasicConfigService priceBasicConfigService;
    private static final String STATUS_COLUMN = "status";
    private static final String PIRCE_LIMIT_NOT_EXIT = "\u4ef7\u76d8\u4e0d\u5b58\u5728";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addPriceLimit(PriceLimitAddReqDto reqDto) {
        Assert.isTrue((!StringUtils.isBlank((CharSequence)reqDto.getName()) ? 1 : 0) != 0, (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Long organizationId = (Long)this.customerExtQueryApi.queryOrgIdByUserId(this.iContext.userId()).getData();
        if (ObjectUtil.isEmpty((Object)reqDto.getOriginalLimitCode())) {
            this.validatePriceLimit(reqDto, organizationId);
            List<PriceLimitRespDto> priceLimitRespDtos = this.checkSameLimit(reqDto);
            if (CollUtil.isNotEmpty(priceLimitRespDtos)) {
                throw new BusinessException(PriceExceptionCode.POLICY_HAVE_SAME.getCode(), String.format(PriceExceptionCode.POLICY_HAVE_SAME.getMsg(), priceLimitRespDtos.get(0).getCode()));
            }
        }
        PriceLimitEo priceLimitEo = this.insertPriceLimitEo(reqDto);
        switch (reqDto.getRelationItemType()) {
            case 0: {
                this.savePriceLimitPriceItem(reqDto.getLimitItemList(), priceLimitEo.getId());
                break;
            }
            case 1: {
                this.insertItemCondition(reqDto.getItemConditionAddReqDto(), priceLimitEo);
                this.insertRejectItem(reqDto.getRejectItemAddReqDtos(), priceLimitEo);
                break;
            }
            case 2: {
                break;
            }
        }
        switch (reqDto.getRelationCustomerType()) {
            case 0: {
                this.insertPriceLimitCustomer(reqDto.getLimitCustomerReqDtos(), priceLimitEo);
                break;
            }
            case 1: {
                this.insertCustomerCondition(priceLimitEo, reqDto.getCustomerConditionAddReqDto());
                this.insertRejectCustomer(reqDto.getRejectCustomerAddReqDtos(), priceLimitEo);
                break;
            }
            case 2: {
                break;
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getAttachementReqDtos())) {
            ArrayList attachementEos = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
            DtoHelper.dtoList2EoList((Collection)reqDto.getAttachementReqDtos(), (Collection)attachementEos, AttachementEo.class);
            attachementEos.stream().forEach(bean -> bean.setBusinessId(priceLimitEo.getId()));
            this.attachementDas.insertBatch((List)attachementEos);
        }
        return priceLimitEo.getId();
    }

    private void insertCustomerCondition(PriceLimitEo priceLimitEo, CustomerConditionAddReqDto customerConditionAddReqDto) {
        CustomerConditionEo customerConditionEo = new CustomerConditionEo();
        DtoHelper.dto2Eo((BaseVo)customerConditionAddReqDto, (BaseEo)customerConditionEo);
        if (CollectionUtils.isNotEmpty((Collection)customerConditionAddReqDto.getCustomerIds())) {
            customerConditionEo.setCustomerIds(StringUtils.join((Iterable)customerConditionAddReqDto.getCustomerIds(), (String)","));
        }
        if (CollectionUtils.isNotEmpty((Collection)customerConditionAddReqDto.getCustomerTypeIds())) {
            customerConditionEo.setCustomerTypeIds(StringUtils.join((Iterable)customerConditionAddReqDto.getCustomerTypeIds(), (String)","));
        }
        if (CollectionUtils.isNotEmpty((Collection)customerConditionAddReqDto.getCustomerGroupIds())) {
            customerConditionEo.setCustomerGroupIds(StringUtils.join((Iterable)customerConditionAddReqDto.getCustomerGroupIds(), (String)","));
            ArrayList customerGroupIdExt = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
            for (String bean : customerConditionAddReqDto.getCustomerGroupIds()) {
                customerGroupIdExt.add(Long.parseLong(bean));
                List<Long> childrenCustomerGroupIds = this.getChildrenCustomerGroupIds(Long.parseLong(bean));
                customerGroupIdExt.addAll(childrenCustomerGroupIds);
            }
            if (CollectionUtils.isNotEmpty((Collection)customerGroupIdExt)) {
                customerConditionEo.setCustomerGroupIdExt(StringUtils.join((Iterable)customerGroupIdExt, (String)","));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)customerConditionAddReqDto.getCustomerAreaCodes())) {
            customerConditionEo.setCustomerAreaCodes(StringUtils.join((Iterable)customerConditionAddReqDto.getCustomerAreaCodes(), (String)","));
            ArrayList<String> customerAreaCodeExt = new ArrayList<String>();
            customerAreaCodeExt.addAll(this.getSubCustAreaCodes(customerConditionAddReqDto.getCustomerAreaCodes()));
            if (CollectionUtils.isNotEmpty(customerAreaCodeExt)) {
                customerConditionEo.setCustomerAreaCodeExt(StringUtils.join(customerAreaCodeExt, (String)","));
            }
        }
        customerConditionEo.setRelateId(priceLimitEo.getId());
        customerConditionEo.setRelateType(RelateTypeEnum.PRICE_LIMIT.getType());
        this.customerConditionDas.insert((BaseEo)customerConditionEo);
    }

    private List<String> getSubCustAreaCodes(List<String> parentAreaCode) {
        CustomerAreaListReqDto reqDto = new CustomerAreaListReqDto();
        reqDto.setCodes(parentAreaCode);
        return (List)this.customerAreaQueryApi.querySubCodeAll(reqDto).getData();
    }

    private List<Long> getChildrenCustomerGroupIds(Long parentGroupId) {
        Map<Long, List<CustomerGroupRespDto>> customerGroupRespDtoMap;
        ArrayList groupIds = Lists.newArrayList();
        CustomerGroupQueryReqDto customerGroupQueryReqDto = new CustomerGroupQueryReqDto();
        customerGroupQueryReqDto.setTenantId(this.iContext.tenantId());
        customerGroupQueryReqDto.setInstanceId(this.iContext.instanceId());
        PageInfo pageInfoRestResponse = (PageInfo)this.customerGroupQueryApi.queryByPage(customerGroupQueryReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)).getData();
        if (null != pageInfoRestResponse && CollectionUtils.isNotEmpty((Collection)pageInfoRestResponse.getList()) && null != (customerGroupRespDtoMap = pageInfoRestResponse.getList().stream().collect(Collectors.groupingBy(bean -> null == bean.getParentGroupId() ? 0L : bean.getParentGroupId())))) {
            this.assembleChildrenCustomerGroupId(customerGroupRespDtoMap, parentGroupId, groupIds);
        }
        return groupIds;
    }

    private void assembleChildrenCustomerGroupId(Map<Long, List<CustomerGroupRespDto>> customerGroupRespDtoMap, Long parentGroupId, List<Long> groupIds) {
        List<CustomerGroupRespDto> customerGroupRespDtos = customerGroupRespDtoMap.get(parentGroupId);
        if (CollectionUtils.isNotEmpty(customerGroupRespDtos)) {
            customerGroupRespDtos.stream().forEach(bean -> {
                groupIds.add(bean.getId());
                this.assembleChildrenCustomerGroupId(customerGroupRespDtoMap, bean.getId(), groupIds);
            });
        }
    }

    private PriceLimitEo insertPriceLimitEo(PriceLimitAddReqDto reqDto) {
        PriceLimitEo priceLimitEo = new PriceLimitEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceLimitEo);
        priceLimitEo.setId(null);
        priceLimitEo.setCode(StringUtils.isBlank((CharSequence)reqDto.getCode()) ? this.generateCode.createCode(GeneralRuleTypeEnum.JPZK) : reqDto.getCode());
        priceLimitEo.setStatus(reqDto.isDraft() ? PriceStatusEnum.DRAFT.getCode() : PriceStatusEnum.WAIT_AUDIT.getCode());
        priceLimitEo.setCategoryCode(reqDto.getCategoryCode());
        priceLimitEo.setOrganizationId((Long)this.customerExtQueryApi.queryOrgIdByUserId(this.iContext.userId()).getData());
        if (ObjectUtil.isEmpty((Object)reqDto.getEffectiveTime())) {
            priceLimitEo.setEffectiveTime(new Date());
        }
        this.priceLimitDas.insert((BaseEo)priceLimitEo);
        return priceLimitEo;
    }

    private void insertPriceLimitCustomer(List<LimitCustomerReqDto> reqDtos, PriceLimitEo priceLimitEo) {
        if (CollUtil.isNotEmpty(reqDtos)) {
            ArrayList limitCustomerEos = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
            DtoHelper.dtoList2EoList(reqDtos, (Collection)limitCustomerEos, LimitCustomerEo.class);
            limitCustomerEos.stream().forEach(bean -> {
                bean.setRelateId(priceLimitEo.getId());
                bean.setRelateType(RelateTypeEnum.PRICE_LIMIT.getType());
            });
            this.limitCustomerDas.insertBatch((List)limitCustomerEos);
        }
    }

    private void insertRejectCustomer(List<PriceRejectCustomerAddReqDto> reqDto, PriceLimitEo priceLimitEo) {
        if (CollUtil.isNotEmpty(reqDto)) {
            ArrayList rejectCustomerEos = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
            DtoHelper.dtoList2EoList(reqDto, (Collection)rejectCustomerEos, PriceRejectCustomerEo.class);
            rejectCustomerEos.stream().forEach(bean -> {
                bean.setRelateId(priceLimitEo.getId());
                bean.setRelateType(RelateTypeEnum.PRICE_LIMIT.getType());
            });
            this.rejectCustomerDas.insertBatch((List)rejectCustomerEos);
        }
    }

    private void insertRejectItem(List<PriceRejectItemAddReqDto> reqDto, PriceLimitEo priceLimitEo) {
        if (CollUtil.isNotEmpty(reqDto)) {
            ArrayList rejectItemEos = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
            DtoHelper.dtoList2EoList(reqDto, (Collection)rejectItemEos, PriceRejectItemEo.class);
            rejectItemEos.stream().forEach(bean -> {
                bean.setRelateId(priceLimitEo.getId());
                bean.setRelateType(RelateTypeEnum.PRICE_LIMIT.getType());
            });
            this.rejectItemDas.insertBatch((List)rejectItemEos);
        }
    }

    private void insertItemCondition(PriceItemConditionAddReqDto itemConditionAddReqDto, PriceLimitEo priceLimitEo) {
        PriceItemConditionEo itemConditionEo = new PriceItemConditionEo();
        DtoHelper.dto2Eo((BaseVo)itemConditionAddReqDto, (BaseEo)itemConditionEo);
        if (CollUtil.isNotEmpty((Collection)itemConditionAddReqDto.getItemTypes())) {
            itemConditionEo.setItemTypes(StringUtils.join((Iterable)itemConditionAddReqDto.getItemTypes(), (String)","));
        }
        if (CollUtil.isNotEmpty((Collection)itemConditionAddReqDto.getItemBackDirIds())) {
            itemConditionEo.setItemBackDirIds(StringUtils.join((Iterable)itemConditionAddReqDto.getItemBackDirIds(), (String)","));
            List<Long> itemBackDirIdsExtList = this.getChildBackDirIds(itemConditionAddReqDto.getItemBackDirIds());
            itemConditionEo.setItemBackDirIdsExt(StringUtils.join(itemBackDirIdsExtList, (String)","));
        }
        if (CollUtil.isNotEmpty((Collection)itemConditionAddReqDto.getItemBrandIds())) {
            itemConditionEo.setItemBrandIds(StringUtils.join((Iterable)itemConditionAddReqDto.getItemBrandIds(), (String)","));
        }
        itemConditionEo.setRelateId(priceLimitEo.getId());
        itemConditionEo.setRelateType(RelateTypeEnum.PRICE_LIMIT.getType());
        this.itemConditionDas.insert((BaseEo)itemConditionEo);
    }

    private List<Long> getChildBackDirIds(List<String> itemBackDirIds) {
        ArrayList<Long> res = new ArrayList<Long>();
        if (CollUtil.isNotEmpty(itemBackDirIds)) {
            List ids = itemBackDirIds.stream().map(Long::valueOf).collect(Collectors.toList());
            DirectoryReqDto directoryReqDto = new DirectoryReqDto();
            directoryReqDto.setIds(ids);
            res.addAll((Collection)this.directoryQueryApi.queryLinkAndChildDirIdListByDirId(directoryReqDto).getData());
        }
        return res;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyPriceLimit(PriceLimitAddReqDto reqDto) {
        PriceLimitEo priceLimitById = (PriceLimitEo)this.priceLimitDas.selectByPrimaryKey(reqDto.getId());
        PriceLimitRespDto respDto = new PriceLimitRespDto();
        DtoHelper.eo2Dto((BaseEo)priceLimitById, (BaseVo)respDto);
        this.setStatus(respDto);
        if (respDto.getStatus().equals(PriceStatusEnum.EFFECT.getCode())) {
            reqDto.setOriginalLimitCode(reqDto.getCode());
            reqDto.setCode(null);
        } else {
            this.priceLimitDas.deleteById(reqDto.getId());
        }
        reqDto.setId(null);
        this.addPriceLimit(reqDto);
    }

    private void savePriceLimitPriceItem(List<LimitItemModifyReqDto> dtos, Long id) {
        if (CollectionUtils.isNotEmpty(dtos)) {
            ArrayList priceLimitPriceItemEos = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
            DtoHelper.dtoList2EoList(dtos, (Collection)priceLimitPriceItemEos, LimitItemEo.class);
            priceLimitPriceItemEos.forEach(bean -> {
                bean.setPriceLimitId(id);
                this.limitItemDas.insert((BaseEo)bean);
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePriceLimit(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            PriceLimitEo priceLimitEo = (PriceLimitEo)this.priceLimitDas.selectByPrimaryKey(Long.valueOf(id));
            if (priceLimitEo == null) continue;
            Assert.isTrue((boolean)priceLimitEo.getStatus().equals(PriceStatusEnum.DRAFT.getCode()), (String)"\u72b6\u6001\u5f02\u5e38,\u4e0d\u5141\u8bb8\u7f16\u8f91");
            this.priceLimitDas.logicDeleteById(Long.valueOf(id.trim()));
        }
    }

    @Override
    public PriceLimitRespDto queryPriceLimitById(Long id) {
        PriceLimitEo priceLimitEo = (PriceLimitEo)this.priceLimitDas.selectByPrimaryKey(id);
        if (priceLimitEo == null) {
            return null;
        }
        PriceLimitRespDto priceLimitRespDto = new PriceLimitRespDto();
        DtoHelper.eo2Dto((BaseEo)priceLimitEo, (BaseVo)priceLimitRespDto);
        this.setCustomerCondition(id, priceLimitRespDto);
        this.setItemCondition(id, priceLimitRespDto);
        if (priceLimitEo.getRelationItemType().equals(Integer.valueOf(ItemDimensionEnum.ITEM_RANGE_ENUM.getType()))) {
            List<PriceRejectItemRespDto> priceRejectItemRespDtos = this.priceRejectItemService.queryByRelateIdAndType(priceLimitEo.getId(), RelateTypeEnum.PRICE_LIMIT.getType());
            priceLimitRespDto.setPriceRejectItemRespDtoList(priceRejectItemRespDtos);
        }
        if (priceLimitEo.getRelationCustomerType().equals(Integer.valueOf(CustomerDimensionEnum.CUSTOMER_RANGE_ENUM.getType()))) {
            List<PriceRejectCustomerRespDto> priceRejectCustomerRespDtos = this.priceRejectCustomerService.queryByRelateIdAndType(priceLimitEo.getId(), RelateTypeEnum.PRICE_LIMIT.getType());
            priceLimitRespDto.setPriceRejectCustomerRespDtoList(priceRejectCustomerRespDtos);
        }
        List limitItemEos = this.limitItemDas.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"price_limit_id", (Object)id));
        ArrayList limitItemRespDto = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)limitItemEos, limitItemRespDto, LimitItemRespDto.class);
        priceLimitRespDto.setPriceItemRespDtos(limitItemRespDto);
        List limitCustomerEos = this.limitCustomerDas.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"relate_id", (Object)id));
        ArrayList customerRespDtos = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)limitCustomerEos, customerRespDtos, LimitCustomerRespDto.class);
        priceLimitRespDto.setCustomerRespDtos(customerRespDtos);
        AuditEo auditEo = new AuditEo();
        auditEo.setRelateId(priceLimitEo.getId());
        auditEo.setRelateType(RelateTypeEnum.PRICE_LIMIT.getType());
        AuditEo auditEoResult = (AuditEo)this.auditDas.selectOne((BaseEo)auditEo);
        if (ObjectUtil.isNotEmpty((Object)auditEoResult)) {
            AuditRespDto auditRespDto = new AuditRespDto();
            DtoHelper.eo2Dto((BaseEo)auditEoResult, (BaseVo)auditRespDto);
            priceLimitRespDto.setAuditRespDto(auditRespDto);
        }
        AttachementEo attachementEo = new AttachementEo();
        attachementEo.setBusinessId(priceLimitEo.getId());
        List attachementEos = this.attachementDas.select((BaseEo)attachementEo);
        ArrayList attachementModifyReqDtos = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)attachementModifyReqDtos, (Collection)attachementEos, AttachementModifyReqDto.class);
        priceLimitRespDto.setAttachementReqDtos((List)attachementModifyReqDtos);
        return priceLimitRespDto;
    }

    @Override
    public PageInfo<PriceLimitRespDto> queryPriceLimitByPage(PriceLimitQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        PageMethod.startPage((int)pageNum, (int)pageSize);
        reqDto.setOrganizationId((Long)this.customerExtQueryApi.queryOrgIdByUserId(this.iContext.userId()).getData());
        List priceLimitRespDtos = this.priceLimitDas.selectPageList(reqDto);
        priceLimitRespDtos.forEach(bean -> {
            AuditEo auditEo = new AuditEo();
            auditEo.setRelateId(bean.getId());
            auditEo.setRelateType(RelateTypeEnum.PRICE_LIMIT.getType());
            List auditEos = this.auditDas.select((BaseEo)auditEo);
            if (CollUtil.isNotEmpty((Collection)auditEos)) {
                AuditRespDto auditRespDto = new AuditRespDto();
                DtoHelper.eo2Dto((BaseEo)((BaseEo)auditEos.get(0)), (BaseVo)auditRespDto);
                bean.setAuditRespDto(auditRespDto);
            }
            this.setStatus((PriceLimitRespDto)bean);
            PriceLimitRespDto respDto = this.queryPriceLimitById(bean.getId());
            bean.setPriceItemConditionRespDto(respDto.getPriceItemConditionRespDto());
            bean.setCustomerConditionRespDto(respDto.getCustomerConditionRespDto());
            bean.setPriceRejectCustomerRespDtoList(respDto.getPriceRejectCustomerRespDtoList());
            bean.setPriceRejectItemRespDtoList(respDto.getPriceRejectItemRespDtoList());
            bean.setCustomerRespDtos(respDto.getCustomerRespDtos());
            bean.setPriceItemRespDtos(respDto.getPriceItemRespDtos());
            bean.setAttachementReqDtos(respDto.getAttachementReqDtos());
        });
        return new PageInfo(priceLimitRespDtos);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelPrice(Long id) {
        PriceLimitEo priceLimitEo1 = this.priceLimitDas.getPriceLimitEo(id);
        if (null == priceLimitEo1) {
            throw new BizException(PIRCE_LIMIT_NOT_EXIT);
        }
        priceLimitEo1.setStatus(PriceStatusEnum.INVALID.getCode());
        this.priceLimitDas.updateSelective((BaseEo)priceLimitEo1);
        this.priceLimitPolicyEsService.deletePriceLimitPolicy(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditPrice(AuditReqDto reqDto) {
        PriceLimitEo waitAuditCopyByCode;
        PriceLimitEo priceEo = (PriceLimitEo)this.priceLimitDas.selectByPrimaryKey(reqDto.getId());
        if (null == priceEo) {
            throw new BizException(PIRCE_LIMIT_NOT_EXIT);
        }
        if (!PriceStatusEnum.WAIT_AUDIT.getCode().equals(priceEo.getStatus())) {
            throw new BizException("\u72b6\u6001\u5f02\u5e38,\u4e0d\u5141\u8bb8\u5ba1\u6838:" + PriceStatusEnum.getByCode((String)priceEo.getStatus()).getDesc());
        }
        if ("1".equals(reqDto.getAuditResult()) && (waitAuditCopyByCode = this.priceLimitDas.findAuditOldPassOriginalByCode(priceEo.getOriginalLimitCode())) != null && waitAuditCopyByCode.getStatus().equals(PriceStatusEnum.AUDIT_PASS.getCode())) {
            this.cancelPrice(waitAuditCopyByCode.getId());
        }
        priceEo.setStatus("1".equals(reqDto.getAuditResult()) ? PriceStatusEnum.AUDIT_PASS.getCode() : PriceStatusEnum.AUDIT_REJECT.getCode());
        priceEo.setRemark(reqDto.getRemark());
        this.priceLimitDas.updateSelective((BaseEo)priceEo);
        AuditEo auditEo = new AuditEo();
        auditEo.setRelateId(reqDto.getId());
        auditEo.setRelateType(RelateTypeEnum.PRICE_LIMIT.getType());
        AuditEo auditEoResult = (AuditEo)this.auditDas.selectOne((BaseEo)auditEo);
        if (ObjectUtil.isNotEmpty((Object)auditEoResult)) {
            auditEoResult.setAuditStatus(priceEo.getStatus());
            auditEoResult.setAuditPerson(Objects.isNull(this.iContext.userName()) ? "\u672a\u77e5" : this.iContext.userName());
            auditEoResult.setAuditComments(priceEo.getRemark());
            auditEoResult.setAuditTime(new Date());
            this.auditDas.update((BaseEo)auditEoResult);
        } else {
            auditEo.setAuditStatus(priceEo.getStatus());
            auditEo.setAuditComments(priceEo.getRemark());
            auditEo.setAuditPerson(Objects.isNull(this.iContext.userName()) ? "\u672a\u77e5" : this.iContext.userName());
            auditEo.setAuditTime(new Date());
            this.auditDas.insert((BaseEo)auditEo);
        }
        if ("1".equals(reqDto.getAuditResult())) {
            this.priceLimitPolicyEsService.updatePriceLimitPolicy(priceEo.getId());
        }
    }

    @Override
    public PageInfo<LimitItemRespDto> queryLimitItemByPage(Long limitId, Integer pageNum, Integer pageSize) {
        if (limitId == null) {
            return new PageInfo();
        }
        PageMethod.startPage((int)pageNum, (int)pageSize);
        LimitItemEo limitEo = new LimitItemEo();
        limitEo.setPriceLimitId(limitId);
        limitEo.setInstanceId(this.iContext.instanceId());
        limitEo.setTenantId(this.iContext.tenantId());
        List select = this.limitItemDas.select((BaseEo)limitEo);
        if (CollectionUtils.isEmpty((Collection)select)) {
            return new PageInfo();
        }
        ArrayList list = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)select, list, LimitItemRespDto.class);
        return new PageInfo(list);
    }

    @Override
    public void submitPrice(Long id) {
        PriceLimitEo priceEo = (PriceLimitEo)this.priceLimitDas.selectByPrimaryKey(id);
        if (null == priceEo) {
            throw new BizException(PIRCE_LIMIT_NOT_EXIT);
        }
        if (!PriceStatusEnum.DRAFT.getCode().equals(priceEo.getStatus())) {
            throw new BizException("\u72b6\u6001\u5f02\u5e38,\u4e0d\u5141\u8bb8\u63d0\u4ea4:" + PriceStatusEnum.getByCode((String)priceEo.getStatus()).getDesc());
        }
        priceEo.setStatus(PriceStatusEnum.WAIT_AUDIT.getCode());
        this.priceLimitDas.updateSelective((BaseEo)priceEo);
    }

    private void setStatus(PriceLimitRespDto bean) {
        if (bean.getStatus().equals(PriceStatusEnum.AUDIT_PASS.getCode())) {
            this.setPriceLimitStatus(bean);
        }
    }

    private void setPriceLimitStatus(PriceLimitRespDto bean) {
        if (DateUtil.compare((Date)bean.getEffectiveTime(), (Date)DateTime.now()) > 0) {
            bean.setStatus(PriceStatusEnum.WAIT_TAKE_EFFECT.getCode());
        } else if (ObjectUtil.isNotEmpty((Object)bean.getInvalidTime())) {
            if (DateUtil.compare((Date)bean.getEffectiveTime(), (Date)DateTime.now()) < 0 && DateUtil.compare((Date)bean.getInvalidTime(), (Date)DateTime.now()) > 0) {
                bean.setStatus(PriceStatusEnum.EFFECT.getCode());
            } else if (DateUtil.compare((Date)bean.getInvalidTime(), (Date)DateTime.now()) < 0) {
                bean.setStatus(PriceStatusEnum.EXPIRED.getCode());
            }
        } else if (DateUtil.compare((Date)bean.getEffectiveTime(), (Date)DateTime.now()) < 0) {
            bean.setStatus(PriceStatusEnum.EFFECT.getCode());
        }
    }

    private void setCustomerCondition(Long id, PriceLimitRespDto priceLimitRespDto) {
        List byRelateIdAndType = this.customerConditionDas.findByRelateIdAndType(id, RelateTypeEnum.PRICE_LIMIT);
        if (CollUtil.isNotEmpty((Collection)byRelateIdAndType)) {
            CustomerConditionEo customerConditionEo = (CustomerConditionEo)byRelateIdAndType.get(0);
            CustomerConditionRespDto customerConditionRespDto = new CustomerConditionRespDto();
            DtoHelper.eo2Dto((BaseEo)customerConditionEo, (BaseVo)customerConditionRespDto);
            if (StringUtils.isNotEmpty((CharSequence)customerConditionEo.getCustomerTypeIds())) {
                ArrayList<String> customerTypeIds = new ArrayList<String>(Arrays.asList(customerConditionEo.getCustomerTypeIds().split(",")));
                customerConditionRespDto.setCustomerTypeIdNum(Integer.valueOf(customerTypeIds.size()));
                customerConditionRespDto.setCustomerTypeIds(customerTypeIds);
            }
            if (StringUtils.isNotEmpty((CharSequence)customerConditionEo.getCustomerGroupIds())) {
                ArrayList<String> customerGroupIds = new ArrayList<String>(Arrays.asList(customerConditionEo.getCustomerGroupIds().split(",")));
                customerConditionRespDto.setCustomerGroupIds(customerGroupIds);
            }
            if (StringUtils.isNotEmpty((CharSequence)customerConditionEo.getCustomerAreaCodes())) {
                ArrayList<String> customerAreaCodes = new ArrayList<String>(Arrays.asList(customerConditionEo.getCustomerAreaCodes().split(",")));
                customerConditionRespDto.setCustomerAreaCodeNum(Integer.valueOf(customerAreaCodes.size()));
                customerConditionRespDto.setCustomerAreaCodes(customerAreaCodes);
            }
            if (StringUtils.isNotEmpty((CharSequence)customerConditionEo.getCustomerIds())) {
                ArrayList<String> customerIds = new ArrayList<String>(Arrays.asList(customerConditionEo.getCustomerIds().split(",")));
                customerConditionRespDto.setCustomerIdNum(Integer.valueOf(customerIds.size()));
                customerConditionRespDto.setCustomerIds(customerIds);
            }
            if (StringUtils.isNotEmpty((CharSequence)customerConditionEo.getCustomerAreaCodeExt())) {
                ArrayList<String> customerAreaCodeExts = new ArrayList<String>(Arrays.asList(customerConditionEo.getCustomerAreaCodeExt().split(",")));
                customerConditionRespDto.setCustomerAreaCodeExts(customerAreaCodeExts);
            }
            priceLimitRespDto.setCustomerConditionRespDto(customerConditionRespDto);
        }
    }

    private List<PriceLimitEo> validatePriceLimit(PriceLimitAddReqDto reqDto, Long organizationId) {
        List priceLimitEoList = this.priceLimitDas.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"name", (Object)reqDto.getName())).eq((Object)"organization_id", (Object)organizationId)).ne((Object)STATUS_COLUMN, (Object)PriceStatusEnum.AUDIT_REJECT)).ne((Object)STATUS_COLUMN, (Object)PriceStatusEnum.CHANGED)).ne((Object)STATUS_COLUMN, (Object)PriceStatusEnum.INVALID));
        if (CollUtil.isNotEmpty((Collection)priceLimitEoList)) {
            throw new BizException("\u8be5\u540d\u79f0\u5df2\u91cd\u590d");
        }
        return priceLimitEoList;
    }

    private void setItemCondition(Long id, PriceLimitRespDto priceLimitRespDto) {
        PriceItemConditionEo itemConditionEo = new PriceItemConditionEo();
        itemConditionEo.setRelateId(id);
        itemConditionEo.setRelateType(RelateTypeEnum.PRICE_LIMIT.getType());
        PriceItemConditionEo resultItemConditionEo = (PriceItemConditionEo)this.itemConditionDas.selectOne((BaseEo)itemConditionEo);
        if (ObjectUtil.isNotEmpty((Object)resultItemConditionEo)) {
            PriceItemConditionRespDto itemConditionRespDto = new PriceItemConditionRespDto();
            DtoHelper.eo2Dto((BaseEo)resultItemConditionEo, (BaseVo)itemConditionRespDto);
            if (ObjectUtil.isNotEmpty((Object)resultItemConditionEo.getItemBackDirIds())) {
                ArrayList<String> itemBackDirIds = new ArrayList<String>(Arrays.asList(resultItemConditionEo.getItemBackDirIds().split(",")));
                itemConditionRespDto.setItemBackDirIds(itemBackDirIds);
                itemConditionRespDto.setItemBackDirIdNum(Integer.valueOf(itemBackDirIds.size()));
            }
            if (ObjectUtil.isNotEmpty((Object)resultItemConditionEo.getItemTypes())) {
                ArrayList<String> itemTypes = new ArrayList<String>(Arrays.asList(resultItemConditionEo.getItemTypes().split(",")));
                itemConditionRespDto.setItemTypes(itemTypes);
                itemConditionRespDto.setItemTypeNum(Integer.valueOf(itemTypes.size()));
            }
            if (ObjectUtil.isNotEmpty((Object)resultItemConditionEo.getItemBrandIds())) {
                ArrayList<String> itemBrandIds = new ArrayList<String>(Arrays.asList(resultItemConditionEo.getItemBrandIds().split(",")));
                itemConditionRespDto.setItemBrandIds(itemBrandIds);
                itemConditionRespDto.setItemBrandIdNum(Integer.valueOf(itemBrandIds.size()));
            }
            priceLimitRespDto.setPriceItemConditionRespDto(itemConditionRespDto);
        }
    }

    private List<PriceLimitRespDto> checkSameLimit(PriceLimitAddReqDto reqDto) {
        List<Object> result = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        PriceBasicConfigRespDto config = this.priceBasicConfigService.query();
        if (config != null && Objects.equals(config.getRuleSameDim(), 1)) {
            return result;
        }
        if (ObjectUtil.isNotEmpty((Object)reqDto)) {
            List<PriceLimitRespDto> effectLimitList = this.getEffectLimitList(reqDto);
            List<Object> priceLimitRespDtos = this.getFitLimitList(effectLimitList, reqDto);
            if (CollUtil.isNotEmpty(priceLimitRespDtos = priceLimitRespDtos.stream().map(bean -> this.queryPriceLimitById(bean.getId())).collect(Collectors.toList()))) {
                int type = this.checkRelationType(reqDto);
                switch (type) {
                    case 1: {
                        result = priceLimitRespDtos;
                        break;
                    }
                    case 2: {
                        result = this.getLimitItemList(priceLimitRespDtos, reqDto);
                        break;
                    }
                    case 3: {
                        result = this.getLimitItemRange(priceLimitRespDtos, reqDto);
                        break;
                    }
                    case 4: {
                        result = this.getLimitCustomerList(priceLimitRespDtos, reqDto);
                        break;
                    }
                    case 5: {
                        result = this.getLimitCustomerList(this.getLimitItemRange(priceLimitRespDtos, reqDto), reqDto);
                        break;
                    }
                    case 6: {
                        result = this.getLimitCustomerList(this.getLimitItemList(priceLimitRespDtos, reqDto), reqDto);
                        break;
                    }
                    case 7: {
                        result = this.getLimitCustomerRange(priceLimitRespDtos, reqDto);
                        break;
                    }
                    case 8: {
                        result = this.getLimitItemRange(this.getLimitCustomerRange(priceLimitRespDtos, reqDto), reqDto);
                        break;
                    }
                    case 9: {
                        result = this.getLimitItemList(this.getLimitCustomerRange(priceLimitRespDtos, reqDto), reqDto);
                        break;
                    }
                }
            }
        }
        return result;
    }

    private int checkRelationType(PriceLimitAddReqDto reqDto) {
        int result = 0;
        if (String.valueOf(reqDto.getRelationCustomerType()).equals(CustomerDimensionEnum.CUSTOMER_ALL_ENUM.getType()) && String.valueOf(reqDto.getRelationItemType()).equals(ItemDimensionEnum.ITEM_ALL_ENUM.getType())) {
            result = 1;
        } else if (String.valueOf(reqDto.getRelationCustomerType()).equals(CustomerDimensionEnum.CUSTOMER_ALL_ENUM.getType()) && String.valueOf(reqDto.getRelationItemType()).equals(ItemDimensionEnum.ITEM_SPECIAL_ENUM.getType())) {
            result = 2;
        } else if (String.valueOf(reqDto.getRelationCustomerType()).equals(CustomerDimensionEnum.CUSTOMER_ALL_ENUM.getType()) && String.valueOf(reqDto.getRelationItemType()).equals(ItemDimensionEnum.ITEM_RANGE_ENUM.getType())) {
            result = 3;
        } else if (String.valueOf(reqDto.getRelationCustomerType()).equals(CustomerDimensionEnum.CUSTOMER_SPECIFIED_ENUM.getType()) && String.valueOf(reqDto.getRelationItemType()).equals(ItemDimensionEnum.ITEM_ALL_ENUM.getType())) {
            result = 4;
        } else if (String.valueOf(reqDto.getRelationCustomerType()).equals(CustomerDimensionEnum.CUSTOMER_SPECIFIED_ENUM.getType()) && String.valueOf(reqDto.getRelationItemType()).equals(ItemDimensionEnum.ITEM_RANGE_ENUM.getType())) {
            result = 5;
        } else if (String.valueOf(reqDto.getRelationCustomerType()).equals(CustomerDimensionEnum.CUSTOMER_SPECIFIED_ENUM.getType()) && String.valueOf(reqDto.getRelationItemType()).equals(ItemDimensionEnum.ITEM_SPECIAL_ENUM.getType())) {
            result = 6;
        } else if (String.valueOf(reqDto.getRelationCustomerType()).equals(CustomerDimensionEnum.CUSTOMER_RANGE_ENUM.getType()) && String.valueOf(reqDto.getRelationItemType()).equals(ItemDimensionEnum.ITEM_ALL_ENUM.getType())) {
            result = 7;
        } else if (String.valueOf(reqDto.getRelationCustomerType()).equals(CustomerDimensionEnum.CUSTOMER_RANGE_ENUM.getType()) && String.valueOf(reqDto.getRelationItemType()).equals(ItemDimensionEnum.ITEM_RANGE_ENUM.getType())) {
            result = 8;
        } else if (String.valueOf(reqDto.getRelationCustomerType()).equals(CustomerDimensionEnum.CUSTOMER_RANGE_ENUM.getType()) && String.valueOf(reqDto.getRelationItemType()).equals(ItemDimensionEnum.ITEM_SPECIAL_ENUM.getType())) {
            result = 9;
        }
        return result;
    }

    private List<PriceLimitRespDto> getEffectLimitList(PriceLimitAddReqDto reqDto) {
        List<Object> respDtos = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        PriceLimitEo priceLimitEo = new PriceLimitEo();
        priceLimitEo.setStatus(PriceStatusEnum.AUDIT_PASS.getCode());
        priceLimitEo.setOrganizationId((Long)this.customerExtQueryApi.queryOrgIdByUserId(this.iContext.userId()).getData());
        priceLimitEo.setRelationCustomerType(reqDto.getRelationCustomerType());
        priceLimitEo.setRelationItemType(reqDto.getRelationItemType());
        List priceLimitEos = this.priceLimitDas.select((BaseEo)priceLimitEo);
        if (CollUtil.isNotEmpty((Collection)priceLimitEos)) {
            ArrayList limitRespDtos = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)limitRespDtos, (Collection)priceLimitEos, PriceLimitRespDto.class);
            limitRespDtos.forEach(this::setStatus);
            respDtos = limitRespDtos.stream().filter(o -> o.getStatus().equals(PriceStatusEnum.EFFECT.getCode())).collect(Collectors.toList());
        }
        return respDtos;
    }

    private List<PriceLimitRespDto> getFitLimitList(List<PriceLimitRespDto> effectLimitList, PriceLimitAddReqDto reqDto) {
        List<Object> result = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        if (CollUtil.isNotEmpty(effectLimitList)) {
            for (PriceLimitRespDto dto : effectLimitList) {
                if (ObjectUtil.isEmpty((Object)dto.getInvalidTime())) {
                    result = this.noTimeLimit(dto, reqDto);
                    continue;
                }
                result = this.hasTimelimit(dto, reqDto);
            }
        }
        return result;
    }

    private List<PriceLimitRespDto> noTimeLimit(PriceLimitRespDto dto, PriceLimitAddReqDto reqDto) {
        ArrayList result = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        if (ObjectUtil.isEmpty((Object)dto.getLowerLimit()) && ObjectUtil.isEmpty((Object)dto.getUpperLimit())) {
            result.add(dto);
        }
        if (ObjectUtil.isNotEmpty((Object)reqDto.getLowerLimit()) && ObjectUtil.isNotEmpty((Object)reqDto.getUpperLimit()) && ObjectUtil.isNotEmpty((Object)dto.getLowerLimit()) && ObjectUtil.isNotEmpty((Object)dto.getUpperLimit()) && dto.getLowerLimit().compareTo(reqDto.getLowerLimit()) <= 0 && dto.getUpperLimit().compareTo(reqDto.getUpperLimit()) >= 0) {
            result.add(dto);
        }
        return result;
    }

    private List<PriceLimitRespDto> hasTimelimit(PriceLimitRespDto dto, PriceLimitAddReqDto reqDto) {
        ArrayList result = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        if (ObjectUtil.isNotEmpty((Object)reqDto.getInvalidTime()) && dto.getInvalidTime().after(reqDto.getInvalidTime())) {
            if (ObjectUtil.isEmpty((Object)dto.getLowerLimit()) && ObjectUtil.isEmpty((Object)dto.getUpperLimit())) {
                result.add(dto);
            }
            if (dto.getLowerLimit().compareTo(reqDto.getLowerLimit()) <= 0 && dto.getUpperLimit().compareTo(reqDto.getUpperLimit()) >= 0) {
                result.add(dto);
            }
        }
        return result;
    }

    private List<PriceLimitRespDto> getLimitItemList(List<PriceLimitRespDto> respDtos, PriceLimitAddReqDto reqDto) {
        ArrayList result = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        if (CollUtil.isNotEmpty(respDtos) && CollUtil.isNotEmpty((Collection)reqDto.getLimitItemList())) {
            List targetList = reqDto.getLimitItemList().stream().map(LimitItemModifyReqDto::getSkuId).collect(Collectors.toList());
            for (PriceLimitRespDto dto : respDtos) {
                LimitItemEo limitItemEo = new LimitItemEo();
                limitItemEo.setPriceLimitId(dto.getId());
                List itemEos = this.limitItemDas.select((BaseEo)limitItemEo);
                ArrayList reqDtos = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)reqDtos, (Collection)itemEos, LimitItemModifyReqDto.class);
                List sourceList = reqDtos.stream().map(LimitItemModifyReqDto::getSkuId).collect(Collectors.toList());
                if (!sourceList.containsAll(targetList)) continue;
                result.add(dto);
            }
        }
        return result;
    }

    private List<PriceLimitRespDto> getLimitItemRange(List<PriceLimitRespDto> respDtos, PriceLimitAddReqDto reqDto) {
        ArrayList result = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        if (CollUtil.isNotEmpty(respDtos)) {
            boolean bl;
            boolean typeAndBrand;
            boolean backDirAndBrand;
            boolean bl2;
            boolean bl3;
            boolean type;
            boolean backDir;
            PriceItemConditionEo itemConditionEo = new PriceItemConditionEo();
            itemConditionEo.setRelateId(reqDto.getId());
            List itemConditionEos = this.itemConditionDas.select((BaseEo)itemConditionEo);
            ArrayList dtos = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)dtos, (Collection)itemConditionEos, PriceItemConditionRespDto.class);
            boolean bl4 = backDir = CollUtil.isNotEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemBackDirIds()) && CollUtil.isEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemTypes()) && CollUtil.isEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemBrandIds());
            if (backDir) {
                for (PriceLimitRespDto priceLimitRespDto : respDtos) {
                    if (!priceLimitRespDto.getPriceItemConditionRespDto().getItemBackDirIds().containsAll(reqDto.getItemConditionAddReqDto().getItemBackDirIds())) continue;
                    result.add(priceLimitRespDto);
                }
            }
            boolean bl5 = type = CollUtil.isEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemBackDirIds()) && CollUtil.isNotEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemTypes()) && CollUtil.isEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemBrandIds());
            if (type) {
                for (PriceLimitRespDto priceLimitRespDto : respDtos) {
                    if (!priceLimitRespDto.getPriceItemConditionRespDto().getItemTypes().containsAll(reqDto.getItemConditionAddReqDto().getItemTypes())) continue;
                    result.add(priceLimitRespDto);
                }
            }
            boolean bl6 = bl3 = CollUtil.isEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemBackDirIds()) && CollUtil.isEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemTypes()) && CollUtil.isNotEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemBrandIds());
            if (bl3) {
                for (PriceLimitRespDto dto : respDtos) {
                    if (!dto.getPriceItemConditionRespDto().getItemBrandIds().containsAll(reqDto.getItemConditionAddReqDto().getItemBrandIds())) continue;
                    result.add(dto);
                }
            }
            boolean bl7 = bl2 = CollUtil.isNotEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemBackDirIds()) && CollUtil.isNotEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemTypes()) && CollUtil.isEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemBrandIds());
            if (bl2) {
                ArrayList respDtoList = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
                for (PriceLimitRespDto priceLimitRespDto : respDtos) {
                    if (!priceLimitRespDto.getPriceItemConditionRespDto().getItemBackDirIds().containsAll(reqDto.getItemConditionAddReqDto().getItemBackDirIds())) continue;
                    respDtoList.add(priceLimitRespDto);
                }
                for (PriceLimitRespDto priceLimitRespDto : respDtoList) {
                    if (!priceLimitRespDto.getPriceItemConditionRespDto().getItemTypes().containsAll(reqDto.getItemConditionAddReqDto().getItemTypes())) continue;
                    result.add(priceLimitRespDto);
                }
            }
            boolean bl8 = backDirAndBrand = CollUtil.isNotEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemBackDirIds()) && CollUtil.isEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemTypes()) && CollUtil.isNotEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemBrandIds());
            if (backDirAndBrand) {
                ArrayList respDtoList = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
                for (PriceLimitRespDto priceLimitRespDto : respDtos) {
                    if (!priceLimitRespDto.getPriceItemConditionRespDto().getItemBackDirIds().containsAll(reqDto.getItemConditionAddReqDto().getItemBackDirIds())) continue;
                    respDtoList.add(priceLimitRespDto);
                }
                for (PriceLimitRespDto priceLimitRespDto : respDtoList) {
                    if (!priceLimitRespDto.getPriceItemConditionRespDto().getItemBrandIds().containsAll(reqDto.getItemConditionAddReqDto().getItemBrandIds())) continue;
                    result.add(priceLimitRespDto);
                }
            }
            boolean bl9 = typeAndBrand = CollUtil.isEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemBackDirIds()) && CollUtil.isNotEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemTypes()) && CollUtil.isNotEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemBrandIds());
            if (typeAndBrand) {
                ArrayList arrayList = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
                for (PriceLimitRespDto priceLimitRespDto : respDtos) {
                    if (!priceLimitRespDto.getPriceItemConditionRespDto().getItemTypes().containsAll(reqDto.getItemConditionAddReqDto().getItemTypes())) continue;
                    arrayList.add(priceLimitRespDto);
                }
                for (PriceLimitRespDto priceLimitRespDto : arrayList) {
                    if (!priceLimitRespDto.getPriceItemConditionRespDto().getItemBrandIds().containsAll(reqDto.getItemConditionAddReqDto().getItemBrandIds())) continue;
                    result.add(priceLimitRespDto);
                }
            }
            boolean bl10 = bl = CollUtil.isNotEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemBackDirIds()) && CollUtil.isNotEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemTypes()) && CollUtil.isNotEmpty((Collection)reqDto.getItemConditionAddReqDto().getItemBrandIds());
            if (bl) {
                ArrayList arrayList = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
                for (PriceLimitRespDto dto : respDtos) {
                    if (!dto.getPriceItemConditionRespDto().getItemBackDirIds().containsAll(reqDto.getItemConditionAddReqDto().getItemBackDirIds())) continue;
                    arrayList.add(dto);
                }
                ArrayList arrayList2 = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
                for (PriceLimitRespDto dto : arrayList) {
                    if (!dto.getPriceItemConditionRespDto().getItemTypes().containsAll(reqDto.getItemConditionAddReqDto().getItemTypes())) continue;
                    arrayList2.add(dto);
                }
                for (PriceLimitRespDto dto : arrayList2) {
                    if (!dto.getPriceItemConditionRespDto().getItemBrandIds().containsAll(reqDto.getItemConditionAddReqDto().getItemBrandIds())) continue;
                    result.add(dto);
                }
            }
        }
        return result;
    }

    private List<PriceLimitRespDto> getLimitCustomerList(List<PriceLimitRespDto> respDtos, PriceLimitAddReqDto reqDto) {
        ArrayList result = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        if (CollUtil.isNotEmpty(respDtos) && CollUtil.isNotEmpty((Collection)reqDto.getLimitItemList())) {
            List targetList = reqDto.getLimitCustomerReqDtos().stream().map(LimitCustomerReqDto::getCustomerCode).collect(Collectors.toList());
            for (PriceLimitRespDto dto : respDtos) {
                LimitCustomerEo customerEo = new LimitCustomerEo();
                customerEo.setRelateId(dto.getId());
                List limitCustomerEos = this.limitCustomerDas.select((BaseEo)customerEo);
                ArrayList reqDtos = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)reqDtos, (Collection)limitCustomerEos, LimitCustomerRespDto.class);
                List sourceList = reqDtos.stream().map(LimitCustomerRespDto::getCustomerCode).collect(Collectors.toList());
                if (!sourceList.containsAll(targetList)) continue;
                result.add(dto);
            }
        }
        return result;
    }

    private List<PriceLimitRespDto> getLimitCustomerRange(List<PriceLimitRespDto> respDtos, PriceLimitAddReqDto reqDto) {
        ArrayList result = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        if (CollUtil.isNotEmpty(respDtos)) {
            CustomerConditionEo customerConditionEo = new CustomerConditionEo();
            customerConditionEo.setRelateId(reqDto.getId());
            List customerConditionEos = this.customerConditionDas.select((BaseEo)customerConditionEo);
            ArrayList dtos = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)dtos, (Collection)customerConditionEos, CustomerConditionRespDto.class);
            this.customerArea(respDtos, reqDto);
            this.customerType(respDtos, reqDto);
            this.customerAreaAndType(respDtos, reqDto);
        }
        return result;
    }

    private List<PriceLimitRespDto> customerArea(List<PriceLimitRespDto> respDtos, PriceLimitAddReqDto reqDto) {
        boolean customerArea;
        ArrayList result = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        boolean bl = customerArea = CollUtil.isNotEmpty((Collection)reqDto.getCustomerConditionAddReqDto().getCustomerAreaCodes()) && CollUtil.isEmpty((Collection)reqDto.getCustomerConditionAddReqDto().getCustomerTypeIds());
        if (customerArea) {
            for (PriceLimitRespDto dto : respDtos) {
                if (!dto.getCustomerConditionRespDto().getCustomerAreaCodes().containsAll(reqDto.getCustomerConditionAddReqDto().getCustomerAreaCodes())) continue;
                result.add(dto);
            }
        }
        return result;
    }

    private List<PriceLimitRespDto> customerType(List<PriceLimitRespDto> respDtos, PriceLimitAddReqDto reqDto) {
        boolean customerType;
        ArrayList result = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        boolean bl = customerType = CollUtil.isEmpty((Collection)reqDto.getCustomerConditionAddReqDto().getCustomerAreaCodes()) && CollUtil.isNotEmpty((Collection)reqDto.getCustomerConditionAddReqDto().getCustomerTypeIds());
        if (customerType) {
            for (PriceLimitRespDto dto : respDtos) {
                if (!dto.getCustomerConditionRespDto().getCustomerTypeIds().containsAll(reqDto.getCustomerConditionAddReqDto().getCustomerTypeIds())) continue;
                result.add(dto);
            }
        }
        return result;
    }

    private List<PriceLimitRespDto> customerAreaAndType(List<PriceLimitRespDto> respDtos, PriceLimitAddReqDto reqDto) {
        boolean customerAreaAndType;
        ArrayList result = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        boolean bl = customerAreaAndType = CollUtil.isNotEmpty((Collection)reqDto.getCustomerConditionAddReqDto().getCustomerAreaCodes()) && CollUtil.isNotEmpty((Collection)reqDto.getCustomerConditionAddReqDto().getCustomerTypeIds());
        if (customerAreaAndType) {
            ArrayList typeList = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
            for (PriceLimitRespDto dto : respDtos) {
                if (!dto.getCustomerConditionRespDto().getCustomerTypeIds().containsAll(reqDto.getCustomerConditionAddReqDto().getCustomerTypeIds())) continue;
                typeList.add(dto);
            }
            for (PriceLimitRespDto dto : typeList) {
                if (!dto.getCustomerConditionRespDto().getCustomerAreaCodes().containsAll(reqDto.getCustomerConditionAddReqDto().getCustomerAreaCodes())) continue;
                result.add(dto);
            }
        }
        return result;
    }
}

