/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.DiscountItemAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.DiscountItemModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.DiscountItemQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.DiscountItemRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.service.IDiscountItemService;
import com.dtyunxi.yundt.cube.center.price.dao.das.DiscountItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.DiscountItemEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DiscountItemServiceImpl
implements IDiscountItemService {
    @Resource
    private DiscountItemDas discountItemDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addDiscountItem(DiscountItemAddReqDto reqDto) {
        DiscountItemEo discountItemEo = new DiscountItemEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)discountItemEo);
        this.discountItemDas.insert((BaseEo)discountItemEo);
        return discountItemEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyDiscountItem(DiscountItemModifyReqDto reqDto) {
        DiscountItemEo discountItemEo = new DiscountItemEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)discountItemEo);
        this.discountItemDas.updateSelective((BaseEo)discountItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDiscountItem(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.discountItemDas.logicDeleteById(Long.valueOf(id.trim()));
        }
    }

    @Override
    public DiscountItemRespDto queryDiscountItemById(Long id) {
        DiscountItemEo discountItemEo = (DiscountItemEo)this.discountItemDas.selectByPrimaryKey(id);
        if (discountItemEo == null) {
            return null;
        }
        DiscountItemRespDto discountItemRespDto = new DiscountItemRespDto();
        DtoHelper.eo2Dto((BaseEo)discountItemEo, (BaseVo)discountItemRespDto);
        return discountItemRespDto;
    }

    @Override
    public PageInfo<DiscountItemRespDto> queryDiscountItemByPage(DiscountItemQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        DiscountItemEo discountItemEo = new DiscountItemEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)discountItemEo);
        PageInfo eoPageInfo = this.discountItemDas.selectPage((BaseEo)discountItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DiscountItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

