/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRelRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.AuditResultEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.CategoryCodeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.CustomerDimensionEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.GeneralRuleTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.ItemDimensionEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceBasicConfigEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceCommonEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceModelSetTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.SyncStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.SyncTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.AuditAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.BasePriceItemDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.InitDataReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceAdjustReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.SyncPriceDataReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceBasicConfigRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.vo.RelationCustomerInfoVo;
import com.dtyunxi.yundt.cube.center.price.api.dto.vo.RelationInfoVo;
import com.dtyunxi.yundt.cube.center.price.api.dto.vo.RelationItemInfoVo;
import com.dtyunxi.yundt.cube.center.price.biz.constant.PriceExceptionCode;
import com.dtyunxi.yundt.cube.center.price.biz.helper.CommonHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.SkuHelper;
import com.dtyunxi.yundt.cube.center.price.biz.service.IAuditService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IInitDataService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceBasicConfigService;
import com.dtyunxi.yundt.cube.center.price.biz.service.ISellerSkuPriceService;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.IPricePolicyEsService;
import com.dtyunxi.yundt.cube.center.price.biz.service.impl.TransactionCallBackService;
import com.dtyunxi.yundt.cube.center.price.biz.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.price.biz.utils.AssertUtils;
import com.dtyunxi.yundt.cube.center.price.biz.utils.CommonUtils;
import com.dtyunxi.yundt.cube.center.price.biz.utils.GenerateCode;
import com.dtyunxi.yundt.cube.center.price.dao.das.AuditDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.BasePriceApplyDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.BasePriceApplyItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.BasePriceItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.BasePriceRelationTypeDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.CustomerConditionDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.InitDataLogDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.LimitItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.ModifyPriceLogDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceBasicConfigDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceItemConditionDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceLimitDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceModelDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceRejectCustomerDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceRejectItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceTypeDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.SellerSkuPriceDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.AuditEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.BasePriceApplyEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.BasePriceItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.BasePriceRelationTypeEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.CustomerConditionEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.InitDataLogEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.LimitItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceBasicConfigEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceItemConditionEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceLimitEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceModelEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceRejectCustomerEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceRejectItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceTypeEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.SellerSkuPriceEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdBasePriceItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdCustomerConditionEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceItemConditionEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceRejectCustomerEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceRejectItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.vo.DealerShopCustomerInfoVo;
import com.dtyunxi.yundt.cube.center.price.dao.vo.SkuPriceInfoVo;
import com.dtyunxi.yundt.cube.center.price.dao.vo.SkuPriceVo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InitDataServiceImpl
implements IInitDataService {
    private static final Logger log = LoggerFactory.getLogger(InitDataServiceImpl.class);
    private static final Long INSTANCEID = 1254039287584232622L;
    private static final Long TENANTID = 1L;
    @Resource
    private SellerSkuPriceDas sellerSkuPriceDas;
    @Resource
    private InitDataLogDas initDataLogDas;
    @Resource
    private CommonHelper commonHelper;
    @Resource
    private SkuHelper skuHelper;
    @Resource
    private ISellerSkuPriceService sellerSkuPriceService;
    @Resource
    private PriceLimitDas priceLimitDas;
    @Resource
    private LimitItemDas limitItemDas;
    @Resource
    private PriceTypeDas priceTypeDas;
    @Resource
    private PriceModelDas priceModelDas;
    @Resource
    private PriceDas priceDas;
    @Resource
    private BasePriceRelationTypeDas basePriceRelationTypeDas;
    @Resource
    private PriceBasicConfigDas priceBasicConfigDas;
    @Resource
    private PriceItemDas priceItemDas;
    @Resource
    private PriceItemConditionDas priceItemConditionDas;
    @Resource
    private PriceRejectItemDas priceRejectItemDas;
    @Resource
    private CustomerConditionDas customerConditionDas;
    @Resource
    private PriceRejectCustomerDas priceRejectCustomerDas;
    @Resource
    private IPriceBasicConfigService priceBasicConfigService;
    @Resource
    private IPricePolicyEsService pricePolicyEsService;
    @Resource
    private GenerateCode generateCode;
    @Resource
    private IAuditService auditService;
    @Resource
    private IContext context;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private BasePriceItemDas basePriceItemDas;
    @Resource
    private BasePriceApplyDas basePriceApplyDas;
    @Resource
    private AuditDas auditDas;
    @Resource
    private BasePriceApplyItemDas basePriceApplyItemDas;
    @Resource
    private ModifyPriceLogDas modifyPriceLogDas;
    @Value(value="${price.type.weight:1000}")
    private String WEIGHT;
    private static final String CREATE_PERSON = "system";
    private static final String INIT_DATA_KEY = "INIT_DATA";
    private static final int SECONDS = 120;
    private static final int INDEX = 0;
    private static ExecutorService executor = ThreadUtil.newExecutor((int)5);
    @Value(value="${price.init.status:DISABLE}")
    private String status;
    @Value(value="${price.init.tenantId}")
    private Long tenantId;
    @Value(value="${price.init.instanceId}")
    private Long instanceId;
    @Autowired
    private IShopExtQueryApi shopExtQueryApi;
    @Autowired
    private ICustomerQueryApi customerQueryApi;
    @Autowired
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Autowired
    TransactionCallBackService transactionCallBackService;
    private final ExecutorService executorService = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors() * 4, 120L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    private void enableInitConfig() {
        AssertUtils.isTrue(Objects.equals(this.status, "ENABLE"), PriceExceptionCode.ERROR.setParamValue("\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u542f\u7528\u521d\u59cb\u5316\u914d\u7f6e\u9879"));
    }

    @Override
    public void initDefaultPrice(Long shopId, Long orgId, String orgName) {
        Long businessId = this.generateCode.genId();
        Date effTime = new Date();
        this.insertDefaultPrice(businessId, shopId, orgId, orgName, effTime);
        int relatedNum = 1;
        this.insertPriceMode(businessId, relatedNum, orgId, effTime);
        this.insertPriceType(businessId, "\u5e38\u89c4\u4ef7", "2", relatedNum, orgId, effTime);
        this.insertPriceBasicConfig(orgId, effTime);
        this.insertAudit(businessId, effTime, "0");
        this.pricePolicyEsService.updatePricePolicy(businessId);
    }

    @Override
    public void batchSyncPriceRules(Long shopId, Long orgId, String orgName, List<PriceAdjustReqDto> priceAdjustReqDtoList) {
        Date effTime = new Date();
        ArrayList priceIdList = Lists.newArrayList();
        priceAdjustReqDtoList.stream().forEach(dto -> priceIdList.addAll(this.initPriceRule(shopId, orgId, orgName, (PriceAdjustReqDto)dto, shopId, effTime)));
        int relatedNum = this.getRelateNum(priceAdjustReqDtoList);
        this.insertOrUpdatePriceMode(shopId, relatedNum, orgId, effTime);
        this.insertOrUpdatePriceType(shopId, "\u7279\u6b8a\u4ef7", "1", relatedNum, orgId, effTime);
        this.transactionCallBackService.execute(() -> this.executorService.execute(new Thread(() -> {
            log.info("\u5f02\u6b65\u5904\u7406ES\u5199\u5165");
            priceIdList.stream().forEach(id -> this.pricePolicyEsService.updatePricePolicy((Long)id));
        })));
    }

    private void insertOrUpdatePriceMode(Long modeId, int relatedNum, Long orgId, Date effTime) {
        PriceModelEo modelEo = (PriceModelEo)this.priceModelDas.selectByPrimaryKey(modeId);
        if (Objects.nonNull(modelEo)) {
            modelEo.setRelatedNum(Integer.valueOf(modelEo.getRelatedNum() + relatedNum));
            modelEo.setUpdateTime(effTime);
            this.priceModelDas.update((BaseEo)modelEo);
        } else {
            PriceModelEo eo = new PriceModelEo();
            eo.setId(modeId);
            eo.setModelName("\u6263\u7387\u5b9a\u4ef7/\u76f4\u63a5\u5b9a\u4ef7");
            eo.setModelCode("JGMX" + modeId);
            eo.setDirectSet(Integer.valueOf(1));
            eo.setDiscountSet(Integer.valueOf(1));
            eo.setTemporaryDiscount(Integer.valueOf(1));
            eo.setFixedDiscount(Integer.valueOf(1));
            eo.setRelatedNum(Integer.valueOf(relatedNum));
            eo.setStatus("0");
            eo.setOrganizationId(orgId);
            this.initBaseEo((BaseEo)eo, effTime);
            this.priceModelDas.insert((BaseEo)eo);
            ArrayList eos = Lists.newArrayList();
            BasePriceRelationTypeEo eo1 = new BasePriceRelationTypeEo();
            eo1.setPriceTypeId(Long.valueOf(1L));
            eo1.setPriceTypeCode("RETAIL_PRICE");
            eo1.setPriceTypeName("\u5efa\u8bae\u96f6\u552e\u4ef7");
            eo1.setPriceModelId(modeId);
            eo1.setPriceModelName("\u6263\u7387\u5b9a\u4ef7/\u76f4\u63a5\u5b9a\u4ef7");
            this.initBaseEo((BaseEo)eo1, effTime);
            eos.add(eo1);
            BasePriceRelationTypeEo eo2 = new BasePriceRelationTypeEo();
            eo2.setPriceTypeId(Long.valueOf(3L));
            eo2.setPriceTypeCode("DEALER_RETAIL_PRICE");
            eo2.setPriceTypeName("\u81ea\u5b9a\u4e49\u96f6\u552e\u4ef7");
            eo2.setPriceModelId(modeId);
            eo2.setPriceModelName("\u6263\u7387\u5b9a\u4ef7/\u76f4\u63a5\u5b9a\u4ef7");
            this.initBaseEo((BaseEo)eo2, effTime);
            eos.add(eo2);
            this.basePriceRelationTypeDas.insertBatch((List)eos);
        }
    }

    private void insertOrUpdatePriceType(Long typeId, String typeName, String weight, int relatedNum, Long orgId, Date effTime) {
        PriceTypeEo typeEo = (PriceTypeEo)this.priceTypeDas.selectByPrimaryKey(typeId);
        if (Objects.nonNull(typeEo)) {
            typeEo.setRelatedNum(Integer.valueOf(typeEo.getRelatedNum() + relatedNum));
            typeEo.setUpdateTime(effTime);
            this.priceTypeDas.update((BaseEo)typeEo);
        } else {
            PriceTypeEo eo = new PriceTypeEo();
            eo.setId(typeId);
            eo.setTypeCode("JGLX" + typeId);
            eo.setCategoryCode("3");
            eo.setTypeName(typeName);
            eo.setStatus("0");
            eo.setWeight(weight);
            eo.setOrganizationId(orgId);
            eo.setRelatedNum(Integer.valueOf(relatedNum));
            this.initBaseEo((BaseEo)eo, effTime);
            this.priceTypeDas.insert((BaseEo)eo);
        }
    }

    private List<Long> initPriceRule(Long shopId, Long orgId, String orgName, PriceAdjustReqDto priceAdjustReqDto, Long businessId, Date effTime) {
        ArrayList priceEoList = Lists.newArrayList();
        ArrayList itemConditionEoList = Lists.newArrayList();
        ArrayList customerConditionEoList = Lists.newArrayList();
        ArrayList priceItemEoList = Lists.newArrayList();
        ArrayList auditEoList = Lists.newArrayList();
        Set detailSet = priceAdjustReqDto.getDetailMap().entrySet();
        for (Map.Entry detail : detailSet) {
            Long priceId = this.generateCode.genId();
            List<PriceItemEo> priceItemEos = this.initPriceItemEos((String)detail.getKey(), priceId, effTime, shopId);
            if (CollUtil.isNotEmpty(priceItemEos = this.queryItemAndSetInfo(priceItemEos))) {
                PriceItemConditionEo itemConditionEo = this.initPriceItemConditionEo(priceItemEos, priceId, effTime, orgId);
                CustomerConditionEo customerConditionEo = this.initCustomerConditionEo((List)detail.getValue(), priceAdjustReqDto.getControlScope(), priceId, effTime);
                String extension = this.getExtension(priceAdjustReqDto.getControlScope(), priceItemEos.size(), ((List)detail.getValue()).size());
                PriceEo priceEo = this.initPriceEo(priceId, businessId, priceAdjustReqDto, shopId, orgId, orgName, extension, effTime);
                AuditEo auditEo = this.initAudit(priceId, effTime, "0");
                priceEoList.add(priceEo);
                itemConditionEoList.add(itemConditionEo);
                customerConditionEoList.add(customerConditionEo);
                priceItemEoList.addAll(priceItemEos);
                auditEoList.add(auditEo);
                continue;
            }
            log.info("batchSyncPriceRules:itemSkuRelRespDtos is NULL detail={}", detail);
        }
        this.priceDas.insertBatch((List)priceEoList);
        this.priceItemConditionDas.insertBatch((List)itemConditionEoList);
        this.priceItemDas.insertBatch((List)priceItemEoList);
        this.customerConditionDas.insertBatch((List)customerConditionEoList);
        this.auditDas.insertBatch((List)auditEoList);
        List<Long> priceIds = priceEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        return priceIds;
    }

    private PriceEo initPriceEo(Long priceId, Long businessId, PriceAdjustReqDto priceAdjustReqDto, Long shopId, Long orgId, String orgName, String extension, Date effTime) {
        PriceEo eo = new PriceEo();
        eo.setId(priceId);
        eo.setCategoryCode("3");
        eo.setTypeId(businessId);
        eo.setModelId(businessId);
        eo.setStatus("AUDIT_PASS");
        eo.setCode("JGZC" + priceId);
        eo.setName(priceAdjustReqDto.getAdjustmentName());
        eo.setOrganizationId(orgId);
        eo.setOrganizationName(orgName);
        eo.setEffectiveTime(priceAdjustReqDto.getStartDate());
        eo.setInvalidTime(priceAdjustReqDto.getEndDate());
        if ("applyer".equals(priceAdjustReqDto.getControlScope())) {
            eo.setRelationCustomerType(Integer.valueOf(0));
        } else {
            eo.setRelationCustomerType(Integer.valueOf(1));
        }
        eo.setExtension(extension);
        eo.setShopId(shopId);
        eo.setRelationItemType(Integer.valueOf(0));
        eo.setDiscountType(Integer.valueOf(2));
        eo.setReadStatus(Integer.valueOf(0));
        this.initBaseEo((BaseEo)eo, effTime);
        return eo;
    }

    private AuditEo initAudit(Long id, Date effTime, String relateType) {
        AuditEo eo = new AuditEo();
        eo.setId(id);
        eo.setAuditPerson(CREATE_PERSON);
        eo.setAuditTime(effTime);
        eo.setAuditComments("\u6570\u636e\u540c\u6b65\uff0c\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7");
        eo.setRelateId(id);
        eo.setRelateType(relateType);
        eo.setAuditStatus(PriceStatusEnum.AUDIT_PASS.getCode());
        this.initBaseEo((BaseEo)eo, effTime);
        return eo;
    }

    private CustomerConditionEo initCustomerConditionEo(List<String> details, String controlScope, Long priceId, Date effTime) {
        CustomerConditionEo eo = new CustomerConditionEo();
        if ("applyer".equals(controlScope)) {
            List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByThirdPartyIds(details));
            Set customerIds = customerRespDtos.stream().map(BaseRespDto::getId).collect(Collectors.toSet());
            if (CollUtil.isNotEmpty(customerIds)) {
                eo.setCustomerIds(StringUtils.join(customerIds, (String)","));
            } else {
                eo.setCustomerIds(StringUtils.join(details, (String)","));
            }
        } else {
            eo.setCustomerAreaCodes(StringUtils.join(details, (String)","));
            CustomerAreaListReqDto reqDto = new CustomerAreaListReqDto();
            reqDto.setCodes(details);
            List areadCodes = (List)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.querySubCodeAll(reqDto));
            eo.setCustomerAreaCodeExt(StringUtils.join((Iterable)areadCodes, (String)","));
        }
        eo.setRelateType("0");
        eo.setRelateId(priceId);
        this.initBaseEo((BaseEo)eo, effTime);
        return eo;
    }

    private PriceItemConditionEo initPriceItemConditionEo(List<PriceItemEo> priceItemEos, Long priceId, Date effTime, Long orgId) {
        PriceItemConditionEo eo = new PriceItemConditionEo();
        Set skuIdSet = priceItemEos.stream().map(StdPriceItemEo::getSkuId).collect(Collectors.toSet());
        Set itemIdSet = priceItemEos.stream().map(StdPriceItemEo::getItemId).collect(Collectors.toSet());
        eo.setSkuIds(StringUtils.join(skuIdSet, (String)","));
        eo.setItemIds(StringUtils.join(itemIdSet, (String)","));
        eo.setRelateType("0");
        eo.setRelateId(priceId);
        eo.setOrganizationId(orgId);
        this.initBaseEo((BaseEo)eo, effTime);
        return eo;
    }

    private List<PriceItemEo> queryItemAndSetInfo(List<PriceItemEo> priceItemEos) {
        ArrayList retList = Lists.newArrayList();
        List skuCodes = priceItemEos.stream().map(StdPriceItemEo::getSkuCode).collect(Collectors.toList());
        List itemSkuRelRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryItemSkuBySkuCodes(skuCodes));
        if (CollUtil.isNotEmpty((Collection)itemSkuRelRespDtos)) {
            itemSkuRelRespDtos.stream().forEach(dto -> priceItemEos.stream().filter(eo -> eo.getSkuCode().equals(dto.getLongCode())).forEach(eo -> {
                eo.setItemId(dto.getItemId());
                eo.setItemName(dto.getItemName());
                eo.setSkuId(dto.getSkuId());
                eo.setSkuDesc(dto.getSkuAttr());
                eo.setItemOrgId(dto.getItemOrgId());
                eo.setItemBrand(dto.getItemBrand());
                eo.setGiftBox(dto.getGiftBox());
                retList.add(eo);
            }));
        } else {
            log.info("batchSyncBasePriceItems:skuCodes is NULL");
        }
        return retList;
    }

    private List<PriceItemEo> initPriceItemEos(String skuKeyStrs, Long priceId, Date effTime, Long shopId) {
        String[] skuKeystr;
        ArrayList retList = Lists.newArrayList();
        for (String skuKey : skuKeystr = skuKeyStrs.split(",")) {
            String[] info = skuKey.split("&");
            PriceItemEo eo = new PriceItemEo();
            eo.setSkuCode(info[0]);
            if ("-1".equals(info[1])) {
                eo.setPriceModelSetType(Integer.valueOf(1));
                eo.setDiscountType(Integer.valueOf(2));
            } else {
                eo.setPriceModelSetType(Integer.valueOf(0));
                eo.setItemPrice(new BigDecimal(info[1]));
            }
            if (!"-1".equals(info[2])) {
                eo.setDiscountRate(new BigDecimal(info[2]));
            }
            if (!"-1".equals(info[3])) {
                eo.setGiftboxIncrPrice(new BigDecimal(info[3]));
            }
            eo.setPriceId(priceId);
            eo.setLowerLimit(Integer.valueOf(1));
            eo.setShopId(shopId);
            this.initBaseEo((BaseEo)eo, effTime);
            retList.add(eo);
        }
        return retList;
    }

    private String getExtension(String controlScope, int skuIdNum, int scopeNum) {
        StringBuffer sb = new StringBuffer();
        if ("applyer".equals(controlScope)) {
            sb.append("{\"relationCustomerInfo\":{\"rejectCustomerCount\":null,\"customerIdNum\":").append(scopeNum).append(",\"customerTypeIdNum\":null,\"customerAreaCodeNum\":null,\"customerGroupIdNum\":null},\"relationItemInfo\":{\"rejectItemCount\":null,\"skuIdNum\":").append(skuIdNum).append(",\"itemTypeNum\":null,\"itemBackDirIdNum\":null,\"itemBrandIdNum\":null}}");
        } else {
            sb.append("{\"relationCustomerInfo\":{\"rejectCustomerCount\":null,\"customerIdNum\":null,\"customerTypeIdNum\":null,\"customerAreaCodeNum\":").append(scopeNum).append(",\"customerGroupIdNum\":null},\"relationItemInfo\":{\"rejectItemCount\":null,\"skuIdNum\":").append(skuIdNum).append(",\"itemTypeNum\":null,\"itemBackDirIdNum\":null,\"itemBrandIdNum\":null}}");
        }
        return sb.toString();
    }

    private int getRelateNum(List<PriceAdjustReqDto> priceAdjustReqDtoList) {
        int relatedNum = 0;
        for (PriceAdjustReqDto dto : priceAdjustReqDtoList) {
            relatedNum += dto.getDetailMap().keySet().size();
        }
        return relatedNum;
    }

    private void insertDefaultPrice(Long businessId, Long shopId, Long orgId, String orgName, Date effTime) {
        PriceEo eo = new PriceEo();
        eo.setId(businessId);
        eo.setCategoryCode("3");
        eo.setTypeId(businessId);
        eo.setModelId(businessId);
        eo.setStatus("AUDIT_PASS");
        eo.setCode("JGZC" + businessId);
        eo.setName("\u9ed8\u8ba4\u6263\u7387\u5b9a\u4ef7\u4ef7\u683c\u653f\u7b56");
        eo.setOrganizationId(orgId);
        eo.setOrganizationName(orgName);
        eo.setEffectiveTime(effTime);
        eo.setRelationCustomerType(Integer.valueOf(2));
        eo.setExtension("{\"relationCustomerInfo\":null,\"relationItemInfo\":null}");
        eo.setShopId(shopId);
        eo.setRelationItemType(Integer.valueOf(2));
        eo.setDiscountType(Integer.valueOf(2));
        eo.setReadStatus(Integer.valueOf(1));
        this.initBaseEo((BaseEo)eo, effTime);
        this.priceDas.insert((BaseEo)eo);
    }

    private void insertPriceBasicConfig(Long orgId, Date effTime) {
        PriceBasicConfigEo eo = new PriceBasicConfigEo();
        eo.setConfigType(Integer.valueOf(0));
        eo.setControlType(Integer.valueOf(0));
        eo.setRuleDiffDim(Integer.valueOf(0));
        eo.setRuleSameDim(Integer.valueOf(1));
        eo.setOrganizationId(orgId);
        this.initBaseEo((BaseEo)eo, effTime);
        this.priceBasicConfigDas.insert((BaseEo)eo);
    }

    private void insertPriceMode(Long modeId, int relatedNum, Long orgId, Date effTime) {
        PriceModelEo eo = new PriceModelEo();
        eo.setId(modeId);
        eo.setModelName("\u6263\u7387\u5b9a\u4ef7/\u76f4\u63a5\u5b9a\u4ef7");
        eo.setModelCode("JGMX" + modeId);
        eo.setDirectSet(Integer.valueOf(1));
        eo.setDiscountSet(Integer.valueOf(1));
        eo.setTemporaryDiscount(Integer.valueOf(1));
        eo.setFixedDiscount(Integer.valueOf(1));
        eo.setRelatedNum(Integer.valueOf(relatedNum));
        eo.setStatus("0");
        eo.setOrganizationId(orgId);
        this.initBaseEo((BaseEo)eo, effTime);
        this.priceModelDas.insert((BaseEo)eo);
        ArrayList eos = Lists.newArrayList();
        BasePriceRelationTypeEo eo1 = new BasePriceRelationTypeEo();
        eo1.setPriceTypeId(Long.valueOf(1L));
        eo1.setPriceTypeCode("RETAIL_PRICE");
        eo1.setPriceTypeName("\u5efa\u8bae\u96f6\u552e\u4ef7");
        eo1.setPriceModelId(modeId);
        eo1.setPriceModelName("\u6263\u7387\u5b9a\u4ef7/\u76f4\u63a5\u5b9a\u4ef7");
        this.initBaseEo((BaseEo)eo1, effTime);
        eos.add(eo1);
        BasePriceRelationTypeEo eo2 = new BasePriceRelationTypeEo();
        eo2.setPriceTypeId(Long.valueOf(3L));
        eo2.setPriceTypeCode("DEALER_RETAIL_PRICE");
        eo2.setPriceTypeName("\u81ea\u5b9a\u4e49\u96f6\u552e\u4ef7");
        eo2.setPriceModelId(modeId);
        eo2.setPriceModelName("\u6263\u7387\u5b9a\u4ef7/\u76f4\u63a5\u5b9a\u4ef7");
        this.initBaseEo((BaseEo)eo2, effTime);
        eos.add(eo2);
        this.basePriceRelationTypeDas.insertBatch((List)eos);
    }

    private void insertPriceType(Long typeId, String typeName, String weight, int relatedNum, Long orgId, Date effTime) {
        PriceTypeEo eo = new PriceTypeEo();
        eo.setId(typeId);
        eo.setTypeCode("JGLX" + typeId);
        eo.setCategoryCode("3");
        eo.setTypeName(typeName);
        eo.setStatus("0");
        eo.setWeight(weight);
        eo.setOrganizationId(orgId);
        eo.setRelatedNum(Integer.valueOf(relatedNum));
        this.initBaseEo((BaseEo)eo, effTime);
        this.priceTypeDas.insert((BaseEo)eo);
    }

    private void initBaseEo(BaseEo eo, Date effTime) {
        eo.setTenantId(this.tenantId);
        eo.setInstanceId(this.instanceId);
        eo.setCreatePerson(CREATE_PERSON);
        eo.setCreateTime(effTime);
        eo.setUpdatePerson(CREATE_PERSON);
        eo.setUpdateTime(effTime);
    }

    @Override
    public void batchSyncBasePriceItems(List<BasePriceItemDto> basePriceItemDtoList) {
        if (CollUtil.isNotEmpty(basePriceItemDtoList)) {
            List<String> samePriceSkuCodes = this.querySamePriceSkuCodes(basePriceItemDtoList);
            log.info("batchSyncBasePriceItems:samePriceSkuCodes={}", samePriceSkuCodes);
            List<ItemSkuRelRespDto> itemSkuRelRespDtos = this.queryItemSkuByItemCodes(basePriceItemDtoList, samePriceSkuCodes);
            if (CollUtil.isNotEmpty(itemSkuRelRespDtos)) {
                Long shopId = basePriceItemDtoList.get(0).getShopId();
                Map<String, BasePriceItemEo> existEosMap = this.queryMapByshopId(shopId);
                ArrayList existIds = Lists.newArrayList();
                List<BasePriceItemEo> newBasePriceItemEos = this.prepareBasePriceItemEos(itemSkuRelRespDtos, basePriceItemDtoList, existEosMap, existIds);
                List<Long> delIds = existEosMap.values().stream().filter(eo -> !existIds.contains(eo.getId())).map(BaseEo::getId).collect(Collectors.toList());
                Long orgId = basePriceItemDtoList.get(0).getOrganizationId();
                this.batchUpdateData(newBasePriceItemEos, delIds, shopId, orgId);
            } else {
                log.info("batchSyncBasePriceItems:itemSkuRelRespDtos is NULL basePriceItemDtoList={}", basePriceItemDtoList);
            }
        } else {
            log.info("batchSyncBasePriceItems:basePriceItemDtoList is NULL");
        }
    }

    public void batchUpdateData(List<BasePriceItemEo> newBasePriceItemEos, List<Long> delIds, Long shopId, Long orgId) {
        Long bussinessId = this.generateCode.genId();
        String bussinessCode = "TJSQ" + bussinessId;
        log.info("batchSyncBasePriceItems:bussinessId; bussinessId={}, bussinessCode={}", (Object)bussinessId, (Object)bussinessCode);
        int skuNum = newBasePriceItemEos.size();
        Date effTime = new Date();
        this.insertBasePriceApply(bussinessId, bussinessCode, skuNum, effTime, shopId, orgId);
        if (skuNum > 0) {
            this.insertAudit(bussinessId, effTime, "3");
            newBasePriceItemEos.stream().forEach(eo -> {
                eo.setBusinessId(bussinessId);
                eo.setBusinessCode(bussinessCode);
            });
            this.basePriceItemDas.updateOrInsert(newBasePriceItemEos);
            List basePriceItemIds = newBasePriceItemEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            log.info("batchSyncBasePriceItems:basePriceItemIds; shopId={}, basePriceItemIds={}", (Object)shopId, basePriceItemIds);
            this.basePriceApplyItemDas.selectInsertBatch(basePriceItemIds);
            this.modifyPriceLogDas.selectInsertBatch(basePriceItemIds);
        } else {
            log.info("batchSyncBasePriceItems:newBasePriceItemEos size=0; shopId={}, orgId={}", (Object)shopId, (Object)orgId);
        }
    }

    private void insertAudit(Long id, Date effTime, String relateType) {
        AuditEo eo = new AuditEo();
        eo.setId(id);
        eo.setAuditPerson(CREATE_PERSON);
        eo.setAuditTime(effTime);
        eo.setAuditComments("\u6570\u636e\u540c\u6b65\uff0c\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7");
        eo.setRelateId(id);
        eo.setRelateType(relateType);
        eo.setAuditStatus(PriceStatusEnum.AUDIT_PASS.getCode());
        eo.setTenantId(this.tenantId);
        eo.setInstanceId(this.instanceId);
        eo.setCreatePerson(CREATE_PERSON);
        eo.setCreateTime(effTime);
        eo.setUpdatePerson(CREATE_PERSON);
        eo.setUpdateTime(effTime);
        this.auditDas.insert((BaseEo)eo);
    }

    private void insertBasePriceApply(Long id, String code, int skuNum, Date effTime, Long shopId, Long orgId) {
        BasePriceApplyEo eo = new BasePriceApplyEo();
        eo.setId(id);
        eo.setApplyCode(code);
        eo.setApplyName("\u6570\u636e\u540c\u6b65");
        eo.setSkuNum(Integer.valueOf(skuNum));
        eo.setShopId(shopId);
        eo.setOrganizationId(orgId);
        eo.setEffectTime(effTime);
        eo.setStatus(PriceStatusEnum.AUDIT_PASS.getCode());
        eo.setSyncStatus(Integer.valueOf(1));
        eo.setTenantId(this.tenantId);
        eo.setInstanceId(this.instanceId);
        eo.setCreatePerson(CREATE_PERSON);
        eo.setCreateTime(effTime);
        eo.setUpdatePerson(CREATE_PERSON);
        eo.setUpdateTime(effTime);
        this.basePriceApplyDas.insert((BaseEo)eo);
    }

    private List<BasePriceItemEo> prepareBasePriceItemEos(List<ItemSkuRelRespDto> itemSkuRelRespDtos, List<BasePriceItemDto> basePriceItemDtoList, Map<String, BasePriceItemEo> existEosMap, List<Long> existIds) {
        ArrayList retList = Lists.newArrayList();
        itemSkuRelRespDtos.stream().forEach(dto -> basePriceItemDtoList.stream().filter(param -> param.getSkuCode().equals(dto.getLongCode())).forEach(param -> {
            BasePriceItemEo eo = (BasePriceItemEo)existEosMap.get(dto.getLongCode());
            if (Objects.isNull(eo)) {
                eo = new BasePriceItemEo();
                DtoHelper.dto2Eo((BaseVo)param, (BaseEo)eo);
                eo.setItemId(dto.getItemId());
                eo.setSkuId(dto.getSkuId());
                eo.setItemType(String.valueOf(dto.getSubType()));
                eo.setItemOrgId(dto.getItemOrgId());
                eo.setGiftBox(dto.getGiftBox());
                eo.setSkuSpec(dto.getSkuAttr());
                eo.setId(this.generateCode.genId());
                eo.setItemDirName("\u9ed8\u8ba4\u7c7b\u76ee");
                eo.setTypeId(Long.valueOf(3L));
                retList.add(eo);
            } else {
                existIds.add(eo.getId());
                if (eo.getItemPrice().compareTo(param.getItemPrice()) == 0) {
                    log.info("batchSyncBasePriceItems: \u4e0d\u9700\u8981\u66f4\u65b0\u6570\u636e eo.getShopId()={}, param.getSkuCode()={}, param.getItemPrice()={}", new Object[]{eo.getShopId(), param.getSkuCode(), param.getItemPrice()});
                } else {
                    eo.setItemPrice(param.getItemPrice());
                    eo.setRenewTime(param.getRenewTime());
                }
            }
        }));
        return retList;
    }

    private Map<String, BasePriceItemEo> queryMapByshopId(Long shopId) {
        BasePriceItemEo eo = new BasePriceItemEo();
        eo.setShopId(shopId);
        List basePriceItemEos = this.basePriceItemDas.select((BaseEo)eo);
        Map<String, BasePriceItemEo> retMap = basePriceItemEos.stream().collect(Collectors.toMap(StdBasePriceItemEo::getSkuCode, Function.identity(), (key1, key2) -> key2));
        return retMap;
    }

    private List<ItemSkuRelRespDto> queryItemSkuByItemCodes(List<BasePriceItemDto> basePriceItemDtoList, List<String> samePriceSkuCodes) {
        List itemSkuRelRespDtos = null;
        List itemCodes = basePriceItemDtoList.stream().filter(dto -> !samePriceSkuCodes.contains(dto.getSkuCode())).map(BasePriceItemDto::getItemCode).collect(Collectors.toList());
        log.info("batchSyncBasePriceItems:itemCodes={}", itemCodes);
        if (CollUtil.isNotEmpty(itemCodes)) {
            itemSkuRelRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryItemSkuByItemCodes(itemCodes));
        } else {
            log.info("batchSyncBasePriceItems:itemCodes is NULL samePriceSkuCodes={}, basePriceItemDtoList={}", samePriceSkuCodes, basePriceItemDtoList);
        }
        return itemSkuRelRespDtos;
    }

    private List<String> querySamePriceSkuCodes(List<BasePriceItemDto> basePriceItemDtoList) {
        List skuPriceVoList = basePriceItemDtoList.stream().map(dto -> {
            SkuPriceVo vo = new SkuPriceVo();
            vo.setSkuCode(dto.getSkuCode());
            vo.setItemPrice(dto.getItemPrice());
            return vo;
        }).collect(Collectors.toList());
        return this.basePriceItemDas.querySamePriceSkuCodes(skuPriceVoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initBrandPriceLimit(InitDataReqDto initDataReqDto) {
        AssertUtils.isNonNull(initDataReqDto, PriceExceptionCode.INVALID_INIT_DATA_PARAMS);
        Long orgId = initDataReqDto.getOrgId();
        this.commonHelper.lock("INIT_DATA:initBrandPriceLimit:" + orgId, 120, key -> {
            PriceLimitEo priceLimitEo = new PriceLimitEo();
            priceLimitEo.setCode(this.generateCode.createCode(GeneralRuleTypeEnum.JPZK));
            priceLimitEo.setEffectiveTime(new Date());
            priceLimitEo.setName("\u521d\u59cb\u5316\u4ef7\u76d8");
            priceLimitEo.setOrganizationId(orgId);
            priceLimitEo.setStatus(PriceStatusEnum.DRAFT.getCode());
            priceLimitEo.setRelationCustomerType(Integer.valueOf(Integer.parseInt(CustomerDimensionEnum.CUSTOMER_ALL_ENUM.getType())));
            priceLimitEo.setRelationItemType(Integer.valueOf(Integer.parseInt(ItemDimensionEnum.ITEM_SPECIAL_ENUM.getType())));
            priceLimitEo.setTenantId(initDataReqDto.getTenantId());
            priceLimitEo.setInstanceId(initDataReqDto.getInstanceId());
            priceLimitEo.setCreatePerson(CREATE_PERSON);
            log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u521d\u59cb\u5316\u54c1\u724c\u65b9\u7ec4\u7ec7[{}]\u4ef7\u76d8[{}]", (Object)orgId, (Object)priceLimitEo.getName());
            this.priceLimitDas.insert((BaseEo)priceLimitEo);
            Long id = priceLimitEo.getId();
            List<ItemSkuQueryRespDto> skuList = this.skuHelper.getSkuList(orgId);
            if (CollUtil.isEmpty(skuList)) {
                log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u7ec4\u7ec7[{}]\u5728it_item\u6ca1\u627e\u5230\u5546\u54c1", (Object)orgId);
                return;
            }
            List skuIdList = skuList.stream().map(ItemSkuQueryRespDto::getSkuId).distinct().collect(Collectors.toList());
            List skuPriceList = this.sellerSkuPriceDas.getSkuMaxMinPriceBySkuIdList(skuIdList);
            Map skuPriceInfoMap = CommonUtils.toMap(skuPriceList, SkuPriceInfoVo::getSkuId, Function.identity());
            log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u7ec4\u7ec7[{}]\u521d\u59cb\u5316\u5316\u4ef7\u76d8\u4e0b\u7684\u5546\u54c1", (Object)orgId);
            for (ItemSkuQueryRespDto itemSkuQueryRespDto : skuList) {
                Long skuId = itemSkuQueryRespDto.getSkuId();
                LimitItemEo limitItemEo = new LimitItemEo();
                limitItemEo.setPriceLimitId(id);
                limitItemEo.setItemId(itemSkuQueryRespDto.getItemId());
                limitItemEo.setInstanceId(initDataReqDto.getInstanceId());
                limitItemEo.setTenantId(initDataReqDto.getTenantId());
                limitItemEo.setItemCode(itemSkuQueryRespDto.getItemCode());
                limitItemEo.setItemName(itemSkuQueryRespDto.getItemName());
                limitItemEo.setSkuCode(itemSkuQueryRespDto.getSkuCode());
                limitItemEo.setSkuDesc(itemSkuQueryRespDto.getSkuAttr());
                limitItemEo.setSkuId(skuId);
                limitItemEo.setCreatePerson(CREATE_PERSON);
                if (skuPriceInfoMap.containsKey(skuId)) {
                    SkuPriceInfoVo skuPriceInfoVo = (SkuPriceInfoVo)skuPriceInfoMap.get(skuId);
                    limitItemEo.setLowerLimit(skuPriceInfoVo.getLowerLimit());
                    limitItemEo.setUpperLimit(skuPriceInfoVo.getUpperLimit());
                }
                this.limitItemDas.insert((BaseEo)limitItemEo);
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initBrandPriceLimitConfig(InitDataReqDto initDataReqDto) {
        AssertUtils.isNonNull(initDataReqDto, PriceExceptionCode.INVALID_INIT_DATA_PARAMS);
        Long orgId = initDataReqDto.getOrgId();
        this.commonHelper.lock("INIT_DATA:initBrandPriceLimitConfig:" + orgId, 120, key -> {
            PriceBasicConfigEo priceBasicConfigEo = new PriceBasicConfigEo();
            priceBasicConfigEo.setOrganizationId(orgId);
            priceBasicConfigEo = (PriceBasicConfigEo)this.priceBasicConfigDas.selectOne((BaseEo)priceBasicConfigEo);
            if (Objects.nonNull(priceBasicConfigEo)) {
                log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u7ec4\u7ec7[{}]\u5df2\u5b58\u5728\u4ef7\u76d8\u8bbe\u7f6e\uff0c\u4e0d\u9700\u8981\u521d\u59cb\u5316\u6570\u636e", (Object)orgId);
                return;
            }
            priceBasicConfigEo = new PriceBasicConfigEo();
            priceBasicConfigEo.setConfigType(PriceBasicConfigEnum.ConfigType.PRICE_SETTING.getCode());
            priceBasicConfigEo.setOrganizationId(orgId);
            priceBasicConfigEo.setControlType(PriceBasicConfigEnum.ControlType.WARN.getCode());
            priceBasicConfigEo.setRuleDiffDim(PriceBasicConfigEnum.RuleDiffDim.MOST_FINE_GRAINED.getCode());
            priceBasicConfigEo.setRuleSameDim(PriceBasicConfigEnum.RuleSameDim.DIFFERENT_DIMENSIONS.getCode());
            priceBasicConfigEo.setTenantId(initDataReqDto.getTenantId());
            priceBasicConfigEo.setInstanceId(initDataReqDto.getInstanceId());
            priceBasicConfigEo.setCreatePerson(CREATE_PERSON);
            log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u521d\u59cb\u5316\u54c1\u724c\u65b9\u7ec4\u7ec7[{}]\u4ef7\u76d8\u8bbe\u7f6e", (Object)orgId);
            this.priceBasicConfigDas.insert((BaseEo)priceBasicConfigEo);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initBrandPriceApply(InitDataReqDto initDataReqDto) {
        AssertUtils.isNonNull(initDataReqDto, PriceExceptionCode.INVALID_INIT_DATA_PARAMS);
        Long orgId = initDataReqDto.getOrgId();
        this.commonHelper.lock("INIT_DATA:initBrandPriceApply:" + orgId, 120, key -> {
            BasePriceApplyEo basePriceApplyEo = new BasePriceApplyEo();
            basePriceApplyEo.setSyncStatus(SyncStatusEnum.NOT_SYNC.getCode());
            basePriceApplyEo.setStatus(PriceStatusEnum.DRAFT.getCode());
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initDealerPriceApply(InitDataReqDto initDataReqDto) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initDealerPriceConfig(InitDataReqDto initDataReqDto) {
        AssertUtils.isNonNull(initDataReqDto, PriceExceptionCode.INVALID_INIT_DATA_PARAMS);
        Long orgId = initDataReqDto.getOrgId();
        this.commonHelper.lock("INIT_DATA:initDealerPriceConfig:" + orgId, 120, key -> {
            PriceBasicConfigRespDto priceBasicConfigRespDto = this.priceBasicConfigService.getBasicConfigByOrgIdAndConfigType(orgId, PriceBasicConfigEnum.ConfigType.BASIC_SETTINGS);
            if (Objects.nonNull(priceBasicConfigRespDto)) {
                log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u7ec4\u7ec7[{}]\u5df2\u5b58\u5728\u57fa\u7840\u8bbe\u7f6e\uff0c\u4e0d\u9700\u8981\u521d\u59cb\u5316\u6570\u636e", (Object)orgId);
                return;
            }
            PriceBasicConfigEo priceBasicConfigEo = new PriceBasicConfigEo();
            priceBasicConfigEo.setConfigType(PriceBasicConfigEnum.ConfigType.BASIC_SETTINGS.getCode());
            priceBasicConfigEo.setOrganizationId(orgId);
            priceBasicConfigEo.setRuleDiffDim(PriceBasicConfigEnum.RuleDiffDim.MOST_FINE_GRAINED.getCode());
            priceBasicConfigEo.setRuleSameDim(PriceBasicConfigEnum.RuleSameDim.DIFFERENT_DIMENSIONS.getCode());
            priceBasicConfigEo.setTenantId(initDataReqDto.getTenantId());
            priceBasicConfigEo.setInstanceId(initDataReqDto.getInstanceId());
            priceBasicConfigEo.setCreatePerson(CREATE_PERSON);
            log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u521d\u59cb\u5316\u7ecf\u9500\u5546\u7ec4\u7ec7[{}]\u57fa\u7840\u8bbe\u7f6e", (Object)orgId);
            this.priceBasicConfigDas.insert((BaseEo)priceBasicConfigEo);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PriceTypeEo initDealerPriceType(InitDataReqDto initDataReqDto) {
        AssertUtils.isNonNull(initDataReqDto, PriceExceptionCode.INVALID_INIT_DATA_PARAMS);
        Long orgId = initDataReqDto.getOrgId();
        return this.commonHelper.lock("INIT_DATA:initDealerPriceType:" + orgId, 120, key -> {
            if (SyncTypeEnum.ALL.getCode().equals(initDataReqDto.getSyncType())) {
                PriceTypeEo priceTypeDel = new PriceTypeEo();
                priceTypeDel.setOrganizationId(orgId);
                priceTypeDel.setCategoryCode(CategoryCodeEnum.CHANNEL_DISTRIBUTION.getCode());
                this.priceTypeDas.deleteByExample((BaseEo)priceTypeDel);
            } else {
                PriceTypeEo priceTypeEo = new PriceTypeEo();
                priceTypeEo.setCategoryCode(CategoryCodeEnum.CHANNEL_DISTRIBUTION.getCode());
                priceTypeEo.setOrganizationId(orgId);
                priceTypeEo.setStatus("0");
                priceTypeEo.setInstanceId(initDataReqDto.getInstanceId());
                priceTypeEo.setTenantId(initDataReqDto.getTenantId());
                priceTypeEo.setCreatePerson(CREATE_PERSON);
                PriceTypeEo resutlEo = (PriceTypeEo)this.priceTypeDas.selectOne((BaseEo)priceTypeEo);
                log.info("\u589e\u91cf\u521d\u59cb\u5316\u4ef7\u683c\u67e5\u8be2\u4ef7\u683c\u7c7b\u578b\u7ed3\u679c\uff1a{}", (Object)JSON.toJsonString((Object)priceTypeEo));
                if (resutlEo != null) {
                    return resutlEo;
                }
            }
            PriceTypeEo priceType = new PriceTypeEo();
            priceType.setCategoryCode(CategoryCodeEnum.CHANNEL_DISTRIBUTION.getCode());
            priceType.setOrganizationId(orgId);
            priceType.setStatus("0");
            priceType.setInstanceId(initDataReqDto.getInstanceId());
            priceType.setTenantId(initDataReqDto.getTenantId());
            priceType.setCreatePerson(CREATE_PERSON);
            priceType.setRelatedNum(Integer.valueOf(0));
            priceType.setTypeCode(this.generateCode.createCode(GeneralRuleTypeEnum.JGLX));
            priceType.setTypeName("\u5e38\u89c4\u4ef7");
            priceType.setWeight("0");
            log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u521d\u59cb\u5316\u7ecf\u9500\u5546\u7ec4\u7ec7[{}]\u4ef7\u683c\u7c7b\u578b[{}]", (Object)orgId, (Object)priceType.getTypeName());
            this.priceTypeDas.insert((BaseEo)priceType);
            return priceType;
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PriceModelEo initDealerPriceModel(InitDataReqDto initDataReqDto) {
        AssertUtils.isNonNull(initDataReqDto, PriceExceptionCode.INVALID_INIT_DATA_PARAMS);
        Long orgId = initDataReqDto.getOrgId();
        return this.commonHelper.lock("INIT_DATA:initDealerPriceModel:" + orgId, 120, key -> {
            if (SyncTypeEnum.ALL.getCode().equals(initDataReqDto.getSyncType())) {
                PriceModelEo priceModeDel = new PriceModelEo();
                priceModeDel.setOrganizationId(orgId);
                List priceModeDelList = this.priceModelDas.select((BaseEo)priceModeDel);
                for (PriceModelEo priceModelEo : priceModeDelList) {
                    this.priceModelDas.deleteById(priceModelEo.getId());
                    BasePriceRelationTypeEo basePriceRelationTypeDel = new BasePriceRelationTypeEo();
                    basePriceRelationTypeDel.setPriceModelId(priceModelEo.getId());
                    this.basePriceRelationTypeDas.deleteByExample((BaseEo)basePriceRelationTypeDel);
                }
            } else {
                PriceModelEo priceModelEo = new PriceModelEo();
                priceModelEo.setModelName("\u76f4\u63a5\u5b9a\u4ef7");
                priceModelEo.setStatus("0");
                priceModelEo.setOrganizationId(orgId);
                priceModelEo.setTenantId(initDataReqDto.getTenantId());
                priceModelEo.setInstanceId(initDataReqDto.getInstanceId());
                priceModelEo.setCreatePerson(CREATE_PERSON);
                PriceModelEo resultModule = (PriceModelEo)this.priceModelDas.selectOne((BaseEo)priceModelEo);
                log.info("\u589e\u91cf\u521d\u59cb\u5316\u4ef7\u683c\u67e5\u8be2\u4ef7\u683c\u6a21\u578b\u7ed3\u679c\uff1a{}", (Object)JSON.toJsonString((Object)resultModule));
                if (resultModule != null) {
                    return resultModule;
                }
            }
            PriceModelEo priceModel = new PriceModelEo();
            priceModel.setModelCode(this.generateCode.createCode(GeneralRuleTypeEnum.JGMX));
            priceModel.setModelName("\u76f4\u63a5\u5b9a\u4ef7");
            priceModel.setDirectSet(Integer.valueOf(1));
            priceModel.setStatus("0");
            priceModel.setRelatedNum(Integer.valueOf(0));
            priceModel.setOrganizationId(orgId);
            priceModel.setTenantId(initDataReqDto.getTenantId());
            priceModel.setInstanceId(initDataReqDto.getInstanceId());
            priceModel.setCreatePerson(CREATE_PERSON);
            log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u521d\u59cb\u5316\u7ecf\u9500\u5546\u7ec4\u7ec7[{}]\u4ef7\u683c\u6a21\u578b[{}]", (Object)orgId, (Object)priceModel.getModelName());
            this.priceModelDas.insert((BaseEo)priceModel);
            return priceModel;
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteExistencePolicyInfo(Long orgId, String type) {
        log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u6e05\u9664\u7ecf\u9500\u5546\u7ec4\u7ec7[{}]\u4ef7\u683c\u653f\u7b56\u76f8\u5173\u6570\u636e", (Object)orgId);
        PriceEo priceDel = new PriceEo();
        priceDel.setOrganizationId(orgId);
        List priceDelList = this.priceDas.select((BaseEo)priceDel);
        if (CollUtil.isEmpty((Collection)priceDelList)) {
            return;
        }
        for (PriceEo priceEo : priceDelList) {
            if (!Objects.equals(priceEo.getStatus(), PriceStatusEnum.AUDIT_PASS.getCode())) continue;
            log.info("[\u4ef7\u683c\u653f\u7b56] >>> \u5220\u9664\u4ef7\u683c\u653f\u7b56[{}]\uff0c \u653f\u7b56\u72b6\u6001[{}]", (Object)priceEo.getCode(), (Object)priceEo.getStatus());
            this.pricePolicyEsService.deletePricePolicy(priceEo.getId());
        }
        List priceIdList = priceDelList.stream().map(BaseEo::getId).collect(Collectors.toList());
        LambdaQueryWrapper priceDelWrapper = Wrappers.lambdaQuery();
        priceDelWrapper.in(BaseEo::getId, priceIdList);
        this.priceDas.getMapper().delete((Wrapper)priceDelWrapper);
        LambdaQueryWrapper priceItemDelWrapper = Wrappers.lambdaQuery();
        priceItemDelWrapper.in(StdPriceItemEo::getPriceId, priceIdList);
        this.priceItemDas.getMapper().delete((Wrapper)priceItemDelWrapper);
        LambdaQueryWrapper priceItemConditionDelWrapper = Wrappers.lambdaQuery();
        priceItemConditionDelWrapper.in(StdPriceItemConditionEo::getRelateId, priceIdList);
        priceItemConditionDelWrapper.eq(StdPriceItemConditionEo::getRelateType, (Object)type);
        this.priceItemConditionDas.getMapper().delete((Wrapper)priceItemConditionDelWrapper);
        LambdaQueryWrapper priceRejectItemDelWrapper = Wrappers.lambdaQuery();
        priceRejectItemDelWrapper.in(StdPriceRejectItemEo::getRelateId, priceIdList);
        priceRejectItemDelWrapper.eq(StdPriceRejectItemEo::getRelateType, (Object)type);
        this.priceRejectItemDas.getMapper().delete((Wrapper)priceRejectItemDelWrapper);
        LambdaQueryWrapper customerConditionDelWrapper = Wrappers.lambdaQuery();
        customerConditionDelWrapper.in(StdCustomerConditionEo::getRelateId, priceIdList);
        customerConditionDelWrapper.eq(StdCustomerConditionEo::getRelateType, (Object)type);
        this.customerConditionDas.getMapper().delete((Wrapper)customerConditionDelWrapper);
        LambdaQueryWrapper priceRejectCustomerDelWrapper = Wrappers.lambdaQuery();
        priceRejectCustomerDelWrapper.in(StdPriceRejectCustomerEo::getRelateId, priceIdList);
        priceRejectCustomerDelWrapper.eq(StdPriceRejectCustomerEo::getRelateType, (Object)type);
        this.priceRejectCustomerDas.getMapper().delete((Wrapper)priceRejectCustomerDelWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initDealerPrice(InitDataReqDto initDataReqDto) {
        AssertUtils.isNonNull(initDataReqDto, PriceExceptionCode.INVALID_INIT_DATA_PARAMS);
        Long orgId = initDataReqDto.getOrgId();
        List dealerShopCustomerInfoList = this.sellerSkuPriceDas.getDealerShopCustomerList(orgId, null);
        if (CollUtil.isEmpty((Collection)dealerShopCustomerInfoList)) {
            return;
        }
        String type = RelateTypeEnum.PRICE.getType();
        String initType = "initDealerPrice";
        log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u521d\u59cb\u5316\u7ecf\u9500\u5546\u7ec4\u7ec7[{}]\u4ef7\u683c\u653f\u7b56(\u5148\u7269\u7406\u5220\u9664\u518d\u6dfb\u52a0\u65b0\u7684)", (Object)orgId);
        if (SyncTypeEnum.ALL.getCode().equals(initDataReqDto.getSyncType())) {
            this.deleteExistencePolicyInfo(orgId, type);
        }
        AtomicInteger useNumber = new AtomicInteger(0);
        AtomicInteger indexNumber = new AtomicInteger(0);
        PriceTypeEo priceTypeEo = this.initDealerPriceType(initDataReqDto);
        log.info("\u521d\u59cb\u5316\u4ef7\u683c\u7c7b\u578b\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJsonString((Object)priceTypeEo));
        PriceModelEo priceModelEo = this.initDealerPriceModel(initDataReqDto);
        log.info("\u521d\u59cb\u5316\u4ef7\u683c\u6a21\u578b\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJsonString((Object)priceModelEo));
        int size = dealerShopCustomerInfoList.size();
        for (DealerShopCustomerInfoVo dealerShopCustomerInfoVo : dealerShopCustomerInfoList) {
            Long shopId = dealerShopCustomerInfoVo.getShopId();
            Long customerId = dealerShopCustomerInfoVo.getCustomerId();
            String policyKey = StrUtil.format((CharSequence)"{}:{}:{}:{}", (Object[])new Object[]{INIT_DATA_KEY, initType, shopId, customerId});
            this.commonHelper.lock(policyKey, 120, key -> {
                TimeInterval timer = DateUtil.timer();
                indexNumber.incrementAndGet();
                SellerSkuPriceEo sellerSkuPriceEo = new SellerSkuPriceEo();
                sellerSkuPriceEo.setShopId(shopId);
                sellerSkuPriceEo.setCustomerId(customerId);
                List sellerSkuPriceList = this.sellerSkuPriceDas.select((BaseEo)sellerSkuPriceEo);
                dealerShopCustomerInfoVo.setSkuCount(Integer.valueOf(sellerSkuPriceList.size()));
                String priceName = "[" + dealerShopCustomerInfoVo.getCustomerName() + "] \u76f4\u63a5\u5b9a\u4ef7\u4ef7\u683c\u653f\u7b56";
                PriceEo price = this.buildPrice(initDataReqDto, dealerShopCustomerInfoVo, priceTypeEo, priceModelEo, priceName);
                InitDataLogEo initDataLogEo = new InitDataLogEo();
                initDataLogEo.setInitKey(key);
                initDataLogEo.setInitKey(key);
                initDataLogEo.setInitType(initType);
                initDataLogEo.setDealerOrgId(orgId);
                initDataLogEo.setStartTime(new Date());
                initDataLogEo.setInitStatus(Integer.valueOf(1));
                initDataLogEo.setRemark(StrUtil.format((CharSequence)"{} \u540c\u6b65\u4e2d {} [\u603b {} \u6761]", (Object[])new Object[]{indexNumber.get(), price.getName(), size}));
                initDataLogEo.setReqId(initDataReqDto.getReqId());
                initDataLogEo.setTenantId(initDataReqDto.getTenantId());
                initDataLogEo.setInstanceId(initDataReqDto.getInstanceId());
                initDataLogEo.setCreatePerson(CREATE_PERSON);
                this.initDataLogDas.insert((BaseEo)initDataLogEo);
                MDC.put((String)"yes.req.requestId", (String)String.valueOf(initDataLogEo.getId()));
                log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u521d\u59cb\u5316\u7ecf\u9500\u5546\u7ec4\u7ec7[{}]\u4e0b\u7684\u5c0fb\u4ef7\u683c\u653f\u7b56[{}]\uff0cshopId[{}], customerId[{}]", new Object[]{orgId, price.getName(), shopId, customerId});
                this.priceDas.insert((BaseEo)price);
                List<PriceItemEo> priceItemList = this.buildPriceItem(sellerSkuPriceList, price);
                if (CollUtil.isNotEmpty(priceItemList)) {
                    log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u521d\u59cb\u5316\u7ecf\u9500\u5546\u7ec4\u7ec7[{}]\u4e0b\u7684\u5c0fb\u4ef7\u683c\u653f\u7b56\u5546\u54c1\u660e\u7ec6[{}]\uff0c\u5171[{}]\u4e2a\u5546\u54c1", new Object[]{orgId, price.getName(), priceItemList.size()});
                    this.priceItemDas.insertBatch(priceItemList);
                }
                log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u521d\u59cb\u5316\u7ecf\u9500\u5546\u7ec4\u7ec7[{}]\u4e0b\u7684\u5c0fb\u4ef7\u683c\u653f\u7b56[{}]\uff0c\u751f\u6210\u653f\u7b56\u5546\u54c1\u9650\u5236", (Object)orgId, (Object)price.getName());
                PriceItemConditionEo priceItemCondition = this.buildPriceItemConditionEo(type, sellerSkuPriceList, price);
                this.priceItemConditionDas.insert((BaseEo)priceItemCondition);
                log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u521d\u59cb\u5316\u7ecf\u9500\u5546\u7ec4\u7ec7[{}]\u4e0b\u7684\u5c0fb\u4ef7\u683c\u653f\u7b56[{}]\uff0c\u751f\u6210\u653f\u7b56\u5ba2\u6237\u9650\u5236", (Object)orgId, (Object)price.getName());
                CustomerConditionEo customerCondition = this.buildCustomerConditionEo(type, customerId, price);
                this.customerConditionDas.insert((BaseEo)customerCondition);
                initDataLogEo.setInitStatus(Integer.valueOf(2));
                initDataLogEo.setEndTime(new Date());
                initDataLogEo.setRemark(StrUtil.format((CharSequence)"{} \u540c\u6b65 {} \u5b8c\u6210\uff0c\u8017\u65f6 {} \u6beb\u79d2[\u603b {} \u6761]", (Object[])new Object[]{indexNumber.get(), price.getName(), timer.intervalMs(), size}));
                this.initDataLogDas.update((BaseEo)initDataLogEo);
                useNumber.getAndIncrement();
                log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u521d\u59cb\u5316\u7ecf\u9500\u5546\u7ec4\u7ec7[{}]\u4e0b\u7684\u5c0fb\u4ef7\u683c\u653f\u7b56[{}]\u7ed3\u675f\uff0c\u8017\u65f6[{}]\u6beb\u79d2", new Object[]{orgId, price.getName(), timer.intervalMs()});
            });
        }
        priceTypeEo.setRelatedNum(Integer.valueOf(useNumber.get()));
        this.priceTypeDas.update((BaseEo)priceTypeEo);
        priceModelEo.setRelatedNum(Integer.valueOf(useNumber.get()));
        this.priceModelDas.update((BaseEo)priceModelEo);
    }

    private void deletePriceData(InitDataReqDto initDataReqDto, DealerShopCustomerInfoVo dealerShopCustomerInfoVo, String type, String priceName) {
        PriceEo queryPriceEo = new PriceEo();
        queryPriceEo.setName(priceName);
        queryPriceEo.setShopId(dealerShopCustomerInfoVo.getShopId());
        queryPriceEo.setCreatePerson(CREATE_PERSON);
        queryPriceEo.setRelationCustomerType(Integer.valueOf(CustomerDimensionEnum.CUSTOMER_SPECIFIED_ENUM.getType()));
        queryPriceEo.setRelationItemType(Integer.valueOf(ItemDimensionEnum.ITEM_SPECIAL_ENUM.getType()));
        queryPriceEo.setOrganizationId(initDataReqDto.getOrgId());
        PriceEo origPriceEo = (PriceEo)this.priceDas.selectOne((BaseEo)queryPriceEo);
        log.info("\u65e7\u4ef7\u683c\u653f\u7b56\u6570\u636e\uff1a{}", (Object)JSON.toJsonString((Object)origPriceEo));
        if (origPriceEo != null) {
            Long id = origPriceEo.getId();
            if (Objects.equals(origPriceEo.getStatus(), PriceStatusEnum.AUDIT_PASS.getCode())) {
                log.info("[\u4ef7\u683c\u653f\u7b56] >>> \u5220\u9664\u4ef7\u683c\u653f\u7b56[{}]\uff0c \u653f\u7b56\u72b6\u6001[{}]", (Object)origPriceEo.getCode(), (Object)origPriceEo.getStatus());
                this.pricePolicyEsService.deletePricePolicy(id);
            }
            this.priceDas.deleteById(id);
            PriceItemEo delPriceItemEo = new PriceItemEo();
            delPriceItemEo.setPriceId(id);
            this.priceItemDas.deleteByExample((BaseEo)delPriceItemEo);
            PriceItemConditionEo delPriceItemConditionEo = new PriceItemConditionEo();
            delPriceItemConditionEo.setRelateId(id);
            delPriceItemConditionEo.setRelateType(type);
            this.priceItemConditionDas.deleteByExample((BaseEo)delPriceItemConditionEo);
            PriceRejectItemEo delPriceRejectItemEo = new PriceRejectItemEo();
            delPriceRejectItemEo.setRelateId(id);
            delPriceRejectItemEo.setRelateType(type);
            this.priceRejectItemDas.deleteByExample((BaseEo)delPriceRejectItemEo);
            CustomerConditionEo delCustomerConditionEo = new CustomerConditionEo();
            delCustomerConditionEo.setRelateId(id);
            delCustomerConditionEo.setRelateType(type);
            this.customerConditionDas.deleteByExample((BaseEo)delCustomerConditionEo);
            PriceRejectCustomerEo delPriceRejectCustomerEo = new PriceRejectCustomerEo();
            delPriceRejectCustomerEo.setRelateId(id);
            delPriceRejectCustomerEo.setRelateType(type);
            this.priceRejectCustomerDas.deleteByExample((BaseEo)delPriceRejectCustomerEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initDealerPriceExt(InitDataReqDto initDataReqDto) {
        AssertUtils.isNonNull(initDataReqDto, PriceExceptionCode.INVALID_INIT_DATA_PARAMS);
        AssertUtils.isNotEmpty(initDataReqDto.getThirdPartyIdSet(), (IExceptionCode)PriceExceptionCode.INVALID_INIT_DATA_PARAMS_CUSID);
        Long orgId = initDataReqDto.getOrgId();
        Set thirdPartyIdSet = initDataReqDto.getThirdPartyIdSet();
        List dealerShopCustomerInfoList = this.sellerSkuPriceDas.getDealerShopCustomerList(orgId, thirdPartyIdSet);
        if (CollUtil.isEmpty((Collection)dealerShopCustomerInfoList)) {
            log.info("\u521d\u59cb\u5316\u4ef7\u683c\u653f\u7b56(\u67e5\u8be2\u8be5\u7ec4\u7ec7\u4e0b\u7684\u5e97\u94fa-\u5ba2\u6237\u5206\u7ec4\u521b\u5efa\u653f\u7b56),\u6570\u636e\u4e3a\u7a7a\uff0c{}", (Object)orgId);
            return;
        }
        String type = RelateTypeEnum.PRICE.getType();
        String initType = "initDealerPrice";
        log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u521d\u59cb\u5316\u7ecf\u9500\u5546\u7ec4\u7ec7[{}]\u4ef7\u683c\u653f\u7b56(\u5148\u7269\u7406\u5220\u9664\u518d\u6dfb\u52a0\u65b0\u7684)", (Object)orgId);
        AtomicInteger useNumber = new AtomicInteger(0);
        AtomicInteger indexNumber = new AtomicInteger(0);
        PriceTypeEo priceTypeEo = this.initDealerPriceType(initDataReqDto);
        log.info("\u521d\u59cb\u5316\u4ef7\u683c\u7c7b\u578b\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJsonString((Object)priceTypeEo));
        PriceModelEo priceModelEo = this.initDealerPriceModel(initDataReqDto);
        log.info("\u521d\u59cb\u5316\u4ef7\u683c\u6a21\u578b\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJsonString((Object)priceModelEo));
        int size = dealerShopCustomerInfoList.size();
        HashSet priceIdSet = Sets.newHashSet();
        for (DealerShopCustomerInfoVo dealerShopCustomerInfoVo : dealerShopCustomerInfoList) {
            Long shopId = dealerShopCustomerInfoVo.getShopId();
            Long customerId = dealerShopCustomerInfoVo.getCustomerId();
            String policyKey = StrUtil.format((CharSequence)"{}:{}:{}:{}", (Object[])new Object[]{INIT_DATA_KEY, initType, shopId, customerId});
            this.commonHelper.lock(policyKey, 120, key -> {
                TimeInterval timer = DateUtil.timer();
                indexNumber.incrementAndGet();
                String priceName = "[" + dealerShopCustomerInfoVo.getCustomerName() + "] \u76f4\u63a5\u5b9a\u4ef7\u4ef7\u683c\u653f\u7b56";
                this.deletePriceData(initDataReqDto, dealerShopCustomerInfoVo, type, priceName);
                SellerSkuPriceEo sellerSkuPriceEo = new SellerSkuPriceEo();
                sellerSkuPriceEo.setShopId(shopId);
                sellerSkuPriceEo.setCustomerId(customerId);
                List sellerSkuPriceList = this.sellerSkuPriceDas.select((BaseEo)sellerSkuPriceEo);
                dealerShopCustomerInfoVo.setSkuCount(Integer.valueOf(sellerSkuPriceList.size()));
                PriceEo price = this.buildPrice(initDataReqDto, dealerShopCustomerInfoVo, priceTypeEo, priceModelEo, priceName);
                InitDataLogEo initDataLogEo = new InitDataLogEo();
                initDataLogEo.setInitKey(key);
                initDataLogEo.setInitKey(key);
                initDataLogEo.setInitType(initType);
                initDataLogEo.setDealerOrgId(orgId);
                initDataLogEo.setStartTime(new Date());
                initDataLogEo.setInitStatus(Integer.valueOf(1));
                initDataLogEo.setRemark(StrUtil.format((CharSequence)"{} \u540c\u6b65\u4e2d {} [\u603b {} \u6761]", (Object[])new Object[]{indexNumber.get(), price.getName(), size}));
                initDataLogEo.setReqId(initDataReqDto.getReqId());
                initDataLogEo.setTenantId(initDataReqDto.getTenantId());
                initDataLogEo.setInstanceId(initDataReqDto.getInstanceId());
                initDataLogEo.setCreatePerson(CREATE_PERSON);
                this.initDataLogDas.insert((BaseEo)initDataLogEo);
                MDC.put((String)"yes.req.requestId", (String)String.valueOf(initDataLogEo.getId()));
                log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u521d\u59cb\u5316\u7ecf\u9500\u5546\u7ec4\u7ec7[{}]\u4e0b\u7684\u5c0fb\u4ef7\u683c\u653f\u7b56[{}]\uff0cshopId[{}], customerId[{}]", new Object[]{orgId, price.getName(), shopId, customerId});
                this.priceDas.insert((BaseEo)price);
                priceIdSet.add(price.getId());
                List<PriceItemEo> priceItemList = this.buildPriceItem(sellerSkuPriceList, price);
                if (CollUtil.isNotEmpty(priceItemList)) {
                    log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u521d\u59cb\u5316\u7ecf\u9500\u5546\u7ec4\u7ec7[{}]\u4e0b\u7684\u5c0fb\u4ef7\u683c\u653f\u7b56\u5546\u54c1\u660e\u7ec6[{}]\uff0c\u5171[{}]\u4e2a\u5546\u54c1", new Object[]{orgId, price.getName(), priceItemList.size()});
                    this.priceItemDas.insertBatch(priceItemList);
                }
                log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u521d\u59cb\u5316\u7ecf\u9500\u5546\u7ec4\u7ec7[{}]\u4e0b\u7684\u5c0fb\u4ef7\u683c\u653f\u7b56[{}]\uff0c\u751f\u6210\u653f\u7b56\u5546\u54c1\u9650\u5236", (Object)orgId, (Object)price.getName());
                PriceItemConditionEo priceItemCondition = this.buildPriceItemConditionEo(type, sellerSkuPriceList, price);
                this.priceItemConditionDas.insert((BaseEo)priceItemCondition);
                log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u521d\u59cb\u5316\u7ecf\u9500\u5546\u7ec4\u7ec7[{}]\u4e0b\u7684\u5c0fb\u4ef7\u683c\u653f\u7b56[{}]\uff0c\u751f\u6210\u653f\u7b56\u5ba2\u6237\u9650\u5236", (Object)orgId, (Object)price.getName());
                CustomerConditionEo customerCondition = this.buildCustomerConditionEo(type, customerId, price);
                this.customerConditionDas.insert((BaseEo)customerCondition);
                initDataLogEo.setInitStatus(Integer.valueOf(2));
                initDataLogEo.setEndTime(new Date());
                initDataLogEo.setRemark(StrUtil.format((CharSequence)"{} \u540c\u6b65 {} \u5b8c\u6210\uff0c\u8017\u65f6 {} \u6beb\u79d2[\u603b {} \u6761]", (Object[])new Object[]{indexNumber.get(), price.getName(), timer.intervalMs(), size}));
                this.initDataLogDas.update((BaseEo)initDataLogEo);
                useNumber.getAndIncrement();
                log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u521d\u59cb\u5316\u7ecf\u9500\u5546\u7ec4\u7ec7[{}]\u4e0b\u7684\u5c0fb\u4ef7\u683c\u653f\u7b56[{}]\u7ed3\u675f\uff0c\u8017\u65f6[{}]\u6beb\u79d2", new Object[]{orgId, price.getName(), timer.intervalMs()});
            });
        }
        priceTypeEo.setRelatedNum(Integer.valueOf(useNumber.get()));
        this.priceTypeDas.update((BaseEo)priceTypeEo);
        priceModelEo.setRelatedNum(Integer.valueOf(useNumber.get()));
        this.priceModelDas.update((BaseEo)priceModelEo);
        initDataReqDto.setPriceIdSet((Set)priceIdSet);
    }

    private CustomerConditionEo buildCustomerConditionEo(String type, Long customerId, PriceEo price) {
        CustomerConditionEo customerCondition = new CustomerConditionEo();
        customerCondition.setRelateType(type);
        customerCondition.setRelateId(price.getId());
        customerCondition.setCustomerIds(String.valueOf(customerId));
        customerCondition.setTenantId(price.getTenantId());
        customerCondition.setInstanceId(price.getInstanceId());
        customerCondition.setCreatePerson(CREATE_PERSON);
        return customerCondition;
    }

    private PriceItemConditionEo buildPriceItemConditionEo(String type, List<SellerSkuPriceEo> sellerSkuPriceList, PriceEo price) {
        PriceItemConditionEo priceItemCondition = new PriceItemConditionEo();
        priceItemCondition.setItemIds(sellerSkuPriceList.stream().map(item -> String.valueOf(item.getItemId())).distinct().collect(Collectors.joining(",")));
        priceItemCondition.setSkuIds(sellerSkuPriceList.stream().map(item -> String.valueOf(item.getSkuId())).distinct().collect(Collectors.joining(",")));
        priceItemCondition.setRelateType(type);
        priceItemCondition.setRelateId(price.getId());
        priceItemCondition.setOrganizationId(price.getOrganizationId());
        priceItemCondition.setTenantId(price.getTenantId());
        priceItemCondition.setInstanceId(price.getInstanceId());
        priceItemCondition.setCreatePerson(CREATE_PERSON);
        return priceItemCondition;
    }

    private List<PriceItemEo> buildPriceItem(List<SellerSkuPriceEo> sellerSkuPriceList, PriceEo price) {
        if (CollUtil.isEmpty(sellerSkuPriceList)) {
            return ListUtil.empty();
        }
        ArrayList priceItemList = ListUtil.toList((Object[])new PriceItemEo[0]);
        for (SellerSkuPriceEo sellerSkuPriceEo : sellerSkuPriceList) {
            PriceItemEo priceItem = new PriceItemEo();
            priceItem.setPriceId(price.getId());
            priceItem.setItemPrice(sellerSkuPriceEo.getSupplyPrice());
            priceItem.setItemOrgId(sellerSkuPriceEo.getItemOrgId());
            priceItem.setLowerLimit(Integer.valueOf(1));
            priceItem.setItemId(sellerSkuPriceEo.getItemId());
            priceItem.setSkuId(sellerSkuPriceEo.getSkuId());
            priceItem.setShopId(sellerSkuPriceEo.getShopId());
            priceItem.setTenantId(price.getTenantId());
            priceItem.setInstanceId(price.getInstanceId());
            priceItem.setCreatePerson(CREATE_PERSON);
            priceItem.setPriceModelSetType(PriceModelSetTypeEnum.DIRECT_SET.getCode());
            priceItemList.add(priceItem);
        }
        return priceItemList;
    }

    private PriceEo buildPrice(InitDataReqDto initDataReqDto, DealerShopCustomerInfoVo dealerShopCustomerInfoVo, PriceTypeEo priceTypeEo, PriceModelEo priceModelEo, String priceName) {
        PriceEo price = new PriceEo();
        price.setOrganizationId(initDataReqDto.getOrgId());
        price.setStatus(PriceStatusEnum.DRAFT.getCode());
        price.setRelationCustomerType(Integer.valueOf(CustomerDimensionEnum.CUSTOMER_SPECIFIED_ENUM.getType()));
        price.setRelationItemType(Integer.valueOf(ItemDimensionEnum.ITEM_SPECIAL_ENUM.getType()));
        price.setName(priceName);
        price.setShopId(dealerShopCustomerInfoVo.getShopId());
        price.setEffectiveTime(new Date());
        price.setCode(this.generateCode.createCode(GeneralRuleTypeEnum.JGZC));
        price.setInstanceId(initDataReqDto.getInstanceId());
        price.setTenantId(initDataReqDto.getTenantId());
        price.setCreatePerson(CREATE_PERSON);
        RelationInfoVo relationInfoVo = new RelationInfoVo();
        RelationCustomerInfoVo relationCustomerInfo = new RelationCustomerInfoVo();
        relationCustomerInfo.setCustomerIdNum(Integer.valueOf(1));
        relationInfoVo.setRelationCustomerInfo(relationCustomerInfo);
        RelationItemInfoVo relationItemInfoVo = new RelationItemInfoVo();
        relationItemInfoVo.setSkuIdNum(dealerShopCustomerInfoVo.getSkuCount());
        relationInfoVo.setRelationItemInfo(relationItemInfoVo);
        price.setExtension(JSON.toJsonString((Object)relationInfoVo));
        price.setCategoryCode(priceTypeEo.getCategoryCode());
        price.setTypeId(priceTypeEo.getId());
        price.setModelId(priceModelEo.getId());
        return price;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sync(SyncPriceDataReqDto syncPriceDataReqDto) {
        this.sellerSkuPriceService.saveSellerSkuPrice(syncPriceDataReqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batch(List<SyncPriceDataReqDto> syncPriceDataReqList) {
        if (CollUtil.isEmpty(syncPriceDataReqList)) {
            log.warn("[\u540c\u6b65\u6570\u636e] >>> \u65e0\u6548\u7684\u540c\u6b65\u6570\u636e\uff0c\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            return;
        }
        String supplierId = syncPriceDataReqList.get(0).getSupplierId();
        OrganizationDto organizationDto = (OrganizationDto)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryOneByOrgCode(null, supplierId));
        if (organizationDto == null) {
            log.warn("[\u540c\u6b65\u6570\u636e] >>> \u672c\u6b21\u540c\u6b65\u6570\u636e\u6709\u95ee\u9898\uff0csupplierId[{}]\u65e0\u6cd5\u627e\u5230\u7ec4\u7ec7\u4fe1\u606f", (Object)supplierId);
            return;
        }
        executor.execute(() -> {
            HashSet thirdPartyIdSet = Sets.newHashSet();
            for (SyncPriceDataReqDto syncPriceDataReqDto : syncPriceDataReqList) {
                thirdPartyIdSet.add(syncPriceDataReqDto.getApplierId());
                this.sync(syncPriceDataReqDto);
            }
            InitDataReqDto initDataReqDto = new InitDataReqDto();
            initDataReqDto.setOrgId(organizationDto.getId());
            initDataReqDto.setThirdPartyIdSet((Set)thirdPartyIdSet);
            this.initDealerDataExt(Lists.newArrayList((Object[])new InitDataReqDto[]{initDataReqDto}));
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String initDealerData(List<InitDataReqDto> initDataReqDtos) {
        this.enableInitConfig();
        Map attachments = ServiceContext.getContext().getAttachments();
        String reqId = attachments.getOrDefault("yes.req.requestId", RequestId.createReqId());
        if (CollUtil.isNotEmpty(initDataReqDtos)) {
            executor.execute(() -> {
                for (InitDataReqDto initDataReqDto : initDataReqDtos) {
                    executor.execute(() -> {
                        initDataReqDto.setReqId(reqId);
                        initDataReqDto.setInstanceId(this.instanceId);
                        initDataReqDto.setTenantId(this.tenantId);
                        this.initDealerPriceConfig(initDataReqDto);
                        this.initDealerPrice(initDataReqDto);
                        this.enablePricePolicy(initDataReqDtos);
                    });
                }
            });
        }
        return reqId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String initDealerDataExt(List<InitDataReqDto> initDataReqDtos) {
        log.info("\u540c\u6b65\u4ef7\u683c\u5165\u53c2\uff1a{}", (Object)JSON.toJsonString(initDataReqDtos));
        this.enableInitConfig();
        Map attachments = ServiceContext.getContext().getAttachments();
        String reqId = attachments.getOrDefault("yes.req.requestId", RequestId.createReqId());
        log.info("\u540c\u6b65reqId:{}", (Object)reqId);
        if (CollUtil.isNotEmpty(initDataReqDtos)) {
            executor.execute(() -> {
                for (InitDataReqDto initDataReqDto : initDataReqDtos) {
                    executor.execute(() -> {
                        MDC.put((String)"yes.req.requestId", (String)reqId);
                        initDataReqDto.setReqId(reqId);
                        initDataReqDto.setInstanceId(this.instanceId);
                        initDataReqDto.setTenantId(this.tenantId);
                        this.initDealerPriceConfig(initDataReqDto);
                        this.initDealerPriceExt(initDataReqDto);
                        this.enablePricePolicy(Lists.newArrayList((Object[])new InitDataReqDto[]{initDataReqDto}));
                    });
                }
            });
        }
        return reqId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String initDealerDataAll() {
        List initDataReqDtos = this.sellerSkuPriceDas.getDealerOrgInfoList();
        return this.initDealerData(initDataReqDtos);
    }

    private String effectPricePolicy(List<InitDataReqDto> initDataReqDtos) {
        this.enableInitConfig();
        Map attachments = ServiceContext.getContext().getAttachments();
        String reqId = attachments.getOrDefault("yes.req.requestId", RequestId.createReqId());
        executor.execute(() -> {
            MDC.put((String)"yes.req.requestId", (String)reqId);
            PriceEo priceEo = new PriceEo();
            priceEo.setStatus(PriceStatusEnum.DRAFT.getCode());
            LambdaQueryWrapper<PriceEo> queryWrapper = MybatisPlusUtils.newLambdaQueryWrapper(priceEo);
            if (CollUtil.isNotEmpty((Collection)initDataReqDtos)) {
                HashSet orgIdList = Sets.newHashSet();
                HashSet priceIdSet = Sets.newHashSet();
                for (InitDataReqDto initDataReqDto : initDataReqDtos) {
                    if (initDataReqDto.getOrgId() != null) {
                        orgIdList.add(initDataReqDto.getOrgId());
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)initDataReqDto.getPriceIdSet())) continue;
                    priceIdSet.addAll(priceIdSet);
                }
                queryWrapper.in(StdPriceEo::getOrganizationId, (Collection)orgIdList);
                if (CollectionUtils.isNotEmpty((Collection)priceIdSet)) {
                    queryWrapper.in(BaseEo::getId, (Collection)priceIdSet);
                }
            }
            Integer pageSize = 500;
            do {
                Page page;
                List priceList;
                if (CollUtil.isEmpty((Collection)(priceList = (page = (Page)this.priceDas.getMapper().selectPage((IPage)new Page(1L, (long)pageSize.intValue()), queryWrapper)).getRecords()))) {
                    pageSize = 0;
                    continue;
                }
                this.savePriceInfo(reqId, priceList);
            } while (!Objects.equals(pageSize, 0));
        });
        return reqId;
    }

    private void savePriceInfo(String reqId, List<PriceEo> priceList) {
        for (PriceEo price : priceList) {
            Long orgId = price.getOrganizationId();
            String policyKey = StrUtil.format((CharSequence)"{}:{}:{}:{}", (Object[])new Object[]{INIT_DATA_KEY, orgId, price.getShopId(), price.getId()});
            this.commonHelper.lock(policyKey, 120, key -> {
                TimeInterval timer = DateUtil.timer();
                price.setStatus(PriceStatusEnum.WAIT_AUDIT.getCode());
                this.priceDas.update((BaseEo)price);
                InitDataLogEo initDataLogEo = new InitDataLogEo();
                initDataLogEo.setInitKey(key);
                initDataLogEo.setInitKey(key);
                initDataLogEo.setInitType("effectPricePolicy");
                initDataLogEo.setDealerOrgId(orgId);
                initDataLogEo.setStartTime(new Date());
                initDataLogEo.setInitStatus(Integer.valueOf(1));
                initDataLogEo.setRemark("\u751f\u6548\u4e2d " + price.getName());
                initDataLogEo.setReqId(reqId);
                initDataLogEo.setTenantId(price.getTenantId());
                initDataLogEo.setInstanceId(price.getInstanceId());
                initDataLogEo.setCreatePerson(CREATE_PERSON);
                this.initDataLogDas.insert((BaseEo)initDataLogEo);
                MDC.put((String)"yes.req.requestId", (String)String.valueOf(initDataLogEo.getId()));
                log.info("[\u751f\u6548\u4ef7\u683c\u653f\u7b56] >>> \u751f\u6548\u4ef7\u683c\u653f\u7b56[{}]\uff0cid[{}]", (Object)price.getName(), (Object)price.getId());
                AuditAddReqDto auditAddReqDto = new AuditAddReqDto();
                auditAddReqDto.setAuditComments("\u521d\u59cb\u5316\u653f\u7b56\uff0c\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7");
                auditAddReqDto.setAuditResult(AuditResultEnum.PASS.toCode());
                auditAddReqDto.setRelateType(RelateTypeEnum.PRICE.getType());
                auditAddReqDto.setRelateId(price.getId());
                auditAddReqDto.setTenantId(price.getTenantId());
                auditAddReqDto.setInstanceId(price.getInstanceId());
                auditAddReqDto.setAuditPerson(CREATE_PERSON);
                this.auditService.addAudit(auditAddReqDto);
                initDataLogEo.setInitStatus(Integer.valueOf(2));
                initDataLogEo.setEndTime(new Date());
                initDataLogEo.setRemark(StrUtil.format((CharSequence)"\u751f\u6548 {} \u5b8c\u6210\uff0c\u8017\u65f6 {} \u6beb\u79d2", (Object[])new Object[]{price.getName(), timer.intervalMs()}));
                this.initDataLogDas.update((BaseEo)initDataLogEo);
                log.info("[\u751f\u6548\u4ef7\u683c\u653f\u7b56] >>> \u751f\u6548\u4ef7\u683c\u653f\u7b56[{}]\uff0cid[{}]\uff0c\u8017\u65f6[{}]\u6beb\u79d2", new Object[]{price.getName(), price.getId(), timer.intervalMs()});
            });
        }
    }

    @Override
    public String enablePricePolicy(List<InitDataReqDto> initDataReqDtos) {
        return this.effectPricePolicy(initDataReqDtos);
    }

    @Override
    public String enablePricePolicyAll() {
        return this.effectPricePolicy(null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void initDefaultDealerPriceData(List<Long> orgIds) {
        log.info("[\u9ed8\u8ba4\u4ef7\u683c\u653f\u7b56]\uff1a{}", orgIds);
        for (Long orgId : orgIds) {
            List shopBaseDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryShopListBySellerOrgId(orgId));
            if (CollectionUtils.isEmpty((Collection)shopBaseDtos)) {
                log.error("[\u9ed8\u8ba4\u4ef7\u683c\u653f\u7b56],\u5e97\u94fa\u4fe1\u606f\u4e3a\u7a7a\uff0c\u7ec4\u7ec7ID:{}", (Object)orgId);
                continue;
            }
            this.deleteExistencePolicyInfo(orgId, RelateTypeEnum.PRICE.getType());
            PriceTypeEo priceType = new PriceTypeEo();
            priceType.setCategoryCode(CategoryCodeEnum.CHANNEL_DISTRIBUTION.getCode());
            priceType.setOrganizationId(orgId);
            priceType.setWeight(this.WEIGHT);
            priceType.setStatus("0");
            priceType.setInstanceId(INSTANCEID);
            priceType.setTenantId(TENANTID);
            priceType.setCreatePerson(CREATE_PERSON);
            priceType.setRelatedNum(Integer.valueOf(1));
            priceType.setTypeCode(this.generateCode.createCode(GeneralRuleTypeEnum.JGLX));
            priceType.setTypeName("\u5e38\u89c4\u4ef7");
            priceType.setWeight("0");
            log.info("[\u9ed8\u8ba4\u4ef7\u683c\u653f\u7b56],\u521d\u59cb\u5316\u7ecf\u9500\u5546\u7ec4\u7ec7[{}]\u4ef7\u683c\u7c7b\u578b[{}]", (Object)orgId, (Object)priceType.getTypeName());
            this.priceTypeDas.insert((BaseEo)priceType);
            PriceModelEo priceModel = new PriceModelEo();
            priceModel.setModelCode(this.generateCode.createCode(GeneralRuleTypeEnum.JGMX));
            priceModel.setModelName("\u9ed8\u8ba4\u4ef7\u683c\u653f\u7b56");
            priceModel.setDirectSet(Integer.valueOf(1));
            priceModel.setDiscountSet(Integer.valueOf(1));
            priceModel.setTemporaryDiscount(Integer.valueOf(1));
            priceModel.setFixedDiscount(Integer.valueOf(1));
            priceModel.setRelatedNum(Integer.valueOf(1));
            priceModel.setOrganizationId(orgId);
            priceModel.setInstanceId(INSTANCEID);
            priceModel.setTenantId(TENANTID);
            priceModel.setCreatePerson(CREATE_PERSON);
            this.priceModelDas.insert((BaseEo)priceModel);
            log.info("[\u521d\u59cb\u5316\u4ef7\u683c] >>> \u521d\u59cb\u5316\u7ecf\u9500\u5546\u7ec4\u7ec7[{}]\u4ef7\u683c\u6a21\u578b[{}]", (Object)orgId, (Object)priceModel.getModelName());
            ArrayList basePriceRelationTypeEoList = Lists.newArrayList();
            BasePriceRelationTypeEo retailPriceType = new BasePriceRelationTypeEo();
            retailPriceType.setPriceTypeId(Long.valueOf(1L));
            retailPriceType.setPriceTypeName("\u5efa\u8bae\u96f6\u552e\u4ef7");
            retailPriceType.setPriceTypeCode("RETAIL_PRICE");
            retailPriceType.setPriceModelId(priceModel.getId());
            retailPriceType.setPriceModelName(priceModel.getModelName());
            basePriceRelationTypeEoList.add(retailPriceType);
            BasePriceRelationTypeEo dealerRetailPriceType = new BasePriceRelationTypeEo();
            dealerRetailPriceType.setPriceTypeId(Long.valueOf(3L));
            dealerRetailPriceType.setPriceTypeName("\u81ea\u5b9a\u4e49\u96f6\u552e\u4ef7");
            dealerRetailPriceType.setPriceTypeCode("DEALER_RETAIL_PRICE");
            dealerRetailPriceType.setPriceModelId(priceModel.getId());
            dealerRetailPriceType.setPriceModelName(priceModel.getModelName());
            basePriceRelationTypeEoList.add(dealerRetailPriceType);
            this.basePriceRelationTypeDas.insertBatch((List)basePriceRelationTypeEoList);
            PriceEo priceEo = new PriceEo();
            priceEo.setCategoryCode(priceType.getCategoryCode());
            priceEo.setModelId(priceModel.getId());
            priceEo.setRelationCustomerType(Integer.valueOf(2));
            priceEo.setRelationItemType(Integer.valueOf(2));
            priceEo.setDiscountType(Integer.valueOf(2));
            priceEo.setGiftboxIncrPrice(BigDecimal.ZERO);
            priceEo.setEffectiveTime(new Date());
            priceEo.setShopId(((ShopBaseDto)shopBaseDtos.get(0)).getId());
            priceEo.setStatus(PriceStatusEnum.WAIT_AUDIT.getCode());
            priceEo.setRemark("\u7cfb\u7edf\u521d\u59cb\u5316\u6570\u636e");
            priceEo.setTypeId(priceType.getId());
            priceEo.setName("\u5e38\u89c4\u6263\u7387\u5b9a\u4ef7\u653f\u7b56");
            priceEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
            priceEo.setTenantId(TENANTID);
            priceEo.setInstanceId(INSTANCEID);
            priceEo.setReadStatus(Integer.valueOf(1));
            priceEo.setCode(this.generateCode.createCode(GeneralRuleTypeEnum.JGZC));
            RelationInfoVo relationInfoVo = new RelationInfoVo();
            priceEo.setExtension(JSON.toJsonString((Object)relationInfoVo));
            priceEo.setOrganizationId(orgId);
            this.priceDas.insert((BaseEo)priceEo);
            AuditAddReqDto auditAddReqDto = new AuditAddReqDto();
            auditAddReqDto.setAuditResult("1");
            auditAddReqDto.setRelateId(priceEo.getId());
            auditAddReqDto.setRelateType("0");
            this.auditService.addAudit(auditAddReqDto);
            this.pricePolicyEsService.createPricePolicy(priceEo.getId());
        }
    }

    @Override
    public void syncAllPriceToEs(List<String> codes) {
        String requestId = ServiceContext.getContext().getRequestId();
        long start = System.currentTimeMillis();
        log.info("\u5f00\u59cb\u540c\u6b65\u4ef7\u683c\u653f\u7b56");
        int pageNum = 1;
        while (true) {
            PageInfo page;
            if ((page = ((ExtQueryChainWrapper)this.priceDas.filter().select(new String[]{"id"}).in(CollectionUtils.isNotEmpty(codes), (Object)"code", codes)).page(Integer.valueOf(pageNum), Integer.valueOf(1000))) == null || CollectionUtils.isEmpty((Collection)page.getList())) {
                log.info("[\u7ed3\u675f\u540c\u6b65\u4ef7\u683c\u653f\u7b56],\u603b\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
                return;
            }
            this.executorService.execute(() -> {
                MDC.put((String)"yes.req.requestId", (String)requestId);
                for (PriceEo priceEo : page.getList()) {
                    try {
                        long oneStart = System.currentTimeMillis();
                        this.pricePolicyEsService.deletePricePolicy(priceEo.getId());
                        this.pricePolicyEsService.createPricePolicy(priceEo.getId());
                        log.info("[\u540c\u6b65\u4ef7\u683c\u653f\u7b56]:{},\u8017\u65f6\uff1a{}", (Object)priceEo.getId(), (Object)(System.currentTimeMillis() - oneStart));
                    }
                    catch (Exception e) {
                        log.error("\u540c\u6b65\u4ef7\u683c\u6b63\u5e38\u62a5\u9519\uff1a\u653f\u7b56id{}", (Object)priceEo.getId());
                        e.printStackTrace();
                    }
                }
            });
            ++pageNum;
        }
    }
}

