/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.utils;

import cn.hutool.core.date.DateUtil;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceStatusEnum;
import com.dtyunxi.yundt.cube.center.price.biz.constant.PriceExceptionCode;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriceStatusUtils {
    private static final Logger log = LoggerFactory.getLogger(PriceStatusUtils.class);

    public static void checkStatus(PriceStatusEnum originalStatus, Long id, PriceStatusEnum ... allowStatus) {
        if (Objects.isNull(allowStatus) || !Arrays.stream(allowStatus).collect(Collectors.toList()).contains(originalStatus)) {
            log.info("[\u72b6\u6001] >>> \u4e1a\u52a1[{}]\u4e0d\u662f\u6307\u5b9a\u72b6\u6001[{}]\u8303\u56f4[{}]\u4e0d\u5141\u8bb8\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c", new Object[]{id, originalStatus, allowStatus});
            BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.OPERATION_NOT_ALLOWED);
        }
    }

    public static String convertStatus(String originalStatus, Date effectiveTime, Date invalidTime) {
        String auditPass = PriceStatusEnum.AUDIT_PASS.getCode();
        long current = DateUtil.current();
        if (!Objects.equals(originalStatus, auditPass)) {
            return originalStatus;
        }
        if (Objects.isNull(effectiveTime)) {
            return originalStatus;
        }
        if (current < effectiveTime.getTime()) {
            return PriceStatusEnum.WAIT_TAKE_EFFECT.getCode();
        }
        if (current >= effectiveTime.getTime() && (Objects.isNull(invalidTime) || current <= invalidTime.getTime())) {
            return PriceStatusEnum.WAIT_AUDIT.getCode().equals(originalStatus) ? PriceStatusEnum.WAIT_AUDIT.getCode() : PriceStatusEnum.EFFECT.getCode();
        }
        return PriceStatusEnum.EXPIRED.getCode();
    }
}

