/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.PriceAndNumLimitDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CustomerConditionModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceBeanReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceItemModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceAddOrModifyRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceOfferLimitItemRespDto;
import com.dtyunxi.yundt.cube.center.price.api.exception.PriceExceptionCode;
import com.dtyunxi.yundt.cube.center.price.dao.das.CustomerConditionDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.LimitItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceLimitDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.CustomerConditionEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.LimitItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceLimitEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdLimitItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceItemEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public interface ValidateStrategy {
    public static final DateTime END_OF_TIME = new DateTime(9999, 1, 1, 0, 0, 0, DateTimeZone.UTC);

    public PriceAddOrModifyRespDto validate(PriceBeanReqDto var1, Long var2);

    default public void validateBegin(PriceBeanReqDto priceBeanReqDto, Long id) {
        this.validateNullItem(priceBeanReqDto);
        List<Object> priceEos = this.getBasePriceEos(priceBeanReqDto);
        if (CollectionUtils.isNotEmpty(priceEos)) {
            Date effectiveTime = priceBeanReqDto.getEffectiveTime();
            Date invalidTime = priceBeanReqDto.getInvalidTime();
            if (null == invalidTime) {
                invalidTime = END_OF_TIME.toDate();
            }
            priceEos = this.filterSameCodePrice(priceEos, priceBeanReqDto);
            if (null == id) {
                if (CollectionUtils.isNotEmpty(priceEos = this.dealWithPrices(priceEos, effectiveTime, invalidTime))) {
                    this.validatePriceName(priceEos, priceBeanReqDto);
                    this.validateCustomer(priceEos, priceBeanReqDto);
                }
            } else if (CollectionUtils.isNotEmpty(priceEos = priceEos.stream().filter(bean -> !bean.getId().equals(id)).collect(Collectors.toList())) && CollectionUtils.isNotEmpty(priceEos = this.dealWithPrices(priceEos, effectiveTime, invalidTime))) {
                this.validatePriceName(priceEos, priceBeanReqDto);
                this.validateCustomer(priceEos, priceBeanReqDto);
            }
        }
    }

    default public void validateNullItem(PriceBeanReqDto priceBeanReqDto) {
        if (CollectionUtils.isEmpty((Collection)priceBeanReqDto.getPriceItemReqDtos())) {
            throw new BizException(PriceExceptionCode.ITEM_IS_NULL.getCode(), PriceExceptionCode.ITEM_IS_NULL.getMsg());
        }
    }

    default public void validateNullCustomer(PriceBeanReqDto priceBeanReqDto) {
        if (null == priceBeanReqDto.getCustomerConditionReqDto() || CollectionUtils.isEmpty((Collection)priceBeanReqDto.getCustomerConditionReqDto().getCustomerIds())) {
            throw new BizException(PriceExceptionCode.CUSTOMER_IS_NULL.getCode(), PriceExceptionCode.CUSTOMER_IS_NULL.getMsg());
        }
    }

    default public List<PriceEo> filterSameCodePrice(List<PriceEo> priceEos, PriceBeanReqDto priceBeanReqDto) {
        List<Object> priceEoList = com.google.common.collect.Lists.newArrayList();
        priceEoList = priceEos.stream().filter(bean -> {
            if (StringUtils.isEmpty((CharSequence)priceBeanReqDto.getCode())) {
                return true;
            }
            return !bean.getCode().equals(priceBeanReqDto.getCode());
        }).collect(Collectors.toList());
        return priceEoList;
    }

    default public List<PriceEo> getBasePriceEos(PriceBeanReqDto priceBeanReqDto) {
        PriceDas priceDas = (PriceDas)SpringBeanUtil.getBean(PriceDas.class);
        PriceEo queryPriceEo = new PriceEo();
        queryPriceEo.setTypeId(priceBeanReqDto.getTypeId());
        queryPriceEo.setCategoryCode(priceBeanReqDto.getCategoryCode());
        ArrayList querySqlFilter = com.google.common.collect.Lists.newArrayList();
        querySqlFilter.add(SqlFilter.in((String)"status", (Object)com.google.common.collect.Lists.newArrayList((Object[])new String[]{PriceStatusEnum.WAIT_AUDIT.getCode(), PriceStatusEnum.WAIT_TAKE_EFFECT.getCode(), PriceStatusEnum.AUDIT_PASS.getCode()})));
        queryPriceEo.setSqlFilters((List)querySqlFilter);
        return priceDas.select((BaseEo)queryPriceEo);
    }

    default public List<PriceEo> dealWithPrices(List<PriceEo> priceEos, Date effectiveTime, Date invalidTime) {
        ArrayList priceEoList = com.google.common.collect.Lists.newArrayList();
        for (PriceEo bean : priceEos) {
            Date tempEffectiveTime = bean.getEffectiveTime();
            Date tempInvalidTime = bean.getInvalidTime();
            if (null == tempInvalidTime) {
                tempInvalidTime = END_OF_TIME.toDate();
            }
            if (effectiveTime.getTime() > tempInvalidTime.getTime() || invalidTime.getTime() < tempEffectiveTime.getTime()) continue;
            priceEoList.add(bean);
        }
        return priceEoList;
    }

    default public void validateCustomer(List<PriceEo> priceEos, PriceBeanReqDto reqDto) {
        List customerIds;
        if (null != reqDto.getCustomerConditionReqDto() && CollectionUtils.isNotEmpty((Collection)(customerIds = reqDto.getCustomerConditionReqDto().getCustomerIds())) && CollectionUtils.isNotEmpty(priceEos = priceEos.stream().filter(bean -> {
            List<String> tempIds;
            CustomerConditionEo conditionEo;
            CustomerConditionDas customerConditionDas = (CustomerConditionDas)SpringBeanUtil.getBean(CustomerConditionDas.class);
            CustomerConditionEo customerConditionEo = new CustomerConditionEo();
            customerConditionEo.setRelateId(bean.getId());
            customerConditionEo.setRelateType(RelateTypeEnum.PRICE.getType());
            List conditionEos = customerConditionDas.select((BaseEo)customerConditionEo);
            return CollectionUtils.isNotEmpty((Collection)conditionEos) && null != (conditionEo = (CustomerConditionEo)conditionEos.get(0)) && StringUtils.isNotEmpty((CharSequence)conditionEo.getCustomerIds()) && !Collections.disjoint(customerIds, tempIds = Arrays.asList(conditionEo.getCustomerIds().split(",")));
        }).collect(Collectors.toList()))) {
            this.validateItems(priceEos, reqDto);
        }
    }

    default public void validateItems(List<PriceEo> priceEos, PriceBeanReqDto reqDto) {
        List skuIds;
        List priceItemReqDtos = reqDto.getPriceItemReqDtos();
        if (CollectionUtils.isNotEmpty((Collection)priceItemReqDtos) && CollectionUtils.isNotEmpty(skuIds = priceItemReqDtos.stream().map(PriceItemModifyReqDto::getSkuId).collect(Collectors.toList()))) {
            priceEos.stream().forEach(bean -> {
                List tempSkuIds;
                PriceItemDas priceItemDas = (PriceItemDas)SpringBeanUtil.getBean(PriceItemDas.class);
                PriceItemEo priceItemEo = new PriceItemEo();
                priceItemEo.setPriceId(bean.getId());
                List priceItemEos = priceItemDas.select((BaseEo)priceItemEo);
                if (CollectionUtils.isNotEmpty((Collection)priceItemEos) && !Collections.disjoint(skuIds, tempSkuIds = priceItemEos.stream().map(StdPriceItemEo::getSkuId).collect(Collectors.toList()))) {
                    throw new BizException(this.getExceptionMsg(bean.getName()));
                }
            });
        }
    }

    default public List<PriceOfferLimitItemRespDto> checkPriceLimit(PriceBeanReqDto priceBeanReqDto) {
        List priceItemReqDtos = priceBeanReqDto.getPriceItemReqDtos();
        ArrayList priceOfferLimitItemRespDtoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)priceItemReqDtos)) {
            List skuIds = priceItemReqDtos.stream().map(PriceItemModifyReqDto::getSkuId).collect(Collectors.toList());
            Map<Long, List<PriceItemModifyReqDto>> priceItemModifyReqDtoMap = priceItemReqDtos.stream().collect(Collectors.groupingBy(PriceItemModifyReqDto::getSkuId));
            LimitItemDas limitItemDas = (LimitItemDas)SpringBeanUtil.getBean(LimitItemDas.class);
            LimitItemEo queryLimitItemEo = new LimitItemEo();
            ArrayList sqlFilters = Lists.newArrayList();
            sqlFilters.add(SqlFilter.in((String)"sku_id", skuIds));
            queryLimitItemEo.setSqlFilters((List)sqlFilters);
            PriceLimitDas priceLimitDas = (PriceLimitDas)SpringBeanUtil.getBean(PriceLimitDas.class);
            List limitItemEos = priceLimitDas.queryAuditPriceLimitBySkuId(skuIds);
            List filterLimitItemEos = limitItemEos.stream().filter(bean -> {
                List priceItemModifyReqDtos;
                if (null != bean.getSkuId() && null != bean.getLowerLimit() && null != bean.getUpperLimit() && CollectionUtils.isNotEmpty((Collection)(priceItemModifyReqDtos = (List)priceItemModifyReqDtoMap.get(bean.getSkuId())))) {
                    PriceItemModifyReqDto priceItemModifyReqDto = (PriceItemModifyReqDto)priceItemModifyReqDtos.get(0);
                    List priceNumLimitList = priceItemModifyReqDto.getPriceNumLimitList();
                    if (null != priceItemModifyReqDto && CollectionUtils.isNotEmpty((Collection)priceNumLimitList)) {
                        for (PriceAndNumLimitDto compare : priceNumLimitList) {
                            if (null == compare.getItemPrice() || compare.getItemPrice().compareTo(bean.getLowerLimit()) >= 0 && compare.getItemPrice().compareTo(bean.getUpperLimit()) <= 0) continue;
                            return true;
                        }
                    } else if (null != priceItemModifyReqDto.getItemPrice() && (priceItemModifyReqDto.getItemPrice().compareTo(bean.getLowerLimit()) < 0 || priceItemModifyReqDto.getItemPrice().compareTo(bean.getUpperLimit()) > 0)) {
                        return true;
                    }
                }
                return false;
            }).collect(Collectors.toList());
            Map<Long, List<LimitItemEo>> limitItemEoMap = filterLimitItemEos.stream().collect(Collectors.groupingBy(StdLimitItemEo::getPriceLimitId));
            List priceLimitIds = filterLimitItemEos.stream().map(StdLimitItemEo::getPriceLimitId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(priceLimitIds)) {
                CustomerConditionDas customerConditionDas = (CustomerConditionDas)SpringBeanUtil.getBean(CustomerConditionDas.class);
                ICustomerQueryApi customerQueryApi = (ICustomerQueryApi)SpringBeanUtil.getBean(ICustomerQueryApi.class);
                PriceLimitEo priceLimitEo = new PriceLimitEo();
                ArrayList queryLimitFilters = Lists.newArrayList();
                queryLimitFilters.add(SqlFilter.in((String)"id", priceLimitIds));
                queryLimitFilters.add(SqlFilter.eq((String)"status", (Object)"AUDIT_PASS"));
                priceLimitEo.setSqlFilters((List)queryLimitFilters);
                List pirceLimitEos = priceLimitDas.select((BaseEo)priceLimitEo);
                ArrayList queryCustomerFilters = Lists.newArrayList();
                CustomerConditionEo customerConditionEo = new CustomerConditionEo();
                queryCustomerFilters.add(SqlFilter.in((String)"relate_id", priceLimitIds));
                customerConditionEo.setRelateType(RelateTypeEnum.PRICE_LIMIT.getType());
                customerConditionEo.setSqlFilters((List)queryCustomerFilters);
                List customerConditionEos = customerConditionDas.select((BaseEo)customerConditionEo);
                if (CollectionUtils.isNotEmpty((Collection)pirceLimitEos) && CollectionUtils.isNotEmpty((Collection)customerConditionEos)) {
                    Map<Long, List<PriceLimitEo>> priceLimitEoMap = pirceLimitEos.stream().collect(Collectors.groupingBy(BaseEo::getId));
                    CustomerConditionModifyReqDto customerConditionReqDto = priceBeanReqDto.getCustomerConditionReqDto();
                    CustomerSearchReqDto customerSearchReqDto = new CustomerSearchReqDto();
                    if (null != customerConditionReqDto && CollectionUtils.isNotEmpty((Collection)customerConditionReqDto.getCustomerIds())) {
                        List ids = customerConditionReqDto.getCustomerIds().stream().map(bean -> Long.parseLong(bean)).collect(Collectors.toList());
                        customerSearchReqDto.setIdList(ids);
                        RestResponse pageInfoRestResponse = customerQueryApi.queryByPage(JSON.toJSONString((Object)customerSearchReqDto), Integer.valueOf(1), Integer.valueOf(5000));
                        if (null != pageInfoRestResponse && null != pageInfoRestResponse.getData() && CollectionUtils.isNotEmpty((Collection)((PageInfo)pageInfoRestResponse.getData()).getList())) {
                            List customerRespDtos = ((PageInfo)pageInfoRestResponse.getData()).getList();
                            for (CustomerRespDto customerRespDto : customerRespDtos) {
                                customerConditionEos.stream().forEach(bean -> {
                                    Object[] split;
                                    List priceLimitEos = (List)priceLimitEoMap.get(bean.getRelateId());
                                    List limitItemEos1 = (List)limitItemEoMap.get(bean.getRelateId());
                                    String limitName = "";
                                    boolean flag = false;
                                    if (CollectionUtils.isNotEmpty((Collection)priceLimitEos)) {
                                        limitName = ((PriceLimitEo)priceLimitEos.get(0)).getName();
                                    }
                                    if (null != customerRespDto.getCustomerTypeId() && StringUtils.isNotEmpty((CharSequence)bean.getCustomerTypeIds()) && ArrayUtils.contains((Object[])(split = bean.getCustomerTypeIds().split(",")), (Object)String.valueOf(customerRespDto.getCustomerTypeId()))) {
                                        flag = true;
                                    }
                                    if (null != customerRespDto.getCustomerGroupId() && StringUtils.isNotEmpty((CharSequence)bean.getCustomerGroupIdExt()) && ArrayUtils.contains((Object[])(split = bean.getCustomerGroupIdExt().split(",")), (Object)String.valueOf(customerRespDto.getCustomerGroupId()))) {
                                        flag = true;
                                    }
                                    if (StringUtils.isNotEmpty((CharSequence)customerRespDto.getRegionCodes()) && StringUtils.isNotEmpty((CharSequence)bean.getCustomerAreaCodeExt())) {
                                        String[] regionCodes;
                                        split = bean.getCustomerAreaCodeExt().split(",");
                                        for (String regionCode : regionCodes = customerRespDto.getRegionCodes().split(",")) {
                                            if (!ArrayUtils.contains((Object[])split, (Object)regionCode)) continue;
                                            flag = true;
                                        }
                                    }
                                    if (flag) {
                                        ArrayList priceOfferLimitItemRespDto = Lists.newArrayList();
                                        if (CollectionUtils.isNotEmpty((Collection)limitItemEos1)) {
                                            CubeBeanUtils.copyCollection((Collection)priceOfferLimitItemRespDto, (Collection)limitItemEos1, PriceOfferLimitItemRespDto.class);
                                            for (PriceOfferLimitItemRespDto limitItem : priceOfferLimitItemRespDto) {
                                                limitItem.setPriceLimitName(limitName);
                                                List priceItemModifyReqDtos = (List)priceItemModifyReqDtoMap.get(limitItem.getSkuId());
                                                if (!CollectionUtils.isNotEmpty((Collection)priceItemModifyReqDtos)) continue;
                                                PriceItemModifyReqDto priceItemModifyReqDto = (PriceItemModifyReqDto)priceItemModifyReqDtos.get(0);
                                                List priceNumLimitList = priceItemModifyReqDto.getPriceNumLimitList();
                                                if (null == priceItemModifyReqDto || !CollectionUtils.isNotEmpty((Collection)priceNumLimitList)) continue;
                                                for (PriceAndNumLimitDto compare : priceNumLimitList) {
                                                    if (null == compare.getItemPrice() || compare.getItemPrice().compareTo(limitItem.getLowerLimit()) >= 0 && compare.getItemPrice().compareTo(limitItem.getUpperLimit()) <= 0) continue;
                                                    limitItem.setItemPrice(compare.getItemPrice());
                                                }
                                            }
                                            priceOfferLimitItemRespDtoList.addAll(priceOfferLimitItemRespDto);
                                        }
                                    }
                                });
                            }
                        }
                    }
                }
            }
        }
        List<Object> tempPriceOfferLimitItemRespDtos = com.google.common.collect.Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)priceOfferLimitItemRespDtoList)) {
            tempPriceOfferLimitItemRespDtos = priceOfferLimitItemRespDtoList;
            tempPriceOfferLimitItemRespDtos = tempPriceOfferLimitItemRespDtos.stream().distinct().collect(Collectors.toList());
            Collections.sort(tempPriceOfferLimitItemRespDtos, new Comparator<PriceOfferLimitItemRespDto>(){

                @Override
                public int compare(PriceOfferLimitItemRespDto o1, PriceOfferLimitItemRespDto o2) {
                    return Integer.valueOf(o2.getControlType()) - Integer.valueOf(o1.getControlType());
                }
            });
        }
        return tempPriceOfferLimitItemRespDtos;
    }

    default public void validatePriceName(List<PriceEo> priceEos, PriceBeanReqDto reqDto) {
        if (CollectionUtils.isNotEmpty(priceEos)) {
            priceEos.forEach(priceEo -> {
                if (priceEo.getName().equals(reqDto.getName())) {
                    throw new BizException("\u4ef7\u683c\u6807\u9898\u4e0d\u80fd\u91cd\u590d");
                }
            });
        }
    }

    default public String getExceptionMsg(String priceName) {
        if (StringUtils.isNotEmpty((CharSequence)priceName)) {
            return "\u4ef7\u683c\u653f\u7b56\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u51b2\u7a81\u4ef7\u683c\u653f\u7b56\u3010" + priceName + "\u3011";
        }
        return "\u4ef7\u683c\u653f\u7b56\u6821\u9a8c\u4e0d\u901a\u8fc7";
    }
}

