/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.ModifyPriceLogAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.ModifyPriceLogModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.ModifyPriceLogQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceHistoryQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ModifyPriceLogRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceHistoryItemRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceHistoryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceModifyLogRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.constant.PriceExceptionCode;
import com.dtyunxi.yundt.cube.center.price.biz.helper.CustomerHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.SkuHelper;
import com.dtyunxi.yundt.cube.center.price.biz.service.IModifyPriceLogService;
import com.dtyunxi.yundt.cube.center.price.biz.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.price.dao.das.BasePriceApplyDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.ModifyPriceLogDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.BasePriceApplyEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.ModifyPriceLogEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdModifyPriceLogEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ModifyPriceLogServiceImpl
implements IModifyPriceLogService {
    @Resource
    private ModifyPriceLogDas modifyPriceLogDas;
    @Resource
    private IContext context;
    @Resource
    private CustomerHelper customerHelper;
    @Resource
    private SkuHelper skuHelper;
    @Autowired
    private BasePriceApplyDas basePriceApplyDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addModifyPriceLog(ModifyPriceLogAddReqDto reqDto) {
        ModifyPriceLogEo modifyPriceLogEo = new ModifyPriceLogEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)modifyPriceLogEo);
        this.modifyPriceLogDas.insert((BaseEo)modifyPriceLogEo);
        return modifyPriceLogEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyModifyPriceLog(ModifyPriceLogModifyReqDto reqDto) {
        ModifyPriceLogEo modifyPriceLogEo = new ModifyPriceLogEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)modifyPriceLogEo);
        this.modifyPriceLogDas.updateSelective((BaseEo)modifyPriceLogEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeModifyPriceLog(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.modifyPriceLogDas.logicDeleteById(Long.valueOf(id.trim()));
        }
    }

    @Override
    public PriceHistoryRespDto priceHistory(PriceHistoryQueryReqDto qry) {
        List modifyPriceLogEoList;
        qry.setTenantId(this.context.tenantId());
        qry.setInstanceId(this.context.instanceId());
        if (qry.getStart() == null && qry.getEnd() == null) {
            LocalDateTime localDateTime = LocalDateTime.now();
            qry.setEnd(Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()));
            localDateTime = localDateTime.minusDays(14L);
            qry.setStart(Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()));
        }
        if (null == (modifyPriceLogEoList = this.modifyPriceLogDas.priceHistory(qry)) || modifyPriceLogEoList.isEmpty()) {
            return null;
        }
        PriceHistoryRespDto historyRespDto = new PriceHistoryRespDto();
        ArrayList data = new ArrayList();
        modifyPriceLogEoList.forEach(eo -> {
            PriceHistoryItemRespDto itemRespDto = new PriceHistoryItemRespDto();
            itemRespDto.setPrice(eo.getPrice());
            itemRespDto.setDate(eo.getCreateTime());
            itemRespDto.setLowerLimit(eo.getLowerLimit());
            itemRespDto.setUpperLimit(eo.getUpperLimit());
            if (null != eo.getPrice() && null != eo.getOriginalPrice()) {
                int compare = eo.getOriginalPrice().compareTo(eo.getPrice());
                itemRespDto.setTrend(Integer.valueOf(2));
                if (compare == 0) {
                    itemRespDto.setTrend(Integer.valueOf(0));
                } else if (compare < 0) {
                    itemRespDto.setTrend(Integer.valueOf(1));
                }
                historyRespDto.setItemName(eo.getItemName());
                historyRespDto.setSkuDesc(eo.getSkuDesc());
                data.add(itemRespDto);
            }
        });
        historyRespDto.setData(data);
        return historyRespDto;
    }

    private LambdaQueryWrapper<ModifyPriceLogEo> getLogParams(ModifyPriceLogQueryReqDto reqDto) {
        String priceTypeCode = reqDto.getPriceTypeCode();
        Long priceTypeId = reqDto.getPriceTypeId();
        if (Objects.isNull(priceTypeId) && StrUtil.isBlank((CharSequence)priceTypeCode)) {
            BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.SAME_TIME_AND_SPACE_ARE_NOT_ALLOWED);
        }
        if (Objects.isNull(priceTypeId)) {
            PriceTypeEnum priceTypeEnum = PriceTypeEnum.toPriceTypeEnum((String)priceTypeCode);
            if (Objects.isNull(priceTypeEnum)) {
                BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.INVALID_PRICE_TYPE);
            }
            priceTypeId = priceTypeEnum.getTypeId();
        }
        reqDto.setPriceTypeId(priceTypeId);
        ModifyPriceLogEo modifyPriceLogEo = new ModifyPriceLogEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)modifyPriceLogEo);
        Long orgId = this.customerHelper.getOrgId();
        modifyPriceLogEo.setOrganizationId(orgId);
        modifyPriceLogEo.setTenantId(this.context.tenantId());
        modifyPriceLogEo.setInstanceId(this.context.instanceId());
        Date approvedStartTime = reqDto.getApprovedStartTime();
        Date approvedEndTime = reqDto.getApprovedEndTime();
        LambdaQueryWrapper<ModifyPriceLogEo> queryWrapper = MybatisPlusUtils.newLambdaQueryWrapper(modifyPriceLogEo);
        if (Objects.nonNull(approvedStartTime)) {
            queryWrapper.ge(StdModifyPriceLogEo::getApprovedTime, (Object)DateUtil.format((Date)approvedStartTime, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (Objects.nonNull(approvedEndTime)) {
            queryWrapper.le(StdModifyPriceLogEo::getApprovedTime, (Object)DateUtil.format((Date)approvedEndTime, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        return queryWrapper;
    }

    @Override
    public PriceModifyLogRespDto skuPriceHistoryStatistics(ModifyPriceLogQueryReqDto reqDto) {
        PriceModifyLogRespDto priceModifyLogRespDto = new PriceModifyLogRespDto();
        Map<Long, ItemSkuQueryRespDto> skuQueryRespDtoMap = this.skuHelper.querySkuMap(ListUtil.toList((Object[])new Long[]{reqDto.getSkuId()}));
        if (skuQueryRespDtoMap.containsKey(reqDto.getSkuId())) {
            ItemSkuQueryRespDto itemSkuQueryRespDto = skuQueryRespDtoMap.get(reqDto.getSkuId());
            priceModifyLogRespDto.setItemCode(itemSkuQueryRespDto.getItemCode());
            priceModifyLogRespDto.setItemId(itemSkuQueryRespDto.getItemId());
            priceModifyLogRespDto.setSkuId(reqDto.getSkuId());
            priceModifyLogRespDto.setSkuCode(itemSkuQueryRespDto.getSkuCode());
            priceModifyLogRespDto.setItemName(itemSkuQueryRespDto.getItemName());
            priceModifyLogRespDto.setSkuSpec(itemSkuQueryRespDto.getSkuAttr());
        }
        LambdaQueryWrapper<ModifyPriceLogEo> logsWrapper = this.getLogParams(reqDto);
        logsWrapper.orderByAsc(StdModifyPriceLogEo::getApprovedTime);
        List modifyPriceLogList = this.modifyPriceLogDas.getMapper().selectList(logsWrapper);
        List logsList = modifyPriceLogList.stream().map(item -> {
            PriceHistoryItemRespDto priceHistoryItemRespDto = new PriceHistoryItemRespDto();
            priceHistoryItemRespDto.setPrice(item.getPrice());
            priceHistoryItemRespDto.setDate(item.getApprovedTime());
            return priceHistoryItemRespDto;
        }).collect(Collectors.toList());
        priceModifyLogRespDto.setLogsList(logsList);
        return priceModifyLogRespDto;
    }

    @Override
    public PageInfo<ModifyPriceLogRespDto> skuPriceHistoryPage(ModifyPriceLogQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        LambdaQueryWrapper<ModifyPriceLogEo> queryWrapper = this.getLogParams(reqDto);
        queryWrapper.orderByDesc(StdModifyPriceLogEo::getApprovedTime);
        PageInfo<ModifyPriceLogRespDto> pageInfo = MybatisPlusUtils.selectPage(this.modifyPriceLogDas, queryWrapper, ModifyPriceLogRespDto.class, pageNum, pageSize);
        if (pageInfo != null && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            List businessIds = pageInfo.getList().stream().map(ModifyPriceLogRespDto::getBusinessId).collect(Collectors.toList());
            LambdaQueryWrapper basePriceApplyQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)basePriceApplyQueryWrapper.eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, businessIds);
            List basePriceApplyEos = this.basePriceApplyDas.getMapper().selectList((Wrapper)basePriceApplyQueryWrapper);
            Map<Long, BasePriceApplyEo> basePriceApplyEoMap = basePriceApplyEos.stream().collect(Collectors.toMap(BaseEo::getId, e -> e, (e1, e2) -> e1));
            for (ModifyPriceLogRespDto modifyPriceLogRespDto : pageInfo.getList()) {
                BasePriceApplyEo basePriceApplyEo = basePriceApplyEoMap.get(modifyPriceLogRespDto.getBusinessId());
                if (basePriceApplyEo == null) continue;
                modifyPriceLogRespDto.setBusinessCreateTime(basePriceApplyEo.getCreateTime());
            }
        }
        return pageInfo;
    }
}

