package com.dtyunxi.yundt.cube.center.customer.dao.eo.customer;

import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerEo;
import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Date;

/**
 * 客户信息
 *
 * @author zhuiming.xhq@dtyunxi.com
 * @since 0.6.0
 */
@Table(name="cs_customer")
public class CustomerEo extends StdCustomerEo {
    /**
     * 账期开始时间
     */
    @Column(name = "accountor_effect_starttime")
    private Date accountorEffectStarttime;

    /**
     * 账期结束时间
     */
    @Column(name = "accountor_effect_endtime")
    private Date accountorEffectEndtime;

    @Column(name = "financial_print")
    private Integer financialPrint;

    /**
     * 是否打印质检报告：1是，0否
     */
    @Column(name = "reports_print")
    private Integer reportsPrint;

    /**
     * 是否有额外资料：1是，0否
     */
    @Column(name = "extra_material")
    private Integer extraMaterial;

    /**
     * 是否整箱起订。值 0否 、1是
     */
    @Column(name = "if_whole_case_purchase")
    private Integer ifWholeCasePurchase;

    /**
     *  旧编号
     */
    @Column(name = "oldCode")
    private String oldCode;

    @Column(
            name = "extension"
    )
    private String extension;

    @Column(name = "information_remarks")
    private String informationRemarks;

    public static CustomerEo newInstance() {
        return new CustomerEo();
    }

    public Integer getIfWholeCasePurchase() {
        return ifWholeCasePurchase;
    }

    public void setIfWholeCasePurchase(Integer ifWholeCasePurchase) {
        this.ifWholeCasePurchase = ifWholeCasePurchase;
    }

    public Date getAccountorEffectStarttime() {
        return accountorEffectStarttime;
    }

    public void setAccountorEffectStarttime(Date accountorEffectStarttime) {
        this.accountorEffectStarttime = accountorEffectStarttime;
    }

    public Date getAccountorEffectEndtime() {
        return accountorEffectEndtime;
    }

    public void setAccountorEffectEndtime(Date accountorEffectEndtime) {
        this.accountorEffectEndtime = accountorEffectEndtime;
    }

    public Integer getFinancialPrint() {
        return financialPrint;
    }

    public void setFinancialPrint(Integer financialPrint) {
        this.financialPrint = financialPrint;
    }

    public Integer getReportsPrint() {
        return reportsPrint;
    }

    public void setReportsPrint(Integer reportsPrint) {
        this.reportsPrint = reportsPrint;
    }

    public Integer getExtraMaterial() {
        return extraMaterial;
    }

    public void setExtraMaterial(Integer extraMaterial) {
        this.extraMaterial = extraMaterial;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getInformationRemarks() {
        return informationRemarks;
    }

    public void setInformationRemarks(String informationRemarks) {
        this.informationRemarks = informationRemarks;
    }

    public String getOldCode() {
        return oldCode;
    }

    public void setOldCode(String oldCode) {
        this.oldCode = oldCode;
    }
}