/*
 * @(#)CustomerSalesmanEo.java 1.0 2021/10/13
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.customer.dao.eo.customer;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerSalesmanEo;

import javax.persistence.Table;

/**
 * 业务员表Eo对象
 * @author 惜笔 | 林五弟
 * @version 1.0.0
 * @date 2021/10/13 18:27
 */
@Table(name="cs_customer_salesman")
public class CustomerSalesmanEo extends StdCustomerSalesmanEo {

    public static CustomerSalesmanEo newInstance() {
        return (CustomerSalesmanEo) BaseEo.newInstance(CustomerSalesmanEo.class);
    }

    public <DTO extends BaseVo> DTO toDto(Class<DTO> dtoClass) {
        try {
            DTO dto = dtoClass.newInstance();
            DtoHelper.eo2Dto(this, dto);
            return dto;
        }catch (Exception e){
            return null;
        }
    }

}
