/*
 * @(#)StdBasePriceItemEo.java 1.0 2021-11-19
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.price.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 商品基础价格明细(BasePriceItem)实体类
 *
 * @author 惜笔 | 林五弟
 * @date 2021-11-19 19:28:03
 * @since v1
 */
@Table(name="pr_base_price_item")
public class StdBasePriceItemEo extends CubeBaseEo{

    /**
     * 更新时间
     */
    @Column(name = "renew_time")
    private Date renewTime;
    /**
     * 价格类型id
     */
    @Column(name = "type_id")
    private Long typeId;
    /**
     * sku编码
     */
    @Column(name = "sku_code")
    private String skuCode;

    /**
     * skuId
     */
    @Column(name = "sku_id")
    private Long skuId;

    /**
     * 组织id
     */
    @Column(name = "organization_id")
    private Long organizationId;
    /**
     * 价格
     */
    @Column(name = "item_price")
    private BigDecimal itemPrice;
    /**
     * 所属品牌方
     */
    @Column(name = "item_org_id")
    private Long itemOrgId;
    /**
     * 商品类型
     */
    @Column(name = "item_type")
    private String itemType;
    /**
     * 商品id
     */
    @Column(name = "item_id")
    private Long itemId;
    /**
     * 品牌
     */
    @Column(name = "item_brand")
    private String itemBrand;
    /**
     * 是否礼盒（0：是、1：否）
     */
    @Column(name = "gift_box")
    private Integer giftBox;
    /**
     * 适用店铺
     */
    @Column(name = "shop_id")
    private Long shopId;
    /**
     * 规格
     */
    @Column(name = "sku_spec")
    private String skuSpec;
    /**
     * 商品名字
     */
    @Column(name = "item_name")
    private String itemName;
    /**
     * 商品编码
     */
    @Column(name = "item_code")
    private String itemCode;
    /**
     * 商品类目
     */
    @Column(name = "item_dir_name")
    private String itemDirName;

    /**
     * 业务id，如申请单id
     */
    @Column(name = "business_id")
    private Long businessId;
    /**
     * 业务编号，如申请单编号
     */
    @Column(name = "business_code")
    private String businessCode;

    public Long getBusinessId() {
        return businessId;
    }

    public void setBusinessId(Long businessId) {
        this.businessId = businessId;
    }

    public String getBusinessCode() {
        return businessCode;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }


    /**
     * get 更新时间
     */     
    public Date getRenewTime() {
        return renewTime;
    }

    /**
     * set 更新时间
     */     
    public void setRenewTime(Date renewTime) {
        this.renewTime = renewTime;
    }

    /**
     * get 价格类型id
     */     
    public Long getTypeId() {
        return typeId;
    }

    /**
     * set 价格类型id
     */     
    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }

    /**
     * get sku编码
     */     
    public String getSkuCode() {
        return skuCode;
    }

    /**
     * set sku编码
     */     
    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    /**
     * get 组织id
     */     
    public Long getOrganizationId() {
        return organizationId;
    }

    /**
     * set 组织id
     */     
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    /**
     * get 价格
     */     
    public BigDecimal getItemPrice() {
        return itemPrice;
    }

    /**
     * set 价格
     */     
    public void setItemPrice(BigDecimal itemPrice) {
        this.itemPrice = itemPrice;
    }

    /**
     * get 所属品牌方
     */     
    public Long getItemOrgId() {
        return itemOrgId;
    }

    /**
     * set 所属品牌方
     */     
    public void setItemOrgId(Long itemOrgId) {
        this.itemOrgId = itemOrgId;
    }

    /**
     * get 商品类型
     */     
    public String getItemType() {
        return itemType;
    }

    /**
     * set 商品类型
     */     
    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    /**
     * get 商品id
     */     
    public Long getItemId() {
        return itemId;
    }

    /**
     * set 商品id
     */     
    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    /**
     * get 品牌
     */     
    public String getItemBrand() {
        return itemBrand;
    }

    /**
     * set 品牌
     */     
    public void setItemBrand(String itemBrand) {
        this.itemBrand = itemBrand;
    }

    /**
     * get 是否礼盒（0：是、1：否）
     */     
    public Integer getGiftBox() {
        return giftBox;
    }

    /**
     * set 是否礼盒（0：是、1：否）
     */     
    public void setGiftBox(Integer giftBox) {
        this.giftBox = giftBox;
    }

    /**
     * get 适用店铺
     */     
    public Long getShopId() {
        return shopId;
    }

    /**
     * set 适用店铺
     */     
    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    /**
     * get 规格
     */     
    public String getSkuSpec() {
        return skuSpec;
    }

    /**
     * set 规格
     */     
    public void setSkuSpec(String skuSpec) {
        this.skuSpec = skuSpec;
    }

    /**
     * get 商品名字
     */     
    public String getItemName() {
        return itemName;
    }

    /**
     * set 商品名字
     */     
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    /**
     * get 商品编码
     */     
    public String getItemCode() {
        return itemCode;
    }

    /**
     * set 商品编码
     */     
    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    /**
     * get 商品类目
     */     
    public String getItemDirName() {
        return itemDirName;
    }

    /**
     * set 商品类目
     */     
    public void setItemDirName(String itemDirName) {
        this.itemDirName = itemDirName;
    }

}
