package com.dtyunxi.yundt.cube.center.price.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
/**
 * StdModifyPriceLogEo对象
 *
 * @author liuji
 * @since 2021-06-30
 */
public class StdModifyPriceLogEo extends CubeBaseEo {
    /**
     * 商品价格id
     */
    @Column(name = "price_item_id")
    private Long priceItemId;

    /**
     * 价格类型 id
     */
    @Column(name = "price_type_id")
    private Long priceTypeId;

    /**
     * 商品id
     */
    @Column(name = "item_id")
    private Long itemId;
    /**
     * 商品名称
     */
    @Column(name = "item_name")
    private String itemName;
    /**
     * skuid
     */
    @Column(name = "sku_id")
    private Long skuId;
    /**
     * 商品规格
     */
    @Column(name = "sku_desc")
    private String skuDesc;
    /**
     * 申请人
     */
    @Column(name = "applicant")
    private String applicant;
    /**
     * 审核人
     */
    @Column(name = "reviewer")
    private String reviewer;
    /**
     * 调价时间
     */
    @Column(name = "approved_time")
    private Date approvedTime;
    /**
     * 状态（0：启用1：禁用）
     */
    @Column(name = "status")
    private String status;
    /**
     * 调整前价格
     */
    @Column(name = "original_price")
    private BigDecimal originalPrice;
    /**
     * 调整后价格
     */
    @Column(name = "price")
    private BigDecimal price;

    /**
     * 业务id，如申请单id
     */
    @Column(name = "business_id")
    private Long businessId;
    /**
     * 业务编号，如申请单编号
     */
    @Column(name = "business_code")
    private String businessCode;
    /**
     * 组织id
     */
    @Column(name = "organization_id")
    private Long organizationId;

    public Long getBusinessId() {
        return businessId;
    }

    public void setBusinessId(Long businessId) {
        this.businessId = businessId;
    }

    public String getBusinessCode() {
        return businessCode;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public Long getPriceItemId() {
        return priceItemId;
    }

    public void setPriceItemId(Long priceItemId) {
        this.priceItemId = priceItemId;
    }

    public Long getPriceTypeId() {
        return priceTypeId;
    }

    public void setPriceTypeId(Long priceTypeId) {
        this.priceTypeId = priceTypeId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public String getSkuDesc() {
        return skuDesc;
    }

    public void setSkuDesc(String skuDesc) {
        this.skuDesc = skuDesc;
    }

    public String getApplicant() {
        return applicant;
    }

    public void setApplicant(String applicant) {
        this.applicant = applicant;
    }

    public String getReviewer() {
        return reviewer;
    }

    public void setReviewer(String reviewer) {
        this.reviewer = reviewer;
    }

    public Date getApprovedTime() {
        return approvedTime;
    }

    public void setApprovedTime(Date approvedTime) {
        this.approvedTime = approvedTime;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public BigDecimal getOriginalPrice() {
        return originalPrice;
    }

    public void setOriginalPrice(BigDecimal originalPrice) {
        this.originalPrice = originalPrice;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
}