package com.dtyunxi.yundt.cube.center.price.dao.eo;

import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
/**
 * StdPriceEo对象
 *
 * @author liuji
 * @since 2021-06-30
 */
@Data
public class StdPriceEo extends CubeBaseEo {
    /**
     * 价格大类
     */
    @Column(name = "category_code")
    private String categoryCode;
    /**
     * 价格类型id
     */
    @Column(name = "type_id")
    private Long typeId;
    /**
     * 状态（WAIT_AUDIT：待审核、AUDIT_REJECT：审核不通过、AUDIT_PASS：审核通过(待生效 、生效中、已失效)、INVALID：作废、DRAFT：草稿）
     */
    @Column(name = "status")
    private String status;
    /**
     * 编号
     */
    @Column(name = "code")
    private String code;
    /**
     * 名称
     */
    @Column(name = "name")
    private String name;
    /**
     * 组织id
     */
    @Column(name = "organization_id")
    private Long organizationId;
    /**
     * 组织名称
     */
    @Column(name = "organization_name")
    private String organizationName;
    /**
     * 生效时间
     */
    @Column(name = "effective_time")
    private Date effectiveTime;
    /**
     * 失效时间
     */
    @Column(name = "invalid_time")
    private Date invalidTime;
    /**
     * 买方id
     */
    @Column(name = "buyer_id")
    private Long buyerId;
    /**
     * 买方名称
     */
    @Column(name = "buyer_name")
    private String buyerName;
    /**
     * 卖方id
     */
    @Column(name = "seller_id")
    private Long sellerId;
    /**
     * 卖方名称
     */
    @Column(name = "seller_name")
    private String sellerName;
    /**
     * 关联客户类型（0： 指定客户、1： 按客户类型、2：不限）
     */
    @Column(name = "relation_customer_type")
    private Integer relationCustomerType;
    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 变更版本号
     */
    @Column(name = "version")
    private Integer version;

    //tcbj新增字段：
    /**
     *  适用的店铺id:
     */
    @Column(name = "shop_id")
    private Long shopId;
    /**
     *  关联的价格模型id
     */
    @Column(name = "model_id")
    private Long modelId;
    /**
     * 关联商品类型（0： 指定客户、1： 按客户类型、2：不限）
     */
    @Column(name = "relation_item_type")
    private Integer relationItemType;
    /**
     *  折扣定价方式的折扣率：
     */
    @Column(name = "discount_rate")
    private BigDecimal discountRate;
    /**
     *  关联原策略id
     */
    @Column(name = "original_price_id")
    private Long originalPriceId;

    /**
     *  礼盒加价（汤臣倍健固定加价用该字段）：
     */
    @Column(name = "giftbox_incr_price")
    private BigDecimal giftboxIncrPrice;

    /**
     * 扣率类型：1.固定扣率，2.临时扣率
     */
    @Column(name = "discount_type")
    private Integer discountType;


    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public Long getTypeId() {
        return typeId;
    }

    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public Date getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public Date getInvalidTime() {
        return invalidTime;
    }

    public void setInvalidTime(Date invalidTime) {
        this.invalidTime = invalidTime;
    }

    public Long getBuyerId() {
        return buyerId;
    }

    public void setBuyerId(Long buyerId) {
        this.buyerId = buyerId;
    }

    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    public Integer getRelationCustomerType() {
        return relationCustomerType;
    }

    public void setRelationCustomerType(Integer relationCustomerType) {
        this.relationCustomerType = relationCustomerType;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }


    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getModelId() {
        return modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Integer getRelationItemType() {
        return relationItemType;
    }

    public void setRelationItemType(Integer relationItemType) {
        this.relationItemType = relationItemType;
    }

    public BigDecimal getDiscountRate() {
        return discountRate;
    }

    public void setDiscountRate(BigDecimal discountRate) {
        this.discountRate = discountRate;
    }

    public Long getOriginalPriceId() {
        return originalPriceId;
    }

    public void setOriginalPriceId(Long originalPriceId) {
        this.originalPriceId = originalPriceId;
    }

    public BigDecimal getGiftboxIncrPrice() {
        return giftboxIncrPrice;
    }

    public void setGiftboxIncrPrice(BigDecimal giftboxIncrPrice) {
        this.giftboxIncrPrice = giftboxIncrPrice;
    }
}