/*
 * @(#)StdPriceItemConditionEo.java 1.0 2021-11-19
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.price.dao.eo;



  
import javax.persistence.Table;
import javax.persistence.Column;
import java.util.Date;
import com.dtyunxi.cube.framework.eo.CubeBaseEo;
import java.math.BigDecimal;

/**
 * 关联商品条件(PriceItemCondition)实体类
 *
 * @author 惜笔 | 林五弟
 * @date 2021-11-19 19:31:02
 * @since v1
 */
@Table(name="pr_price_item_condition")
public class StdPriceItemConditionEo extends CubeBaseEo{

    /**
     * skuId
     */
    @Column(name = "sku_ids")
    private String skuIds;
    /**
     * 商品id
     */
    @Column(name = "item_ids")
    private String itemIds;
    /**
     * 商品类型，多个之间用,分割
     */
    @Column(name = "item_types")
    private String itemTypes;
    /**
     * 后台类目，多个之间用,分割
     */
    @Column(name = "item_back_dir_ids")
    private String itemBackDirIds;
    /**
     * 商品品牌，多个之间用,分割
     */
    @Column(name = "item_brand_ids")
    private String itemBrandIds;
    /**
     * 关联类型
     */
    @Column(name = "relate_type")
    private String relateType;
    /**
     * 关联id
     */
    @Column(name = "relate_id")
    private Long relateId;
    /**
     * 组织id
     */
    @Column(name = "organization_id")
    private Long organizationId;

    /**
     * 后台类目，多个之间用,分割
     */
    @Column(name = "item_back_dir_ids_ext")
    private String itemBackDirIdsExt;

    /**
     * get skuId
     */     
    public String getSkuIds() {
        return skuIds;
    }

    /**
     * set skuId
     */     
    public void setSkuIds(String skuIds) {
        this.skuIds = skuIds;
    }

    /**
     * get 商品id
     */     
    public String getItemIds() {
        return itemIds;
    }

    /**
     * set 商品id
     */     
    public void setItemIds(String itemIds) {
        this.itemIds = itemIds;
    }

    public String getItemTypes() {
        return itemTypes;
    }

    public void setItemTypes(String itemTypes) {
        this.itemTypes = itemTypes;
    }

    public String getItemBackDirIds() {
        return itemBackDirIds;
    }

    public void setItemBackDirIds(String itemBackDirIds) {
        this.itemBackDirIds = itemBackDirIds;
    }

    /**
     * get 商品品牌，多个之间用,分割
     */     
    public String getItemBrandIds() {
        return itemBrandIds;
    }

    /**
     * set 商品品牌，多个之间用,分割
     */     
    public void setItemBrandIds(String itemBrandIds) {
        this.itemBrandIds = itemBrandIds;
    }

    /**
     * get 关联类型
     */     
    public String getRelateType() {
        return relateType;
    }

    /**
     * set 关联类型
     */     
    public void setRelateType(String relateType) {
        this.relateType = relateType;
    }

    /**
     * get 关联id
     */     
    public Long getRelateId() {
        return relateId;
    }

    /**
     * set 关联id
     */     
    public void setRelateId(Long relateId) {
        this.relateId = relateId;
    }

    /**
     * get 组织id
     */     
    public Long getOrganizationId() {
        return organizationId;
    }

    /**
     * set 组织id
     */     
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getItemBackDirIdsExt() {
        return itemBackDirIdsExt;
    }

    public void setItemBackDirIdsExt(String itemBackDirIdsExt) {
        this.itemBackDirIdsExt = itemBackDirIdsExt;
    }
}
