/*
 * @(#)StdPriceRejectItemEo.java 1.0 2021-11-19
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.price.dao.eo;


import com.dtyunxi.cube.framework.eo.CubeBaseEo;

import javax.persistence.Column;
import javax.persistence.Table;

/**
 * 剔除商品明细(PriceRejectItem)实体类
 *
 * @author 惜笔 | 林五弟
 * @date 2021-11-19 19:30:14
 * @since v1
 */
@Table(name="pr_price_reject_item")
public class StdPriceRejectItemEo extends CubeBaseEo{

    /**
     * 商品名称
     */
    @Column(name = "item_name")
    private String itemName;
    /**
     * 所属品牌方
     */
    @Column(name = "item_org_id")
    private Long itemOrgId;
    /**
     * 商品编码
     */
    @Column(name = "item_code")
    private String itemCode;
    /**
     * 商品类型
     */
    @Column(name = "item_type")
    private String itemType;
    /**
     * 规格
     */
    @Column(name = "sku_spec")
    private String skuSpec;

    /**
     * 规格id
     */
    @Column(name = "sku_id")
    private Long skuId;

    /**
     * 组织id
     */
    @Column(name = "organization_id")
    private Long organizationId;
    /**
     * 关联类型
     */
    @Column(name = "relate_type")
    private String relateType;
    /**
     * 关联id
     */
    @Column(name = "relate_id")
    private Long relateId;
    /**
     * 库存
     */
    @Column(name = "item_stock")
    private Long stock;

    /**
     * get 商品名称
     */     
    public String getItemName() {
        return itemName;
    }

    /**
     * set 商品名称
     */     
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    /**
     * get 所属品牌方
     */     
    public Long getItemOrgId() {
        return itemOrgId;
    }

    /**
     * set 所属品牌方
     */     
    public void setItemOrgId(Long itemOrgId) {
        this.itemOrgId = itemOrgId;
    }

    /**
     * get 商品编码
     */     
    public String getItemCode() {
        return itemCode;
    }

    /**
     * set 商品编码
     */     
    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    /**
     * get 商品类型
     */     
    public String getItemType() {
        return itemType;
    }

    /**
     * set 商品类型
     */     
    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    /**
     * get 规格
     */     
    public String getSkuSpec() {
        return skuSpec;
    }

    /**
     * set 规格
     */     
    public void setSkuSpec(String skuSpec) {
        this.skuSpec = skuSpec;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    /**
     * get 组织id
     */     
    public Long getOrganizationId() {
        return organizationId;
    }

    /**
     * set 组织id
     */     
    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    /**
     * get 关联类型
     */     
    public String getRelateType() {
        return relateType;
    }

    /**
     * set 关联类型
     */     
    public void setRelateType(String relateType) {
        this.relateType = relateType;
    }

    /**
     * get 关联id
     */     
    public Long getRelateId() {
        return relateId;
    }

    /**
     * set 关联id
     */     
    public void setRelateId(Long relateId) {
        this.relateId = relateId;
    }

    public Long getStock() {
        return stock;
    }

    public void setStock(Long stock) {
        this.stock = stock;
    }
}
