/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.api.dto.entity;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class NacosPropertiesOrgEntity {
    private static final Logger logger = LoggerFactory.getLogger(NacosPropertiesOrgEntity.class);
    public static final List<String> ENV_PROPERTIES = Arrays.asList("dev", "test", "uat");
    @Value(value="${cube.global.profile:}")
    private String envProfile;
    @Value(value="${env.organization.open:false}")
    private boolean envOrganizationOpen;
    @Value(value="${env.organization.value:}")
    private String envOrganizationValue;

    public String orgId() {
        logger.info("\u8bfb\u53d6nacos\u7684\u7ec4\u7ec7\u914d\u7f6e\u9879 >>> cube.global.profile={}\uff0cenv.organization.open={}\uff0cenv.organization.value={}", new Object[]{this.envProfile, this.envOrganizationOpen, this.envOrganizationValue});
        if (!this.envOrganizationOpen) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)this.envProfile) && ENV_PROPERTIES.contains(this.envProfile)) {
            return this.envOrganizationValue;
        }
        return null;
    }

    public String getEnvProfile() {
        return this.envProfile;
    }

    public void setEnvProfile(String envProfile) {
        this.envProfile = envProfile;
    }

    public boolean isEnvOrganizationOpen() {
        return this.envOrganizationOpen;
    }

    public void setEnvOrganizationOpen(boolean envOrganizationOpen) {
        this.envOrganizationOpen = envOrganizationOpen;
    }

    public String getEnvOrganizationValue() {
        return this.envOrganizationValue;
    }

    public void setEnvOrganizationValue(String envOrganizationValue) {
        this.envOrganizationValue = envOrganizationValue;
    }
}

