/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.adapter;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerPropertyInfoReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerPropertyInfoRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerPropertyInfoService;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerInfoDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerPropertyInfoDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerPropertyInfoEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractCustomerPropertyInfoServiceImpl
implements ICustomerPropertyInfoService {
    @Resource
    private CustomerPropertyInfoDas customerPropertyInfoDas;
    @Resource
    private CustomerInfoDas customerInfoDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addCustomerPropertyInfo(List<CustomerPropertyInfoReqDto> customerPropertyInfoReqDtoList) {
        Long customerId = customerPropertyInfoReqDtoList.get(0).getCustomerId();
        CustomerPropertyInfoEo customerPropertyInfoEo = new CustomerPropertyInfoEo();
        customerPropertyInfoEo.setCustomerId(customerId);
        List select = this.customerPropertyInfoDas.select((BaseEo)customerPropertyInfoEo);
        if (!CollectionUtils.isEmpty((Collection)select)) {
            this.customerPropertyInfoDas.delete((BaseEo)customerPropertyInfoEo);
        }
        Iterator<CustomerPropertyInfoReqDto> iterator = customerPropertyInfoReqDtoList.iterator();
        ArrayList customerPropertyInfoEoList = new ArrayList();
        while (iterator.hasNext()) {
            CustomerPropertyInfoReqDto customerPropertyInfoReqDto = iterator.next();
            List customerPropertyValueReqDtoList = customerPropertyInfoReqDto.getCustomerPropertyValueReqDtoList();
            if (!CollectionUtils.isNotEmpty((Collection)customerPropertyValueReqDtoList)) continue;
            customerPropertyValueReqDtoList.stream().forEach(c -> {
                CustomerPropertyInfoEo customerPropertyInfo = new CustomerPropertyInfoEo();
                CubeBeanUtils.copyProperties((Object)customerPropertyInfo, (Object)customerPropertyInfoReqDto, (String[])new String[0]);
                customerPropertyInfo.setPropertyValueId(c.getId());
                customerPropertyInfoEoList.add(customerPropertyInfo);
            });
        }
        if (CollectionUtils.isNotEmpty(customerPropertyInfoEoList)) {
            this.customerPropertyInfoDas.insertBatch(customerPropertyInfoEoList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyCustomerPropertyInfo(CustomerPropertyInfoReqDto modifyReqDto) {
        CustomerPropertyInfoEo customerPropertyInfoEo = new CustomerPropertyInfoEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerPropertyInfoEo);
        this.customerPropertyInfoDas.updateSelective((BaseEo)customerPropertyInfoEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerPropertyInfo(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerPropertyInfoDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CustomerPropertyInfoRespDto queryById(Long id) {
        CustomerPropertyInfoEo customerPropertyInfoEo = (CustomerPropertyInfoEo)this.customerPropertyInfoDas.selectByPrimaryKey(id);
        CustomerPropertyInfoRespDto customerPropertyInfoRespDto = new CustomerPropertyInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)customerPropertyInfoEo, (BaseVo)customerPropertyInfoRespDto);
        return customerPropertyInfoRespDto;
    }

    @Override
    public List<CustomerPropertyInfoRespDto> queryByCustomerId(Long customerId) {
        CustomerPropertyInfoEo customerPropertyInfoEo = new CustomerPropertyInfoEo();
        customerPropertyInfoEo.setCustomerId(customerId);
        List customerPropertyInfoEoList = this.customerPropertyInfoDas.select((BaseEo)customerPropertyInfoEo);
        ArrayList<CustomerPropertyInfoRespDto> customerPropertyInfoRespDtoList = new ArrayList<CustomerPropertyInfoRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerPropertyInfoEoList, customerPropertyInfoRespDtoList, CustomerPropertyInfoRespDto.class);
        return customerPropertyInfoRespDtoList;
    }

    @Override
    public PageInfo<CustomerPropertyInfoRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerPropertyInfoReqDto customerPropertyInfoReqDto = (CustomerPropertyInfoReqDto)JSON.parseObject((String)filter, CustomerPropertyInfoReqDto.class);
        CustomerPropertyInfoEo customerPropertyInfoEo = new CustomerPropertyInfoEo();
        DtoHelper.dto2Eo((BaseVo)customerPropertyInfoReqDto, (BaseEo)customerPropertyInfoEo);
        PageInfo eoPageInfo = this.customerPropertyInfoDas.selectPage((BaseEo)customerPropertyInfoEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerPropertyInfoRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

