/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.customer.biz.service.adapter;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AddressTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CompanyInfoDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.CustomerAddResultDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.RCustomerSalesmanReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.AddressRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.EditCustomerSaveTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerReqExtDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.OrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.OrganizationInfoExtTemporaryDto;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IAddressService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerAreaService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerExtService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IRCustomerSalesmanService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.customer.biz.proxy.user.IUserExtV2QueryApi;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.AddressDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerLevelDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerStatusDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerTypeDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.RCustomerRegionDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.RCustomerSalesmanDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerSalesmanMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.RCustomerSalesmanMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.das.EmployeeCustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.AddressEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerStatusEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerTypeEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerSalesmanEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerLevelEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerSalesmanEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerTypeEo;
import com.dtyunxi.yundt.cube.center.customer.dao.vo.CustomerRegionNameTemporaryVo;
import com.dtyunxi.yundt.cube.center.user.api.IOrganizationExtApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvInfoReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.request.OrgAdvModifyReqDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAdvDetailRespDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.request.CustomerBatchUpReqDto;
import com.yx.tcbj.center.customer.api.dto.request.CustomerSearchExtReqTemporaryDto;
import com.yx.tcbj.center.customer.api.dto.response.ImportParseCustomerRespDto;
import com.yx.tcbj.center.customer.biz.service.ICustomerExtThreeService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractCustomerExtThreeServiceImpl
implements ICustomerExtThreeService {
    private Logger logger = LoggerFactory.getLogger(AbstractCustomerExtThreeServiceImpl.class);
    @Resource
    private ICacheService cacheService;
    @Resource
    private CustomerDas customerDas;
    @Resource
    private CustomerTypeDas customerTypeDas;
    @Resource
    private IContext context;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private CustomerStatusDas customerStatusDas;
    @Resource
    private RCustomerRegionDas rCustomerRegionDas;
    @Resource
    private IOrganizationExtApi organizationExtApi;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Value(value="${yundt.cube.customer.orgRootId}")
    private Long orgRootId;
    @Resource
    private IAddressService addressService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Autowired
    private IRCustomerSalesmanService rCustomerSalesmanService;
    @Resource
    private ICustomerAreaService customerAreaService;
    @Resource
    private RCustomerSalesmanDas rCustomerSalesmanDas;
    @Resource
    private RCustomerSalesmanMapper rCustomerSalesmanMapper;
    @Resource
    private CustomerSalesmanMapper customerSalesmanMapper;
    @Resource
    private CustomerLevelDas customerLevelDas;
    @Resource
    private EmployeeCustomerDas employeeCustomerDas;
    @Resource
    private IUserExtV2QueryApi userExtV2QueryApi;
    @Resource
    private AddressDas addressDas;
    @Resource
    private ICustomerExtService customerExtService;

    @Override
    public void update(CustomerReqExtDto reqDto) {
        Assert.notNull((Object)reqDto.getId(), (String)CustomerExceptionCode.PK_ID_NULL.getMsg(), (Object[])new Object[0]);
        CustomerEo queryEo = (CustomerEo)this.customerDas.selectByPrimaryKey(reqDto.getId());
        Assert.notNull((Object)queryEo, (String)CustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg(), (Object[])new Object[0]);
        this.validCustomerCode((CustomerReqDto)reqDto, reqDto.getTenantId());
        if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
            Assert.notNull((Object)reqDto.getMerchantId(), (String)"\u6240\u5c5e\u5546\u5bb6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        if (EditCustomerSaveTypeEnum.COMPANY.getCode().equals(reqDto.getSaveType())) {
            this.updateCompany(reqDto);
            CustomerEo updateCusEo = new CustomerEo();
            updateCusEo.setId(reqDto.getId());
            updateCusEo.setIfCertification(Integer.valueOf(1));
            this.customerDas.updateSelective((BaseEo)updateCusEo);
        } else if (EditCustomerSaveTypeEnum.CUSTOMER.getCode().equals(reqDto.getSaveType())) {
            this.updateCustomer(reqDto, queryEo);
        } else {
            this.updateCompany(reqDto);
            this.updateCustomer(reqDto, queryEo);
        }
    }

    private void updateCompany(CustomerReqExtDto reqDto) {
        CompanyInfoDto companyInfoDto = reqDto.getCompanyInfoDto();
        Assert.notNull((Object)companyInfoDto.getSubjectType(), (String)"\u4e3b\u4f53\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getBusinessLicenseType(), (String)"\u6267\u7167\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getProvinceCode(), (String)"\u6240\u5c5e\u5730\u533a\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getCreditCode(), (String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        RestResponse orgAdvDetailRestResp = this.organizationQueryExtApi.queryById(companyInfoDto.getOrgInfoId());
        OrgAdvDetailRespDto orgAdvDetailRespDto = (OrgAdvDetailRespDto)RestResponseHelper.extractData((RestResponse)orgAdvDetailRestResp);
        this.logger.info("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u4e3a:{}", (Object)JSONObject.toJSONString((Object)orgAdvDetailRespDto));
        companyInfoDto.setOrgCode(orgAdvDetailRespDto.getCode());
        Assert.notNull((Object)companyInfoDto.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)companyInfoDto.getLegalName(), (String)"\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getMerchantId(), (String)"\u6240\u5c5e\u5546\u5bb6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List customerEoList = this.customerDas.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_info_id", (Object)companyInfoDto.getOrgInfoId())).eq((Object)"merchant_id", (Object)reqDto.getMerchantId())).ne((Object)"id", (Object)reqDto.getId()));
        if (!CollectionUtils.isEmpty((Collection)customerEoList)) {
            if (CustomerTypeEnum.DEALER.getCode().equals(reqDto.getType())) {
                throw new CustomerBusinessRuntimeException(CustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getCode(), String.format(CustomerExceptionCode.DEALER_CUSTOMER_EXISTS.getMsg(), ((CustomerEo)customerEoList.get(0)).getCode()));
            }
            if (CustomerTypeEnum.RETAILER.getCode().equals(reqDto.getType())) {
                throw new CustomerBusinessRuntimeException(CustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getCode(), String.format(CustomerExceptionCode.RETAILER_CUSTOMER_EXISTS.getMsg(), ((CustomerEo)customerEoList.get(0)).getCode()));
            }
        }
        this.updateOrgInfo(companyInfoDto);
        this.addressService.removeAddressByOrgInfoIdAndType(companyInfoDto.getOrgInfoId(), AddressTypeEnum.COMPANY.getCode());
        if (StringUtils.isNotEmpty((CharSequence)companyInfoDto.getProvinceCode())) {
            AddressAddReqDto addressReqDto = new AddressAddReqDto();
            CubeBeanUtils.copyProperties((Object)addressReqDto, (Object)companyInfoDto, (String[])new String[0]);
            addressReqDto.setOrgInfoId(companyInfoDto.getOrgInfoId());
            addressReqDto.setAddressType(AddressTypeEnum.COMPANY.getCode());
            this.addressService.addAddress(addressReqDto);
        }
        reqDto.setOrgInfoId(companyInfoDto.getOrgInfoId());
    }

    private void updateCustomer(CustomerReqExtDto reqDto, CustomerEo queryEo) {
        Assert.notNull((Object)reqDto.getName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getType(), (String)"\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AssertUtil.isFalse((boolean)CollectionUtils.isEmpty((Collection)reqDto.getRegionCodeList()), (String)"\u5ba2\u6237\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)reqDto.getCountyCode(), (String)"\u6240\u5c5e\u5730\u533a\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getStatusId(), (String)"\u5ba2\u6237\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CustomerEo customerEo = CustomerEo.newInstance();
        reqDto.setOrgInfoId((Long)null);
        this.initCustomerEo((CustomerReqDto)reqDto, customerEo);
        this.customerDas.updateSelective((BaseEo)customerEo);
        RCustomerRegionEo deleteEo = new RCustomerRegionEo();
        deleteEo.setCustomerId(reqDto.getId());
        this.rCustomerRegionDas.delete((BaseEo)deleteEo);
        if (!CollectionUtils.isEmpty((Collection)reqDto.getRegionCodeList())) {
            ArrayList<RCustomerRegionEo> customerRegionEos = new ArrayList<RCustomerRegionEo>(reqDto.getRegionCodeList().size());
            for (String regionCode : reqDto.getRegionCodeList()) {
                RCustomerRegionEo customerRegionEo = new RCustomerRegionEo();
                customerRegionEo.setCustomerId(reqDto.getId());
                customerRegionEo.setRegionCode(regionCode);
                customerRegionEos.add(customerRegionEo);
            }
            this.rCustomerRegionDas.insertBatch(customerRegionEos);
        }
        RCustomerSalesmanReqDto salesmanReqDto = new RCustomerSalesmanReqDto();
        salesmanReqDto.setCustomerId(reqDto.getId());
        salesmanReqDto.setSalesmanIds(reqDto.getSalesmanIds());
        salesmanReqDto.setOrgId(this.queryOrgIdByUserId(this.context.userId()));
        if (!CollectionUtils.isEmpty((Collection)reqDto.getSalesmanIds())) {
            this.rCustomerSalesmanService.update(salesmanReqDto);
        }
        CubeBeanUtils.copyProperties((Object)queryEo, (Object)customerEo, (String[])new String[0]);
        String regionCodes = StringUtils.join((Iterable)reqDto.getRegionCodeList(), (String)",");
        String regionNames = StringUtils.join((Iterable)reqDto.getRegionNameList(), (String)",");
        this.sendMq(queryEo, regionNames, regionCodes);
    }

    public void sendMq(CustomerEo customerEo, String regionNames, String regionCodes) {
        CustomerRespDto customerRespDto = new CustomerRespDto();
        this.logger.info("\u53d1\u9001mq\u5f53\u524d\u7c7b=CustomerServiceImpl.sendMq()customerEo = [" + customerEo + "], regionNames = [" + regionNames + "], regionNames = [" + regionCodes + "]");
        try {
            if (customerEo.getCustomerTypeId() != null) {
                CustomerTypeEo customerTypeEo = (CustomerTypeEo)this.customerTypeDas.selectByPrimaryKey(customerEo.getCustomerTypeId());
                customerRespDto.setCustomerTypeName(customerTypeEo.getName());
            }
            if (customerEo.getStatusId() != null) {
                CustomerStatusEo customerStatusEo = (CustomerStatusEo)this.customerStatusDas.selectByPrimaryKey(customerEo.getStatusId());
                customerRespDto.setStatusName(customerStatusEo.getName());
            }
            customerRespDto.setStatusId(customerEo.getStatusId());
            customerRespDto.setId(customerEo.getId());
            customerRespDto.setCode(customerEo.getCode());
            customerRespDto.setName(customerEo.getName());
            customerRespDto.setRegionId(customerEo.getRegionId());
            customerRespDto.setRegionCode(regionCodes);
            customerRespDto.setRegion(regionNames);
            customerRespDto.setCustomerTypeId(customerEo.getCustomerTypeId());
            customerRespDto.setCustomerId(customerEo.getId());
            customerRespDto.setId(customerEo.getId());
            this.commonsMqService.sendSingleMessage("CUSTOMER_UPDATE", (Object)customerRespDto);
            this.logger.info("\u53d1\u9001\u5ba2\u6237\u66f4\u65b0\u5e7f\u64ad\u6d88\u606f: {}", (Object)JSON.toJSONString((Object)customerRespDto));
            this.commonsMqService.publishMessageAsync("CUSTOMER_UPDATE_PUBLISH", (Object)JSON.toJSONString((Object)customerRespDto));
        }
        catch (Exception var6) {
            this.logger.debug(var6.getMessage());
        }
    }

    public Long queryOrgIdByUserId(Long userId) {
        String cahceKey;
        Long cacheValue;
        AssertUtil.isTrue((userId != null ? 1 : 0) != 0, (String)"queryOrgIdByUserId\uff0c\u627e\u4e0d\u5230userId:");
        if (userId.equals(this.context.userId())) {
            ServiceContext serviceContext = ServiceContext.getContext();
            String customer = serviceContext.getAttachment("yes.req.cus.b2b.customerid");
            if (StringUtils.isNotEmpty((CharSequence)customer)) {
                Long customerId = Long.valueOf(customer);
                return Optional.ofNullable(this.customerDas.selectByPrimaryKey(customerId)).map(StdCustomerEo::getOrgInfoId).orElse(null);
            }
            String object = serviceContext.getAttachment("yes.req.cus.b2b.organizationid");
            if (StringUtils.isNotEmpty((CharSequence)object)) {
                return Long.valueOf(object);
            }
        }
        if (null != (cacheValue = (Long)this.cacheService.getCache(cahceKey = "queryOrgIdByUserId_" + userId, Long.class))) {
            return cacheValue;
        }
        RestResponse pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(userId, Integer.valueOf(1), Integer.valueOf(1));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        AssertUtil.isTrue((!CollectionUtils.isEmpty((Collection)pageInfo.getList()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u672a\u7ed1\u5b9a\u7ec4\u7ec7");
        this.logger.info("\u67e5\u8be2\u5230\u5173\u8054\u7684\u7ec4\u7ec7\u5173\u7cfb{}", (Object)JSON.toJSONString((Object)pageInfo.getList()));
        Long orgId = pageInfo.getList().stream().filter(o -> this.orgRootId.equals(o.getParentId())).findFirst().orElse(new OrganizationDto()).getId();
        if (orgId != null) {
            this.cacheService.setCache(cahceKey, (Object)orgId, 86400);
        }
        return orgId;
    }

    private void initCustomerEo(CustomerReqDto reqDto, CustomerEo customerEo) {
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerEo);
        if (Objects.nonNull(reqDto.getCompanyInfoDto()) && StringUtils.isNotEmpty((CharSequence)reqDto.getCompanyInfoDto().getCreditCode())) {
            customerEo.setIfCertification(Integer.valueOf(1));
        }
    }

    private void validCustomerCode(CustomerReqDto reqDto, Long tenantId) {
        if (Objects.nonNull(reqDto)) {
            Assert.notNull((Object)reqDto.getCode(), (String)CustomerExceptionCode.CUSTOMER_CODE_NULL.getMsg(), (Object[])new Object[0]);
            CustomerEo customerEo = CustomerEo.newInstance();
            customerEo.setTenantId(tenantId);
            customerEo.setCode(reqDto.getCode());
            customerEo = (CustomerEo)this.customerDas.selectOne((BaseEo)customerEo);
            if (customerEo != null) {
                if (reqDto.getId() == null) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
                if (reqDto.getId() != null && !customerEo.getId().equals(reqDto.getId())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
            }
        }
    }

    private void updateOrgInfo(CompanyInfoDto companyInfoDto) {
        OrgAdvModifyReqDto orgAdvModifyReqDto = new OrgAdvModifyReqDto();
        orgAdvModifyReqDto.setName(companyInfoDto.getOrgName());
        orgAdvModifyReqDto.setCode(companyInfoDto.getOrgCode());
        orgAdvModifyReqDto.setId(companyInfoDto.getOrgInfoId());
        orgAdvModifyReqDto.setEntityPropCode("company");
        orgAdvModifyReqDto.setTenantId(companyInfoDto.getTenantId());
        OrgAdvInfoReqDto orgAdvInfoReqDto = new OrgAdvInfoReqDto();
        CubeBeanUtils.copyProperties((Object)orgAdvInfoReqDto, (Object)companyInfoDto, (String[])new String[0]);
        orgAdvModifyReqDto.setOrgAdvInfoReqDto(orgAdvInfoReqDto);
        RestResponse modify = this.organizationExtApi.modify(orgAdvModifyReqDto);
        if (!"0".equals(modify.getResultCode())) {
            if (modify.getResultMsg().equals(CustomerExceptionCode.ORG_NAME_EXISTS.getMsg())) {
                throw new CustomerBusinessRuntimeException(CustomerExceptionCode.COMPANY_NAME_EXISTS.getCode(), CustomerExceptionCode.COMPANY_NAME_EXISTS.getMsg());
            }
            throw new BizException(modify.getResultCode(), modify.getResultMsg());
        }
    }

    @Override
    public PageInfo<CustomerRespDto> queryByPageExport(CustomerSearchExtReqTemporaryDto searchReqDto) {
        String queryStr = JSON.toJSONString((Object)searchReqDto);
        this.logger.info("\u5ba2\u6237\u4fe1\u606f\u5206\u9875\u67e5\u8be2\u7b5b\u9009\u5bf9\u8c61searchReqDto\uff0c{}", (Object)queryStr);
        PageInfo pageInfo = this.customerExtService.queryByPage(queryStr, searchReqDto.getPageNum(), searchReqDto.getPageSize());
        List respDtos = pageInfo.getList();
        List idList = respDtos.stream().map(BaseRespDto::getId).collect(Collectors.toList());
        QueryWrapper rCustomerSaleQuery = new QueryWrapper();
        rCustomerSaleQuery.in((Object)"customer_Id", idList);
        rCustomerSaleQuery.eq((Object)"org_id", (Object)searchReqDto.getUserOrgId());
        List rCustomerSalesmanEos = this.rCustomerSalesmanMapper.selectList((Wrapper)rCustomerSaleQuery);
        Map<Object, Object> salesmanNameMap = new HashMap();
        Map<Object, Object> salesmanIdsMap = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)rCustomerSalesmanEos)) {
            List salesmanIds = rCustomerSalesmanEos.stream().map(RCustomerSalesmanEo::getSalesmanId).distinct().collect(Collectors.toList());
            salesmanIdsMap = rCustomerSalesmanEos.stream().collect(Collectors.groupingBy(RCustomerSalesmanEo::getCustomerId, Collectors.mapping(e -> e.getSalesmanId().toString(), Collectors.joining(","))));
            QueryWrapper customerQuery = new QueryWrapper();
            customerQuery.in((Object)"user_id", salesmanIds);
            customerQuery.eq((Object)"org_info_id", (Object)searchReqDto.getUserOrgId());
            List customerSalesmanEos = this.customerSalesmanMapper.selectList((Wrapper)customerQuery);
            salesmanNameMap = customerSalesmanEos.stream().collect(Collectors.toMap(StdCustomerSalesmanEo::getUserId, StdCustomerSalesmanEo::getName, (e1, e2) -> e1));
        }
        Map<Object, Object> cRegionNameMap = new HashMap();
        List customerRegionName = this.employeeCustomerDas.getCustomerRegionName(idList);
        if (CollectionUtils.isNotEmpty((Collection)customerRegionName)) {
            cRegionNameMap = customerRegionName.stream().collect(Collectors.groupingBy(CustomerRegionNameTemporaryVo::getCustomerId));
        }
        List<Long> orgInfoIdList = respDtos.stream().map(CustomerRespDto::getOrgInfoId).distinct().collect(Collectors.toList());
        List orgInfoList = (List)RestResponseHelper.extractData(this.userExtV2QueryApi.queryOrgInfoByOrgId(orgInfoIdList));
        Map<Object, Object> orgInfoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)orgInfoList)) {
            orgInfoMap = orgInfoList.stream().collect(Collectors.toMap(OrganizationInfoExtTemporaryDto::getOrgId, Function.identity(), (k1, k2) -> k1));
        }
        CompletableFuture<Map> typeMapFuture = CompletableFuture.supplyAsync(() -> this.customerTypeDas.getMapper().selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{BaseEo::getId, StdCustomerTypeEo::getName}).in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(CustomerRespDto::getCustomerTypeId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, StdCustomerTypeEo::getName)));
        CompletableFuture<Map> statusMapFuture = CompletableFuture.supplyAsync(() -> this.customerStatusDas.getMapper().selectList((Wrapper)new LambdaQueryWrapper().in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(CustomerRespDto::getStatusId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity())));
        CompletableFuture<Map> levelMapFuture = CompletableFuture.supplyAsync(() -> this.customerLevelDas.getMapper().selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{BaseEo::getId, StdCustomerLevelEo::getName}).in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(CustomerRespDto::getLevelId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, StdCustomerLevelEo::getName)));
        CompletableFuture.allOf(levelMapFuture, statusMapFuture, typeMapFuture);
        Map levelMap = new HashMap(0);
        Map statusMap = new HashMap(0);
        Map typeMap = new HashMap(0);
        try {
            levelMap = levelMapFuture.get();
            statusMap = statusMapFuture.get();
            typeMap = typeMapFuture.get();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        List merchantList = respDtos.stream().map(e -> e.getMerchantId()).distinct().collect(Collectors.toList());
        this.logger.info("\u67e5\u8be2\u8bf7\u6c42\u6240\u5c5e\u5546\u5bb6\u7684id\u94fe\u8868\u4e3a:{}", merchantList);
        RestResponse orgResp = this.organizationQueryApi.queryOrgAndOrgInfoByIds(merchantList);
        List orgInfoRespDtos = (List)RestResponseHelper.extractData((RestResponse)orgResp);
        this.logger.info("\u67e5\u8be2\u8bf7\u6c42\u6240\u5c5e\u5546\u5bb6\u7684\u4fe1\u606f\u4e3a:{}", (Object)orgInfoRespDtos);
        Map<Object, Object> merchantNameMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)orgInfoRespDtos)) {
            merchantNameMap = orgInfoRespDtos.stream().collect(Collectors.toMap(e -> e.getOrganizationDto().getId(), e -> e, (e1, e2) -> e1));
        }
        for (CustomerRespDto customerRespDto : respDtos) {
            OrgAndOrgInfoRespDto mechatDto;
            CustomerEo customerEo;
            CustomerStatusEo statusEo = statusMap.getOrDefault(customerRespDto.getStatusId(), new CustomerStatusEo());
            customerRespDto.setAccountStatus(statusEo.getAccountStatus());
            customerRespDto.setRecordStatus(statusEo.getRecordStatus());
            customerRespDto.setStatusName(statusEo.getName());
            customerRespDto.setCustomerTypeName(typeMap.getOrDefault(customerRespDto.getCustomerTypeId(), ""));
            customerRespDto.setLevelName(levelMap.getOrDefault(customerRespDto.getLevelId(), ""));
            if (!salesmanIdsMap.isEmpty() && salesmanIdsMap.containsKey(customerRespDto.getId())) {
                String salesmanIds = (String)salesmanIdsMap.get(customerRespDto.getId());
                String[] salesmanIdsArr = salesmanIds.split(",");
                List<String> salesmanIdList = Arrays.asList(salesmanIdsArr);
                ArrayList regionNameList = Lists.newArrayList();
                for (String salesmanId : salesmanIdList) {
                    Long id = Long.valueOf(salesmanId);
                    if (salesmanNameMap.isEmpty() || !salesmanNameMap.containsKey(id)) continue;
                    regionNameList.add(salesmanNameMap.get(id));
                }
                customerRespDto.setSalesmanNames(String.join((CharSequence)",", regionNameList));
            }
            if (!cRegionNameMap.isEmpty() && cRegionNameMap.containsKey(customerRespDto.getId())) {
                List customerRegionNameVos = (List)cRegionNameMap.get(customerRespDto.getId());
                List regionNameList = customerRegionNameVos.stream().map(CustomerRegionNameTemporaryVo::getRegionName).collect(Collectors.toList());
                List regionCodeList = customerRegionNameVos.stream().map(CustomerRegionNameTemporaryVo::getRegionCode).collect(Collectors.toList());
                customerRespDto.setRegionNames(StringUtils.join(regionNameList, (String)","));
                customerRespDto.setRegionCodeList(regionCodeList);
                customerRespDto.setRegionCodes(StringUtils.join(regionCodeList, (String)","));
            }
            if (customerRespDto.getParentCustomerId() != null && Objects.nonNull(customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(customerRespDto.getParentCustomerId()))) {
                customerRespDto.setParentCustomerName(customerEo.getName());
                customerRespDto.setRemark(customerEo.getCode());
            }
            if (!orgInfoMap.isEmpty() && orgInfoMap.containsKey(customerRespDto.getOrgInfoId())) {
                List<AddressRespDto> addressList = this.queryAddressList(customerRespDto.getOrgInfoId(), Lists.newArrayList((Object[])new String[]{AddressTypeEnum.COMPANY.getCode()}));
                CompanyInfoDto companyInfoDto = new CompanyInfoDto();
                if (!CollectionUtils.isEmpty(addressList)) {
                    BeanUtils.copyProperties((Object)addressList.get(0), (Object)companyInfoDto);
                }
                OrganizationInfoExtTemporaryDto orgInfoDto = (OrganizationInfoExtTemporaryDto)orgInfoMap.get(customerRespDto.getOrgInfoId());
                CubeBeanUtils.copyProperties((Object)companyInfoDto, (Object)orgInfoDto, (String[])new String[0]);
                companyInfoDto.setOrgInfoId(orgInfoDto.getId());
                customerRespDto.setCompanyInfoDto(companyInfoDto);
                customerRespDto.setOrgName(orgInfoDto.getOrgName());
                customerRespDto.setCreditCode(orgInfoDto.getCreditCode());
            }
            if (!ObjectUtils.isNotEmpty((Object)(mechatDto = (OrgAndOrgInfoRespDto)merchantNameMap.get(customerRespDto.getMerchantId()))) || !ObjectUtils.isNotEmpty((Object)mechatDto.getOrganizationDto())) continue;
            customerRespDto.setMerchantName(mechatDto.getOrganizationDto().getName());
        }
        return pageInfo;
    }

    public List<AddressRespDto> queryAddressList(Long orgInfoId, List<String> addressTypes) {
        AddressEo addressEo = new AddressEo();
        addressEo.setOrgInfoId(orgInfoId);
        if (CollectionUtils.isNotEmpty(addressTypes)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"address_type", addressTypes));
            addressEo.setSqlFilters(sqlFilters);
        }
        List addressEoList = this.addressDas.select((BaseEo)addressEo);
        ArrayList<AddressRespDto> addressDtoList = new ArrayList<AddressRespDto>();
        DtoHelper.eoList2DtoList((Collection)addressEoList, addressDtoList, AddressRespDto.class);
        return addressDtoList;
    }

    @Override
    public void updateCustomerStatus(Long id, Long statusId) {
    }

    @Override
    public CustomerAddResultDto add(CustomerReqExtDto reqDto) {
        return null;
    }

    @Override
    public ImportParseCustomerRespDto parseExcelCustomer(MultipartFile file, String customerCodes) {
        return null;
    }

    @Override
    public PageInfo<CustomerRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return null;
    }

    @Override
    public List<String> batchUpCusIfWholePurchase(CustomerBatchUpReqDto reqDto) {
        return null;
    }

    @Override
    public PageInfo<OrgInfoRespDto> queryOrgInfoPageByUserId(Long userId, String orgName, Integer pageNum, Integer pageSize) {
        return null;
    }
}

