/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.customer.biz.service.tcbj;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.StatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerSalesmanRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerExtService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerStatusDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerExtDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerStatusEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.response.CustomerIdsRespDto;
import com.yx.tcbj.center.customer.biz.service.ICustomerSalesmanExtService;
import com.yx.tcbj.center.customer.biz.service.adapter.AbstractCustomerQueryServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="tcbj_ICustomerQueryService")
public class TcbjCustomerQueryServiceImpl
extends AbstractCustomerQueryServiceImpl {
    @Resource
    private IContext context;
    @Resource
    private CustomerExtDas customerExtDas;
    @Resource
    private CustomerDas customerDas;
    @Resource
    private CustomerStatusDas customerStatusDas;
    @Resource
    private ICustomerExtService customerExtService;
    @Resource(name="${yunxi.dg.base.project}_ICustomerSalesmanExtService")
    private ICustomerSalesmanExtService customerSalesmanExtService;

    @Override
    public CustomerRespDto queryCustomerByCode(String code) {
        CustomerEo customerEo = new CustomerEo();
        customerEo.setCode(code);
        customerEo = (CustomerEo)this.customerDas.selectOne((BaseEo)customerEo);
        CustomerRespDto customerRespDto = new CustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)customerEo, (BaseVo)customerRespDto);
        if (customerRespDto.getSalesmanId() != null) {
            this.setCustomerSalesman(customerRespDto);
        }
        return customerRespDto;
    }

    @Override
    public CustomerIdsRespDto queryCustomerIdsBySalesmanName(String salesmanName) {
        CustomerIdsRespDto dto = new CustomerIdsRespDto();
        dto.setCustomerIds(this.customerExtDas.queryCustomerIdsBySalesmanName(salesmanName));
        return dto;
    }

    @Override
    public List<CustomerRespDto> queryUpstreamOrgIdsByUserId(Long userId) {
        ServiceContext serviceContext;
        String object;
        if (userId == null) {
            userId = this.context.userId();
        }
        if (userId == null) {
            return Lists.newArrayList();
        }
        if (userId.equals(this.context.userId()) && StringUtils.isNotEmpty((CharSequence)(object = (String)(serviceContext = ServiceContext.getContext()).get("yes.req.cus.b2b.sellerorgid")))) {
            Long customerId;
            CustomerEo customerEo;
            CustomerStatusEo customerStatusEo;
            String customer = (String)serviceContext.get("yes.req.cus.b2b.customerid");
            if (StringUtils.isNotEmpty((CharSequence)customer) && (customerStatusEo = (CustomerStatusEo)this.customerStatusDas.selectByPrimaryKey((customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(customerId = Long.valueOf(customer))).getStatusId())) != null && StatusEnum.ENABLED.getCode().equals(customerStatusEo.getRecordStatus()) && StatusEnum.ENABLED.getCode().equals(customerStatusEo.getAccountStatus())) {
                CustomerRespDto customerRespDto = new CustomerRespDto();
                BeanUtils.copyProperties((Object)customerEo, (Object)customerRespDto);
                customerRespDto.setCustomerId(customerEo.getId());
                return Collections.singletonList(customerRespDto);
            }
            return Lists.newArrayList();
        }
        Long currentUserOrgId = this.customerExtService.queryOrgIdByUserId(userId);
        AssertUtil.isTrue((currentUserOrgId != null ? 1 : 0) != 0, (String)(" \u627e\u4e0d\u5230userId\u5bf9\u5e94\u7684\u673a\u6784id,userId:" + userId));
        List customerEoList = ((ExtQueryChainWrapper)this.customerDas.filter().eq((Object)"org_info_id", (Object)currentUserOrgId)).list();
        if (CollectionUtils.isEmpty((Collection)customerEoList)) {
            return Lists.newArrayList();
        }
        ArrayList customerRespDtoList = Lists.newArrayList();
        Map statusMap = ((ExtQueryChainWrapper)this.customerStatusDas.filter().in((Object)"id", (Collection)customerEoList.stream().map(StdCustomerEo::getStatusId).collect(Collectors.toSet()))).list().stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (CustomerEo customerEo : customerEoList) {
            CustomerStatusEo customerStatusEo = (CustomerStatusEo)statusMap.get(customerEo.getStatusId());
            if (customerStatusEo == null || !StatusEnum.ENABLED.getCode().equals(customerStatusEo.getRecordStatus()) || !StatusEnum.ENABLED.getCode().equals(customerStatusEo.getAccountStatus())) continue;
            CustomerRespDto customerRespDto = new CustomerRespDto();
            BeanUtils.copyProperties((Object)customerEo, (Object)customerRespDto);
            customerRespDto.setCustomerId(customerEo.getId());
            customerRespDtoList.add(customerRespDto);
        }
        return customerRespDtoList;
    }

    @Override
    public List<CustomerRespDto> queryCustomerListByIds(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Lists.newArrayList();
        }
        CustomerEo customerEo = new CustomerEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"id", idList));
        customerEo.setSqlFilters(sqlFilters);
        List customerEoList = this.customerDas.select((BaseEo)customerEo);
        if (CollectionUtils.isEmpty((Collection)customerEoList)) {
            return Lists.newArrayList();
        }
        ArrayList<CustomerRespDto> customerRespDtoList = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEoList, customerRespDtoList, CustomerRespDto.class);
        return customerRespDtoList;
    }

    @Override
    public List<CustomerRespDto> queryCustomerListByCodes(List<String> codeList) {
        return this.queryCustomerListByCodesAndOrg(codeList, null);
    }

    @Override
    public List<CustomerRespDto> queryCustomerListByCodesAndOrg(List<String> codeList, String merchantId) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Lists.newArrayList();
        }
        CustomerEo customerEo = new CustomerEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"code", codeList));
        if (StringUtils.isNotBlank((CharSequence)merchantId)) {
            sqlFilters.add(SqlFilter.eq((String)"merchant_id", (Object)merchantId));
        }
        customerEo.setSqlFilters(sqlFilters);
        List customerEoList = this.customerDas.select((BaseEo)customerEo);
        if (CollectionUtils.isEmpty((Collection)customerEoList)) {
            return Lists.newArrayList();
        }
        ArrayList<CustomerRespDto> customerRespDtoList = new ArrayList<CustomerRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerEoList, customerRespDtoList, CustomerRespDto.class);
        return customerRespDtoList;
    }

    private void setCustomerSalesman(CustomerRespDto customerRespDto) {
        CustomerSalesmanRespDto customerSalesmanRespDto = this.customerSalesmanExtService.queryById(customerRespDto.getSalesmanId());
        if (ObjectUtils.isNotEmpty((Object)customerSalesmanRespDto)) {
            customerRespDto.setSalesmanName(customerSalesmanRespDto.getSellerName());
        }
    }
}

