/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.tcbj;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.GovernStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.GovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernContentRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernContentService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.adapter.AbstractStoreSellerRelateServiceImpl;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreSellerRelateDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreSellerRelateEo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.biz.service.IStoreService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tcbj_IStoreSellerRelateService")
public class TcbjStoreSellerRelateServiceImpl
extends AbstractStoreSellerRelateServiceImpl {
    private static Logger logger = LoggerFactory.getLogger(TcbjStoreSellerRelateServiceImpl.class);
    @Resource(name="${yunxi.dg.base.project}_IStoreSellerGovernService")
    private IStoreSellerGovernService storeSellerGovernService;
    @Resource(name="${yunxi.dg.base.project}_IStoreService")
    private IStoreService storeService;
    @Resource
    private StoreSellerRelateDas storeSellerRelateDas;
    @Resource(name="${yunxi.dg.base.project}_IStoreSellerGovernContentService")
    private IStoreSellerGovernContentService storeSellerGovernContentService;
    @Resource
    private StoreDas storeDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void buildStoreSellerRelate(Long sellerId, Long orgId) {
        logger.info("\u6784\u5efa\u5546\u5bb6\u7ba1\u8f96\u836f\u5e97\u7684\u5173\u7cfb\u6570\u636e\uff1a{}=={}", (Object)sellerId, (Object)orgId);
        if (ObjectUtils.isEmpty((Object)sellerId) || ObjectUtils.isEmpty((Object)orgId)) {
            return;
        }
        this.buildStoreSellerRelateProcess(sellerId, orgId);
        this.storeSellerGovernService.changeStoreSellerGovernStatus(sellerId, orgId, GovernStatusEnum.OVER);
    }

    @Override
    public void updateRelateByStoreChange(List<String> storeIds) {
        logger.info("\u836f\u5e97\u533a\u57df\u51fa\u73b0\u53d8\u66f4\uff0c\u66f4\u65b0\u7ba1\u8f96\u5173\u8054\u6570\u636e");
        List<StoreRespDto> list = this.storeService.queryListByIds(storeIds);
        list.forEach(store -> {
            logger.info("\u5904\u7406\u836f\u5e97\uff1a{}", (Object)JSON.toJSONString((Object)store));
            this.deleteRelateByStore(store.getStoreId());
            StoreReqDto reqDto = new StoreReqDto();
            CubeBeanUtils.copyProperties((Object)reqDto, (Object)store, (String[])new String[0]);
            List<StoreSellerGovernRespDto> storeSellerGovernList = this.storeSellerGovernService.queryByStore(reqDto);
            if (CollectionUtil.isEmpty(storeSellerGovernList)) {
                return;
            }
            ArrayList insertList = new ArrayList();
            storeSellerGovernList.forEach(dto -> {
                StoreSellerRelateEo eo = new StoreSellerRelateEo();
                eo.setOrganizationId(dto.getOrganizationId());
                eo.setSellerId(dto.getSellerId());
                eo.setGovernSource(GovernTypeEnum.AREA.getCode());
                eo.setStoreId(store.getStoreId());
                insertList.add(eo);
            });
            this.storeSellerRelateDas.insertBatch(insertList);
        });
    }

    @Override
    public void buildStoreSellerRelateProcess(Long sellerId, Long orgId) {
        logger.info("\u6267\u884c\u6784\u5efa\u5546\u5bb6\u7ba1\u8f96\u836f\u5e97\u7684\u5173\u7cfb\u6570\u636e\u8fc7\u7a0b\uff1a{}=={}", (Object)sellerId, (Object)orgId);
        this.deleteRelate(sellerId, null);
        List<StoreSellerGovernContentRespDto> governContentList = this.storeSellerGovernContentService.queryGovernContentByOrgId(orgId);
        if (CollectionUtil.isEmpty(governContentList)) {
            return;
        }
        ArrayList<String> areas = new ArrayList<String>();
        ArrayList storeIds = new ArrayList();
        ArrayList<String> blacklistIds = new ArrayList<String>();
        ArrayList storeParentIds = new ArrayList();
        governContentList.forEach(dto -> {
            if (dto.getGovernType().equals(GovernTypeEnum.AREA.getCode())) {
                areas.add(dto.getGovernContent());
                return;
            }
            if (dto.getGovernType().equals(GovernTypeEnum.STORE.getCode())) {
                storeIds.add(dto.getGovernContent());
                return;
            }
            if (dto.getGovernType().equals(GovernTypeEnum.BLACKLIST.getCode())) {
                blacklistIds.add(dto.getGovernContent());
                return;
            }
            if (dto.getGovernType().equals(GovernTypeEnum.STOREPARENT.getCode())) {
                storeParentIds.add(dto.getGovernContent());
                return;
            }
        });
        ArrayList insertList = new ArrayList();
        if (CollectionUtil.isNotEmpty(areas)) {
            List<String> stores = this.storeService.queryByArea(areas);
            stores.forEach(storeId -> {
                StoreSellerRelateEo eo = new StoreSellerRelateEo();
                eo.setOrganizationId(orgId);
                eo.setSellerId(sellerId);
                eo.setGovernSource(GovernTypeEnum.AREA.getCode());
                eo.setStoreId(storeId);
                insertList.add(eo);
            });
        }
        if (CollectionUtil.isNotEmpty(storeIds)) {
            storeIds.forEach(storeId -> {
                StoreSellerRelateEo eo = new StoreSellerRelateEo();
                eo.setOrganizationId(orgId);
                eo.setSellerId(sellerId);
                eo.setGovernSource(GovernTypeEnum.STORE.getCode());
                eo.setStoreId(storeId);
                insertList.add(eo);
            });
        }
        if (CollectionUtil.isNotEmpty(storeParentIds)) {
            StoreEo storeEo = new StoreEo();
            storeEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"store_id", storeParentIds)}));
            List storeEos = this.storeDas.select((BaseEo)storeEo);
            Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)storeEos), (String)"0001", (String)"\u5f53\u524d\u4e0a\u4f20\u7236\u7ea7\u836f\u5e97\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            StoreEo store = new StoreEo();
            List creditNum = storeEos.stream().map(c -> c.getSocialCreditNum()).collect(Collectors.toList());
            store.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"parent_social_credit_num", creditNum)}));
            List storeChildren = this.storeDas.select((BaseEo)store);
            Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)storeChildren), (String)"0001", (String)"\u5f53\u524d\u4e0a\u4f20\u7236\u7ea7\u836f\u5e97\u4e0d\u5b58\u5728\u4e0b\u7ea7\u95e8\u5e97\uff01\uff01\uff01");
            storeChildren.forEach(storeId -> {
                StoreSellerRelateEo eo = new StoreSellerRelateEo();
                eo.setOrganizationId(orgId);
                eo.setSellerId(sellerId);
                eo.setGovernSource(GovernTypeEnum.STORE.getCode());
                eo.setStoreId(storeId.getStoreId());
                insertList.add(eo);
            });
        }
        this.storeSellerRelateDas.insertBatch(insertList);
        if (CollectionUtil.isNotEmpty(blacklistIds)) {
            this.deleteRelate(sellerId, blacklistIds);
        }
    }
}

