/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.utils;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.CustomerExceptionCode;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;

public class Assert
extends com.dtyunxi.cube.biz.commons.utils.Assert {
    public static final String CODE = "customer-";

    public static void isTrue(boolean expression, CustomerExceptionCode customerExceptionCode, String msg) {
        if (!expression) {
            Assert.throwException(customerExceptionCode, msg);
        }
    }

    public static void isTrue(boolean expression, CustomerExceptionCode customerExceptionCode) {
        if (!expression) {
            Assert.throwException(customerExceptionCode);
        }
    }

    public static void notNull(@Nullable Object object, CustomerExceptionCode customerExceptionCode) {
        if (object == null) {
            Assert.throwException(customerExceptionCode);
        }
    }

    public static void notBlank(@Nullable String object, CustomerExceptionCode customerExceptionCode) {
        if (StringUtils.isBlank((CharSequence)object)) {
            Assert.throwException(customerExceptionCode);
        }
    }

    public static void notEmpty(@Nullable Collection coll, CustomerExceptionCode customerExceptionCode) {
        if (CollectionUtils.isEmpty((Collection)coll)) {
            Assert.throwException(customerExceptionCode);
        }
    }

    private static String throwException(CustomerExceptionCode customerExceptionCode) {
        String code = CODE + customerExceptionCode.getCode();
        throw new BizException(code, customerExceptionCode.getMsg());
    }

    private static String throwException(CustomerExceptionCode customerExceptionCode, String msg) {
        String code = CODE + customerExceptionCode.getCode();
        throw new BizException(code, String.format(customerExceptionCode.getMsg(), msg));
    }
}

