/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreAreaLevelEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreAreaReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreAreaService;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreAreaDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreAreaEo;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.customer.biz.service.IStoreService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StoreAreaServiceImpl
implements IStoreAreaService {
    private Logger logger = LoggerFactory.getLogger(StoreAreaServiceImpl.class);
    @Resource
    private StoreAreaDas storeAreaDas;
    @Resource
    private IStoreService storeService;

    @Override
    public Long addStoreArea(StoreAreaReqDto addReqDto) {
        StoreAreaRespDto storeAreaRespDto = this.queryByCode(addReqDto.getCode());
        if (ObjectUtils.isNotEmpty((Object)storeAreaRespDto) && ObjectUtils.isNotEmpty((Object)storeAreaRespDto.getId())) {
            StoreAreaEo storeAreaEo = new StoreAreaEo();
            storeAreaEo.setId(storeAreaRespDto.getId());
            storeAreaEo.setLevel(addReqDto.getLevel());
            storeAreaEo.setParentCode(addReqDto.getParentCode());
            storeAreaEo.setName(addReqDto.getName());
            this.storeAreaDas.updateSelective((BaseEo)storeAreaEo);
            return storeAreaEo.getId();
        }
        StoreAreaEo storeAreaEo = new StoreAreaEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)storeAreaEo);
        this.storeAreaDas.insert((BaseEo)storeAreaEo);
        return storeAreaEo.getId();
    }

    @Override
    public void modifyStoreArea(StoreAreaReqDto modifyReqDto) {
        StoreAreaEo storeAreaEo = new StoreAreaEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)storeAreaEo);
        this.storeAreaDas.updateSelective((BaseEo)storeAreaEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStoreArea(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.storeAreaDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public StoreAreaRespDto queryById(Long id) {
        StoreAreaEo storeAreaEo = (StoreAreaEo)this.storeAreaDas.selectByPrimaryKey(id);
        StoreAreaRespDto storeAreaRespDto = new StoreAreaRespDto();
        DtoHelper.eo2Dto((BaseEo)storeAreaEo, (BaseVo)storeAreaRespDto);
        return storeAreaRespDto;
    }

    @Override
    public PageInfo<StoreAreaRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        StoreAreaReqDto storeAreaReqDto = (StoreAreaReqDto)JSON.parseObject((String)filter, StoreAreaReqDto.class);
        StoreAreaEo storeAreaEo = new StoreAreaEo();
        DtoHelper.dto2Eo((BaseVo)storeAreaReqDto, (BaseEo)storeAreaEo);
        PageInfo eoPageInfo = this.storeAreaDas.selectPage((BaseEo)storeAreaEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, StoreAreaRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public StoreAreaRespDto queryByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        StoreAreaEo storeAreaParams = new StoreAreaEo();
        storeAreaParams.setCode(code);
        StoreAreaEo storeAreaEo = (StoreAreaEo)this.storeAreaDas.selectOne((BaseEo)storeAreaParams);
        StoreAreaRespDto storeAreaRespDto = new StoreAreaRespDto();
        DtoHelper.eo2Dto((BaseEo)storeAreaEo, (BaseVo)storeAreaRespDto);
        return storeAreaRespDto;
    }

    @Override
    public List<StoreAreaRespDto> queryByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"code", codes);
        List storeAreaEos = this.storeAreaDas.getMapper().selectList((Wrapper)wrapper);
        ArrayList<StoreAreaRespDto> storeAreaRespDto = new ArrayList<StoreAreaRespDto>();
        DtoHelper.eoList2DtoList((Collection)storeAreaEos, storeAreaRespDto, StoreAreaRespDto.class);
        return storeAreaRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String syncStoreArea(List<StoreAreaReqDto> reqDtoList) {
        this.logger.info("\u8bf7\u6c42\u540c\u6b65\u836f\u5e97\u533a\u57df\u4fe1\u606f\uff1a{}", (Object)reqDtoList.size());
        List queryStoreAreaEos = this.storeAreaDas.selectAll();
        if (CollectionUtil.isEmpty((Collection)queryStoreAreaEos)) {
            ArrayList insertStoreAreaEos = new ArrayList();
            DtoHelper.dtoList2EoList(reqDtoList, insertStoreAreaEos, StoreAreaEo.class);
            this.storeAreaDas.insertBatch(insertStoreAreaEos);
            this.logger.info("\u6b64\u6b21\u540c\u6b65\u4e3a\u521d\u59cb\u5316\uff0c\u540c\u6b65\u6210\u529f\uff1a\uff1a{}", (Object)insertStoreAreaEos.size());
            return "\u6b64\u6b21\u540c\u6b65\u4e3a\u521d\u59cb\u5316\uff0c\u540c\u6b65\u6210\u529f\uff1a" + insertStoreAreaEos.size();
        }
        ArrayList<StoreAreaEo> insertStoreAreaEos = new ArrayList<StoreAreaEo>();
        ArrayList<StoreAreaEo> updateStoreAreaEos = new ArrayList<StoreAreaEo>();
        for (StoreAreaReqDto storeAreaReqDto : reqDtoList) {
            StoreAreaEo queryAreaEo = null;
            for (StoreAreaEo queryEo : queryStoreAreaEos) {
                if (!queryEo.getCode().equals(storeAreaReqDto.getCode())) continue;
                queryAreaEo = queryEo;
                break;
            }
            if (ObjectUtils.isNotEmpty(queryAreaEo)) {
                StoreAreaEo updateEo = new StoreAreaEo();
                updateEo.setId(queryAreaEo.getId());
                updateEo.setName(storeAreaReqDto.getName());
                updateEo.setLevel(storeAreaReqDto.getLevel());
                updateEo.setParentCode(storeAreaReqDto.getParentCode());
                updateStoreAreaEos.add(updateEo);
                this.storeAreaDas.updateSelective((BaseEo)updateEo);
                continue;
            }
            StoreAreaEo insertEo = new StoreAreaEo();
            DtoHelper.dto2Eo((BaseVo)storeAreaReqDto, (BaseEo)insertEo);
            insertStoreAreaEos.add(insertEo);
        }
        this.storeAreaDas.insertBatch(insertStoreAreaEos);
        this.logger.info("\u8bf7\u6c42\u540c\u6b65\u836f\u5e97\u533a\u57df\u4fe1\u606f\u5b8c\u6210\uff0c\u65b0\u589e\uff1a{}\uff0c\u66f4\u65b0\uff1a{}", (Object)insertStoreAreaEos.size(), (Object)updateStoreAreaEos.size());
        return "\u8bf7\u6c42\u540c\u6b65\u836f\u5e97\u533a\u57df\u4fe1\u606f\u5b8c\u6210\uff0c\u65b0\u589e\uff1a" + insertStoreAreaEos.size() + "\uff0c\u66f4\u65b0\uff1a" + updateStoreAreaEos.size();
    }

    @Override
    public List<StoreAreaRespDto> queryAllStoreArea() {
        List storeAreaEos = this.storeAreaDas.selectAll();
        ArrayList<StoreAreaRespDto> storeAreaRespDtoList = new ArrayList<StoreAreaRespDto>();
        DtoHelper.eoList2DtoList((Collection)storeAreaEos, storeAreaRespDtoList, StoreAreaRespDto.class);
        return storeAreaRespDtoList;
    }

    @Override
    public List<StoreAreaRespDto> queryTree() {
        long st = System.currentTimeMillis();
        List storeAreaRespDtoList = this.storeAreaDas.queryAll();
        if (CollectionUtil.isEmpty((Collection)storeAreaRespDtoList)) {
            return new ArrayList<StoreAreaRespDto>();
        }
        List<StoreAreaRespDto> topStoreAreaList = storeAreaRespDtoList.stream().filter(area -> area.getLevel() == StoreAreaLevelEnum.PROVINCE.getCode()).collect(Collectors.toList());
        for (StoreAreaRespDto area2 : topStoreAreaList) {
            List<StoreAreaRespDto> childrenList = this.getChildrenList(area2.getCode(), area2.getLevel(), storeAreaRespDtoList);
            if (!CollectionUtil.isNotEmpty(childrenList)) continue;
            area2.setChildren(childrenList);
        }
        long et = System.currentTimeMillis();
        this.logger.info("\u6570\u636e\u5904\u7406\u7528\u65f6\uff1a" + (et - st) + "ms");
        return topStoreAreaList;
    }

    @Override
    public String initStoreArea(List<StoreAreaReqDto> reqDtoList) {
        if (CollectionUtil.isEmpty(reqDtoList)) {
            return "\u65e0\u6570\u636e\u521d\u59cb\u5316";
        }
        StoreAreaEo storeAreaEo = new StoreAreaEo();
        storeAreaEo.setDr(0);
        this.storeAreaDas.delete((BaseEo)storeAreaEo);
        ArrayList storeAreaEos = new ArrayList();
        DtoHelper.dtoList2EoList(reqDtoList, storeAreaEos, StoreAreaEo.class);
        this.storeAreaDas.insertBatch(storeAreaEos);
        ExecutorUtils.execute(() -> this.storeService.fillStoreAreaCodeForNot());
        return "\u5904\u7406\u5b8c\u6210\uff1a" + storeAreaEos.size();
    }

    private List<StoreAreaRespDto> getChildrenList(String code, int level, List<StoreAreaRespDto> entityList) {
        ArrayList<StoreAreaRespDto> childList = new ArrayList<StoreAreaRespDto>();
        if (level == 3) {
            return null;
        }
        entityList.forEach(area -> {
            if (code.equals(area.getParentCode())) {
                childList.add((StoreAreaRespDto)area);
            }
        });
        if (CollectionUtil.isEmpty(childList)) {
            return null;
        }
        childList.forEach(area -> {
            List<StoreAreaRespDto> indirectChildList = this.getChildrenList(area.getCode(), area.getLevel(), entityList);
            if (CollectionUtil.isNotEmpty(indirectChildList)) {
                area.setChildren(indirectChildList);
            }
        });
        return childList;
    }
}

