/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.query.ICustomerDistributorsQueryApi;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreCategoryCodeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreSellerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.UpdateStoreSellerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreCategoryCodeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerService;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreSellerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreSellerEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StoreSellerServiceImpl
implements IStoreSellerService {
    private static final Logger logger = LoggerFactory.getLogger(StoreSellerServiceImpl.class);
    @Resource
    private StoreSellerDas storeSellerDas;
    @Resource
    private StoreDas storeDas;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ICustomerDistributorsQueryApi customerDistributorsQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;

    @Override
    public Long addStoreSeller(StoreSellerReqDto addReqDto) {
        StoreSellerEo storeSellerEo = new StoreSellerEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)storeSellerEo);
        this.storeSellerDas.insert((BaseEo)storeSellerEo);
        return storeSellerEo.getId();
    }

    @Override
    public void modifyStoreSeller(StoreSellerReqDto modifyReqDto) {
        StoreSellerEo storeSellerEo = new StoreSellerEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)storeSellerEo);
        this.storeSellerDas.updateSelective((BaseEo)storeSellerEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStoreSeller(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.storeSellerDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public StoreSellerRespDto queryById(Long id) {
        StoreSellerEo storeSellerEo = (StoreSellerEo)this.storeSellerDas.selectByPrimaryKey(id);
        StoreSellerRespDto storeSellerRespDto = new StoreSellerRespDto();
        DtoHelper.eo2Dto((BaseEo)storeSellerEo, (BaseVo)storeSellerRespDto);
        return storeSellerRespDto;
    }

    @Override
    public PageInfo<StoreSellerRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        StoreSellerReqDto storeSellerReqDto = (StoreSellerReqDto)JSON.parseObject((String)filter, StoreSellerReqDto.class);
        StoreSellerEo storeSellerEo = new StoreSellerEo();
        DtoHelper.dto2Eo((BaseVo)storeSellerReqDto, (BaseEo)storeSellerEo);
        PageInfo eoPageInfo = this.storeSellerDas.selectPage((BaseEo)storeSellerEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, StoreSellerRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void batchUpdateStoreSeller(UpdateStoreSellerReqDto reqDto) {
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        logger.info("\u6279\u91cf\u4fee\u6539\u5546\u5bb6\u836f\u5e97\u5173\u7cfb \u5f53\u524d\u5927B\u7ec4\u7ec7id\uff0c{}", (Object)orgId);
        SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(orgId));
        if (null == sellerRespDto) {
            throw new BizException("-1", "\u6839\u636e\u5927B\u7ec4\u7ec7id: " + orgId + "\u83b7\u53d6\u5546\u5bb6\u4fe1\u606f\u4e3a\u7a7a");
        }
        StoreSellerEo selectEo = new StoreSellerEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"store_id", (Object)reqDto.getStoreIds()));
        sqlFilters.add(SqlFilter.eq((String)"seller_id", (Object)sellerRespDto.getId()));
        selectEo.setSqlFilters(sqlFilters);
        List storeSellerEoList = this.storeSellerDas.select((BaseEo)selectEo);
        HashMap storeSellerMap = CollectionUtils.isNotEmpty((Collection)storeSellerEoList) ? storeSellerEoList.stream().collect(Collectors.toMap(e -> e.getStoreId(), e -> e, (e1, e2) -> e1)) : new HashMap();
        String brands = null;
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getBrandCodes())) {
            brands = reqDto.getBrandCodes().stream().distinct().collect(Collectors.joining(";"));
        }
        ArrayList<StoreSellerEo> addStoreSeller = new ArrayList<StoreSellerEo>();
        ArrayList<StoreSellerEo> updateStoreSeller = new ArrayList<StoreSellerEo>();
        StoreSellerEo storeSellerEo = null;
        for (String storeId : reqDto.getStoreIds()) {
            if (storeSellerMap.containsKey(storeId)) {
                StoreSellerEo storeSeller = (StoreSellerEo)storeSellerMap.get(storeId);
                if (null != reqDto.getIfSupply()) {
                    storeSeller.setIfSupply(reqDto.getIfSupply());
                } else if (ObjectUtils.isNotEmpty((Object)reqDto.getParentDistributionId()) && StringUtils.isNotBlank((CharSequence)reqDto.getParentDistributionCode())) {
                    Boolean result = this.verifyStoreCreditNum(reqDto);
                    Assert.isTrue((boolean)result, (String)"0001", (String)"\u5f53\u524d\u8bbe\u7f6e\u95e8\u5e97\u4e2d\u5b58\u5728\u95e8\u5e97\u6216\u4e0a\u7ea7\u95e8\u5e97\u4e0e\u5f53\u524d\u5206\u914d\u5206\u9500\u5546\u4fe1\u7528\u4ee3\u7801\u4e00\u81f4");
                } else if (StringUtils.isNotBlank((CharSequence)brands)) {
                    storeSeller.setBrand(brands);
                } else if (StringUtils.isNotBlank((CharSequence)reqDto.getStoreCategoryCode())) {
                    storeSeller.setStoreCategoryCode(reqDto.getStoreCategoryCode());
                }
                storeSeller.setParentDistributionId(reqDto.getParentDistributionId());
                storeSeller.setParentDistributionCode(reqDto.getParentDistributionCode());
                storeSeller.setUpdateTime(null);
                updateStoreSeller.add(storeSeller);
                continue;
            }
            storeSellerEo = new StoreSellerEo();
            storeSellerEo.setSellerId(sellerRespDto.getId());
            storeSellerEo.setStoreId(storeId);
            storeSellerEo.setIfSupply(Integer.valueOf(0));
            storeSellerEo.setDr(0);
            if (null != reqDto.getIfSupply()) {
                storeSellerEo.setIfSupply(reqDto.getIfSupply());
            } else if (ObjectUtils.isNotEmpty((Object)reqDto.getParentDistributionId()) && StringUtils.isNotBlank((CharSequence)reqDto.getParentDistributionCode())) {
                storeSellerEo.setParentDistributionId(reqDto.getParentDistributionId());
                storeSellerEo.setParentDistributionCode(reqDto.getParentDistributionCode());
            } else if (StringUtils.isNotBlank((CharSequence)reqDto.getStoreCategoryCode())) {
                storeSellerEo.setStoreCategoryCode(reqDto.getStoreCategoryCode());
            } else if (StringUtils.isNotBlank((CharSequence)brands)) {
                storeSellerEo.setBrand(brands);
            }
            addStoreSeller.add(storeSellerEo);
        }
        if (CollectionUtils.isNotEmpty(addStoreSeller)) {
            logger.info("\u6279\u91cf\u65b0\u589e\u5546\u5bb6\u836f\u5e97\u6570\u636e\uff0c{}", (Object)JSONObject.toJSONString(addStoreSeller));
            this.storeSellerDas.insertBatch(addStoreSeller);
        }
        if (CollectionUtils.isNotEmpty(updateStoreSeller)) {
            logger.info("\u6279\u91cf\u4fee\u6539\u5546\u5bb6\u836f\u5e97\u6570\u636e\uff0c{}", (Object)JSONObject.toJSONString(updateStoreSeller));
            for (StoreSellerEo sellerEo : updateStoreSeller) {
                this.storeSellerDas.updateSelective((BaseEo)sellerEo);
            }
        }
    }

    private Boolean verifyStoreCreditNum(UpdateStoreSellerReqDto reqDto) {
        RestResponse customerRespDtoRestResponse = this.customerDistributorsQueryApi.queryCustomerByDistributionCode(reqDto.getParentDistributionCode());
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)customerRespDtoRestResponse);
        logger.info("\u3010\u62a5\u8868\u4e2d\u5fc3\u3011\u83b7\u53d6\u5206\u9500\u5546\u8be6\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)customerRespDto));
        if (ObjectUtils.isEmpty((Object)customerRespDto) || !StringUtils.isNotBlank((CharSequence)customerRespDto.getCreditCode())) {
            return false;
        }
        StoreEo storeEo = new StoreEo();
        ArrayList<SqlFilter> storeEoSqlFilters = new ArrayList<SqlFilter>();
        storeEoSqlFilters.add(SqlFilter.in((String)"store_id", (Object)reqDto.getStoreIds()));
        storeEo.setSqlFilters(storeEoSqlFilters);
        List storeEos = this.storeDas.selectList((BaseEo)storeEo);
        List storeParentCreditNumList = Optional.of(storeEos).orElse(Lists.newArrayList()).stream().map(c -> c.getParentSocialCreditNum()).collect(Collectors.toList());
        List storeCreditNumList = Optional.of(storeEos).orElse(Lists.newArrayList()).stream().map(c -> c.getSocialCreditNum()).collect(Collectors.toList());
        if (storeParentCreditNumList.contains(customerRespDto.getCreditCode())) {
            return false;
        }
        if (storeCreditNumList.contains(customerRespDto.getCreditCode())) {
            return false;
        }
        return true;
    }

    @Override
    public StoreSellerRespDto selectOne(StoreSellerReqDto storeSellerReqDto) {
        StoreSellerEo reqEo = new StoreSellerEo();
        DtoHelper.dto2Eo((BaseVo)storeSellerReqDto, (BaseEo)reqEo);
        StoreSellerEo storeSellerEo = (StoreSellerEo)this.storeSellerDas.selectOne((BaseEo)reqEo);
        StoreSellerRespDto storeSellerRespDto = new StoreSellerRespDto();
        CubeBeanUtils.copyProperties((Object)storeSellerRespDto, (Object)storeSellerEo, (String[])new String[0]);
        return storeSellerRespDto;
    }

    @Override
    public List<StoreCategoryCodeRespDto> queryStoreCategory() {
        StoreCategoryCodeEnum[] values = StoreCategoryCodeEnum.values();
        ArrayList<StoreCategoryCodeRespDto> list = new ArrayList<StoreCategoryCodeRespDto>();
        for (StoreCategoryCodeEnum storeCategory : values) {
            StoreCategoryCodeRespDto respDto = new StoreCategoryCodeRespDto();
            respDto.setCode(storeCategory.getCode());
            respDto.setName(storeCategory.getName());
            list.add(respDto);
        }
        return list;
    }

    @Override
    public List<StoreSellerRespDto> selectList(StoreSellerReqDto storeSellerReqDto) {
        QueryWrapper wrapper = new QueryWrapper();
        if (storeSellerReqDto.getSellerId() != null) {
            wrapper.eq((Object)"seller_id", (Object)storeSellerReqDto.getSellerId());
        }
        List list = this.storeSellerDas.getMapper().selectList((Wrapper)wrapper);
        ArrayList rList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)rList, (Collection)list, StoreSellerRespDto.class);
        return rList;
    }
}

