/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.request.TbPersonPartnerRelReqDto;
import com.dtyunxi.tcbj.api.dto.response.TbPersonPartnerRelRespDto;
import com.dtyunxi.tcbj.api.query.ITbPersonPartnerRelQueryApi;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.BizChannelEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CheckPatternTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreCheckErrorEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckRelationReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckPatternService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckRelationService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.impl.StoreAndSalesmanHelper;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerCheckPatternDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerCheckRelationDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerCheckPatternEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerCheckRelationEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.biz.service.ICustomerQueryService;
import com.yx.tcbj.center.customer.biz.service.IStoreService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class CustomerCheckRelationServiceImpl
implements ICustomerCheckRelationService {
    private static final Logger log = LoggerFactory.getLogger(CustomerCheckRelationServiceImpl.class);
    @Resource
    private CustomerCheckRelationDas customerCheckRelationDas;
    @Resource
    private CustomerCheckPatternDas customerCheckPatternDas;
    @Resource
    private StoreAndSalesmanHelper storeAndSalesmanHelper;
    @Resource
    private ICustomerQueryService customerQueryService;
    @Resource
    private ITbPersonPartnerRelQueryApi tbPersonPartnerRelQueryApi;
    @Resource
    private ICustomerCheckPatternService customerCheckPatternService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IStoreService storeService;
    @Resource
    private ICustomerCheckRelationService customerCheckRelationService;

    @Override
    public Long addCustomerCheckRelation(CustomerCheckRelationReqDto addReqDto) {
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerCheckRelationEo);
        this.customerCheckRelationDas.insert((BaseEo)customerCheckRelationEo);
        return customerCheckRelationEo.getId();
    }

    @Override
    public void modifyCustomerCheckRelation(CustomerCheckRelationReqDto modifyReqDto) {
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerCheckRelationEo);
        this.customerCheckRelationDas.updateSelective((BaseEo)customerCheckRelationEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerCheckRelation(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerCheckRelationDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CustomerCheckRelationRespDto queryById(Long id) {
        CustomerCheckRelationEo customerCheckRelationEo = (CustomerCheckRelationEo)this.customerCheckRelationDas.selectByPrimaryKey(id);
        CustomerCheckRelationRespDto customerCheckRelationRespDto = new CustomerCheckRelationRespDto();
        DtoHelper.eo2Dto((BaseEo)customerCheckRelationEo, (BaseVo)customerCheckRelationRespDto);
        return customerCheckRelationRespDto;
    }

    @Override
    public PageInfo<CustomerCheckRelationRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerCheckRelationReqDto customerCheckRelationReqDto = (CustomerCheckRelationReqDto)JSON.parseObject((String)filter, CustomerCheckRelationReqDto.class);
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        DtoHelper.dto2Eo((BaseVo)customerCheckRelationReqDto, (BaseEo)customerCheckRelationEo);
        PageInfo eoPageInfo = this.customerCheckRelationDas.selectPage((BaseEo)customerCheckRelationEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerCheckRelationRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<CustomerCheckRelationRespDto> queryByStoreIds(CustomerCheckRelationReqDto customerCheckRelationReqDto) {
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        DtoHelper.dto2Eo((BaseVo)customerCheckRelationReqDto, (BaseEo)customerCheckRelationEo);
        ArrayList sqlFilters = Lists.newArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerCheckRelationReqDto.getStoreIds())) {
            sqlFilters.add(SqlFilter.in((String)"store_id", (Object)customerCheckRelationReqDto.getStoreIds()));
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerCheckRelationReqDto.getOrgIds())) {
            sqlFilters.add(SqlFilter.in((String)"org_id", (Object)customerCheckRelationReqDto.getOrgIds()));
        }
        customerCheckRelationEo.setSqlFilters((List)sqlFilters);
        List results = this.customerCheckRelationDas.select((BaseEo)customerCheckRelationEo);
        ArrayList customerCheckRelationRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)results, (Collection)customerCheckRelationRespDtos, CustomerCheckRelationRespDto.class);
        return customerCheckRelationRespDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bindStoreAndSalesmanRelation(CustomerCheckRelationReqDto addReqDto) {
        log.info("\u7ed1\u5b9a\u5ba2\u6237\u5173\u7cfb req params => {} ", (Object)JSON.toJSONString((Object)addReqDto));
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        CustomerRespDto customerRespDto = this.customerQueryService.queryByOrgInfoId(orgId);
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)customerRespDto) ? 1 : 0) != 0, (String)"\u5f53\u524d\u5ba2\u6237\u4e0d\u5b58\u5728");
        CustomerCheckStatusEnum customerCheckStatusEnum = this.verifyBindRelationParams(addReqDto, customerRespDto);
        BizChannelEnum bizChannelEnum = this.storeAndSalesmanHelper.calculateBizChannel(addReqDto.getThirdPartyId());
        switch (customerCheckStatusEnum) {
            case BOUND: {
                CustomerCheckRelationEo reqDto = new CustomerCheckRelationEo();
                reqDto.setStoreId(addReqDto.getStoreId());
                reqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
                List dbList = this.customerCheckRelationDas.select((BaseEo)reqDto);
                this.verifyRelation(addReqDto, bizChannelEnum, dbList);
                this.checkPersonPartnerDisable(addReqDto, dbList, customerRespDto);
                CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
                DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerCheckRelationEo);
                customerCheckRelationEo.setBizType(Long.valueOf(bizChannelEnum.getChannelCode()));
                customerCheckRelationEo.setStoreId(addReqDto.getStoreId());
                customerCheckRelationEo.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
                this.customerCheckRelationDas.insert((BaseEo)customerCheckRelationEo);
                break;
            }
            case NOT_BOUND: {
                CustomerCheckRelationEo customerCheckRelation = new CustomerCheckRelationEo();
                customerCheckRelation.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"biz_type", (Object)bizChannelEnum.getBizTypes())}));
                customerCheckRelation.setStoreId(addReqDto.getStoreId());
                customerCheckRelation.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
                customerCheckRelation.setOrgId(addReqDto.getOrgId());
                List list = this.customerCheckRelationDas.select((BaseEo)customerCheckRelation);
                AssertUtil.isTrue((list.size() > 0 ? 1 : 0) != 0, (String)"\u8003\u6838\u95e8\u5e97\u5173\u7cfb\u5b58\u5728\u5f02\u5e38\uff01");
                customerCheckRelation = (CustomerCheckRelationEo)list.stream().findFirst().get();
                AssertUtil.isTrue((boolean)customerCheckRelation.getOrgId().equals(addReqDto.getOrgId()), (String)"\u5f53\u524d\u89e3\u7ed1\u5173\u7cfb\u4e0e\u6240\u5c5e\u516c\u53f8\u4e0d\u4e00\u81f4\uff01");
                AssertUtil.isTrue((boolean)customerCheckRelation.getStoreId().equals(addReqDto.getStoreId()), (String)"\u89e3\u7ed1\u95e8\u5e97\u4e0e\u5f53\u524d\u7ed1\u5b9a\u95e8\u5e97\u4e0d\u4e00\u81f4\uff01");
                AssertUtil.isTrue((boolean)customerCheckRelation.getSalesmanId().equals(addReqDto.getSalesmanId()), (String)"\u89e3\u7ed1\u4e1a\u52a1\u5458\u4e0e\u5f53\u524d\u7ed1\u5b9a\u4e1a\u52a1\u5458\u4e0d\u4e00\u81f4\uff01");
                customerCheckRelation.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
                this.customerCheckRelationDas.updateSelective((BaseEo)customerCheckRelation);
                break;
            }
            default: {
                throw new BizException("0001", "\u4e0d\u5b58\u5728\u5f53\u524d\u64cd\u4f5c\u7c7b\u578b");
            }
        }
    }

    @Override
    public void disableRelationByOrgId(String orgId) {
        CustomerCheckRelationEo customerCheckRelation = new CustomerCheckRelationEo();
        customerCheckRelation.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"org_id", (Object)orgId)}));
        customerCheckRelation.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
        int result = this.customerCheckRelationDas.updateSelectiveSqlFilter((BaseEo)customerCheckRelation);
        AssertUtil.isTrue((result >= 0 ? 1 : 0) != 0, (String)("\u5931\u6548[" + orgId + "]\u7ec4\u7ec7\u4eba\u5e97\u5173\u7cfb\u5931\u8d25"));
    }

    private void checkPersonPartnerDisable(CustomerCheckRelationReqDto addReqDto, List<CustomerCheckRelationEo> dbList, CustomerRespDto customerRespDto) {
        if (CollectionUtils.isNotEmpty(dbList)) {
            TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
            tbPersonPartnerRelReqDto.setRowIds(dbList.stream().map(CustomerCheckRelationEo::getSalesmanId).collect(Collectors.toList()));
            tbPersonPartnerRelReqDto.setCustomerId(addReqDto.getThirdPartyId());
            tbPersonPartnerRelReqDto.setMasterOuId(customerRespDto.getThirdPartyId());
            PageInfo tbPersonPartnerRelRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tbPersonPartnerRelQueryApi.queryByPage(JSON.toJSONString((Object)tbPersonPartnerRelReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
            if (CollectionUtils.isNotEmpty((Collection)tbPersonPartnerRelRespDtoPageInfo.getList())) {
                List rowIds = tbPersonPartnerRelRespDtoPageInfo.getList().stream().map(TbPersonPartnerRelRespDto::getRowId).collect(Collectors.toList());
                dbList.forEach(c -> {
                    if (!rowIds.contains(c.getSalesmanId())) {
                        int result = this.customerCheckRelationDas.update((BaseEo)c);
                        AssertUtil.isTrue((result > 0 ? 1 : 0) != 0, (String)"\u8003\u6838\u5173\u7cfb\u53d8\u66f4\u5931\u8d25\uff01");
                    }
                });
            }
        }
    }

    private void verifyRelation(CustomerCheckRelationReqDto addReqDto, BizChannelEnum bizChannelEnum, List<CustomerCheckRelationEo> dbList) {
        CustomerRespDto theCustomerRespDto = this.customerQueryService.queryByOrgInfoId(addReqDto.getOrgId());
        CustomerCheckPatternReqDto customerCheckPatternReqDto = new CustomerCheckPatternReqDto();
        customerCheckPatternReqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{theCustomerRespDto.getCode()}));
        List customerCheckPatternEos = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(customerCheckPatternReqDto);
        AssertUtil.isTrue((!org.springframework.util.CollectionUtils.isEmpty((Collection)customerCheckPatternEos) ? 1 : 0) != 0, (String)"\u5f53\u524d\u5ba2\u6237\u672a\u6307\u5b9a\u8003\u6838\u65b9\u5f0f\uff01");
        log.info("\u68c0\u6d4b\u662f\u5426\u5b58\u5728\u5408\u5e76\u8003\u6838\u7ecf\u9500\u5546 result => {} ", (Object)JSON.toJSONString((Object)customerCheckPatternEos));
        CustomerCheckPatternEo customerCheckPatternEo = (CustomerCheckPatternEo)customerCheckPatternEos.stream().findFirst().get();
        CheckPatternTypeEnum checkPatternTypeEnum = CheckPatternTypeEnum.enumOfType((Integer)customerCheckPatternEo.getPatternType());
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)checkPatternTypeEnum) ? 1 : 0) != 0, (String)"\u8003\u6838\u6a21\u5f0f\u4e0d\u5b58\u5728\uff01");
        AssertUtil.isTrue((boolean)bizChannelEnum.getCheckPatternTypes().contains(checkPatternTypeEnum), (String)"\u5f53\u524d\u4e1a\u52a1\u7ebf\u4e0d\u5b58\u5728\u8be5\u8003\u6838\u6a21\u5f0f");
        switch (checkPatternTypeEnum) {
            case ALONE_CHECK: {
                if (!CollectionUtils.isNotEmpty(dbList)) break;
                dbList.stream().filter(a -> BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType()))).forEach(eo -> {
                    CustomerRespDto customerRespDto = this.customerQueryService.queryByOrgInfoId(eo.getOrgId());
                    AssertUtil.isTrue((boolean)false, (String)String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)eo.getBizType().toString()).getDesc(), customerRespDto.getName()));
                });
                break;
            }
            case SEPARATE_CHECK: {
                List<CustomerCheckRelationEo> notByHealthList;
                if (!CollectionUtils.isNotEmpty(dbList) || !CollectionUtils.isNotEmpty(notByHealthList = dbList.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType()))).collect(Collectors.toList()))) break;
                notByHealthList.forEach(eo -> {
                    CustomerRespDto customerRespDto = this.customerQueryService.queryByOrgInfoId(eo.getOrgId());
                    AssertUtil.isTrue((!bizChannelEnum.getChannelCode().equals(String.valueOf(eo.getBizType())) ? 1 : 0) != 0, (String)String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)eo.getBizType().toString()).getDesc(), customerRespDto.getName()));
                    CustomerCheckPatternReqDto reqDto = new CustomerCheckPatternReqDto();
                    reqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{String.valueOf(eo.getOrgId())}));
                    List patternEoList = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(reqDto);
                    patternEoList.forEach(patternEo -> AssertUtil.isTrue((!String.valueOf(CheckPatternTypeEnum.MERGE_CHECK.getType()).equals(String.valueOf(patternEo.getPatternType())) ? 1 : 0) != 0, (String)String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)eo.getBizType().toString()).getDesc(), customerRespDto.getName())));
                });
                break;
            }
            case MERGE_CHECK: {
                if (!CollectionUtils.isNotEmpty(dbList)) break;
                dbList.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType()))).forEach(eo -> {
                    CustomerRespDto customerRespDto = this.customerQueryService.queryByOrgInfoId(eo.getOrgId());
                    AssertUtil.isTrue((boolean)false, (String)String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)eo.getBizType().toString()).getDesc(), customerRespDto.getName()));
                });
                break;
            }
            default: {
                throw new BizException("0001", "\u4e0d\u5b58\u5728\u5f53\u524d\u64cd\u4f5c\u7c7b\u578b");
            }
        }
    }

    @Override
    public void customerRelationToTenantScope(Long orgId, List<String> enableRecord) {
        CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
        customerCheckRelationReqDto.setOrgId(orgId);
        customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        List<CustomerCheckRelationRespDto> customerCheckRelationRespDtos = this.customerCheckRelationService.queryByStoreIds(customerCheckRelationReqDto);
        List disableStoreIds = customerCheckRelationRespDtos.stream().filter(c -> !enableRecord.contains(c.getStoreId())).map(c -> c.getStoreId()).distinct().collect(Collectors.toList());
        if (!org.springframework.util.CollectionUtils.isEmpty(disableStoreIds)) {
            ArrayList sqlFilters = Lists.newArrayList();
            CustomerCheckRelationEo customerCheckRelation = new CustomerCheckRelationEo();
            sqlFilters.add(SqlFilter.eq((String)"org_id", (Object)orgId));
            sqlFilters.add(SqlFilter.in((String)"store_id", disableStoreIds));
            customerCheckRelation.setSqlFilters((List)sqlFilters);
            customerCheckRelation.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
            int result = this.customerCheckRelationDas.updateSelectiveSqlFilter((BaseEo)customerCheckRelation);
            AssertUtil.isTrue((result >= 0 ? 1 : 0) != 0, (String)("\u5931\u6548[" + orgId + "]\u7ec4\u7ec7\u4eba\u5e97\u5173\u7cfb\u5931\u8d25"));
        }
    }

    @NotNull
    private CustomerCheckStatusEnum verifyBindRelationParams(CustomerCheckRelationReqDto addReqDto, CustomerRespDto customerRespDto) {
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)addReqDto.getOrgId()) ? 1 : 0) != 0, (String)"\u7ec4\u7ec7ID\u4e3a\u7a7a!");
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)addReqDto.getStoreId()) ? 1 : 0) != 0, (String)"\u95e8\u5e97ID\u4e3a\u7a7a!");
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)addReqDto.getSalesmanId()) ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458ID\u4e3a\u7a7a!");
        AssertUtil.isTrue((!StringUtils.isEmpty((Object)addReqDto.getThirdPartyId()) ? 1 : 0) != 0, (String)"\u7ecf\u9500\u5546ID\u4e3a\u7a7a!");
        AssertUtil.isTrue((!StringUtils.isEmpty((Object)addReqDto.getStatus()) ? 1 : 0) != 0, (String)"\u8003\u6838\u5173\u7cfb\u72b6\u6001\u4e3a\u7a7a!");
        CustomerCheckStatusEnum customerCheckStatusEnum = CustomerCheckStatusEnum.enumOfStatus((Integer)addReqDto.getStatus());
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)customerCheckStatusEnum) ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u4e1a\u52a1\u65b9\u5f0f\uff01");
        TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
        tbPersonPartnerRelReqDto.setRowIds(Arrays.asList(addReqDto.getSalesmanId()));
        tbPersonPartnerRelReqDto.setCustomerId(addReqDto.getThirdPartyId());
        tbPersonPartnerRelReqDto.setMasterOuId(customerRespDto.getThirdPartyId());
        PageInfo tbPersonPartnerRelRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tbPersonPartnerRelQueryApi.queryByPage(JSON.toJSONString((Object)tbPersonPartnerRelReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)tbPersonPartnerRelRespDtoPageInfo.getList()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7ecf\u9500\u5546\u4e0d\u5b58\u5728\u8be5\u4e1a\u52a1\u5458");
        return customerCheckStatusEnum;
    }
}

