/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.BizChannelEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CheckPatternTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckRelationSourceOperateTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckRelationReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckPatternRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckPatternService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckRelationService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.impl.StoreAndSalesmanHelper;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerCheckPatternDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerCheckRelationDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerCheckPatternEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerCheckRelationEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.biz.service.ICustomerQueryService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class CustomerCheckPatternServiceImpl
implements ICustomerCheckPatternService {
    private static final Logger log = LoggerFactory.getLogger(CustomerCheckPatternServiceImpl.class);
    @Resource
    private CustomerCheckPatternDas customerCheckPatternDas;
    @Resource
    private CustomerCheckRelationDas customerCheckRelationDas;
    @Resource
    private ICustomerQueryService customerQueryService;
    @Resource
    private StoreAndSalesmanHelper storeAndSalesmanHelper;
    @Resource
    private ICustomerCheckRelationService customerCheckRelationService;

    @Override
    public void addCustomerCheckPattern(CustomerCheckPatternReqDto addReqDto) {
        log.info("\u6dfb\u52a0\u7ecf\u9500\u5546\u8003\u6838\u65b9\u5f0f params => {} ", (Object)JSON.toJSONString((Object)addReqDto));
        CheckPatternTypeEnum reqCheckPatternTypeEnum = CheckPatternTypeEnum.enumOfType((Integer)addReqDto.getPatternType());
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)reqCheckPatternTypeEnum) ? 1 : 0) != 0, (String)"\u8003\u6838\u65b9\u5f0f\u4e0d\u5b58\u5728\uff01");
        AssertUtil.isTrue((!StringUtils.isEmpty((Object)addReqDto.getCustomerCode()) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<CustomerRespDto> customerRespDtoList = this.customerQueryService.queryCustomerListByCodes(Arrays.asList(addReqDto.getCustomerCode()));
        AssertUtil.isTrue((!org.springframework.util.CollectionUtils.isEmpty(customerRespDtoList) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtoList.stream().findFirst().get();
        CustomerCheckPatternReqDto reqDto = new CustomerCheckPatternReqDto();
        reqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{addReqDto.getCustomerCode()}));
        List customerCheckPatternList = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(reqDto);
        BizChannelEnum bizChannelEnum = this.storeAndSalesmanHelper.calculateBizChannel(customerRespDto.getThirdPartyId());
        AssertUtil.isTrue((boolean)bizChannelEnum.getCheckPatternTypes().contains(reqCheckPatternTypeEnum), (String)"\u5f53\u524d\u4e1a\u52a1\u7ebf\u4e0d\u5b58\u5728\u8be5\u8003\u6838\u6a21\u5f0f");
        switch (reqCheckPatternTypeEnum) {
            case SEPARATE_CHECK: 
            case ALONE_CHECK: {
                this.customerCheckPatternLogicDeleteBatch(customerCheckPatternList);
                CustomerCheckPatternEo customerCheckPattern = new CustomerCheckPatternEo();
                customerCheckPattern.setPatternType(reqCheckPatternTypeEnum.getType());
                customerCheckPattern.setCustomerCode(customerRespDto.getCode());
                customerCheckPattern.setCustomerName(customerRespDto.getName());
                customerCheckPattern.setOrgId(customerRespDto.getOrgInfoId());
                int result = this.customerCheckPatternDas.insert((BaseEo)customerCheckPattern);
                AssertUtil.isTrue((result > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u8003\u6838\u89c4\u5219\u5931\u8d25\uff01");
                break;
            }
            case MERGE_CHECK: {
                List addCustomerCheckPatterns;
                int results;
                AssertUtil.isTrue((!StringUtils.isEmpty((Object)addReqDto.getMergeCustomerCodes()) ? 1 : 0) != 0, (String)"\u5408\u5e76\u8003\u6838\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                List<CustomerRespDto> mergeCustomerRespDtoList = this.customerQueryService.queryCustomerListByCodes(addReqDto.getMergeCustomerCodes());
                AssertUtil.isTrue((!org.springframework.util.CollectionUtils.isEmpty(mergeCustomerRespDtoList) ? 1 : 0) != 0, (String)"\u7ed1\u5b9a\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
                mergeCustomerRespDtoList.forEach(c -> AssertUtil.isTrue((!c.getCode().equals(addReqDto.getCustomerCode()) ? 1 : 0) != 0, (String)"\u540c\u79df\u6237\u65e0\u6cd5\u8fdb\u884c\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5\uff01"));
                mergeCustomerRespDtoList.forEach(c -> AssertUtil.isTrue((!c.getMerchantId().equals(customerRespDto.getMerchantId()) ? 1 : 0) != 0, (String)"\u76f8\u540c\u4e1a\u52a1\u7ebf\u65e0\u6cd5\u8fdb\u884c\u7ed1\u5b9a\uff0c\u8bf7\u68c0\u67e5\uff01"));
                this.mergeCheckBefore(addReqDto, customerCheckPatternList);
                this.mergeCheckBefore_v1(customerRespDto, customerCheckPatternList, mergeCustomerRespDtoList);
                this.customerCheckPatternLogicDeleteBatch(customerCheckPatternList);
                CustomerCheckPatternReqDto reqDto2 = new CustomerCheckPatternReqDto();
                reqDto2.setCustomerCodes(mergeCustomerRespDtoList.stream().map(CustomerRespDto::getCode).collect(Collectors.toList()));
                List list = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(reqDto2);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    List<CustomerCheckPatternEo> eoList = list.stream().filter(a -> !CheckPatternTypeEnum.MERGE_CHECK.getType().equals(a.getPatternType())).collect(Collectors.toList());
                    this.customerCheckPatternLogicDeleteBatch(eoList);
                }
                AssertUtil.isTrue(((results = this.customerCheckPatternDas.insertBatch(addCustomerCheckPatterns = mergeCustomerRespDtoList.stream().map(c -> {
                    CustomerCheckPatternEo customerCheckPatternEo = new CustomerCheckPatternEo();
                    customerCheckPatternEo.setPatternType(reqCheckPatternTypeEnum.getType());
                    customerCheckPatternEo.setCustomerCode(customerRespDto.getCode());
                    customerCheckPatternEo.setCustomerName(customerRespDto.getName());
                    customerCheckPatternEo.setOrgId(customerRespDto.getOrgInfoId());
                    customerCheckPatternEo.setMergeCustomerCode(c.getCode());
                    customerCheckPatternEo.setMergeCustomerName(c.getName());
                    customerCheckPatternEo.setMergeOrgId(c.getOrgInfoId());
                    return customerCheckPatternEo;
                }).collect(Collectors.toList()))) > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u8003\u6838\u89c4\u5219\u5931\u8d25\uff01");
                break;
            }
            default: {
                throw new BizException("0001", "\u4e0d\u5b58\u5728\u5f53\u524d\u64cd\u4f5c\u7c7b\u578b");
            }
        }
        this.deleteCheckRelationsByNotPatternType(customerCheckPatternList);
    }

    private void deleteCheckRelationsByNotPatternType(List<CustomerCheckPatternEo> customerCheckPatternList) {
        ArrayList customerCodeList;
        HashSet collectCustomerCodeSets = new HashSet(16);
        if (CollectionUtils.isNotEmpty(customerCheckPatternList)) {
            collectCustomerCodeSets.addAll(customerCheckPatternList.stream().map(CustomerCheckPatternEo::getCustomerCode).collect(Collectors.toList()));
            collectCustomerCodeSets.addAll(customerCheckPatternList.stream().map(CustomerCheckPatternEo::getMergeCustomerCode).collect(Collectors.toList()));
        }
        if (CollectionUtils.isNotEmpty(customerCodeList = new ArrayList(collectCustomerCodeSets))) {
            customerCodeList.stream().filter(org.apache.commons.lang3.StringUtils::isNotBlank).forEach(c -> {
                List<CustomerRespDto> customerRespDtos = this.customerQueryService.queryCustomerListByCodes(Lists.newArrayList((Object[])new String[]{c}));
                AssertUtil.isTrue((!org.springframework.util.CollectionUtils.isEmpty(customerRespDtos) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
                CustomerRespDto customer = (CustomerRespDto)customerRespDtos.stream().findFirst().get();
                CustomerCheckPatternReqDto reqDto3 = new CustomerCheckPatternReqDto();
                reqDto3.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{c}));
                List patternEoList = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(reqDto3);
                if (CollectionUtils.isEmpty((Collection)patternEoList)) {
                    CustomerCheckRelationReqDto relationReqDto = new CustomerCheckRelationReqDto();
                    relationReqDto.setOrgId(customer.getOrgInfoId());
                    List<CustomerCheckRelationRespDto> checkRelationList = this.customerCheckRelationService.queryByStoreIds(relationReqDto);
                    if (CollectionUtils.isNotEmpty(checkRelationList)) {
                        checkRelationList.forEach(d -> this.updateDIsabelStatus((CustomerCheckRelationRespDto)d));
                    }
                }
            });
        }
    }

    private void updateDIsabelStatus(CustomerCheckRelationRespDto d) {
        CustomerCheckRelationEo updateEo = new CustomerCheckRelationEo();
        DtoHelper.dto2Eo((BaseVo)d, (BaseEo)updateEo);
        updateEo.setStatus(CustomerCheckStatusEnum.DISABLE.getStatus());
        updateEo.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.SCHEDULER.getType());
        int result = this.customerCheckRelationDas.update((BaseEo)updateEo);
        AssertUtil.isTrue((result > 0 ? 1 : 0) != 0, (String)"\u8003\u6838\u5173\u7cfb\u53d8\u66f4\u5931\u8d25\uff01");
    }

    private void mergeCheckBefore_v1(CustomerRespDto customerRespDto, List<CustomerCheckPatternEo> customerCheckPatternList, List<CustomerRespDto> mergeCustomerRespDtoList) {
        if (CollectionUtils.isNotEmpty(customerCheckPatternList)) {
            CheckPatternTypeEnum currCheckPatternTypeEnum = CheckPatternTypeEnum.enumOfType((Integer)((CustomerCheckPatternEo)customerCheckPatternList.stream().findFirst().get()).getPatternType());
            AssertUtil.notNull((Object)currCheckPatternTypeEnum, (String)"\u5f53\u524d\u7ecf\u9500\u5546\u7684\u8003\u6838\u65b9\u5f0f\u4e0d\u5b58\u5728\uff01");
            switch (currCheckPatternTypeEnum) {
                case SEPARATE_CHECK: {
                    ArrayList<Long> currCustomerOrgIdList = new ArrayList<Long>();
                    currCustomerOrgIdList.add(customerRespDto.getOrgInfoId());
                    CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
                    customerCheckRelationReqDto.setOrgIds(currCustomerOrgIdList);
                    customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
                    List<CustomerCheckRelationRespDto> currList = this.customerCheckRelationService.queryByStoreIds(customerCheckRelationReqDto);
                    ArrayList<CustomerCheckRelationRespDto> needHandlerList = new ArrayList<CustomerCheckRelationRespDto>();
                    if (CollectionUtils.isNotEmpty(currList)) {
                        needHandlerList.addAll(currList);
                    }
                    List mergerCustomerOrgIdList = mergeCustomerRespDtoList.stream().map(CustomerRespDto::getOrgInfoId).collect(Collectors.toList());
                    CustomerCheckRelationReqDto mergerCheckRelationReqDto = new CustomerCheckRelationReqDto();
                    mergerCheckRelationReqDto.setOrgIds(mergerCustomerOrgIdList);
                    mergerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
                    List<CustomerCheckRelationRespDto> mergerList = this.customerCheckRelationService.queryByStoreIds(mergerCheckRelationReqDto);
                    if (CollectionUtils.isNotEmpty(mergerList)) {
                        needHandlerList.addAll(mergerList);
                    }
                    ArrayList<CustomerCheckRelationRespDto> storeIdsRespList = new ArrayList<CustomerCheckRelationRespDto>();
                    if (CollectionUtils.isNotEmpty(needHandlerList)) {
                        Map<String, List<CustomerCheckRelationRespDto>> map = needHandlerList.stream().collect(Collectors.groupingBy(CustomerCheckRelationRespDto::getStoreId));
                        map.forEach((storeId, list) -> {
                            if (list.size() > 1) {
                                list.forEach(c -> {
                                    if (BizChannelEnum.LIFE_SPACE.getChannelCode().equals(String.valueOf(c.getBizType()))) {
                                        this.updateDIsabelStatus((CustomerCheckRelationRespDto)c);
                                    }
                                });
                            }
                        });
                        HashSet storeIdSets = new HashSet(16);
                        storeIdSets.addAll(needHandlerList.stream().map(CustomerCheckRelationRespDto::getStoreId).collect(Collectors.toList()));
                        ArrayList storeIds = new ArrayList(storeIdSets);
                        CustomerCheckRelationReqDto reqDto = new CustomerCheckRelationReqDto();
                        reqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
                        reqDto.setStoreIds(storeIds);
                        storeIdsRespList.addAll(this.customerCheckRelationService.queryByStoreIds(reqDto));
                    }
                    if (!CollectionUtils.isNotEmpty(storeIdsRespList)) break;
                    List orgIds = needHandlerList.stream().map(CustomerCheckRelationRespDto::getOrgId).collect(Collectors.toList());
                    Map<String, List<CustomerCheckRelationRespDto>> map = storeIdsRespList.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(a.getBizType().toString())).collect(Collectors.groupingBy(CustomerCheckRelationRespDto::getStoreId));
                    if (map.entrySet().size() <= 0) break;
                    map.forEach((storeId, list) -> {
                        if (list.size() > 1) {
                            list.stream().filter(a -> orgIds.contains(a.getOrgId())).forEach(c -> {
                                this.updateDIsabelStatus((CustomerCheckRelationRespDto)c);
                                log.warn("\u5408\u5e76\u8003\u6838==>\u5220\u9664\u5408\u5e76\u5173\u7cfb\u5185\u7684\u95e8\u5e97\u8003\u6838\u5173\u7cfb:" + JSON.toJSONString((Object)c));
                            });
                        }
                    });
                    break;
                }
                case MERGE_CHECK: {
                    CustomerCheckPatternReqDto reqDto2 = new CustomerCheckPatternReqDto();
                    reqDto2.setCustomerCodes(mergeCustomerRespDtoList.stream().map(c -> String.valueOf(c.getOrgInfoId())).collect(Collectors.toList()));
                    List patternList = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(reqDto2);
                    List<Object> separateCheckTypeList = new ArrayList();
                    if (CollectionUtils.isNotEmpty((Collection)patternList)) {
                        separateCheckTypeList = patternList.stream().filter(p -> CheckPatternTypeEnum.SEPARATE_CHECK.getType().equals(p.getPatternType())).collect(Collectors.toList());
                    }
                    List<Object> separateOrgIds = new ArrayList();
                    if (CollectionUtils.isNotEmpty(separateCheckTypeList)) {
                        separateOrgIds = separateCheckTypeList.stream().map(CustomerCheckPatternEo::getOrgId).collect(Collectors.toList());
                    }
                    List<Object> separateRelationRespDtoList = new ArrayList();
                    if (CollectionUtils.isNotEmpty(separateOrgIds)) {
                        CustomerCheckRelationReqDto relationReqDto = new CustomerCheckRelationReqDto();
                        relationReqDto.setOrgIds(separateOrgIds);
                        separateRelationRespDtoList = this.customerCheckRelationService.queryByStoreIds(relationReqDto);
                    }
                    if (!CollectionUtils.isNotEmpty(separateRelationRespDtoList)) break;
                    separateRelationRespDtoList.forEach(c -> this.customerCheckPatternDas.logicDeleteById(c.getId()));
                    break;
                }
            }
        }
    }

    private void mergeCheckBefore(CustomerCheckPatternReqDto addReqDto, List<CustomerCheckPatternEo> customerCheckPatternList) {
        HashSet collectCustomerCodeSets = new HashSet(16);
        if (CollectionUtils.isNotEmpty(customerCheckPatternList)) {
            collectCustomerCodeSets.addAll(customerCheckPatternList.stream().map(CustomerCheckPatternEo::getCustomerCode).collect(Collectors.toList()));
            collectCustomerCodeSets.addAll(customerCheckPatternList.stream().map(CustomerCheckPatternEo::getMergeCustomerCode).collect(Collectors.toList()));
        }
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)addReqDto.getMergeCustomerCodes()), (String)"\u65b0\u589e[\u5408\u5e76\u8003\u6838]\u5173\u7cfb,\u6307\u5b9a\u7ecf\u9500\u5546\u5217\u8868\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!");
        List<Object> customerCheckPatternLists = new ArrayList();
        CustomerCheckPatternReqDto checkPatternReqDto = new CustomerCheckPatternReqDto();
        checkPatternReqDto.setCustomerCodes(addReqDto.getMergeCustomerCodes());
        List mergeCustomerCodesPatternList = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(checkPatternReqDto);
        if (CollectionUtils.isNotEmpty((Collection)mergeCustomerCodesPatternList)) {
            customerCheckPatternLists = mergeCustomerCodesPatternList.stream().filter(a -> !collectCustomerCodeSets.contains(a.getCustomerCode()) && !collectCustomerCodeSets.contains(a.getMergeCustomerCode())).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(customerCheckPatternLists)) {
            List mergeCheckPatternEoList = customerCheckPatternLists.stream().filter(a -> CheckPatternTypeEnum.MERGE_CHECK.getType().equals(a.getPatternType())).collect(Collectors.toList());
            AssertUtil.isTrue((boolean)CollectionUtils.isEmpty(mergeCheckPatternEoList), (String)"\u5f53\u524d\u9009\u4e2d\u5173\u8054\u7ecf\u9500\u5546\u5df2\u5b58\u5728\u5408\u5e76\u8003\u6838\u5173\u7cfb,\u8bf7\u68c0\u67e5");
            customerCheckPatternLists.forEach(c -> this.customerCheckPatternDas.logicDeleteById(c.getId()));
        }
    }

    private void customerCheckPatternLogicDeleteBatch(List<CustomerCheckPatternEo> customerCheckPatternList) {
        if (CollectionUtils.isNotEmpty(customerCheckPatternList)) {
            customerCheckPatternList.forEach(c -> this.customerCheckPatternDas.logicDeleteById(c.getId()));
        }
    }

    private void extracted(CheckPatternTypeEnum reqCheckPatternTypeEnum, List<CustomerRespDto> mergeCustomerRespDtoList, List<CustomerCheckPatternEo> customerCheckPatterns) {
        if (org.springframework.util.CollectionUtils.isEmpty(customerCheckPatterns)) {
            return;
        }
        CustomerCheckPatternEo customerCheckPattern = (CustomerCheckPatternEo)customerCheckPatterns.stream().findFirst().get();
        CheckPatternTypeEnum checkPatternTypeEnum = CheckPatternTypeEnum.enumOfType((Integer)customerCheckPattern.getPatternType());
        AssertUtil.notNull((Object)checkPatternTypeEnum, (String)"\u5f53\u524d\u8003\u6838\u65b9\u5f0f\u4e0d\u5b58\u5728\uff01");
        if (checkPatternTypeEnum.equals((Object)CheckPatternTypeEnum.SEPARATE_CHECK) && reqCheckPatternTypeEnum.equals((Object)CheckPatternTypeEnum.MERGE_CHECK)) {
            Map<BizChannelEnum, List<CustomerRespDto>> customerGroupByChannel = mergeCustomerRespDtoList.stream().collect(Collectors.groupingBy(key -> this.storeAndSalesmanHelper.calculateBizChannel(key.getThirdPartyId())));
            List<CustomerRespDto> orDefault = customerGroupByChannel.getOrDefault(BizChannelEnum.LIFE_SPACE, Lists.newArrayList());
            List orgIds = orDefault.stream().map(CustomerRespDto::getOrgInfoId).collect(Collectors.toList());
            CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
            customerCheckRelationReqDto.setOrgIds(orgIds);
            List<CustomerCheckRelationRespDto> customerCheckRelationRespDtos = this.customerCheckRelationService.queryByStoreIds(customerCheckRelationReqDto);
            if (!org.springframework.util.CollectionUtils.isEmpty(customerCheckRelationRespDtos)) {
                customerCheckRelationRespDtos.forEach(c -> this.customerCheckPatternDas.logicDeleteById(c.getId()));
            }
        }
    }

    @Override
    public void modifyCustomerCheckPattern(CustomerCheckPatternReqDto modifyReqDto) {
        CustomerCheckPatternEo customerCheckPatternEo = new CustomerCheckPatternEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerCheckPatternEo);
        this.customerCheckPatternDas.updateSelective((BaseEo)customerCheckPatternEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerCheckPattern(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerCheckPatternDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CustomerCheckPatternRespDto queryById(Long id) {
        CustomerCheckPatternEo customerCheckPatternEo = (CustomerCheckPatternEo)this.customerCheckPatternDas.selectByPrimaryKey(id);
        CustomerCheckPatternRespDto customerCheckPatternRespDto = new CustomerCheckPatternRespDto();
        DtoHelper.eo2Dto((BaseEo)customerCheckPatternEo, (BaseVo)customerCheckPatternRespDto);
        return customerCheckPatternRespDto;
    }

    @Override
    public PageInfo<CustomerCheckPatternRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerCheckPatternReqDto customerCheckPatternReqDto = (CustomerCheckPatternReqDto)JSON.parseObject((String)filter, CustomerCheckPatternReqDto.class);
        CustomerCheckPatternEo customerCheckPatternEo = new CustomerCheckPatternEo();
        DtoHelper.dto2Eo((BaseVo)customerCheckPatternReqDto, (BaseEo)customerCheckPatternEo);
        PageInfo eoPageInfo = this.customerCheckPatternDas.selectPage((BaseEo)customerCheckPatternEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerCheckPatternRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<CustomerCheckPatternRespDto> selectCustomerCheckPatternByCode(CustomerCheckPatternReqDto customerCheckPatternReqDto) {
        List customerCheckPatternEos = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(customerCheckPatternReqDto);
        ArrayList<CustomerCheckPatternRespDto> dtoList = new ArrayList<CustomerCheckPatternRespDto>();
        DtoHelper.eoList2DtoList((Collection)customerCheckPatternEos, dtoList, CustomerCheckPatternRespDto.class);
        return dtoList;
    }
}

