/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreGovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternConfigReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckPatternConfigDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckPatternConfigRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckPatternConfigService;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerCheckPatternConfigDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerCheckPatternConfigEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CustomerCheckPatternConfigServiceImpl
implements ICustomerCheckPatternConfigService {
    @Resource
    private CustomerCheckPatternConfigDas customerCheckPatternConfigDas;

    @Override
    public Long addCustomerCheckPatternConfig(CustomerCheckPatternConfigReqDto addReqDto) {
        CustomerCheckPatternConfigEo customerCheckPatternConfigEo = new CustomerCheckPatternConfigEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerCheckPatternConfigEo);
        this.customerCheckPatternConfigDas.insert((BaseEo)customerCheckPatternConfigEo);
        return customerCheckPatternConfigEo.getId();
    }

    @Override
    public void saveOrUpdateCustomerCheckPatternConfig(CustomerCheckPatternConfigReqDto addReqDto) {
        StoreGovernTypeEnum storeGovernTypeEnum = StoreGovernTypeEnum.enumOfCode((String)addReqDto.getConfigType());
        Assert.isTrue((null == storeGovernTypeEnum ? 1 : 0) != 0, (String)"0001", (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u914d\u7f6e\u7c7b\u578b");
        Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)addReqDto.getConfigContentLists()), (String)"0001", (String)"\u914d\u7f6e\u5185\u5bb9\u4e3a\u7a7a");
        CustomerCheckPatternConfigEo customerCheckPatternConfigEo = new CustomerCheckPatternConfigEo();
        customerCheckPatternConfigEo.setConfigType(storeGovernTypeEnum.getCode());
        customerCheckPatternConfigEo.setOrganizationId(addReqDto.getOrganizationId());
        this.customerCheckPatternConfigDas.delete((BaseEo)customerCheckPatternConfigEo);
        List collect = addReqDto.getConfigContentLists().stream().map(config -> {
            CustomerCheckPatternConfigEo customerCheckPatternConfig = new CustomerCheckPatternConfigEo();
            customerCheckPatternConfig.setConfigType(storeGovernTypeEnum.getCode());
            customerCheckPatternConfig.setConfigContent(config);
            customerCheckPatternConfig.setOrganizationId(addReqDto.getOrganizationId());
            return customerCheckPatternConfig;
        }).collect(Collectors.toList());
        int result = this.customerCheckPatternConfigDas.insertBatch(collect);
        Assert.isTrue((result > 0 ? 1 : 0) != 0, (String)"0001", (String)"\u767d\u540d\u5355\u914d\u7f6e\u5931\u8d25");
    }

    @Override
    public void modifyCustomerCheckPatternConfig(CustomerCheckPatternConfigReqDto modifyReqDto) {
        CustomerCheckPatternConfigEo customerCheckPatternConfigEo = new CustomerCheckPatternConfigEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerCheckPatternConfigEo);
        this.customerCheckPatternConfigDas.updateSelective((BaseEo)customerCheckPatternConfigEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerCheckPatternConfig(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerCheckPatternConfigDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CustomerCheckPatternConfigRespDto queryById(Long id) {
        CustomerCheckPatternConfigEo customerCheckPatternConfigEo = (CustomerCheckPatternConfigEo)this.customerCheckPatternConfigDas.selectByPrimaryKey(id);
        CustomerCheckPatternConfigRespDto customerCheckPatternConfigRespDto = new CustomerCheckPatternConfigRespDto();
        DtoHelper.eo2Dto((BaseEo)customerCheckPatternConfigEo, (BaseVo)customerCheckPatternConfigRespDto);
        return customerCheckPatternConfigRespDto;
    }

    @Override
    public PageInfo<CustomerCheckPatternConfigRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerCheckPatternConfigReqDto customerCheckPatternConfigReqDto = (CustomerCheckPatternConfigReqDto)JSON.parseObject((String)filter, CustomerCheckPatternConfigReqDto.class);
        StoreGovernTypeEnum storeGovernTypeEnum = StoreGovernTypeEnum.enumOfCode((String)customerCheckPatternConfigReqDto.getConfigType());
        Assert.isTrue((null == storeGovernTypeEnum ? 1 : 0) != 0, (String)"0001", (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u914d\u7f6e\u7c7b\u578b");
        CustomerCheckPatternConfigEo customerCheckPatternConfigEo = new CustomerCheckPatternConfigEo();
        DtoHelper.dto2Eo((BaseVo)customerCheckPatternConfigReqDto, (BaseEo)customerCheckPatternConfigEo);
        PageInfo eoPageInfo = this.customerCheckPatternConfigDas.selectPage((BaseEo)customerCheckPatternConfigEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerCheckPatternConfigRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public CustomerCheckPatternConfigDetailRespDto calculateConfigTotal(Long orgId) {
        CustomerCheckPatternConfigDetailRespDto customerCheckPatternConfigDetailRespDto = new CustomerCheckPatternConfigDetailRespDto();
        CustomerCheckPatternConfigEo customerCheckPatternConfigEo = new CustomerCheckPatternConfigEo();
        customerCheckPatternConfigEo.setOrganizationId(orgId);
        PageInfo eoPageInfo = this.customerCheckPatternConfigDas.selectPage((BaseEo)customerCheckPatternConfigEo, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        if (CollectionUtils.isEmpty((Collection)eoPageInfo.getList())) {
            Map<String, List<CustomerCheckPatternConfigEo>> collect = eoPageInfo.getList().stream().collect(Collectors.groupingBy(CustomerCheckPatternConfigEo::getConfigType));
            customerCheckPatternConfigDetailRespDto.setAreaConfigTotal(Integer.valueOf(collect.getOrDefault(StoreGovernTypeEnum.AREA.getCode(), Lists.newArrayList()).size()));
            customerCheckPatternConfigDetailRespDto.setStoreConfigTotal(Integer.valueOf(collect.getOrDefault(StoreGovernTypeEnum.STORE.getCode(), Lists.newArrayList()).size()));
            customerCheckPatternConfigDetailRespDto.setParentStoreConfigTotal(Integer.valueOf(collect.getOrDefault(StoreGovernTypeEnum.STORE_PARENT.getCode(), Lists.newArrayList()).size()));
            customerCheckPatternConfigDetailRespDto.setBlackListConfigTotal(Integer.valueOf(collect.getOrDefault(StoreGovernTypeEnum.BLACKLIST.getCode(), Lists.newArrayList()).size()));
        }
        return customerCheckPatternConfigDetailRespDto;
    }
}

