/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.yundt.cube.center.customer.api.constants.RoBootAccessTokenEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.GovernStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.GovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.DingTaskReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreModifyRecordRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernContentRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerRelateRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckRelationService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernContentService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerRelateService;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreSellerGovernDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreSellerRelateDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreSellerGovernEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreSellerRelateEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.biz.service.IStoreService;
import com.yx.tcbj.center.customer.biz.util.DingTaskUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StoreSellerRelateServiceImpl
implements IStoreSellerRelateService {
    Logger logger = LoggerFactory.getLogger(StoreSellerRelateServiceImpl.class);
    @Resource
    private StoreSellerRelateDas storeSellerRelateDas;
    @Resource
    private StoreSellerGovernDas storeSellerGovernDas;
    @Resource
    private ILockService lockService;
    @Resource
    private StoreDas storeDas;
    @Resource
    private IStoreSellerGovernContentService storeSellerGovernContentService;
    @Resource
    private IStoreSellerGovernService storeSellerGovernService;
    @Resource
    private IStoreService storeService;
    @Resource
    private ICustomerCheckRelationService customerCheckRelationService;
    @Resource
    private DingTaskUtils dingTaskUtils;
    @Resource
    private IContext context;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void buildStoreSellerRelate(Long sellerId, Long orgId, String username) {
        this.logger.info("\u6784\u5efa\u5546\u5bb6\u7ba1\u8f96\u836f\u5e97\u7684\u5173\u7cfb\u6570\u636e\uff1a{}=={}", (Object)sellerId, (Object)orgId);
        if (ObjectUtils.isEmpty((Object)sellerId) || ObjectUtils.isEmpty((Object)orgId)) {
            return;
        }
        this.buildStoreSellerRelateProcess(sellerId, orgId, username);
        this.storeSellerGovernService.changeStoreSellerGovernStatus(sellerId, orgId, GovernStatusEnum.OVER);
    }

    @Override
    public void deleteStoreSellerRelate(Long sellerId) {
        if (ObjectUtils.isEmpty((Object)sellerId)) {
            return;
        }
        this.deleteRelate(sellerId, null);
    }

    @Override
    public void updateRelateByStoreChange(List<String> storeIds) {
        this.logger.info("{}\u836f\u5e97\u533a\u57df\u51fa\u73b0\u53d8\u66f4\uff0c\u66f4\u65b0\u7ba1\u8f96\u5173\u8054\u6570\u636e", (Object)JSON.toJSONString(storeIds));
        List<StoreRespDto> list = this.storeService.queryListByIds(storeIds);
        List collect = list.stream().map(c -> c.getStoreId()).collect(Collectors.toList());
        StoreSellerRelateEo storeSellerRelateEo = new StoreSellerRelateEo();
        storeSellerRelateEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"store_id", collect)}));
        List relateList = this.storeSellerRelateDas.select((BaseEo)storeSellerRelateEo);
        Map<String, List<StoreSellerRelateEo>> storeRelateMap = relateList.stream().collect(Collectors.groupingBy(StoreSellerRelateEo::getStoreId));
        ArrayList typeEnumList = Lists.newArrayList((Object[])new GovernTypeEnum[]{GovernTypeEnum.AREA, GovernTypeEnum.STOREPARENT});
        typeEnumList.forEach(c -> {
            this.delTargetRelate(storeRelateMap, (Collection<StoreRespDto>)list, (GovernTypeEnum)c);
            this.dealStoreChangeAndCreateRelate((Collection<StoreRespDto>)list, (GovernTypeEnum)c);
        });
    }

    @Override
    public void updateRelateByModifyRecord(List<StoreModifyRecordRespDto> storeModifyRecordRespDtos) {
        this.logger.info("\u836f\u5e97\u533a\u57df\u51fa\u73b0\u53d8\u66f4\uff0c\u66f4\u65b0\u7ba1\u8f96\u5173\u8054\u6570\u636e");
        List<String> storeIds = storeModifyRecordRespDtos.stream().map(c -> c.getStoreId()).collect(Collectors.toList());
        List<StoreRespDto> list = this.storeService.queryListByIds(storeIds);
        Map<String, StoreRespDto> storeRespDtoMap = list.stream().collect(Collectors.toMap(key -> key.getStoreId(), val -> val, (k1, k2) -> k2));
        StoreSellerRelateEo storeSellerRelateEo = new StoreSellerRelateEo();
        storeSellerRelateEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"store_id", storeRespDtoMap.keySet())}));
        List relateList = this.storeSellerRelateDas.select((BaseEo)storeSellerRelateEo);
        Map<String, List<StoreSellerRelateEo>> storeRelateMap = relateList.stream().collect(Collectors.groupingBy(StoreSellerRelateEo::getStoreId));
        Map<String, List<StoreModifyRecordRespDto>> modifyRecordMap = storeModifyRecordRespDtos.stream().collect(Collectors.groupingBy(c -> c.getStoreId()));
        modifyRecordMap.keySet().forEach(c -> {
            List<String> collect = ((List)modifyRecordMap.get(c)).stream().map(respDto -> Arrays.asList(respDto.getModifyCode().split(","))).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            collect.forEach(code -> {
                this.delTargetRelate(storeRelateMap, Arrays.asList((StoreRespDto)storeRespDtoMap.get(c)), GovernTypeEnum.fromCode((String)code));
                this.dealStoreChangeAndCreateRelate(Arrays.asList((StoreRespDto)storeRespDtoMap.get(c)), GovernTypeEnum.fromCode((String)code));
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealStoreChangeAndCreateRelate(Collection<StoreRespDto> list, GovernTypeEnum governTypeEnum) {
        for (StoreRespDto store : list) {
            Mutex mutex = null;
            ArrayList storeSellerGoverns = Lists.newArrayList();
            switch (governTypeEnum) {
                case STOREPARENT: {
                    if (!StringUtils.isNotBlank((CharSequence)store.getParentSocialCreditNum())) break;
                    List<StoreRespDto> storeRespDtoList = this.storeService.querySocialCreditNums(Arrays.asList(store.getParentSocialCreditNum()));
                    Assert.notNull(storeRespDtoList, (String)"0001", (String)"\u6821\u9a8c\u95e8\u5e97\u6570\u636e\u51fa\u73b0\u5f02\u5e38");
                    StoreRespDto respDto = (StoreRespDto)storeRespDtoList.stream().findFirst().get();
                    storeSellerGoverns.addAll(this.storeSellerGovernService.queryByParentStoreId(respDto.getStoreId()));
                    break;
                }
                case AREA: {
                    StoreReqDto reqDto = new StoreReqDto();
                    CubeBeanUtils.copyProperties((Object)reqDto, (Object)store, (String[])new String[0]);
                    storeSellerGoverns.addAll(this.storeSellerGovernService.queryByStore(reqDto));
                }
            }
            for (StoreSellerGovernRespDto dto : storeSellerGoverns) {
                try {
                    mutex = this.lockService.lock("buildStoreSellerRelate", dto.getSellerId().toString(), 10, 5, TimeUnit.MINUTES);
                    this.verifyStoreSellerRelateStatus(dto.getSellerId());
                    this.storeSellerGovernService.changeStoreSellerGovernStatus(dto.getSellerId(), dto.getOrganizationId(), GovernStatusEnum.DEAL);
                    StoreSellerRelateEo eo = new StoreSellerRelateEo();
                    eo.setOrganizationId(dto.getOrganizationId());
                    eo.setSellerId(dto.getSellerId());
                    eo.setGovernSource(governTypeEnum.getCode());
                    eo.setStoreId(store.getStoreId());
                    List collect = this.storeSellerRelateDas.select((BaseEo)eo);
                    if (CollectionUtils.isEmpty((Collection)collect)) {
                        eo.setGovernSource(governTypeEnum.getCode());
                        this.storeSellerRelateDas.insert((BaseEo)eo);
                    }
                    this.storeSellerGovernService.changeStoreSellerGovernStatus(dto.getSellerId(), dto.getOrganizationId(), GovernStatusEnum.OVER);
                }
                catch (Throwable throwable) {
                    this.lockService.unlock(mutex);
                    throw throwable;
                }
                this.lockService.unlock(mutex);
            }
        }
    }

    private void delTargetRelate(Map<String, List<StoreSellerRelateEo>> storeRelateMap, Collection<StoreRespDto> dealList, GovernTypeEnum governTypeEnum) {
        if (ObjectUtils.isNotEmpty(storeRelateMap)) {
            dealList.forEach(store -> {
                List orDefault = storeRelateMap.getOrDefault(store.getStoreId(), Lists.newArrayList());
                List relateEoList = orDefault.stream().filter(c -> c.getGovernSource().equals(governTypeEnum.getCode())).collect(Collectors.toList());
                Mutex mutex = null;
                for (StoreSellerRelateEo relateEo : relateEoList) {
                    try {
                        mutex = this.lockService.lock("buildStoreSellerRelate", relateEo.getSellerId().toString(), 10, 5, TimeUnit.MINUTES);
                        this.verifyStoreSellerRelateStatus(relateEo.getSellerId());
                        this.storeSellerGovernService.changeStoreSellerGovernStatus(relateEo.getSellerId(), relateEo.getOrganizationId(), GovernStatusEnum.DEAL);
                        this.deleteRelateByStore(store.getStoreId(), governTypeEnum);
                        this.storeSellerGovernService.changeStoreSellerGovernStatus(relateEo.getSellerId(), relateEo.getOrganizationId(), GovernStatusEnum.OVER);
                    }
                    catch (Throwable throwable) {
                        this.lockService.unlock(mutex);
                        throw throwable;
                    }
                    this.lockService.unlock(mutex);
                }
            });
        }
    }

    private synchronized void verifyStoreSellerRelateStatus(Long sellerId) {
        this.logger.info("\u6821\u9a8c\u5546\u5bb6[{}]\u7ba1\u8f96\u5206\u914d\u72b6\u6001", (Object)sellerId);
        StoreSellerGovernEo storeSellerGovernEo = new StoreSellerGovernEo();
        storeSellerGovernEo.setSellerId(sellerId);
        StoreSellerGovernEo sellerGovernEo = (StoreSellerGovernEo)this.storeSellerGovernDas.selectOne((BaseEo)storeSellerGovernEo);
        if (!sellerGovernEo.getRelateStatus().equals(GovernStatusEnum.OVER.getKey())) {
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.verifyStoreSellerRelateStatus(sellerId);
        }
    }

    @Override
    public List<StoreSellerRelateRespDto> queryStoreSellerRelateBySellerId(Long sellerId, List<String> storeIds) {
        Assert.notNull((Object)sellerId, (String)"0001", (String)"\u5546\u5bb6Id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        Assert.notNull(storeIds, (String)"0001", (String)"\u95e8\u5e97id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        StoreSellerRelateEo storeSellerRelateEo = new StoreSellerRelateEo();
        storeSellerRelateEo.setSellerId(sellerId);
        storeSellerRelateEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"store_id", storeIds)}));
        List select = this.storeSellerRelateDas.select((BaseEo)storeSellerRelateEo);
        ArrayList storeSellerRelateRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)select, (Collection)storeSellerRelateRespDtos, StoreSellerRelateRespDto.class);
        return storeSellerRelateRespDtos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildStoreSellerRelateProcess(Long sellerId, Long orgId, String username) {
        List<StoreSellerGovernContentRespDto> governContentList;
        Mutex mutex;
        block9: {
            this.logger.info("\u6267\u884c\u6784\u5efa\u5546\u5bb6\u7ba1\u8f96\u836f\u5e97\u7684\u5173\u7cfb\u6570\u636e\u8fc7\u7a0b\uff1a{}=={}", (Object)sellerId, (Object)orgId);
            mutex = null;
            mutex = this.lockService.lock("buildStoreSellerRelate", sellerId.toString(), 10, 5, TimeUnit.MINUTES);
            this.deleteRelate(sellerId, null);
            governContentList = this.storeSellerGovernContentService.queryGovernContentByOrgId(orgId);
            if (!CollectionUtil.isEmpty(governContentList)) break block9;
            this.lockService.unlock(mutex);
            return;
        }
        try {
            ArrayList<String> areas = new ArrayList<String>();
            ArrayList storeIds = new ArrayList();
            ArrayList<String> blacklistIds = new ArrayList<String>();
            ArrayList storeParentIds = new ArrayList();
            governContentList.forEach(dto -> {
                if (dto.getGovernType().equals(GovernTypeEnum.AREA.getCode())) {
                    areas.add(dto.getGovernContent());
                    return;
                }
                if (dto.getGovernType().equals(GovernTypeEnum.STORE.getCode())) {
                    storeIds.add(dto.getGovernContent());
                    return;
                }
                if (dto.getGovernType().equals(GovernTypeEnum.BLACKLIST.getCode())) {
                    blacklistIds.add(dto.getGovernContent());
                    return;
                }
                if (dto.getGovernType().equals(GovernTypeEnum.STOREPARENT.getCode())) {
                    storeParentIds.add(dto.getGovernContent());
                    return;
                }
            });
            ArrayList insertList = new ArrayList();
            if (CollectionUtil.isNotEmpty(areas)) {
                List<String> stores = this.storeService.queryByArea(areas);
                stores.forEach(storeId -> {
                    StoreSellerRelateEo eo = new StoreSellerRelateEo();
                    eo.setOrganizationId(orgId);
                    eo.setSellerId(sellerId);
                    eo.setGovernSource(GovernTypeEnum.AREA.getCode());
                    eo.setStoreId(storeId);
                    insertList.add(eo);
                });
            }
            if (CollectionUtil.isNotEmpty(storeIds)) {
                storeIds.forEach(storeId -> {
                    StoreSellerRelateEo eo = new StoreSellerRelateEo();
                    eo.setOrganizationId(orgId);
                    eo.setSellerId(sellerId);
                    eo.setGovernSource(GovernTypeEnum.STORE.getCode());
                    eo.setStoreId(storeId);
                    insertList.add(eo);
                });
            }
            if (CollectionUtil.isNotEmpty(storeParentIds)) {
                StoreEo storeEo = new StoreEo();
                storeEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"store_id", storeParentIds)}));
                List storeEos = this.storeDas.select((BaseEo)storeEo);
                Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)storeEos), (String)"0001", (String)"\u5f53\u524d\u4e0a\u4f20\u7236\u7ea7\u836f\u5e97\u4e0d\u5b58\u5728\uff01\uff01\uff01");
                StoreEo store = new StoreEo();
                List creditNum = storeEos.stream().map(c -> c.getSocialCreditNum()).collect(Collectors.toList());
                store.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"parent_social_credit_num", creditNum)}));
                List storeChildren = this.storeDas.select((BaseEo)store);
                Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)storeChildren), (String)"0001", (String)"\u5f53\u524d\u4e0a\u4f20\u7236\u7ea7\u836f\u5e97\u4e0d\u5b58\u5728\u4e0b\u7ea7\u95e8\u5e97\uff01\uff01\uff01");
                storeChildren.forEach(storeId -> {
                    StoreSellerRelateEo eo = new StoreSellerRelateEo();
                    eo.setOrganizationId(orgId);
                    eo.setSellerId(sellerId);
                    eo.setGovernSource(GovernTypeEnum.STOREPARENT.getCode());
                    eo.setStoreId(storeId.getStoreId());
                    insertList.add(eo);
                });
            }
            Map<String, StoreSellerRelateEo> collect = insertList.stream().collect(Collectors.toMap(StoreSellerRelateEo::getStoreId, v -> v, (key1, key2) -> key2));
            this.storeSellerRelateDas.insertBatch((List)Lists.newArrayList(collect.values()));
            if (CollectionUtil.isNotEmpty(blacklistIds)) {
                this.deleteRelate(sellerId, blacklistIds);
            }
            List<String> enableRecord = collect.values().stream().filter(c -> !blacklistIds.contains(c.getStoreId())).map(c -> c.getStoreId()).collect(Collectors.toList());
            this.customerCheckRelationService.customerRelationToTenantScope(orgId, enableRecord);
        }
        catch (Exception e) {
            try {
                this.logger.info("\u51fa\u73b0\u5f02\u5e38\u5f00\u59cb\u53d1\u9001\u9489\u9489\u6d88\u606f : {} ", (Object)e.getMessage());
                DingTaskReqDto.ActionCard actionCard = new DingTaskReqDto.ActionCard(String.format(DingTaskUtils.SELLER_RELATION_WARN_CONTENT, RoBootAccessTokenEnum.STORE_SELLER_RELATION_ROBOOT.getDesc(), sellerId, e.getMessage(), username, LocalDate.now()), RoBootAccessTokenEnum.STORE_SELLER_RELATION_ROBOOT.getTitle());
                DingTaskReqDto dingTaskReqDto = new DingTaskReqDto();
                dingTaskReqDto.setMsgtype(RoBootAccessTokenEnum.STORE_SELLER_RELATION_ROBOOT.getContentModel());
                dingTaskReqDto.setActionCard(actionCard);
                this.dingTaskUtils.dingTalkRobot(RoBootAccessTokenEnum.STORE_SELLER_RELATION_ROBOOT.getAccessToken(), com.dtyunxi.huieryun.core.util.JSON.toJsonString((Object)dingTaskReqDto));
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                this.lockService.unlock(mutex);
                throw throwable;
            }
            this.lockService.unlock(mutex);
        }
        this.lockService.unlock(mutex);
    }

    private void deleteRelate(Long sellerId, List<String> storeIds) {
        if (ObjectUtils.isEmpty((Object)sellerId)) {
            return;
        }
        StoreSellerRelateEo params = new StoreSellerRelateEo();
        params.setSellerId(sellerId);
        if (CollectionUtil.isNotEmpty(storeIds)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"store_id", storeIds));
            sqlFilters.add(SqlFilter.in((String)"seller_id", (Object)sellerId));
            params.setSqlFilters(sqlFilters);
        }
        this.storeSellerRelateDas.delete((BaseEo)params);
    }

    private void deleteRelateByStore(String storeId, GovernTypeEnum governTypeEnum) {
        if (StringUtils.isEmpty((CharSequence)storeId)) {
            return;
        }
        StoreSellerRelateEo params = new StoreSellerRelateEo();
        params.setStoreId(storeId);
        params.setGovernSource(governTypeEnum.getCode());
        this.storeSellerRelateDas.delete((BaseEo)params);
    }
}

