/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreGovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.GovernStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.GovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreGovernAllotReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreSellerGovernContentReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernContentRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernContentService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerRelateService;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreSellerGovernContentDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreSellerGovernContentEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StoreSellerGovernContentServiceImpl
implements IStoreSellerGovernContentService {
    private Logger logger = LoggerFactory.getLogger(StoreSellerGovernContentServiceImpl.class);
    @Resource
    private StoreSellerGovernContentDas storeSellerGovernContentDas;
    @Resource
    private StoreDas storeDas;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;
    @Resource
    private IStoreSellerGovernService storeSellerGovernService;
    @Resource
    private IStoreSellerRelateService storeSellerRelateService;
    @Resource
    private IContext context;

    @Override
    public Long addStoreSellerGovernContent(StoreSellerGovernContentReqDto addReqDto) {
        StoreSellerGovernContentEo storeSellerGovernContentEo = new StoreSellerGovernContentEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)storeSellerGovernContentEo);
        this.storeSellerGovernContentDas.insert((BaseEo)storeSellerGovernContentEo);
        return storeSellerGovernContentEo.getId();
    }

    @Override
    public void modifyStoreSellerGovernContent(StoreSellerGovernContentReqDto modifyReqDto) {
        StoreSellerGovernContentEo storeSellerGovernContentEo = new StoreSellerGovernContentEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)storeSellerGovernContentEo);
        this.storeSellerGovernContentDas.updateSelective((BaseEo)storeSellerGovernContentEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStoreSellerGovernContent(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.storeSellerGovernContentDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public StoreSellerGovernContentRespDto queryById(Long id) {
        StoreSellerGovernContentEo storeSellerGovernContentEo = (StoreSellerGovernContentEo)this.storeSellerGovernContentDas.selectByPrimaryKey(id);
        StoreSellerGovernContentRespDto storeSellerGovernContentRespDto = new StoreSellerGovernContentRespDto();
        DtoHelper.eo2Dto((BaseEo)storeSellerGovernContentEo, (BaseVo)storeSellerGovernContentRespDto);
        return storeSellerGovernContentRespDto;
    }

    @Override
    public PageInfo<StoreSellerGovernContentRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        StoreSellerGovernContentReqDto storeSellerGovernContentReqDto = (StoreSellerGovernContentReqDto)JSON.parseObject((String)filter, StoreSellerGovernContentReqDto.class);
        StoreSellerGovernContentEo storeSellerGovernContentEo = new StoreSellerGovernContentEo();
        DtoHelper.dto2Eo((BaseVo)storeSellerGovernContentReqDto, (BaseEo)storeSellerGovernContentEo);
        PageInfo eoPageInfo = this.storeSellerGovernContentDas.selectPage((BaseEo)storeSellerGovernContentEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, StoreSellerGovernContentRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<StoreSellerGovernContentRespDto> queryByStoreSellerIds(List<Long> storeSellerId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"store_seller_id", storeSellerId);
        wrapper.eq((Object)"dr", (Object)0);
        List result = this.storeSellerGovernContentDas.getMapper().selectList((Wrapper)wrapper);
        ArrayList<StoreSellerGovernContentRespDto> dtoList = new ArrayList<StoreSellerGovernContentRespDto>();
        DtoHelper.eoList2DtoList((Collection)result, dtoList, StoreSellerGovernContentRespDto.class);
        return dtoList;
    }

    @Override
    public List<StoreSellerGovernContentRespDto> queryByStoreSellerId(Long storeSellerId) {
        StoreSellerGovernContentEo eo = new StoreSellerGovernContentEo();
        eo.setStoreSellerId(storeSellerId);
        List result = this.storeSellerGovernContentDas.select((BaseEo)eo);
        ArrayList<StoreSellerGovernContentRespDto> dtoList = new ArrayList<StoreSellerGovernContentRespDto>();
        DtoHelper.eoList2DtoList((Collection)result, dtoList, StoreSellerGovernContentRespDto.class);
        return dtoList;
    }

    @Override
    public void updateGovernContent(Long id, String governContent) {
        StoreSellerGovernContentEo eo = (StoreSellerGovernContentEo)this.storeSellerGovernContentDas.selectByPrimaryKey(id);
        if (Objects.nonNull(eo)) {
            eo.setGovernContent(governContent);
            this.storeSellerGovernContentDas.update((BaseEo)eo);
        }
    }

    @Override
    public void deleteStoreGovernContent(Long storeSellerId, String governType) {
        this.logger.info("\u6839\u636e\u5546\u5bb6\u836f\u5e97\u5206\u914d\u5220\u9664\u6307\u5b9a\u5206\u914d\u5185\u5bb9\u7c7b\u578b\u4fe1\u606f\uff1a{}=={}", (Object)storeSellerId, (Object)governType);
        if (ObjectUtils.isEmpty((Object)storeSellerId) || StringUtils.isEmpty((String)governType)) {
            return;
        }
        StoreSellerGovernContentEo params = new StoreSellerGovernContentEo();
        params.setStoreSellerId(storeSellerId);
        params.setGovernType(governType);
        this.storeSellerGovernContentDas.logicDelete((BaseEo)params);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStoreSellerGovernArea(StoreGovernAllotReqDto reqDto) {
        if (ObjectUtils.isEmpty((Object)reqDto.getId()) || reqDto.getAreas() == null) {
            throw new BizException("-1", "id\u3001areas\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StoreSellerGovernRespDto storeSellerGovern = this.storeSellerGovernService.queryStoreSellerGovernByID(reqDto.getId(), null);
        if (ObjectUtils.isEmpty((Object)storeSellerGovern)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u8be5\u5546\u5bb6\u7ba1\u8f96\u5206\u914d\u4fe1\u606f");
        }
        Assert.isTrue((boolean)storeSellerGovern.getRelateStatus().equals(GovernStatusEnum.OVER.getKey()), (String)"0001", (String)"\u5f53\u524d\u5546\u5bb6\u836f\u5e97\u7ba1\u8f96\u5173\u7cfb\u6b63\u5728\u751f\u6210\u4e2d");
        this.deleteStoreGovernContent(storeSellerGovern.getId(), GovernTypeEnum.AREA.getCode());
        this.dealStoreGovernContent(storeSellerGovern, reqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStoreSellerGovernStore(StoreGovernAllotReqDto reqDto) {
        if (ObjectUtils.isEmpty((Object)reqDto.getId()) || reqDto.getStoreIds() == null) {
            throw new BizException("-1", "id\u3001storeIds\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StoreSellerGovernRespDto storeSellerGovern = this.storeSellerGovernService.queryStoreSellerGovernByID(reqDto.getId(), null);
        if (ObjectUtils.isEmpty((Object)storeSellerGovern)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u8be5\u5546\u5bb6\u7ba1\u8f96\u5206\u914d\u4fe1\u606f");
        }
        Assert.isTrue((boolean)storeSellerGovern.getRelateStatus().equals(GovernStatusEnum.OVER.getKey()), (String)"0001", (String)"\u5f53\u524d\u5546\u5bb6\u836f\u5e97\u7ba1\u8f96\u5173\u7cfb\u6b63\u5728\u751f\u6210\u4e2d");
        this.deleteStoreGovernContent(storeSellerGovern.getId(), GovernTypeEnum.STORE.getCode());
        this.dealStoreGovernContent(storeSellerGovern, reqDto);
    }

    @Override
    public void updateStoreSellerGovernStoreParent(StoreGovernAllotReqDto reqDto) {
        if (ObjectUtils.isEmpty((Object)reqDto.getId()) || reqDto.getStoreParentIds() == null) {
            throw new BizException("-1", "id\u3001storeIds\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StoreSellerGovernRespDto storeSellerGovern = this.storeSellerGovernService.queryStoreSellerGovernByID(reqDto.getId(), null);
        if (ObjectUtils.isEmpty((Object)storeSellerGovern)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u8be5\u5546\u5bb6\u7ba1\u8f96\u5206\u914d\u4fe1\u606f");
        }
        Assert.isTrue((boolean)storeSellerGovern.getRelateStatus().equals(GovernStatusEnum.OVER.getKey()), (String)"0001", (String)"\u5f53\u524d\u5546\u5bb6\u836f\u5e97\u7ba1\u8f96\u5173\u7cfb\u6b63\u5728\u751f\u6210\u4e2d");
        this.deleteStoreGovernContent(storeSellerGovern.getId(), GovernTypeEnum.STOREPARENT.getCode());
        this.dealStoreGovernContent(storeSellerGovern, reqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStoreSellerGovernBlacklist(StoreGovernAllotReqDto reqDto) {
        if (ObjectUtils.isEmpty((Object)reqDto.getId()) || reqDto.getBlacklistIds() == null) {
            throw new BizException("-1", "id\u3001blacklistIds\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StoreSellerGovernRespDto storeSellerGovern = this.storeSellerGovernService.queryStoreSellerGovernByID(reqDto.getId(), null);
        if (ObjectUtils.isEmpty((Object)storeSellerGovern)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u8be5\u5546\u5bb6\u7ba1\u8f96\u5206\u914d\u4fe1\u606f");
        }
        Assert.isTrue((boolean)storeSellerGovern.getRelateStatus().equals(GovernStatusEnum.OVER.getKey()), (String)"0001", (String)"\u5f53\u524d\u5546\u5bb6\u836f\u5e97\u7ba1\u8f96\u5173\u7cfb\u6b63\u5728\u751f\u6210\u4e2d");
        this.deleteStoreGovernContent(storeSellerGovern.getId(), GovernTypeEnum.BLACKLIST.getCode());
        this.dealStoreGovernContent(storeSellerGovern, reqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void dealStoreGovernContent(StoreSellerGovernRespDto storeSellerGovern, StoreGovernAllotReqDto governContent) {
        this.logger.info("\u5904\u7406\u5546\u5bb6\u836f\u5e97\u7ba1\u8f96\u5206\u914d\u5185\u5bb9\uff1a{}==={}", (Object)JSON.toJSONString((Object)storeSellerGovern), (Object)JSON.toJSONString((Object)governContent));
        if (ObjectUtils.isEmpty((Object)storeSellerGovern) || ObjectUtils.isEmpty((Object)governContent)) {
            throw new BizException("-1", "\u53c2\u6570\u8bf7\u6c42\u5f02\u5e38");
        }
        ArrayList insertGovernContentList = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)governContent.getAreas())) {
            governContent.getAreas().forEach(area -> {
                StoreSellerGovernContentEo eo = new StoreSellerGovernContentEo();
                eo.setStoreSellerId(storeSellerGovern.getId());
                eo.setOrganizationId(storeSellerGovern.getOrganizationId());
                eo.setGovernType(GovernTypeEnum.AREA.getCode());
                eo.setGovernContent(area);
                insertGovernContentList.add(eo);
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)governContent.getStoreIds())) {
            governContent.getStoreIds().forEach(store -> {
                StoreSellerGovernContentEo eo = new StoreSellerGovernContentEo();
                eo.setStoreSellerId(storeSellerGovern.getId());
                eo.setOrganizationId(storeSellerGovern.getOrganizationId());
                eo.setGovernType(GovernTypeEnum.STORE.getCode());
                eo.setGovernContent(store);
                insertGovernContentList.add(eo);
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)governContent.getStoreParentIds())) {
            StoreEo storeEo = new StoreEo();
            storeEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"store_id", (Object)governContent.getStoreParentIds())}));
            List storeEos = this.storeDas.select((BaseEo)storeEo);
            Assert.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)storeEos), (String)"0001", (String)"\u5f53\u524d\u4e0a\u4f20\u7236\u7ea7\u836f\u5e97\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            StoreEo storeChild = new StoreEo();
            List creditNum = storeEos.stream().map(c -> c.getSocialCreditNum()).collect(Collectors.toList());
            storeChild.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"parent_social_credit_num", creditNum)}));
            List storeChildren = this.storeDas.select((BaseEo)storeChild);
            Assert.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)storeChildren), (String)"0001", (String)"\u5f53\u524d\u4e0a\u4f20\u7236\u7ea7\u836f\u5e97\u4e0d\u5b58\u5728\u4e0b\u7ea7\u95e8\u5e97\uff01\uff01\uff01");
            governContent.getStoreParentIds().forEach(store -> {
                StoreSellerGovernContentEo eo = new StoreSellerGovernContentEo();
                eo.setStoreSellerId(storeSellerGovern.getId());
                eo.setOrganizationId(storeSellerGovern.getOrganizationId());
                eo.setGovernType(GovernTypeEnum.STOREPARENT.getCode());
                eo.setGovernContent(store);
                insertGovernContentList.add(eo);
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)governContent.getBlacklistIds())) {
            governContent.getBlacklistIds().forEach(store -> {
                StoreSellerGovernContentEo eo = new StoreSellerGovernContentEo();
                eo.setStoreSellerId(storeSellerGovern.getId());
                eo.setOrganizationId(storeSellerGovern.getOrganizationId());
                eo.setGovernType(GovernTypeEnum.BLACKLIST.getCode());
                eo.setGovernContent(store);
                insertGovernContentList.add(eo);
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(insertGovernContentList)) {
            this.storeSellerGovernContentDas.insertBatch(insertGovernContentList);
        }
        this.logger.info("\u7ba1\u8f96\u5185\u5bb9\u5904\u7406\u5b8c\u6210\uff0c\u51c6\u5907\u6784\u5efa\u5173\u8054\u6570\u636e");
        this.storeSellerGovernService.changeStoreSellerGovernStatus(storeSellerGovern.getSellerId(), storeSellerGovern.getOrganizationId(), GovernStatusEnum.DEAL);
        ExecutorUtils.execute(() -> {
            this.logger.info("\u5f02\u6b65\u6267\u884c");
            this.storeSellerRelateService.buildStoreSellerRelate(storeSellerGovern.getSellerId(), storeSellerGovern.getOrganizationId(), this.context.userName());
        });
    }

    @Override
    public PageInfo<StoreRespDto> querySellerGovernStore(Long id, String governType, Integer pageNum, Integer pageSize) {
        PageInfo storeRespDtoPageInfo = this.storeSellerGovernContentDas.querySellerGovernStore(id, null, governType, pageNum, pageSize);
        if (storeRespDtoPageInfo.getList() == null) {
            storeRespDtoPageInfo.setList(new ArrayList());
        }
        return storeRespDtoPageInfo;
    }

    @Override
    public List<StoreAreaRespDto> querySellerGovernArea(Long id) {
        List storeAreaRespDtoList = this.storeSellerGovernContentDas.querySellerGovernArea(id, null);
        if (storeAreaRespDtoList == null) {
            return new ArrayList<StoreAreaRespDto>();
        }
        return storeAreaRespDtoList;
    }

    @Override
    public void deleteGovernContent(Long storeSellerId) {
        if (ObjectUtils.isEmpty((Object)storeSellerId)) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        }
        StoreSellerGovernContentEo storeSellerGovernContentEo = new StoreSellerGovernContentEo();
        storeSellerGovernContentEo.setStoreSellerId(storeSellerId);
        this.storeSellerGovernContentDas.logicDelete((BaseEo)storeSellerGovernContentEo);
    }

    @Override
    public List<StoreRespDto> queryByOrgId(Long orgId) {
        ArrayList list = Lists.newArrayList();
        List<String> storeIds = this.queryGovernContentListByOrgId(orgId);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(storeIds)) {
            List storeEos = this.storeDas.queryByOrgId(storeIds);
            DtoHelper.eoList2DtoList((Collection)storeEos, (Collection)list, StoreRespDto.class);
        }
        return list;
    }

    @Override
    public List<StoreSellerGovernContentRespDto> queryGovernContentByOrgId(Long orgId) {
        if (ObjectUtils.isEmpty((Object)orgId)) {
            return new ArrayList<StoreSellerGovernContentRespDto>();
        }
        StoreSellerGovernContentEo params = new StoreSellerGovernContentEo();
        params.setOrganizationId(orgId);
        List select = this.storeSellerGovernContentDas.select((BaseEo)params);
        ArrayList<StoreSellerGovernContentRespDto> list = new ArrayList<StoreSellerGovernContentRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, list, StoreSellerGovernContentRespDto.class);
        return list;
    }

    @Override
    public List<String> queryGovernContentListByOrgId(Long orgId) {
        SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(orgId));
        if (null == sellerRespDto) {
            throw new BizException("-1", "\u6839\u636e\u5927B\u7ec4\u7ec7id: " + orgId + "\u83b7\u53d6\u5546\u5bb6\u4fe1\u606f\u4e3a\u7a7a");
        }
        List storeSellerGovernContentRespDtos = this.storeSellerGovernContentDas.queryGovernContentList(sellerRespDto.getId());
        ArrayList<String> storeIds = new ArrayList<String>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)storeSellerGovernContentRespDtos)) {
            List<StoreSellerGovernContentRespDto> storeParentType;
            Map<String, List<StoreSellerGovernContentRespDto>> storeSellerGovernContentMap = storeSellerGovernContentRespDtos.stream().collect(Collectors.groupingBy(e -> e.getGovernType()));
            List<StoreSellerGovernContentRespDto> areaType = storeSellerGovernContentMap.get("AREA");
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(areaType)) {
                ArrayList governContentArea = new ArrayList();
                areaType.forEach(e -> governContentArea.add(e.getGovernContent()));
                List storeIdList = this.storeDas.queryStoreIdByArea(governContentArea);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)storeIdList)) {
                    storeIds.addAll(storeIdList);
                }
            }
            this.logger.info("\u7ba1\u8f96\u533a\u57df\u7c7b\u578b\u836f\u5e97\u673a\u6784id\uff0c{}", storeIds);
            List<StoreSellerGovernContentRespDto> storeType = storeSellerGovernContentMap.get("STORE");
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(storeType)) {
                storeType.forEach(e -> storeIds.add(e.getGovernContent()));
            }
            this.logger.info("\u7ba1\u8f96\u533a\u57df\u548c\u5e97\u94fa\u7c7b\u578b\u836f\u5e97\u673a\u6784id\uff0c{}", storeIds);
            List<StoreSellerGovernContentRespDto> blackType = storeSellerGovernContentMap.get("BLACKLIST");
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(blackType)) {
                ArrayList blackStoreIds = new ArrayList();
                blackType.forEach(e -> blackStoreIds.add(e.getGovernContent()));
                storeIds.removeAll(blackStoreIds);
                this.logger.info("\u7ba1\u8f96\u9ed1\u540d\u5355\u7c7b\u578b\u836f\u5e97\u673a\u6784id\uff0c{}", blackStoreIds);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(storeParentType = storeSellerGovernContentMap.get(StoreGovernTypeEnum.STORE_PARENT.getCode()))) {
                ArrayList storeParentIds = new ArrayList();
                storeParentType.forEach(e -> storeParentIds.add(e.getGovernContent()));
                StoreEo storeEo = new StoreEo();
                storeEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"store_id", storeParentIds)}));
                List stores = this.storeDas.select((BaseEo)storeEo);
                List parentStoreSocialCreditNums = stores.stream().map(c -> c.getSocialCreditNum()).collect(Collectors.toList());
                StoreEo storeEos = new StoreEo();
                storeEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"parent_social_credit_num", parentStoreSocialCreditNums)}));
                List childrenStores = this.storeDas.select((BaseEo)storeEos);
                List storeIdList = Optional.of(childrenStores).orElse(Lists.newArrayList()).stream().map(c -> c.getStoreId()).collect(Collectors.toList());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(storeIdList)) {
                    storeIds.addAll(storeIdList);
                }
            }
        }
        this.logger.info("\u6700\u7ec8\u8fd4\u56de\u836f\u5e97\u673a\u6784id\uff0c{}", storeIds);
        return storeIds;
    }

    @Override
    public List<StoreSellerGovernContentRespDto> queryByGovernContents(List<String> governContents) {
        if (CollectionUtils.isEmpty(governContents)) {
            return Lists.newArrayList();
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"govern_content", governContents);
        wrapper.eq((Object)"dr", (Object)0);
        List result = this.storeSellerGovernContentDas.getMapper().selectList((Wrapper)wrapper);
        ArrayList<StoreSellerGovernContentRespDto> dtoList = new ArrayList<StoreSellerGovernContentRespDto>();
        DtoHelper.eoList2DtoList((Collection)result, dtoList, StoreSellerGovernContentRespDto.class);
        return dtoList;
    }

    @Override
    public PageInfo<StoreRespDto> querySellerGovern(Long orgId, String dataType, Integer pageNum, Integer pageSize) {
        StoreGovernTypeEnum storeGovernTypeEnum = StoreGovernTypeEnum.enumOfCode((String)dataType);
        Assert.isTrue((null != storeGovernTypeEnum ? 1 : 0) != 0, (String)"001", (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u6570\u636e\u7c7b\u578b!");
        Assert.isTrue((null != orgId ? 1 : 0) != 0, (String)"0001", (String)"\u7ec4\u7ec7ID\u4e0d\u4e3a\u7a7a!");
        return this.storeSellerGovernContentDas.querySellerGovernStore(null, orgId, dataType, pageNum, pageSize);
    }

    @Override
    public List<StoreAreaRespDto> querySellerGovernAreaByOrgId(Long orgId) {
        List storeAreaRespDtoList = this.storeSellerGovernContentDas.querySellerGovernArea(null, orgId);
        if (storeAreaRespDtoList == null) {
            return new ArrayList<StoreAreaRespDto>();
        }
        return storeAreaRespDtoList;
    }
}

