/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CheckPatternTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreGovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternConfigReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckPatternConfigDetailRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckPatternConfigRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IStoreAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckPatternConfigService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernContentService;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerCheckPatternConfigDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerCheckPatternDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerCheckPatternConfigEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.biz.service.ICustomerQueryService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CustomerCheckPatternConfigServiceImpl
implements ICustomerCheckPatternConfigService {
    private static final Logger log = LoggerFactory.getLogger(CustomerCheckPatternConfigServiceImpl.class);
    @Resource
    private CustomerCheckPatternConfigDas customerCheckPatternConfigDas;
    @Resource
    private CustomerCheckPatternDas customerCheckPatternDas;
    @Resource
    private ICustomerQueryService customerQueryService;
    @Resource
    private IStoreSellerGovernContentService storeSellerGovernContentService;
    @Resource
    private IStoreAreaQueryApi storeAreaQueryApi;

    @Override
    public Long addCustomerCheckPatternConfig(CustomerCheckPatternConfigReqDto addReqDto) {
        CustomerCheckPatternConfigEo customerCheckPatternConfigEo = new CustomerCheckPatternConfigEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerCheckPatternConfigEo);
        this.customerCheckPatternConfigDas.insert((BaseEo)customerCheckPatternConfigEo);
        return customerCheckPatternConfigEo.getId();
    }

    @Override
    public void saveOrUpdateCustomerCheckPatternConfig(CustomerCheckPatternConfigReqDto addReqDto) {
        StoreGovernTypeEnum storeGovernTypeEnum = StoreGovernTypeEnum.enumOfCode((String)addReqDto.getConfigType());
        Assert.isTrue((null != storeGovernTypeEnum ? 1 : 0) != 0, (String)"0001", (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u914d\u7f6e\u7c7b\u578b");
        CustomerCheckPatternConfigEo customerCheckPatternConfigEo = new CustomerCheckPatternConfigEo();
        customerCheckPatternConfigEo.setConfigType(storeGovernTypeEnum.getCode());
        customerCheckPatternConfigEo.setOrganizationId(addReqDto.getOrganizationId());
        this.customerCheckPatternConfigDas.delete((BaseEo)customerCheckPatternConfigEo);
        List collect = addReqDto.getConfigContentLists().stream().map(config -> {
            CustomerCheckPatternConfigEo customerCheckPatternConfig = new CustomerCheckPatternConfigEo();
            customerCheckPatternConfig.setConfigType(storeGovernTypeEnum.getCode());
            customerCheckPatternConfig.setConfigContent(config);
            customerCheckPatternConfig.setOrganizationId(addReqDto.getOrganizationId());
            return customerCheckPatternConfig;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            int result = this.customerCheckPatternConfigDas.insertBatch(collect);
            Assert.isTrue((result > 0 ? 1 : 0) != 0, (String)"0001", (String)"\u767d\u540d\u5355\u914d\u7f6e\u5931\u8d25");
        }
    }

    @Override
    public void modifyCustomerCheckPatternConfig(CustomerCheckPatternConfigReqDto modifyReqDto) {
        CustomerCheckPatternConfigEo customerCheckPatternConfigEo = new CustomerCheckPatternConfigEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerCheckPatternConfigEo);
        this.customerCheckPatternConfigDas.updateSelective((BaseEo)customerCheckPatternConfigEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerCheckPatternConfig(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerCheckPatternConfigDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CustomerCheckPatternConfigRespDto queryById(Long id) {
        CustomerCheckPatternConfigEo customerCheckPatternConfigEo = (CustomerCheckPatternConfigEo)this.customerCheckPatternConfigDas.selectByPrimaryKey(id);
        CustomerCheckPatternConfigRespDto customerCheckPatternConfigRespDto = new CustomerCheckPatternConfigRespDto();
        DtoHelper.eo2Dto((BaseEo)customerCheckPatternConfigEo, (BaseVo)customerCheckPatternConfigRespDto);
        return customerCheckPatternConfigRespDto;
    }

    @Override
    public PageInfo<CustomerCheckPatternConfigRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerRespDto customerRespDto;
        CustomerCheckPatternConfigReqDto customerCheckPatternConfigReqDto = (CustomerCheckPatternConfigReqDto)JSON.parseObject((String)filter, CustomerCheckPatternConfigReqDto.class);
        CustomerCheckPatternConfigEo customerCheckPatternConfigEo = new CustomerCheckPatternConfigEo();
        DtoHelper.dto2Eo((BaseVo)customerCheckPatternConfigReqDto, (BaseEo)customerCheckPatternConfigEo);
        if (!CollectionUtils.isEmpty((Collection)customerCheckPatternConfigReqDto.getOrganizationIds())) {
            customerCheckPatternConfigEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"organization_id", (Object)customerCheckPatternConfigReqDto.getOrganizationIds())}));
        }
        Assert.isTrue((null != (customerRespDto = this.customerQueryService.queryByOrgInfoId(customerCheckPatternConfigEo.getOrganizationId())) ? 1 : 0) != 0, (String)"0001", (String)"\u5f53\u524d\u5ba2\u6237\u4e0d\u5b58\u5728");
        CustomerCheckPatternReqDto reqDto = new CustomerCheckPatternReqDto();
        reqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{customerRespDto.getCode()}));
        List patternEoList = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(reqDto);
        ArrayList orgIds = Lists.newArrayList();
        orgIds.addAll(patternEoList.stream().map(c -> c.getOrgId()).collect(Collectors.toList()));
        orgIds.addAll(patternEoList.stream().map(c -> c.getMergeOrgId()).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty((Collection)orgIds)) {
            customerCheckPatternConfigEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"organization_id", (Object)orgIds)}));
            customerCheckPatternConfigEo.setOrganizationId(null);
        }
        PageInfo eoPageInfo = this.customerCheckPatternConfigDas.selectPage((BaseEo)customerCheckPatternConfigEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerCheckPatternConfigRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public CustomerCheckPatternConfigDetailRespDto calculateConfigTotal(Long orgId) {
        CustomerCheckPatternConfigDetailRespDto customerCheckPatternConfigDetailRespDto = new CustomerCheckPatternConfigDetailRespDto();
        CustomerRespDto customerRespDto = this.customerQueryService.queryByOrgInfoId(orgId);
        Assert.isTrue((null != customerRespDto ? 1 : 0) != 0, (String)"0001", (String)"\u5f53\u524d\u5ba2\u6237\u4e0d\u5b58\u5728");
        CustomerCheckPatternReqDto reqDto = new CustomerCheckPatternReqDto();
        reqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{customerRespDto.getCode()}));
        List patternEoList = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(reqDto);
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)patternEoList) ? 1 : 0) != 0, (String)"0001", (String)"\u672a\u914d\u7f6e\u8003\u6838\u65b9\u5f0f");
        List verifyList = patternEoList.stream().filter(c -> !CheckPatternTypeEnum.MERGE_CHECK.getType().equals(c.getPatternType())).collect(Collectors.toList());
        Assert.isTrue((boolean)CollectionUtils.isEmpty(verifyList), (String)"0001", (String)"\u975e\u5408\u5e76\u8003\u6838\u65e0\u9700\u8bbe\u7f6e\u9ed1\u767d\u540d\u5355");
        ArrayList orgIds = Lists.newArrayList();
        orgIds.addAll(patternEoList.stream().map(c -> c.getOrgId()).collect(Collectors.toList()));
        orgIds.addAll(patternEoList.stream().map(c -> c.getMergeOrgId()).collect(Collectors.toList()));
        CustomerCheckPatternConfigReqDto customerCheckPatternConfigReqDto = new CustomerCheckPatternConfigReqDto();
        customerCheckPatternConfigReqDto.setOrganizationIds((List)orgIds);
        PageInfo<CustomerCheckPatternConfigRespDto> eoPageInfo = this.queryByPage(JSON.toJSONString((Object)customerCheckPatternConfigReqDto), 1, Integer.MAX_VALUE);
        if (!CollectionUtils.isEmpty((Collection)eoPageInfo.getList())) {
            Map<String, List<CustomerCheckPatternConfigRespDto>> collect = eoPageInfo.getList().stream().collect(Collectors.groupingBy(CustomerCheckPatternConfigRespDto::getConfigType));
            customerCheckPatternConfigDetailRespDto.setAreaConfigTotal(Integer.valueOf(collect.getOrDefault(StoreGovernTypeEnum.AREA.getCode(), Lists.newArrayList()).size()));
            customerCheckPatternConfigDetailRespDto.setStoreConfigTotal(Integer.valueOf(collect.getOrDefault(StoreGovernTypeEnum.STORE.getCode(), Lists.newArrayList()).size()));
            customerCheckPatternConfigDetailRespDto.setParentStoreConfigTotal(Integer.valueOf(collect.getOrDefault(StoreGovernTypeEnum.STORE_PARENT.getCode(), Lists.newArrayList()).size()));
            customerCheckPatternConfigDetailRespDto.setBlackListConfigTotal(Integer.valueOf(collect.getOrDefault(StoreGovernTypeEnum.BLACKLIST.getCode(), Lists.newArrayList()).size()));
        }
        return customerCheckPatternConfigDetailRespDto;
    }

    @Override
    public List<StoreAreaRespDto> queryCheckPatternConfigByOrgId(Long orgId) {
        List storeAreaRespDtoList = this.customerCheckPatternConfigDas.queryCheckPatternArea(orgId);
        return CollectionUtils.isEmpty((Collection)storeAreaRespDtoList) ? Lists.newArrayList() : storeAreaRespDtoList;
    }

    @Override
    public PageInfo<StoreRespDto> queryCheckPatternConfigStore(Long orgId, String dataType, Integer pageNum, Integer pageSize) {
        StoreGovernTypeEnum storeGovernTypeEnum = StoreGovernTypeEnum.enumOfCode((String)dataType);
        Assert.isTrue((null != storeGovernTypeEnum ? 1 : 0) != 0, (String)"001", (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u6570\u636e\u7c7b\u578b!");
        Assert.isTrue((null != orgId ? 1 : 0) != 0, (String)"0001", (String)"\u7ec4\u7ec7ID\u4e0d\u4e3a\u7a7a!");
        return this.customerCheckPatternConfigDas.queryCheckPatternConfigStore(orgId, dataType, pageNum, pageSize);
    }

    @Override
    public void synStoreSellerGovern(Long orgId) {
        CustomerRespDto customerRespDto = this.customerQueryService.queryByOrgInfoId(orgId);
        Assert.isTrue((null != customerRespDto ? 1 : 0) != 0, (String)"0001", (String)"\u5f53\u524d\u5ba2\u6237\u4e0d\u5b58\u5728");
        CustomerCheckPatternReqDto reqDto = new CustomerCheckPatternReqDto();
        reqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{customerRespDto.getCode()}));
        List patternEoList = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(reqDto);
        if (CollectionUtils.isEmpty((Collection)patternEoList)) {
            log.info("\u672a\u914d\u7f6e\u8003\u6838\u65b9\u5f0f");
            return;
        }
        Arrays.stream(StoreGovernTypeEnum.values()).forEach(enums -> {
            if (enums.getCode().equals(StoreGovernTypeEnum.AREA.getCode())) {
                List<StoreAreaRespDto> governAreaList = this.storeSellerGovernContentService.querySellerGovernAreaByOrgId(orgId);
                List<StoreAreaRespDto> configAreaList = this.queryCheckPatternConfigByOrgId(orgId);
                List areaTree = (List)RestResponseHelper.extractData((RestResponse)this.storeAreaQueryApi.queryTree());
                List governAreaCodeList = governAreaList.stream().map(c -> c.getCode()).collect(Collectors.toList());
                List collect = areaTree.stream().filter(c -> governAreaCodeList.contains(c.getParentCode())).map(c -> c.getCode()).collect(Collectors.toList());
                governAreaCodeList.addAll(CollectionUtils.isEmpty(collect) ? Lists.newArrayList() : collect);
                List resultList = configAreaList.stream().filter(c -> governAreaCodeList.contains(c.getCode())).map(c -> c.getCode()).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(resultList)) {
                    CustomerCheckPatternConfigReqDto customerCheckPatternConfigReqDto = new CustomerCheckPatternConfigReqDto();
                    customerCheckPatternConfigReqDto.setConfigType(enums.getCode());
                    customerCheckPatternConfigReqDto.setConfigContentLists(resultList);
                    customerCheckPatternConfigReqDto.setOrganizationId(orgId);
                    this.saveOrUpdateCustomerCheckPatternConfig(customerCheckPatternConfigReqDto);
                }
            } else {
                PageInfo<StoreRespDto> governList = this.storeSellerGovernContentService.querySellerGovern(orgId, enums.getCode(), 1, Integer.MAX_VALUE);
                PageInfo configList = this.customerCheckPatternConfigDas.queryCheckPatternConfigStore(orgId, enums.getCode(), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
                if (!CollectionUtils.isEmpty((Collection)governList.getList()) && !CollectionUtils.isEmpty((Collection)configList.getList())) {
                    List governStoreIdList = governList.getList().stream().map(c -> c.getStoreId()).collect(Collectors.toList());
                    List configStoreIdList = governList.getList().stream().map(c -> c.getStoreId()).collect(Collectors.toList());
                    List dealConfigStoreIdList = configStoreIdList.stream().filter(c -> governStoreIdList.contains(c)).collect(Collectors.toList());
                    CustomerCheckPatternConfigReqDto customerCheckPatternConfigReqDto = new CustomerCheckPatternConfigReqDto();
                    customerCheckPatternConfigReqDto.setConfigType(enums.getCode());
                    customerCheckPatternConfigReqDto.setConfigContentLists(dealConfigStoreIdList);
                    customerCheckPatternConfigReqDto.setOrganizationId(orgId);
                    this.saveOrUpdateCustomerCheckPatternConfig(customerCheckPatternConfigReqDto);
                }
            }
        });
    }
}

