/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.dtyunxi.tcbj.api.dto.request.CustomerStoreReqDto;
import com.dtyunxi.tcbj.api.dto.request.TbPersonPartnerRelReqDto;
import com.dtyunxi.tcbj.api.dto.request.ValidInsiderCheckRelReqDto;
import com.dtyunxi.tcbj.api.dto.response.TbPersonPartnerRelRespDto;
import com.dtyunxi.tcbj.api.query.ICustomerDistributorsQueryApi;
import com.dtyunxi.tcbj.api.query.ITbPersonPartnerRelQueryApi;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.BizChannelEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CheckPatternTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckRelationSourceOperateTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerStatusExtEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreCheckErrorEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreGovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternConfigReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckRelationReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckPatternConfigRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckRelationBindErrorRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerRelateRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckPatternConfigService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckPatternService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckRelationService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerRelateService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.impl.StoreAndSalesmanHelper;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerCheckPatternDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerCheckRelationDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerCheckPatternEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerCheckRelationEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.biz.service.ICustomerQueryService;
import com.yx.tcbj.center.customer.biz.service.IStoreService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class CustomerCheckRelationServiceImpl
implements ICustomerCheckRelationService {
    private static final Logger log = LoggerFactory.getLogger(CustomerCheckRelationServiceImpl.class);
    @Resource
    private CustomerCheckRelationDas customerCheckRelationDas;
    @Resource
    private CustomerCheckPatternDas customerCheckPatternDas;
    @Resource
    private StoreAndSalesmanHelper storeAndSalesmanHelper;
    @Resource
    private ICustomerQueryService customerQueryService;
    @Resource
    private ITbPersonPartnerRelQueryApi tbPersonPartnerRelQueryApi;
    @Resource
    private ICustomerCheckPatternService customerCheckPatternService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IStoreService storeService;
    @Resource
    private ICustomerCheckRelationService customerCheckRelationService;
    @Resource
    private ICustomerDistributorsQueryApi customerDistributorsQueryApi;
    @Resource
    private ILockService lockService;
    @Resource
    private ICustomerCheckPatternConfigService customerCheckPatternConfigService;
    @Resource
    private IStoreSellerRelateService storeSellerRelateService;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;

    @Override
    public Long addCustomerCheckRelation(CustomerCheckRelationReqDto addReqDto) {
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerCheckRelationEo);
        this.customerCheckRelationDas.insert((BaseEo)customerCheckRelationEo);
        return customerCheckRelationEo.getId();
    }

    @Override
    public void modifyCustomerCheckRelation(CustomerCheckRelationReqDto modifyReqDto) {
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerCheckRelationEo);
        this.customerCheckRelationDas.updateSelective((BaseEo)customerCheckRelationEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerCheckRelation(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerCheckRelationDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CustomerCheckRelationRespDto queryById(Long id) {
        CustomerCheckRelationEo customerCheckRelationEo = (CustomerCheckRelationEo)this.customerCheckRelationDas.selectByPrimaryKey(id);
        CustomerCheckRelationRespDto customerCheckRelationRespDto = new CustomerCheckRelationRespDto();
        DtoHelper.eo2Dto((BaseEo)customerCheckRelationEo, (BaseVo)customerCheckRelationRespDto);
        return customerCheckRelationRespDto;
    }

    @Override
    public PageInfo<CustomerCheckRelationRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerCheckRelationReqDto customerCheckRelationReqDto = (CustomerCheckRelationReqDto)JSON.parseObject((String)filter, CustomerCheckRelationReqDto.class);
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        DtoHelper.dto2Eo((BaseVo)customerCheckRelationReqDto, (BaseEo)customerCheckRelationEo);
        ArrayList sqlFilters = Lists.newArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerCheckRelationReqDto.getStatusList())) {
            sqlFilters.add(SqlFilter.in((String)"status", (Object)customerCheckRelationReqDto.getStatusList()));
        }
        customerCheckRelationEo.setSqlFilters((List)sqlFilters);
        customerCheckRelationEo.setOrderByDesc("update_time");
        PageInfo eoPageInfo = this.customerCheckRelationDas.selectPage((BaseEo)customerCheckRelationEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerCheckRelationRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<CustomerCheckRelationRespDto> queryByStoreIds(CustomerCheckRelationReqDto customerCheckRelationReqDto) {
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        DtoHelper.dto2Eo((BaseVo)customerCheckRelationReqDto, (BaseEo)customerCheckRelationEo);
        ArrayList sqlFilters = Lists.newArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerCheckRelationReqDto.getStoreIds())) {
            sqlFilters.add(SqlFilter.in((String)"store_id", (Object)customerCheckRelationReqDto.getStoreIds()));
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerCheckRelationReqDto.getOrgIds())) {
            sqlFilters.add(SqlFilter.in((String)"org_id", (Object)customerCheckRelationReqDto.getOrgIds()));
        }
        customerCheckRelationEo.setSqlFilters((List)sqlFilters);
        List results = this.customerCheckRelationDas.select((BaseEo)customerCheckRelationEo);
        ArrayList customerCheckRelationRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)results, (Collection)customerCheckRelationRespDtos, CustomerCheckRelationRespDto.class);
        return customerCheckRelationRespDtos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bindStoreAndSalesmanRelation(CustomerCheckRelationReqDto addReqDto) {
        CustomerCheckRelationServiceImpl.log.info("\u7ed1\u5b9a\u5ba2\u6237\u5173\u7cfb req params => {} ", (Object)JSON.toJSONString((Object)addReqDto));
        AssertUtil.isTrue((boolean)(ObjectUtils.isEmpty((Object)addReqDto.getOrgId()) == false), (String)("\u7ec4\u7ec7ID\u4e3a\u7a7a,addReqDto:" + JSON.toJSONString((Object)addReqDto)));
        orgId = addReqDto.getOrgId();
        customerRespDto = this.customerQueryService.queryByOrgInfoId(orgId);
        AssertUtil.isTrue((boolean)(ObjectUtils.isEmpty((Object)customerRespDto) == false), (String)"\u5f53\u524d\u5ba2\u6237\u4e0d\u5b58\u5728");
        AssertUtil.isTrue((boolean)CustomerStatusExtEnum.ENABLED.getCode().equals(customerRespDto.getStatusId()), (String)"\u5f53\u524d\u5ba2\u6237\u975e\u5408\u6cd5\u72b6\u6001");
        mutex = null;
        AssertUtil.isTrue((boolean)CustomerStatusExtEnum.ENABLED.getCode().equals(customerRespDto.getStatusId()), (String)"\u5f53\u524d\u5ba2\u6237\u975e\u5408\u6cd5\u72b6\u6001");
        lockKey = addReqDto.getOrgId() + "-" + addReqDto.getStoreId() + "-" + addReqDto.getStatus();
        try {
            mutex = this.lockService.lock("bindStoreAndSalesmanRelation", lockKey, 10, 5, TimeUnit.MINUTES);
            customerCheckStatusEnum = this.verifyBindRelationParams(addReqDto, customerRespDto);
            bizChannelEnum = this.storeAndSalesmanHelper.calculateBizChannel(addReqDto.getThirdPartyId());
            switch (1.$SwitchMap$com$dtyunxi$yundt$cube$center$customer$api$constants$CustomerCheckStatusEnum[customerCheckStatusEnum.ordinal()]) {
                case 1: {
                    this.checkStoreIdsDisable(addReqDto.getStoreId());
                    this.checkPersonPartnerDisable(orgId, addReqDto, customerRespDto);
                    this.verifyRelation(addReqDto, bizChannelEnum);
                    this.insertCustomerCheckRelationEo(addReqDto, bizChannelEnum);
                    ** break;
                }
                case 2: {
                    customerCheckRelation = new CustomerCheckRelationEo();
                    customerCheckRelation.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"biz_type", (Object)bizChannelEnum.getBizTypes())}));
                    customerCheckRelation.setStoreId(addReqDto.getStoreId());
                    customerCheckRelation.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
                    customerCheckRelation.setOrgId(addReqDto.getOrgId());
                    list = this.customerCheckRelationDas.select((BaseEo)customerCheckRelation);
                    AssertUtil.isTrue((boolean)(list.size() > 0), (String)"\u8003\u6838\u95e8\u5e97\u5173\u7cfb\u5b58\u5728\u5f02\u5e38\uff01");
                    customerCheckRelation = (CustomerCheckRelationEo)list.stream().findFirst().get();
                    AssertUtil.isTrue((boolean)customerCheckRelation.getOrgId().equals(addReqDto.getOrgId()), (String)"\u5f53\u524d\u89e3\u7ed1\u5173\u7cfb\u4e0e\u6240\u5c5e\u516c\u53f8\u4e0d\u4e00\u81f4\uff01");
                    AssertUtil.isTrue((boolean)customerCheckRelation.getStoreId().equals(addReqDto.getStoreId()), (String)"\u89e3\u7ed1\u95e8\u5e97\u4e0e\u5f53\u524d\u7ed1\u5b9a\u95e8\u5e97\u4e0d\u4e00\u81f4\uff01");
                    AssertUtil.isTrue((boolean)customerCheckRelation.getSalesmanId().equals(addReqDto.getSalesmanId()), (String)"\u89e3\u7ed1\u4e1a\u52a1\u5458\u4e0e\u5f53\u524d\u7ed1\u5b9a\u4e1a\u52a1\u5458\u4e0d\u4e00\u81f4\uff01");
                    customerCheckRelation.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
                    customerCheckRelation.setSourceOperateType(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)addReqDto.getSourceOperateType()) != false ? addReqDto.getSourceOperateType() : CustomerCheckRelationSourceOperateTypeEnum.MANUAL.getType());
                    this.customerCheckRelationDas.updateSelective((BaseEo)customerCheckRelation);
                    ** break;
                }
                default: {
                    throw new BizException("0001", "\u4e0d\u5b58\u5728\u5f53\u524d\u64cd\u4f5c\u7c7b\u578b");
lbl40:
                    // 2 sources

                }
            }
        }
        catch (Throwable var10_10) {
            this.lockService.unlock(mutex);
            throw var10_10;
        }
        this.lockService.unlock(mutex);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<CustomerCheckRelationBindErrorRespDto> batchBindStoreAndSalesmanRelation(List<CustomerCheckRelationReqDto> addReqDtoList) {
        ArrayList respDtoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(addReqDtoList)) {
            return respDtoList;
        }
        for (CustomerCheckRelationReqDto addReqDto : addReqDtoList) {
            try {
                this.bindStoreAndSalesmanRelation(addReqDto);
            }
            catch (Exception e) {
                CustomerCheckRelationBindErrorRespDto respDto = new CustomerCheckRelationBindErrorRespDto();
                respDto.setStoreNo(addReqDto.getStoreNo());
                respDto.setSalesmanCode(addReqDto.getSalesmanCode());
                respDto.setResultMsg(e.getCause().toString());
                respDtoList.add(respDto);
            }
        }
        return respDtoList;
    }

    private void insertCustomerCheckRelationEo(CustomerCheckRelationReqDto addReqDto, BizChannelEnum bizChannelEnum) {
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerCheckRelationEo);
        customerCheckRelationEo.setBizType(Long.valueOf(bizChannelEnum.getChannelCode()));
        customerCheckRelationEo.setStoreId(addReqDto.getStoreId());
        customerCheckRelationEo.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        customerCheckRelationEo.setStoreThirdPartyId(addReqDto.getThirdPartyId());
        customerCheckRelationEo.setSourceOperateType(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)addReqDto.getSourceOperateType()) ? addReqDto.getSourceOperateType() : CustomerCheckRelationSourceOperateTypeEnum.MANUAL.getType());
        this.customerCheckRelationDas.insert((BaseEo)customerCheckRelationEo);
    }

    private void checkStoreIdsDisable(String StoreId) {
        CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
        customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        customerCheckRelationReqDto.setStoreId(StoreId);
        List customerCheckRelationList = this.queryByPage(JSON.toJSONString((Object)customerCheckRelationReqDto), 1, Integer.MAX_VALUE).getList();
        if (CollectionUtils.isNotEmpty((Collection)customerCheckRelationList)) {
            this.customerRelationCheckStoreDisable(customerCheckRelationList);
        }
    }

    @Override
    public void disableRelationByOrgId(String orgId) {
        AssertUtil.isTrue((!StringUtils.isEmpty((Object)orgId) ? 1 : 0) != 0, (String)"\u7ec4\u7ec7ID\u4e3a\u7a7a");
        CustomerCheckRelationEo customerCheckRelation = new CustomerCheckRelationEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.eq((String)"org_id", (Object)orgId));
        sqlFilters.add(SqlFilter.ne((String)"status", (Object)CustomerCheckStatusEnum.NOT_BOUND.getStatus()));
        customerCheckRelation.setSqlFilters((List)sqlFilters);
        customerCheckRelation.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
        customerCheckRelation.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.MANUAL.getType());
        int result = this.customerCheckRelationDas.updateSelectiveSqlFilter((BaseEo)customerCheckRelation);
        AssertUtil.isTrue((result >= 0 ? 1 : 0) != 0, (String)("\u5931\u6548[" + orgId + "]\u7ec4\u7ec7\u4eba\u5e97\u5173\u7cfb\u5931\u8d25"));
    }

    private void checkPersonPartnerDisable(Long orgId, CustomerCheckRelationReqDto addReqDto, CustomerRespDto customerRespDto) {
        List rowIds;
        CustomerCheckRelationEo customerCheckRelationReqDto = new CustomerCheckRelationEo();
        customerCheckRelationReqDto.setStoreId(addReqDto.getStoreId());
        customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        customerCheckRelationReqDto.setOrgId(orgId);
        List dbList = this.customerCheckRelationDas.select((BaseEo)customerCheckRelationReqDto);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
            tbPersonPartnerRelReqDto.setRowIds(dbList.stream().map(CustomerCheckRelationEo::getSalesmanId).collect(Collectors.toList()));
            tbPersonPartnerRelReqDto.setCustomerId(addReqDto.getThirdPartyId());
            tbPersonPartnerRelReqDto.setMasterOuId(customerRespDto.getThirdPartyId());
            PageInfo tbPersonPartnerRelRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tbPersonPartnerRelQueryApi.queryByPage(JSON.toJSONString((Object)tbPersonPartnerRelReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
            if (CollectionUtils.isNotEmpty((Collection)tbPersonPartnerRelRespDtoPageInfo.getList())) {
                rowIds = tbPersonPartnerRelRespDtoPageInfo.getList().stream().map(TbPersonPartnerRelRespDto::getRowId).collect(Collectors.toList());
                dbList.forEach(c -> {
                    if (!rowIds.contains(c.getSalesmanId())) {
                        c.setStatus(CustomerCheckStatusEnum.DISABLE.getStatus());
                        c.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.DISABLE_STORE_REL.getType());
                        int result = this.customerCheckRelationDas.update((BaseEo)c);
                        AssertUtil.isTrue((result > 0 ? 1 : 0) != 0, (String)"\u8003\u6838\u5173\u7cfb\u53d8\u66f4\u5931\u8d25\uff01");
                    }
                });
            } else {
                log.error("checkPersonPartnerDisable \u5220\u9664\u5df2\u7ecf\u5b58\u5728\u7ed1\u5b9a\u7684\u8003\u6838\u5173\u7cfb\u5217\u8868:" + JSON.toJSONString((Object)dbList));
                dbList.forEach(c -> {
                    c.setStatus(CustomerCheckStatusEnum.DISABLE.getStatus());
                    c.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.DISABLE_STORE_REL.getType());
                    int result = this.customerCheckRelationDas.update((BaseEo)c);
                    AssertUtil.isTrue((result > 0 ? 1 : 0) != 0, (String)"\u8003\u6838\u5173\u7cfb\u53d8\u66f4\u5931\u8d25\uff01");
                });
            }
        }
        CustomerCheckRelationEo reqDto = new CustomerCheckRelationEo();
        reqDto.setStoreId(addReqDto.getStoreId());
        reqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        log.info("\u6821\u9a8c\u8be5\u95e8\u5e97\u662f\u5426\u7ed1\u5b9a\u4e86\u5176\u4ed6\u7ecf\u9500\u5546\u4e0b\u7684\u4e1a\u52a1\u5458, \u5224\u65ad\u662f\u5426\u5df2\u7ecf\u5931\u6548.... \u8bf7\u6c42\u53c2\u6570:" + JSON.toJSONString((Object)reqDto));
        List dbList2 = this.customerCheckRelationDas.select((BaseEo)reqDto);
        if (CollectionUtils.isNotEmpty((Collection)dbList2)) {
            rowIds = dbList2.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType())) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)a.getSalesmanId())).map(c -> c.getSalesmanId()).collect(Collectors.toList());
            List<Long> orgIds = dbList2.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType())) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)a.getOrgId())).map(c -> c.getOrgId()).collect(Collectors.toList());
            List storeThirdPartyIds = dbList2.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType())) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)a.getStoreThirdPartyId())).map(c -> c.getStoreThirdPartyId()).collect(Collectors.toList());
            ArrayList masterOuIds = new ArrayList();
            HashMap map = new HashMap(16);
            List<Object> customerRespDtoList = new ArrayList();
            if (CollectionUtils.isNotEmpty(orgIds)) {
                customerRespDtoList = this.customerQueryService.queryCustomerByOrgId(orgIds);
            }
            if (CollectionUtils.isNotEmpty(customerRespDtoList)) {
                masterOuIds.addAll(customerRespDtoList.stream().map(a -> a.getThirdPartyId()).collect(Collectors.toList()));
                customerRespDtoList.stream().filter(a -> org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)a.getOrgInfoId()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)a.getThirdPartyId())).forEach(c -> map.put(c.getOrgInfoId(), c.getThirdPartyId()));
            }
            if (CollectionUtils.isNotEmpty(rowIds) && CollectionUtils.isNotEmpty(storeThirdPartyIds) && CollectionUtils.isNotEmpty(masterOuIds)) {
                TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
                tbPersonPartnerRelReqDto.setRowIds(rowIds);
                tbPersonPartnerRelReqDto.setMasterOuIds(masterOuIds);
                tbPersonPartnerRelReqDto.setStoreThirdPartyIds(storeThirdPartyIds);
                log.info("\u6821\u9a8c\u8be5\u95e8\u5e97\u662f\u5426\u7ed1\u5b9a\u4e86\u5176\u4ed6\u7ecf\u9500\u5546\u4e0b\u7684\u4e1a\u52a1\u5458, \u5224\u65ad\u62a5\u8868\u4e2d\u5fc3\u4eba\u5458\u662f\u5426\u5df2\u7ecf\u5b58\u5728.... \u8bf7\u6c42\u53c2\u6570:" + JSON.toJSONString((Object)tbPersonPartnerRelReqDto));
                List personInfoList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.tbPersonPartnerRelQueryApi.queryByPage(JSON.toJSONString((Object)tbPersonPartnerRelReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)))).getList();
                if (CollectionUtils.isEmpty((Collection)personInfoList)) {
                    dbList2.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType()))).forEach(c -> {
                        c.setStatus(CustomerCheckStatusEnum.DISABLE.getStatus());
                        c.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.DISABLE_EMPLOYEE.getType());
                        int result = this.customerCheckRelationDas.update((BaseEo)c);
                        AssertUtil.isTrue((result > 0 ? 1 : 0) != 0, (String)"\u8003\u6838\u5173\u7cfb\u53d8\u66f4\u5931\u8d25\uff01");
                        log.info("bindStoreAndSalesmanRelation.checkPersonPartnerDisable \u7ed1\u5b9a\u65b0\u589e\u8003\u6838\u4eba\u5458,\u67e5\u8be2\u6821\u9a8c\u4e1a\u52a1\u5458\u662f\u5426\u5b58\u5728,(\u90fd\u4e0d\u5b58\u5728),\u5220\u9664\u4eba\u5e97\u7ed1\u5b9a\u5173\u7cfb:" + JSON.toJSONString((Object)c));
                    });
                } else {
                    Map<String, List<TbPersonPartnerRelRespDto>> personMap = personInfoList.stream().collect(Collectors.groupingBy(p -> p.getMasterOuId() + "-" + p.getCustomerId() + "-" + p.getRowId()));
                    dbList2.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType()))).forEach(c -> {
                        String key;
                        List partnerRelRespDtoList;
                        String customerThirdPartyId = (String)map.get(c.getOrgId());
                        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)customerThirdPartyId) && CollectionUtils.isEmpty((Collection)(partnerRelRespDtoList = (List)personMap.get(key = customerThirdPartyId + "-" + c.getStoreThirdPartyId() + "-" + c.getSalesmanId())))) {
                            c.setStatus(CustomerCheckStatusEnum.DISABLE.getStatus());
                            c.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.DISABLE_EMPLOYEE.getType());
                            int result = this.customerCheckRelationDas.update((BaseEo)c);
                            AssertUtil.isTrue((result > 0 ? 1 : 0) != 0, (String)"\u8003\u6838\u5173\u7cfb\u53d8\u66f4\u5931\u8d25\uff01");
                            log.info("bindStoreAndSalesmanRelation.checkPersonPartnerDisable \u7ed1\u5b9a\u65b0\u589e\u8003\u6838\u4eba\u5458,\u67e5\u8be2\u6821\u9a8c\u4e1a\u52a1\u5458\u662f\u5426\u5b58\u5728,(\u4eba\u5458\u5931\u6548),\u5220\u9664\u4eba\u5e97\u7ed1\u5b9a\u5173\u7cfb:" + JSON.toJSONString((Object)c));
                        }
                    });
                }
            }
        }
    }

    private void verifyRelation(CustomerCheckRelationReqDto addReqDto, BizChannelEnum bizChannelEnum) {
        CustomerCheckRelationEo customerCheckRelationReqDto = new CustomerCheckRelationEo();
        customerCheckRelationReqDto.setStoreId(addReqDto.getStoreId());
        customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        log.info("verifyRelation \u67e5\u8be2\u5f53\u524d\u95e8\u5e97\u662f\u5426\u7ed1\u5b9a\u4e86\u5176\u4ed6\u7ecf\u9500\u5546\u4e0b\u7684\u4eba\u5e97\u8003\u6838\u5173\u7cfb...... \u8bf7\u6c42\u53c2\u6570:" + JSON.toJSONString((Object)customerCheckRelationReqDto));
        List dbList = this.customerCheckRelationDas.select((BaseEo)customerCheckRelationReqDto);
        CustomerRespDto theCustomerRespDto = this.customerQueryService.queryByOrgInfoId(addReqDto.getOrgId());
        CustomerCheckPatternReqDto customerCheckPatternReqDto = new CustomerCheckPatternReqDto();
        customerCheckPatternReqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{theCustomerRespDto.getCode()}));
        List customerCheckPatternEos = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(customerCheckPatternReqDto);
        AssertUtil.isTrue((!org.springframework.util.CollectionUtils.isEmpty((Collection)customerCheckPatternEos) ? 1 : 0) != 0, (String)"\u5f53\u524d\u5ba2\u6237\u672a\u6307\u5b9a\u8003\u6838\u65b9\u5f0f\uff01");
        log.info("\u68c0\u6d4b\u662f\u5426\u5b58\u5728\u5408\u5e76\u8003\u6838\u7ecf\u9500\u5546 result => {} ", (Object)JSON.toJSONString((Object)customerCheckPatternEos));
        CustomerCheckPatternEo customerCheckPatternEo = (CustomerCheckPatternEo)customerCheckPatternEos.stream().findFirst().get();
        CheckPatternTypeEnum checkPatternTypeEnum = CheckPatternTypeEnum.enumOfType((Integer)customerCheckPatternEo.getPatternType());
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)checkPatternTypeEnum) ? 1 : 0) != 0, (String)"\u8003\u6838\u6a21\u5f0f\u4e0d\u5b58\u5728\uff01");
        AssertUtil.isTrue((boolean)bizChannelEnum.getCheckPatternTypes().contains(checkPatternTypeEnum), (String)"\u5f53\u524d\u4e1a\u52a1\u7ebf\u4e0d\u5b58\u5728\u8be5\u8003\u6838\u6a21\u5f0f");
        switch (checkPatternTypeEnum) {
            case ALONE_CHECK: {
                if (!CollectionUtils.isNotEmpty((Collection)dbList)) break;
                dbList.stream().filter(a -> BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType()))).forEach(eo -> {
                    CustomerRespDto customerRespDto = this.customerQueryService.queryByOrgInfoId(eo.getOrgId());
                    AssertUtil.isTrue((boolean)false, (String)String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)eo.getBizType().toString()).getDesc(), customerRespDto.getName()));
                });
                break;
            }
            case SEPARATE_CHECK: {
                List<CustomerCheckRelationEo> notByHealthList;
                if (!CollectionUtils.isNotEmpty((Collection)dbList) || !CollectionUtils.isNotEmpty(notByHealthList = dbList.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType()))).collect(Collectors.toList()))) break;
                notByHealthList.forEach(eo -> {
                    CustomerRespDto customerRespDto = this.customerQueryService.queryByOrgInfoId(eo.getOrgId());
                    AssertUtil.isTrue((!bizChannelEnum.getChannelCode().equals(String.valueOf(eo.getBizType())) ? 1 : 0) != 0, (String)String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)eo.getBizType().toString()).getDesc(), customerRespDto.getName()));
                    CustomerCheckPatternReqDto reqDto = new CustomerCheckPatternReqDto();
                    reqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{customerRespDto.getCode()}));
                    List patternEoList = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(reqDto);
                    patternEoList.forEach(patternEo -> AssertUtil.isTrue((!String.valueOf(CheckPatternTypeEnum.MERGE_CHECK.getType()).equals(String.valueOf(patternEo.getPatternType())) ? 1 : 0) != 0, (String)String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)eo.getBizType().toString()).getDesc(), customerRespDto.getName())));
                });
                break;
            }
            case MERGE_CHECK: {
                if (!CollectionUtils.isNotEmpty((Collection)dbList)) break;
                dbList.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType()))).forEach(eo -> this.verifyMergeCheckRule(theCustomerRespDto, (CustomerCheckRelationEo)eo, addReqDto.getStoreId()));
                break;
            }
            default: {
                throw new BizException("0001", "\u4e0d\u5b58\u5728\u5f53\u524d\u64cd\u4f5c\u7c7b\u578b");
            }
        }
    }

    private void verifyMergeCheckRule(CustomerRespDto customerRespDto, CustomerCheckRelationEo customerCheckRelationEo, String storeId) {
        AssertUtil.isTrue((!customerCheckRelationEo.getOrgId().equals(customerRespDto.getOrgInfoId()) ? 1 : 0) != 0, (String)"\u95e8\u5e97\u53ea\u53ef\u4ee5\u7ed1\u5b9a\u4e00\u4e2a\u4eba\u5458\u8fdb\u884c\u8003\u6838\uff0c\u7ed1\u5b9a\u540e\u82e5\u9700\u8c03\u6574\uff0c\u9700\u89e3\u9664\u7ed1\u5b9a\u540e\u624d\u53ef\u8fdb\u884c\u9009\u62e9");
        CustomerCheckPatternReqDto reqDto = new CustomerCheckPatternReqDto();
        reqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{customerRespDto.getCode()}));
        List patternEoList = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(reqDto);
        ArrayList orgIds = Lists.newArrayList();
        orgIds.addAll(patternEoList.stream().map(c -> c.getOrgId()).collect(Collectors.toList()));
        orgIds.addAll(patternEoList.stream().map(c -> c.getMergeOrgId()).collect(Collectors.toList()));
        CustomerRespDto theCustomerRespDto = this.customerQueryService.queryByOrgInfoId(customerCheckRelationEo.getOrgId());
        AssertUtil.isTrue((boolean)orgIds.contains(customerCheckRelationEo.getOrgId()), (String)String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)customerCheckRelationEo.getBizType().toString()).getDesc(), theCustomerRespDto.getName()));
        CustomerCheckPatternConfigReqDto customerCheckPatternConfigReqDto = new CustomerCheckPatternConfigReqDto();
        customerCheckPatternConfigReqDto.setOrganizationIds((List)orgIds);
        PageInfo<CustomerCheckPatternConfigRespDto> customerCheckPatternConfigRespDtoPageInfo = this.customerCheckPatternConfigService.queryByPage(JSON.toJSONString((Object)customerCheckPatternConfigReqDto), 1, Integer.MAX_VALUE);
        AssertUtil.isTrue((!org.springframework.util.CollectionUtils.isEmpty((Collection)customerCheckPatternConfigRespDtoPageInfo.getList()) ? 1 : 0) != 0, (String)String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)customerCheckRelationEo.getBizType().toString()).getDesc(), theCustomerRespDto.getName()));
        List<String> storeIds = this.calculateStoreIds(customerCheckPatternConfigRespDtoPageInfo.getList());
        AssertUtil.isTrue((!org.springframework.util.CollectionUtils.isEmpty(storeIds) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7ecf\u9500\u5546\u7ba1\u8f96\u5b58\u5728\u5f02\u5e38");
        SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(customerRespDto.getOrgInfoId()));
        List<StoreSellerRelateRespDto> storeSellerRelateRespDtos = this.storeSellerRelateService.queryStoreSellerRelateBySellerId(sellerRespDto.getId(), storeIds);
        AssertUtil.isTrue((boolean)storeSellerRelateRespDtos.stream().map(c -> c.getStoreId()).distinct().collect(Collectors.toList()).contains(storeId), (String)String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)customerCheckRelationEo.getBizType().toString()).getDesc(), theCustomerRespDto.getName()));
    }

    @Override
    public List<String> calculateStoreIds(List<CustomerCheckPatternConfigRespDto> customerCheckPatternConfigRespDtos) {
        if (org.springframework.util.CollectionUtils.isEmpty(customerCheckPatternConfigRespDtos)) {
            return Lists.newArrayList();
        }
        Map<String, List<CustomerCheckPatternConfigRespDto>> collect = customerCheckPatternConfigRespDtos.stream().collect(Collectors.groupingBy(CustomerCheckPatternConfigRespDto::getConfigType));
        ArrayList storeIds = Lists.newArrayList();
        storeIds.addAll(this.storeService.queryByArea(collect.getOrDefault(StoreGovernTypeEnum.AREA.getCode(), Lists.newArrayList()).stream().map(c -> c.getConfigContent()).collect(Collectors.toList())));
        List<String> storeParents = collect.getOrDefault(StoreGovernTypeEnum.STORE_PARENT.getCode(), Lists.newArrayList()).stream().map(c -> c.getConfigContent()).collect(Collectors.toList());
        List<StoreRespDto> storeRespDtos = this.storeService.queryListByIds(storeParents);
        if (!org.springframework.util.CollectionUtils.isEmpty(storeRespDtos)) {
            List creditNums = storeRespDtos.stream().map(c -> c.getSocialCreditNum()).collect(Collectors.toList());
            StoreQueryReqDto storeQueryReqDto = new StoreQueryReqDto();
            storeQueryReqDto.setParentSocialCreditNums(creditNums);
            storeQueryReqDto.setPageNum(1);
            storeQueryReqDto.setPageSize(Integer.MAX_VALUE);
            PageInfo<StoreRespDto> storeRespDtoPageInfo = this.storeService.queryPage(storeQueryReqDto);
            storeIds.addAll(org.springframework.util.CollectionUtils.isEmpty((Collection)storeRespDtoPageInfo.getList()) ? Lists.newArrayList() : (Collection)storeRespDtoPageInfo.getList().stream().map(c -> c.getStoreId()).collect(Collectors.toSet()));
        }
        storeIds.addAll(collect.getOrDefault(StoreGovernTypeEnum.STORE.getCode(), Lists.newArrayList()).stream().map(c -> c.getConfigContent()).collect(Collectors.toList()));
        storeIds.removeAll(collect.getOrDefault(StoreGovernTypeEnum.BLACKLIST.getCode(), Lists.newArrayList()).stream().map(c -> c.getConfigContent()).collect(Collectors.toList()));
        return storeIds;
    }

    @Override
    public void customerRelationToTenantScope(Long orgId, List<String> enableRecord) {
        CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
        customerCheckRelationReqDto.setOrgId(orgId);
        customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        List<CustomerCheckRelationRespDto> customerCheckRelationRespDtos = this.customerCheckRelationService.queryByStoreIds(customerCheckRelationReqDto);
        List disableStoreIds = customerCheckRelationRespDtos.stream().filter(c -> !enableRecord.contains(c.getStoreId())).map(c -> c.getStoreId()).distinct().collect(Collectors.toList());
        if (!org.springframework.util.CollectionUtils.isEmpty(disableStoreIds)) {
            ArrayList sqlFilters = Lists.newArrayList();
            CustomerCheckRelationEo customerCheckRelation = new CustomerCheckRelationEo();
            sqlFilters.add(SqlFilter.eq((String)"org_id", (Object)orgId));
            sqlFilters.add(SqlFilter.in((String)"store_id", disableStoreIds));
            customerCheckRelation.setSqlFilters((List)sqlFilters);
            customerCheckRelation.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
            customerCheckRelation.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.DISABLE_STORE_REL.getType());
            int result = this.customerCheckRelationDas.updateSelectiveSqlFilter((BaseEo)customerCheckRelation);
            AssertUtil.isTrue((result >= 0 ? 1 : 0) != 0, (String)("\u5931\u6548[" + orgId + "]\u7ec4\u7ec7\u4eba\u5e97\u5173\u7cfb\u5931\u8d25"));
        }
    }

    @NotNull
    private CustomerCheckStatusEnum verifyBindRelationParams(CustomerCheckRelationReqDto addReqDto, CustomerRespDto customerRespDto) {
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)addReqDto.getOrgId()) ? 1 : 0) != 0, (String)"\u7ec4\u7ec7ID\u4e3a\u7a7a!");
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)addReqDto.getStoreId()) ? 1 : 0) != 0, (String)"\u95e8\u5e97ID\u4e3a\u7a7a!");
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)addReqDto.getSalesmanId()) ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458ID\u4e3a\u7a7a!");
        AssertUtil.isTrue((!StringUtils.isEmpty((Object)addReqDto.getThirdPartyId()) ? 1 : 0) != 0, (String)"\u7ecf\u9500\u5546ID\u4e3a\u7a7a!");
        AssertUtil.isTrue((!StringUtils.isEmpty((Object)addReqDto.getStatus()) ? 1 : 0) != 0, (String)"\u8003\u6838\u5173\u7cfb\u72b6\u6001\u4e3a\u7a7a!");
        CustomerCheckStatusEnum customerCheckStatusEnum = CustomerCheckStatusEnum.enumOfStatus((Integer)addReqDto.getStatus());
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)customerCheckStatusEnum) ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u4e1a\u52a1\u65b9\u5f0f\uff01");
        TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
        tbPersonPartnerRelReqDto.setRowIds(Arrays.asList(addReqDto.getSalesmanId()));
        tbPersonPartnerRelReqDto.setCustomerId(addReqDto.getThirdPartyId());
        tbPersonPartnerRelReqDto.setMasterOuId(customerRespDto.getThirdPartyId());
        PageInfo tbPersonPartnerRelRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tbPersonPartnerRelQueryApi.queryByPage(JSON.toJSONString((Object)tbPersonPartnerRelReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)tbPersonPartnerRelRespDtoPageInfo.getList()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7ecf\u9500\u5546\u4e0d\u5b58\u5728\u8be5\u4e1a\u52a1\u5458");
        return customerCheckStatusEnum;
    }

    @Override
    public void customerRelationCheckStoreDisable(List<CustomerCheckRelationRespDto> checkRelationRespDtoList) {
        log.info("\u4eba\u5e97\u8003\u6838\u5173\u7cfb---->\u8c03\u5ea6\u5220\u9664  customerRelationCheckStoreDisable Star ");
        Map<Object, Object> map = new HashMap(16);
        if (CollectionUtils.isNotEmpty(checkRelationRespDtoList)) {
            List storeIds = checkRelationRespDtoList.stream().filter(a -> org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)a.getStoreId())).map(c -> c.getStoreId()).collect(Collectors.toList());
            List orgIds = checkRelationRespDtoList.stream().filter(a -> org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)a.getOrgId())).map(c -> c.getOrgId()).collect(Collectors.toList());
            CustomerStoreReqDto customerStoreReqDto = new CustomerStoreReqDto();
            customerStoreReqDto.setStoreIds(storeIds);
            customerStoreReqDto.setMerchantIds(orgIds);
            List customerStoreResponseDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerDistributorsQueryApi.queryCustomerStoreByPost(customerStoreReqDto));
            if (CollectionUtils.isNotEmpty((Collection)customerStoreResponseDtos)) {
                map = customerStoreResponseDtos.stream().collect(Collectors.groupingBy(a -> a.getMerchantId() + "-" + a.getStoreId()));
            } else {
                checkRelationRespDtoList.forEach(c -> {
                    CustomerCheckRelationEo updateEo = new CustomerCheckRelationEo();
                    DtoHelper.dto2Eo((BaseVo)c, (BaseEo)updateEo);
                    updateEo.setStatus(CustomerCheckStatusEnum.DISABLE.getStatus());
                    updateEo.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.DISABLE_STORE_REL.getType());
                    int result = this.customerCheckRelationDas.update((BaseEo)updateEo);
                    AssertUtil.isTrue((result > 0 ? 1 : 0) != 0, (String)"\u8003\u6838\u5173\u7cfb\u53d8\u66f4\u5931\u8d25\uff01");
                    log.info("[bindStoreAndSalesmanRelation.customerRelationCheckStoreDisable]\u95e8\u5e97\u5217\u8868\u5931\u6548[\u5168\u4e0d\u5b58\u5728],\u5220\u9664\u4eba\u5e97\u7ed1\u5b9a\u5173\u7cfb:" + JSON.toJSONString((Object)c));
                });
            }
            HashMap finalMap = map;
            checkRelationRespDtoList.forEach(c -> {
                List list = (List)finalMap.get(c.getOrgId() + "-" + c.getStoreId());
                if (CollectionUtils.isEmpty((Collection)list)) {
                    CustomerCheckRelationEo updateEo = new CustomerCheckRelationEo();
                    DtoHelper.dto2Eo((BaseVo)c, (BaseEo)updateEo);
                    updateEo.setStatus(CustomerCheckStatusEnum.DISABLE.getStatus());
                    updateEo.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.DISABLE_STORE_REL.getType());
                    int result = this.customerCheckRelationDas.update((BaseEo)updateEo);
                    AssertUtil.isTrue((result > 0 ? 1 : 0) != 0, (String)"\u8003\u6838\u5173\u7cfb\u53d8\u66f4\u5931\u8d25\uff01");
                    log.info("[bindStoreAndSalesmanRelation.customerRelationCheckStoreDisable]\u95e8\u5e97\u5217\u8868\u5931\u6548,\u5220\u9664\u4eba\u5e97\u7ed1\u5b9a\u5173\u7cfb:" + JSON.toJSONString((Object)c));
                }
            });
            log.info("\u4eba\u5e97\u8003\u6838\u5173\u7cfb---->\u8c03\u5ea6\u5220\u9664  customerRelationCheckStoreDisable End ");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void DetectionInsiderCheckRel() {
        ValidInsiderCheckRelReqDto validInsiderCheckRelReqDto = new ValidInsiderCheckRelReqDto();
        validInsiderCheckRelReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        validInsiderCheckRelReqDto.setIsException(YesOrNoEnum.YES.getCode());
        List validInsiderCheckRelRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerDistributorsQueryApi.queryValidInsiderCheckRel(validInsiderCheckRelReqDto));
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)validInsiderCheckRelRespDtos)) {
            log.info("\u76ee\u524d\u4e0d\u5b58\u5728\u7ed1\u5b9a\u6570\u636e\u4e0d\u4e00\u81f4\u8003\u6838\u5173\u7cfb");
            return;
        }
        validInsiderCheckRelRespDtos.forEach(rel -> {
            CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
            customerCheckRelationEo.setStoreThirdPartyId(rel.getCustomerId());
            customerCheckRelationEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"id", (Object)rel.getRelId())}));
            int result = this.customerCheckRelationDas.updateSelectiveSqlFilter((BaseEo)customerCheckRelationEo);
            AssertUtil.isTrue((result >= 0 ? 1 : 0) != 0, (String)"\u68c0\u67e5\u66f4\u65b0\u8003\u6838\u5173\u7cfb\u5173\u8054\u5ba2\u6237\u4fe1\u606f\u5931\u8d25");
        });
        List relIds = validInsiderCheckRelRespDtos.stream().map(c -> c.getRelId()).collect(Collectors.toList());
        List customerCheckRelationEos = this.customerCheckRelationDas.selectByIds(relIds);
        ArrayList checkRelationRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)customerCheckRelationEos, (Collection)checkRelationRespDtoList, CustomerCheckRelationRespDto.class);
        this.customerRelationCheckStoreDisable(checkRelationRespDtoList);
    }
}

