/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.dtyunxi.tcbj.api.dto.request.CustomerStoreReqDto;
import com.dtyunxi.tcbj.api.dto.request.TbPersonPartnerRelReqDto;
import com.dtyunxi.tcbj.api.dto.request.ValidInsiderCheckRelReqDto;
import com.dtyunxi.tcbj.api.dto.response.CustomerStoreResponseDto;
import com.dtyunxi.tcbj.api.dto.response.TbPersonPartnerRelRespDto;
import com.dtyunxi.tcbj.api.query.ICustomerDistributorsQueryApi;
import com.dtyunxi.tcbj.api.query.ITbPersonPartnerRelQueryApi;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.BizChannelEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CheckPatternTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckRelationExportOperateTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckRelationSourceOperateTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerCheckStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.CustomerStatusExtEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreCheckErrorEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreGovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternConfigReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckPatternReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckRelationExportReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckRelationReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckPatternConfigRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckPatternRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckRelationBindErrorRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerRelateRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckPatternConfigService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckPatternService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckRelationService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerRelateService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.impl.StoreAndSalesmanHelper;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerCheckPatternDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerCheckRelationDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerCheckPatternEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerCheckRelationEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.response.CustomerExtRespDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerExtThreeQueryApi;
import com.yx.tcbj.center.customer.biz.service.ICustomerExtThreeService;
import com.yx.tcbj.center.customer.biz.service.ICustomerQueryService;
import com.yx.tcbj.center.customer.biz.service.IStoreService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class CustomerCheckRelationServiceImpl
implements ICustomerCheckRelationService {
    private static final Logger log = LoggerFactory.getLogger(CustomerCheckRelationServiceImpl.class);
    public static final int IMPORT_LIST_LIMIT_SIZE = 100;
    private static Logger logger = LoggerFactory.getLogger(CustomerCheckRelationServiceImpl.class);
    @Resource
    private CustomerCheckRelationServiceImpl thisCustomerCheckRelationServiceImpl;
    @Resource
    private CustomerCheckRelationDas customerCheckRelationDas;
    @Resource
    private CustomerCheckPatternDas customerCheckPatternDas;
    @Resource
    private StoreAndSalesmanHelper storeAndSalesmanHelper;
    @Resource
    private ICustomerQueryService customerQueryService;
    @Resource
    private ITbPersonPartnerRelQueryApi tbPersonPartnerRelQueryApi;
    @Resource
    private ICustomerCheckPatternService customerCheckPatternService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IStoreService storeService;
    @Resource
    private ICustomerCheckRelationService customerCheckRelationService;
    @Resource
    private ICustomerDistributorsQueryApi customerDistributorsQueryApi;
    @Resource
    private ILockService lockService;
    @Resource
    private ICustomerCheckPatternConfigService customerCheckPatternConfigService;
    @Resource
    private IStoreSellerRelateService storeSellerRelateService;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;
    @Resource
    private ICustomerExtThreeQueryApi customerExtThreeQueryApi;
    @Resource
    private ICustomerExtThreeService customerExtThreeService;

    @Override
    public Long addCustomerCheckRelation(CustomerCheckRelationReqDto addReqDto) {
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerCheckRelationEo);
        this.customerCheckRelationDas.insert((BaseEo)customerCheckRelationEo);
        return customerCheckRelationEo.getId();
    }

    @Override
    public void modifyCustomerCheckRelation(CustomerCheckRelationReqDto modifyReqDto) {
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerCheckRelationEo);
        this.customerCheckRelationDas.updateSelective((BaseEo)customerCheckRelationEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerCheckRelation(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerCheckRelationDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CustomerCheckRelationRespDto queryById(Long id) {
        CustomerCheckRelationEo customerCheckRelationEo = (CustomerCheckRelationEo)this.customerCheckRelationDas.selectByPrimaryKey(id);
        CustomerCheckRelationRespDto customerCheckRelationRespDto = new CustomerCheckRelationRespDto();
        DtoHelper.eo2Dto((BaseEo)customerCheckRelationEo, (BaseVo)customerCheckRelationRespDto);
        return customerCheckRelationRespDto;
    }

    @Override
    public PageInfo<CustomerCheckRelationRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerCheckRelationReqDto customerCheckRelationReqDto = (CustomerCheckRelationReqDto)JSON.parseObject((String)filter, CustomerCheckRelationReqDto.class);
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        DtoHelper.dto2Eo((BaseVo)customerCheckRelationReqDto, (BaseEo)customerCheckRelationEo);
        ArrayList sqlFilters = Lists.newArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerCheckRelationReqDto.getStatusList())) {
            sqlFilters.add(SqlFilter.in((String)"status", (Object)customerCheckRelationReqDto.getStatusList()));
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerCheckRelationReqDto.getStoreIds())) {
            sqlFilters.add(SqlFilter.in((String)"store_id", (Object)customerCheckRelationReqDto.getStoreIds()));
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerCheckRelationReqDto.getOrgIds())) {
            sqlFilters.add(SqlFilter.in((String)"org_id", (Object)customerCheckRelationReqDto.getOrgIds()));
        }
        customerCheckRelationEo.setSqlFilters((List)sqlFilters);
        customerCheckRelationEo.setOrderByDesc("update_time");
        customerCheckRelationEo.setDr(0);
        PageInfo eoPageInfo = this.customerCheckRelationDas.selectPage((BaseEo)customerCheckRelationEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerCheckRelationRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<CustomerCheckRelationRespDto> queryByStoreIds(CustomerCheckRelationReqDto customerCheckRelationReqDto) {
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        DtoHelper.dto2Eo((BaseVo)customerCheckRelationReqDto, (BaseEo)customerCheckRelationEo);
        ArrayList sqlFilters = Lists.newArrayList();
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerCheckRelationReqDto.getStoreIds())) {
            sqlFilters.add(SqlFilter.in((String)"store_id", (Object)customerCheckRelationReqDto.getStoreIds()));
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)customerCheckRelationReqDto.getOrgIds())) {
            sqlFilters.add(SqlFilter.in((String)"org_id", (Object)customerCheckRelationReqDto.getOrgIds()));
        }
        customerCheckRelationEo.setSqlFilters((List)sqlFilters);
        List results = this.customerCheckRelationDas.select((BaseEo)customerCheckRelationEo);
        ArrayList customerCheckRelationRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)results, (Collection)customerCheckRelationRespDtos, CustomerCheckRelationRespDto.class);
        return customerCheckRelationRespDtos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bindStoreAndSalesmanRelation(CustomerCheckRelationReqDto addReqDto) {
        CustomerCheckRelationServiceImpl.log.info("\u7ed1\u5b9a\u5ba2\u6237\u5173\u7cfb req params => {} ", (Object)JSON.toJSONString((Object)addReqDto));
        AssertUtil.isTrue((boolean)(ObjectUtils.isEmpty((Object)addReqDto.getOrgId()) == false), (String)("\u7ec4\u7ec7ID\u4e3a\u7a7a,addReqDto:" + JSON.toJSONString((Object)addReqDto)));
        orgId = addReqDto.getOrgId();
        customerRespDto = this.customerQueryService.queryByOrgInfoId(orgId);
        AssertUtil.isTrue((boolean)(ObjectUtils.isEmpty((Object)customerRespDto) == false), (String)"\u5f53\u524d\u5ba2\u6237\u4e0d\u5b58\u5728");
        AssertUtil.isTrue((boolean)CustomerStatusExtEnum.ENABLED.getCode().equals(customerRespDto.getStatusId()), (String)"\u5f53\u524d\u5ba2\u6237\u975e\u5408\u6cd5\u72b6\u6001");
        mutex = null;
        AssertUtil.isTrue((boolean)CustomerStatusExtEnum.ENABLED.getCode().equals(customerRespDto.getStatusId()), (String)"\u5f53\u524d\u5ba2\u6237\u975e\u5408\u6cd5\u72b6\u6001");
        lockKey = addReqDto.getOrgId() + "-" + addReqDto.getStoreId() + "-" + addReqDto.getStatus();
        try {
            mutex = this.lockService.lock("bindStoreAndSalesmanRelation", lockKey, 10, 5, TimeUnit.MINUTES);
            customerCheckStatusEnum = this.verifyBindRelationParams(addReqDto, customerRespDto);
            bizChannelEnum = this.storeAndSalesmanHelper.calculateBizChannel(addReqDto.getThirdPartyId());
            switch (1.$SwitchMap$com$dtyunxi$yundt$cube$center$customer$api$constants$CustomerCheckStatusEnum[customerCheckStatusEnum.ordinal()]) {
                case 1: {
                    this.checkStoreIdsDisable(addReqDto.getStoreId());
                    this.checkPersonPartnerDisable(orgId, addReqDto, customerRespDto);
                    this.verifyRelation(addReqDto, bizChannelEnum);
                    this.insertCustomerCheckRelationEo(addReqDto, bizChannelEnum);
                    ** break;
                }
                case 2: {
                    customerCheckRelation = new CustomerCheckRelationEo();
                    customerCheckRelation.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"biz_type", (Object)bizChannelEnum.getBizTypes())}));
                    customerCheckRelation.setStoreId(addReqDto.getStoreId());
                    customerCheckRelation.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
                    customerCheckRelation.setOrgId(addReqDto.getOrgId());
                    list = this.customerCheckRelationDas.select((BaseEo)customerCheckRelation);
                    AssertUtil.isTrue((boolean)(list.size() > 0), (String)"\u8003\u6838\u95e8\u5e97\u5173\u7cfb\u5b58\u5728\u5f02\u5e38\uff01");
                    customerCheckRelation = (CustomerCheckRelationEo)list.stream().findFirst().get();
                    AssertUtil.isTrue((boolean)customerCheckRelation.getOrgId().equals(addReqDto.getOrgId()), (String)"\u5f53\u524d\u89e3\u7ed1\u5173\u7cfb\u4e0e\u6240\u5c5e\u516c\u53f8\u4e0d\u4e00\u81f4\uff01");
                    AssertUtil.isTrue((boolean)customerCheckRelation.getStoreId().equals(addReqDto.getStoreId()), (String)"\u89e3\u7ed1\u95e8\u5e97\u4e0e\u5f53\u524d\u7ed1\u5b9a\u95e8\u5e97\u4e0d\u4e00\u81f4\uff01");
                    AssertUtil.isTrue((boolean)customerCheckRelation.getSalesmanId().equals(addReqDto.getSalesmanId()), (String)"\u89e3\u7ed1\u4e1a\u52a1\u5458\u4e0e\u5f53\u524d\u7ed1\u5b9a\u4e1a\u52a1\u5458\u4e0d\u4e00\u81f4\uff01");
                    customerCheckRelation.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
                    customerCheckRelation.setSourceOperateType(StringUtils.isNotBlank((CharSequence)addReqDto.getSourceOperateType()) != false ? addReqDto.getSourceOperateType() : CustomerCheckRelationSourceOperateTypeEnum.MANUAL.getType());
                    this.customerCheckRelationDas.updateSelective((BaseEo)customerCheckRelation);
                    ** break;
                }
                default: {
                    throw new BizException("0001", "\u4e0d\u5b58\u5728\u5f53\u524d\u64cd\u4f5c\u7c7b\u578b");
lbl40:
                    // 2 sources

                }
            }
        }
        catch (Throwable var10_10) {
            this.lockService.unlock(mutex);
            throw var10_10;
        }
        this.lockService.unlock(mutex);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<CustomerCheckRelationBindErrorRespDto> batchBindStoreAndSalesmanRelation(List<CustomerCheckRelationReqDto> addReqDtoList) {
        ArrayList respDtoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(addReqDtoList)) {
            return respDtoList;
        }
        long startTime = System.currentTimeMillis();
        log.info("\u6279\u91cf\u7ed1\u5b9a\u5ba2\u6237\u5173\u7cfb batchBindStoreAndSalesmanRelation \u5f00\u59cb\u6267\u884c\u65f6\u95f4:{}, req params => {} ", (Object)DateUtil.now(), (Object)JSON.toJSONString(addReqDtoList));
        List<CustomerCheckRelationBindErrorRespDto> resultList = this.handleBatchBindStoreAndSalesmanRelation(addReqDtoList);
        long endTime = System.currentTimeMillis();
        log.info("\u6279\u91cf\u7ed1\u5b9a\u5ba2\u6237\u5173\u7cfb batchBindStoreAndSalesmanRelation \u6267\u884c\u7ed3\u675f\u65f6\u95f4:{} ,req params => {} ", (Object)DateUtil.now(), (Object)JSON.toJSONString(addReqDtoList));
        log.info("\u6279\u91cf\u7ed1\u5b9a\u5ba2\u6237\u5173\u7cfb batchBindStoreAndSalesmanRelation \u603b\u5171\u8017\u65f6:{}ms, \u603b\u5171\u6267\u884c:{}\u6761, req params => {} ", new Object[]{endTime - startTime, addReqDtoList.size(), JSON.toJSONString(addReqDtoList)});
        return resultList;
    }

    @Override
    public List<CustomerCheckRelationBindErrorRespDto> batchBindStoreAndSalesmanRelation_V2(List<CustomerCheckRelationExportReqDto> importList) {
        ArrayList errorList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(importList)) {
            return errorList;
        }
        log.info("\u6279\u91cf\u7ed1\u5b9a\u5ba2\u6237\u5173\u7cfb CustomerCheckRelationServiceImpl batchBindStoreAndSalesmanRelation_V2  \u5bfc\u5165\u65f6\u95f4:{},\u5bfc\u5165\u603b\u6761\u6570:{},  Excel \u5bfc\u5165data\uff1a => {} ", new Object[]{DateUtil.now(), importList.size(), JSON.toJSONString(importList)});
        String userName = this.context.userName();
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCurrentUserOrgId());
        BizChannelEnum bizChannelEnum = BizChannelEnum.enumOfChannelCode((String)String.valueOf(orgId));
        int everyTimeSize = 100;
        int limit = (importList.size() + everyTimeSize - 1) / everyTimeSize;
        long startTime_V1 = System.currentTimeMillis();
        List<CompletableFuture<List<CustomerCheckRelationExportReqDto>>> futureList_v1 = CustomerCheckRelationServiceImpl.getFutureList_v1(importList, limit, everyTimeSize, bizChannelEnum, errorList);
        long endTime_V1 = System.currentTimeMillis();
        log.info("\u7b2c\u4e00\u6ce2\u6821\u9a8cExcel\u662f\u5426\u6b63\u5e38\u8f93\u5165\u586b\u5199  v1_\u65b9\u6cd5\u6267\u884c\u8017\u65f6\uff1a" + (endTime_V1 - startTime_V1) + "ms , \u6267\u884c\u6761\u6570\uff1a" + importList.size());
        List<CustomerCheckRelationExportReqDto> importList_v1 = futureList_v1.stream().map(CompletableFuture::join).flatMap(Collection::stream).filter(c -> !c.isSkipFlag()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(importList_v1)) {
            return errorList;
        }
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)bizChannelEnum)) {
            CustomerRespDto customerRespDto = (CustomerRespDto)this.customerExtQueryApi.queryOneByOrgId(orgId).getData();
            Assert.isTrue((boolean)org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)customerRespDto), (String)"0001", (String)"\u5f53\u524d\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
            importList_v1.stream().filter(a -> !a.isSkipFlag()).forEach(a -> {
                a.setOrgId(customerRespDto.getOrgInfoId());
                a.setCustomerCode(customerRespDto.getCode());
                a.setMerchantId(customerRespDto.getMerchantId());
                a.setCustomerThirdPartyId(customerRespDto.getThirdPartyId());
            });
        }
        List<String> customerCodeList = importList_v1.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getCustomerCode())).map(c -> c.getCustomerCode()).collect(Collectors.toList());
        List<CustomerExtRespDto> customerExtRespDtoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(customerCodeList)) {
            customerCodeList = customerCodeList.stream().distinct().collect(Collectors.toList());
            customerExtRespDtoList = (List)this.customerExtThreeService.queryByCodeList(customerCodeList).getData();
        }
        List<Object> customerOrgIdList = Lists.newArrayList();
        ArrayList customerMerchantIdList = Lists.newArrayList();
        List<Object> customerThirdPartyIdList = Lists.newArrayList();
        HashMap<String, CustomerExtRespDto> customerCodeMap = new HashMap(16);
        if (CollectionUtils.isNotEmpty((Collection)customerExtRespDtoList)) {
            customerCodeMap = customerExtRespDtoList.stream().collect(Collectors.toMap(CustomerRespDto::getCode, obj -> obj, (o, n) -> o));
            customerMerchantIdList.addAll(customerExtRespDtoList.stream().filter(a -> org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)a.getMerchantId())).map(c -> c.getMerchantId()).collect(Collectors.toList()));
            customerThirdPartyIdList.addAll(customerExtRespDtoList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getThirdPartyId())).map(c -> c.getThirdPartyId()).collect(Collectors.toList()));
            customerOrgIdList.addAll(customerExtRespDtoList.stream().filter(a -> org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)a.getOrgInfoId())).map(c -> c.getOrgInfoId()).collect(Collectors.toList()));
        }
        List storeNoList = importList_v1.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getStoreNo())).map(c -> c.getStoreNo()).collect(Collectors.toList());
        List salesmanCodeList = importList_v1.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSalesmanCode())).map(c -> c.getSalesmanCode()).collect(Collectors.toList());
        ArrayList storeIds = Lists.newArrayList();
        ArrayList storeCustomerIdList = Lists.newArrayList();
        Map<String, List<CustomerStoreResponseDto>> customerStoreStoreNoCustomerMerchantIdMap = new HashMap<String, List<CustomerStoreResponseDto>>(16);
        Map<String, CustomerStoreResponseDto> customerStoreStoreNoMap = new HashMap<String, CustomerStoreResponseDto>(16);
        if (CollectionUtils.isNotEmpty(storeNoList) && CollectionUtils.isNotEmpty((Collection)customerOrgIdList)) {
            storeNoList = storeNoList.stream().distinct().collect(Collectors.toList());
            customerOrgIdList = customerOrgIdList.stream().distinct().collect(Collectors.toList());
            CustomerStoreReqDto customerStoreReqDto = new CustomerStoreReqDto();
            customerStoreReqDto.setStoreNos(storeNoList);
            customerStoreReqDto.setMerchantIds((List)customerOrgIdList);
            List customerStoreResponseDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerDistributorsQueryApi.queryCustomerStoreByPost(customerStoreReqDto));
            if (CollectionUtils.isNotEmpty((Collection)customerStoreResponseDtoList)) {
                customerStoreStoreNoMap = customerStoreResponseDtoList.stream().collect(Collectors.toMap(CustomerStoreResponseDto::getStoreNo, obj -> obj, (o, n) -> o));
                customerStoreStoreNoCustomerMerchantIdMap = customerStoreResponseDtoList.stream().collect(Collectors.groupingBy(c -> c.getStoreNo() + "-" + c.getMerchantId()));
                storeIds.addAll(customerStoreResponseDtoList.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getStoreId())).map(a -> a.getStoreId()).collect(Collectors.toList()));
                storeCustomerIdList.addAll(customerStoreResponseDtoList.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getCustomerId())).map(a -> a.getCustomerId()).collect(Collectors.toList()));
            }
        }
        Map<String, List<TbPersonPartnerRelRespDto>> personSalesmanCodeCustomerThirdPartyIdMap = new HashMap<String, List<TbPersonPartnerRelRespDto>>(16);
        Map<String, List<TbPersonPartnerRelRespDto>> personSalesmanCodeCustomerThirdPartyIStoreThirdPartyIdMap = new HashMap<String, List<TbPersonPartnerRelRespDto>>(16);
        Map<String, List<TbPersonPartnerRelRespDto>> personRowIdStoreThirdPartyIdCustomerThirdPartyIdMap = new HashMap<String, List<TbPersonPartnerRelRespDto>>(16);
        if (CollectionUtils.isNotEmpty(salesmanCodeList) && CollectionUtils.isNotEmpty((Collection)customerThirdPartyIdList) && CollectionUtils.isNotEmpty((Collection)storeCustomerIdList)) {
            salesmanCodeList = salesmanCodeList.stream().distinct().collect(Collectors.toList());
            customerThirdPartyIdList = customerThirdPartyIdList.stream().distinct().collect(Collectors.toList());
            TbPersonPartnerRelReqDto personPartnerRelReqDto = new TbPersonPartnerRelReqDto();
            personPartnerRelReqDto.setEmpNos(salesmanCodeList);
            personPartnerRelReqDto.setMasterOuIds((List)customerThirdPartyIdList);
            personPartnerRelReqDto.setStoreThirdPartyIds((List)storeCustomerIdList);
            List personPartnerList = (List)RestResponseHelper.extractData((RestResponse)this.tbPersonPartnerRelQueryApi.queryByPost(personPartnerRelReqDto));
            if (CollectionUtils.isNotEmpty((Collection)personPartnerList)) {
                personSalesmanCodeCustomerThirdPartyIdMap = personPartnerList.stream().collect(Collectors.groupingBy(p -> p.getEmpNo() + "-" + p.getMasterOuId()));
                personSalesmanCodeCustomerThirdPartyIStoreThirdPartyIdMap = personPartnerList.stream().collect(Collectors.groupingBy(p -> p.getEmpNo() + "-" + p.getMasterOuId() + "-" + p.getCustomerId()));
                personRowIdStoreThirdPartyIdCustomerThirdPartyIdMap = personPartnerList.stream().collect(Collectors.groupingBy(p -> p.getRowId() + "-" + p.getCustomerId() + "-" + p.getMasterOuId()));
            }
        }
        long startTime_V2 = System.currentTimeMillis();
        List<CompletableFuture<List<CustomerCheckRelationExportReqDto>>> futureList_v2 = this.getFutureList_v2(limit, importList_v1, everyTimeSize, customerCodeMap, errorList, orgId, customerStoreStoreNoMap, customerStoreStoreNoCustomerMerchantIdMap, personSalesmanCodeCustomerThirdPartyIdMap, personSalesmanCodeCustomerThirdPartyIStoreThirdPartyIdMap, personRowIdStoreThirdPartyIdCustomerThirdPartyIdMap);
        long endTime_V2 = System.currentTimeMillis();
        log.info("\u57fa\u7840\u4fe1\u606f\uff08\u5ba2\u6237\uff0c\u95e8\u5e97\uff0c\u4e1a\u52a1\u5458\uff09\u5173\u7cfb\u6570\u636e\u6821\u9a8c  getFutureList_v2 \u65b9\u6cd5\u6267\u884c\u8017\u65f6\uff1a" + (endTime_V2 - startTime_V2) + "ms , \u6267\u884c\u6761\u6570\uff1a" + importList_v1.size());
        List<CustomerCheckRelationExportReqDto> importList_v2 = futureList_v2.stream().map(CompletableFuture::join).flatMap(Collection::stream).filter(c -> !c.isSkipFlag()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(importList_v2)) {
            return errorList;
        }
        long startTime_V3 = System.currentTimeMillis();
        List<CompletableFuture<List<CustomerCheckRelationExportReqDto>>> futureList_v3 = this.getFutureList_v3(limit, importList_v2, everyTimeSize, errorList, userName);
        long endTime_V3 = System.currentTimeMillis();
        log.info("\u5148\u6267\u884c\u4e00\u6ce2 \u5220\u9664\u5931\u6548 \u7684\u64cd\u4f5c\u7c7b\u578b\u3002 \u65b9\u4fbf\u540e\u9762\u51cf\u5c11\u67e5\u8be2db  getFutureList_v3 \u65b9\u6cd5\u6267\u884c\u8017\u65f6\uff1a" + (endTime_V3 - startTime_V3) + "ms , \u6267\u884c\u6761\u6570\uff1a" + importList_v2.size());
        List importList_v3 = futureList_v3.stream().map(CompletableFuture::join).flatMap(Collection::stream).filter(c -> !c.isSkipFlag()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(importList_v3)) {
            return errorList;
        }
        List<Object> importList_v4 = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(importList_v3)) {
            List<CustomerCheckRelationExportReqDto> importAddOrUpdateList = importList_v3.stream().filter(i -> CustomerCheckRelationExportOperateTypeEnum.ADD_OR_UPDATE.getName().equals(i.getOperateType())).collect(Collectors.toList());
            this.thisCustomerCheckRelationServiceImpl.coverDeleteExistCustomerCheckRelation(importAddOrUpdateList, bizChannelEnum);
            long startTime_V4 = System.currentTimeMillis();
            List<CompletableFuture<List<CustomerCheckRelationExportReqDto>>> futureList_v4 = this.getFutureList_v4(limit, importAddOrUpdateList, everyTimeSize, errorList, bizChannelEnum);
            long endTime_V4 = System.currentTimeMillis();
            log.info("\u6839\u636e\u8003\u6838\u6a21\u5f0f\u68c0\u9a8c\u662f\u5426\u80fd\u65b0\u589e\u4eba\u5e97\u8003\u6838\u7ed1\u5b9a  getFutureList_v4 \u65b9\u6cd5\u6267\u884c\u8017\u65f6\uff1a" + (endTime_V4 - startTime_V4) + "ms , \u6267\u884c\u6761\u6570\uff1a" + importAddOrUpdateList.size());
            importList_v4 = futureList_v4.stream().map(CompletableFuture::join).flatMap(Collection::stream).filter(c -> !c.isSkipFlag()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty((Collection)importList_v4)) {
                return errorList;
            }
        }
        List<Object> importList_v5 = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)importList_v4)) {
            long startTime_V5 = System.currentTimeMillis();
            List<CompletableFuture<List<CustomerCheckRelationExportReqDto>>> futureList_v5 = this.getFutureList_v5(limit, importList_v4, everyTimeSize, customerExtRespDtoList);
            long endTime_V5 = System.currentTimeMillis();
            log.info("batchBindStoreAndSalesmanRelation_V2_add_operate_type \u65b9\u6cd5\u6267\u884c\u8017\u65f6\uff1a" + (endTime_V5 - startTime_V5) + "ms , \u6267\u884c\u6761\u6570\uff1a" + importList_v4.size());
            importList_v5 = futureList_v5.stream().map(CompletableFuture::join).flatMap(Collection::stream).filter(c -> !c.isSkipFlag()).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(futureList_v5)) {
                return errorList;
            }
        }
        List<Object> insertList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)importList_v5)) {
            insertList = CustomerCheckRelationServiceImpl.getInsertList(importList_v5, userName);
        }
        if (CollectionUtils.isNotEmpty((Collection)insertList)) {
            this.customerCheckRelationDas.insertBatch((List)insertList);
        }
        return errorList;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void coverDeleteExistCustomerCheckRelation(List<CustomerCheckRelationExportReqDto> importAddOrUpdateList, BizChannelEnum bizChannelEnum) {
        if (CollectionUtils.isNotEmpty(importAddOrUpdateList)) {
            CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
            customerCheckRelationReqDto.setStoreIds(importAddOrUpdateList.stream().map(CustomerCheckRelationExportReqDto::getStoreId).distinct().collect(Collectors.toList()));
            customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
            List customerCheckRelationList = this.queryByPage(JSON.toJSONString((Object)customerCheckRelationReqDto), 1, Integer.MAX_VALUE).getList();
            ArrayList dbList = Lists.newArrayList();
            Map<Object, Object> customerCheckRelationOrgIdStoreIdMap = new HashMap(16);
            Map<Object, Object> customerCheckRelationStoreIdMap = new HashMap(16);
            if (CollectionUtils.isNotEmpty((Collection)customerCheckRelationList)) {
                if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)bizChannelEnum)) {
                    customerCheckRelationOrgIdStoreIdMap = customerCheckRelationList.stream().collect(Collectors.groupingBy(c -> c.getOrgId() + "-" + c.getStoreId()));
                } else {
                    customerCheckRelationStoreIdMap = customerCheckRelationList.stream().collect(Collectors.groupingBy(c -> c.getStoreId()));
                }
                for (CustomerCheckRelationExportReqDto vo : importAddOrUpdateList) {
                    List dtoList;
                    if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)bizChannelEnum)) {
                        dtoList = (List)customerCheckRelationOrgIdStoreIdMap.get(vo.getOrgId() + "-" + vo.getStoreId());
                        if (!CollectionUtils.isNotEmpty((Collection)dtoList)) continue;
                        dbList.addAll(dtoList);
                        continue;
                    }
                    dtoList = (List)customerCheckRelationStoreIdMap.get(vo.getStoreId());
                    if (!CollectionUtils.isNotEmpty((Collection)dtoList)) continue;
                    dbList.addAll(dtoList);
                }
            }
            ArrayList updateList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)dbList)) {
                log.info("\u6279\u91cf\u7ed1\u5b9a\u5ba2\u6237\u5173\u7cfb  coverDeleteExistCustomerCheckRelation   \u5b58\u5728\u539f\u6709\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u5219\u9700\u8981\u8986\u76d6 dbList\uff1a{}", (Object)JSON.toJSONString((Object)dbList));
                for (CustomerCheckRelationRespDto relationRespDto : dbList) {
                    CustomerCheckRelationEo updateEo = new CustomerCheckRelationEo();
                    BeanUtils.copyProperties((Object)relationRespDto, (Object)updateEo);
                    updateEo.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
                    updateEo.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.EXCEL.getType());
                    updateEo.setUpdatePerson(this.context.userName());
                    updateList.add(updateEo);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                log.info("\u6279\u91cf\u7ed1\u5b9a\u5ba2\u6237\u5173\u7cfb  coverDeleteExistCustomerCheckRelation   \u5b58\u5728\u539f\u6709\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u5219\u9700\u8981\u8986\u76d6 updateBatch\uff1a{}", (Object)JSON.toJSONString((Object)updateList));
                this.customerCheckRelationDas.updateBatch((List)updateList);
            }
        }
    }

    @NotNull
    private static List<CompletableFuture<List<CustomerCheckRelationExportReqDto>>> getFutureList_v1(List<CustomerCheckRelationExportReqDto> importList, int limit, int applyIdSelectSize, BizChannelEnum bizChannelEnum, List<CustomerCheckRelationBindErrorRespDto> errorList) {
        ArrayList futureList_v1 = Lists.newArrayList();
        Stream.iterate(0, n -> n + 1).limit(limit).forEach(a -> {
            List collect = importList.stream().skip(a * applyIdSelectSize).limit(applyIdSelectSize).collect(Collectors.toList());
            futureList_v1.add(CompletableFuture.supplyAsync(() -> CustomerCheckRelationServiceImpl.batchBindStoreAndSalesmanRelation_V2_before_check_v1(collect, bizChannelEnum, errorList)));
        });
        return futureList_v1;
    }

    @NotNull
    private List<CompletableFuture<List<CustomerCheckRelationExportReqDto>>> getFutureList_v2(int limit, List<CustomerCheckRelationExportReqDto> importList_v1, int applyIdSelectSize, Map<String, CustomerExtRespDto> customerCodeMap, List<CustomerCheckRelationBindErrorRespDto> errorList, Long orgId, Map<String, CustomerStoreResponseDto> customerStoreStoreNoMap, Map<String, List<CustomerStoreResponseDto>> customerStoreStoreNoCustomerMerchantIdMap, Map<String, List<TbPersonPartnerRelRespDto>> personSalesmanCodeCustomerThirdPartyIdMap, Map<String, List<TbPersonPartnerRelRespDto>> personSalesmanCodeCustomerThirdPartyIStoreThirdPartyIdMap, Map<String, List<TbPersonPartnerRelRespDto>> personRowIdStoreThirdPartyIdCustomerThirdPartyIdMap) {
        ArrayList futureList_v2 = Lists.newArrayList();
        Stream.iterate(0, n -> n + 1).limit(limit).forEach(a -> {
            List collect = importList_v1.stream().skip(a * applyIdSelectSize).limit(applyIdSelectSize).collect(Collectors.toList());
            futureList_v2.add(CompletableFuture.supplyAsync(() -> this.batchBindStoreAndSalesmanRelation_V2_before_check_v2(collect, customerCodeMap, errorList, customerStoreStoreNoMap, customerStoreStoreNoCustomerMerchantIdMap, personSalesmanCodeCustomerThirdPartyIdMap, personSalesmanCodeCustomerThirdPartyIStoreThirdPartyIdMap, personRowIdStoreThirdPartyIdCustomerThirdPartyIdMap)));
        });
        return futureList_v2;
    }

    @NotNull
    private List<CompletableFuture<List<CustomerCheckRelationExportReqDto>>> getFutureList_v3(int limit, List<CustomerCheckRelationExportReqDto> importList_v2, int applyIdSelectSize, List<CustomerCheckRelationBindErrorRespDto> errorList, String userName) {
        ArrayList futureList_v3 = Lists.newArrayList();
        Stream.iterate(0, n -> n + 1).limit(limit).forEach(a -> {
            List collect = importList_v2.stream().skip(a * applyIdSelectSize).limit(applyIdSelectSize).collect(Collectors.toList());
            futureList_v3.add(CompletableFuture.supplyAsync(() -> this.thisCustomerCheckRelationServiceImpl.batchBindStoreAndSalesmanRelation_V2_delete_operate_type(collect, errorList, userName)));
        });
        return futureList_v3;
    }

    @NotNull
    private List<CompletableFuture<List<CustomerCheckRelationExportReqDto>>> getFutureList_v4(int limit, List<CustomerCheckRelationExportReqDto> importAddOrUpdateList, int applyIdSelectSize, List<CustomerCheckRelationBindErrorRespDto> errorList, BizChannelEnum bizChannelEnum) {
        ArrayList futureList_v4 = Lists.newArrayList();
        Stream.iterate(0, n -> n + 1).limit(limit).forEach(a -> {
            List collect = importAddOrUpdateList.stream().skip(a * applyIdSelectSize).limit(applyIdSelectSize).collect(Collectors.toList());
            futureList_v4.add(CompletableFuture.supplyAsync(() -> this.batchBindStoreAndSalesmanRelation_V2_add_operateType_check_pattern_type(collect, errorList, bizChannelEnum)));
        });
        return futureList_v4;
    }

    @NotNull
    private List<CompletableFuture<List<CustomerCheckRelationExportReqDto>>> getFutureList_v5(int limit, List<CustomerCheckRelationExportReqDto> finalImportList_v4, int applyIdSelectSize, List<CustomerExtRespDto> finalCustomerExtRespDtoList) {
        ArrayList futureList_v5 = Lists.newArrayList();
        Stream.iterate(0, n -> n + 1).limit(limit).forEach(a -> {
            List collect = finalImportList_v4.stream().skip(a * applyIdSelectSize).limit(applyIdSelectSize).collect(Collectors.toList());
            futureList_v5.add(CompletableFuture.supplyAsync(() -> this.batchBindStoreAndSalesmanRelation_V2_add_operate_type(collect, finalCustomerExtRespDtoList)));
        });
        return futureList_v5;
    }

    private static List<CustomerCheckRelationEo> getInsertList(List<CustomerCheckRelationExportReqDto> importList, String userName) {
        ArrayList insertList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(importList)) {
            importList.stream().filter(a -> !a.isSkipFlag()).forEach(vo -> {
                if (CustomerCheckRelationExportOperateTypeEnum.ADD_OR_UPDATE.getName().equals(vo.getOperateType())) {
                    CustomerCheckRelationEo addEo = new CustomerCheckRelationEo();
                    addEo.setStoreId(vo.getStoreId());
                    addEo.setSalesmanId(vo.getSalesmanId());
                    addEo.setSalesmanName(vo.getSalesmanName());
                    addEo.setSalesmanCode(vo.getSalesmanCode());
                    addEo.setSalesmanType(vo.getSalesmanType());
                    addEo.setSalesmanPhone(vo.getSalesmanPhone());
                    addEo.setStoreThirdPartyId(vo.getStoreCustomerThirdPartyId());
                    addEo.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
                    addEo.setOrgId(vo.getOrgId());
                    addEo.setBizType(vo.getMerchantId());
                    addEo.setCreatePerson(userName);
                    addEo.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.DISABLE_STORE_REL.getType());
                    insertList.add(addEo);
                }
            });
        }
        return insertList;
    }

    private List<CustomerCheckRelationExportReqDto> batchBindStoreAndSalesmanRelation_V2_before_check_v2(List<CustomerCheckRelationExportReqDto> importList, Map<String, CustomerExtRespDto> customerCodeMap, List<CustomerCheckRelationBindErrorRespDto> errorList, Map<String, CustomerStoreResponseDto> customerStoreStoreNoMap, Map<String, List<CustomerStoreResponseDto>> customerStoreStoreNoCustomerMerchantIdMap, Map<String, List<TbPersonPartnerRelRespDto>> personSalesmanCodeCustomerThirdPartyIdMap, Map<String, List<TbPersonPartnerRelRespDto>> personSalesmanCodeCustomerThirdPartyIStoreThirdPartyIdMap, Map<String, List<TbPersonPartnerRelRespDto>> personRowIdStoreThirdPartyIdCustomerThirdPartyIdMap) {
        for (CustomerCheckRelationExportReqDto vo : importList) {
            CustomerExtRespDto customerExtRespDto = customerCodeMap.get(vo.getCustomerCode());
            if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)customerExtRespDto)) {
                errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728"));
                vo.setSkipFlag(true);
                continue;
            }
            if (!CustomerStatusExtEnum.ENABLED.getCode().equals(customerExtRespDto.getStatusId())) {
                errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u5f53\u524d\u5ba2\u6237\u975e\u5408\u6cd5\u72b6\u6001"));
                vo.setSkipFlag(true);
                continue;
            }
            vo.setOrgId(customerExtRespDto.getOrgInfoId());
            vo.setCustomerCode(customerExtRespDto.getCode());
            vo.setMerchantId(customerExtRespDto.getMerchantId());
            vo.setCustomerThirdPartyId(customerExtRespDto.getThirdPartyId());
            CustomerCheckPatternReqDto customerCheckPatternReqDto = new CustomerCheckPatternReqDto();
            customerCheckPatternReqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{vo.getCustomerCode()}));
            List<CustomerCheckPatternRespDto> customerCheckPatternRespDtoList = this.customerCheckPatternService.selectCustomerCheckPatternByCode(customerCheckPatternReqDto);
            if (CollectionUtils.isEmpty(customerCheckPatternRespDtoList)) {
                errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u5f53\u524d\u5ba2\u6237\u672a\u6307\u5b9a\u8003\u6838\u65b9\u5f0f\uff01"));
                vo.setSkipFlag(true);
                continue;
            }
            CustomerCheckPatternRespDto customerCheckPatternRespDto = customerCheckPatternRespDtoList.get(0);
            CheckPatternTypeEnum checkPatternTypeEnum = CheckPatternTypeEnum.enumOfType((Integer)customerCheckPatternRespDto.getPatternType());
            if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)checkPatternTypeEnum)) {
                errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u8003\u6838\u6a21\u5f0f\u4e0d\u5b58\u5728"));
                vo.setSkipFlag(true);
                continue;
            }
            BizChannelEnum bizChannelEnum2 = this.storeAndSalesmanHelper.calculateBizChannel(vo.getCustomerThirdPartyId());
            if (!bizChannelEnum2.getCheckPatternTypes().contains(checkPatternTypeEnum)) {
                errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u5f53\u524d\u4e1a\u52a1\u7ebf\u4e0d\u5b58\u5728\u8be5\u8003\u6838\u6a21\u5f0f"));
                vo.setSkipFlag(true);
                continue;
            }
            vo.setCheckPatternTypeEnum(checkPatternTypeEnum);
            if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)customerStoreStoreNoMap.get(vo.getStoreNo()))) {
                errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u65e0\u5f53\u524d\u95e8\u5e97\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4"));
                vo.setSkipFlag(true);
                continue;
            }
            vo.setStoreId(customerStoreStoreNoMap.get(vo.getStoreNo()).getStoreId());
            vo.setStoreName(customerStoreStoreNoMap.get(vo.getStoreNo()).getStoreName());
            List<CustomerStoreResponseDto> storeListByStoreNoOrgId = customerStoreStoreNoCustomerMerchantIdMap.get(vo.getStoreNo() + "-" + vo.getOrgId());
            if (CollectionUtils.isEmpty(storeListByStoreNoOrgId)) {
                errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u8bf7\u7ef4\u62a4\u5ba2\u6237\u95e8\u5e97\u6570\u636e,\u5ba2\u6237\uff1a" + customerExtRespDto.getName() + ";\u95e8\u5e97\u7f16\u7801\uff1a" + vo.getStoreNo()));
                vo.setSkipFlag(true);
                continue;
            }
            vo.setStoreCustomerThirdPartyId(storeListByStoreNoOrgId.get(0).getCustomerId());
            List<TbPersonPartnerRelRespDto> personPartnerRelRespDtoList = personSalesmanCodeCustomerThirdPartyIdMap.get(vo.getSalesmanCode() + "-" + vo.getCustomerThirdPartyId());
            if (CollectionUtils.isEmpty(personPartnerRelRespDtoList)) {
                errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u672a\u7ef4\u62a4\u8be5\u4e1a\u52a1\u5458\u4eba\u5e97\u5173\u7cfb\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u505a\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u7ed1\u5b9a"));
                vo.setSkipFlag(true);
                continue;
            }
            List<TbPersonPartnerRelRespDto> person = personSalesmanCodeCustomerThirdPartyIStoreThirdPartyIdMap.get(vo.getSalesmanCode() + "-" + vo.getCustomerThirdPartyId() + "-" + vo.getStoreCustomerThirdPartyId());
            if (CollectionUtils.isEmpty(person)) {
                errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u5f53\u524d\u7ecf\u9500\u5546\u7684\u95e8\u5e97\u4e0d\u5b58\u5728\u8be5\u4e1a\u52a1\u5458"));
                vo.setSkipFlag(true);
                continue;
            }
            vo.setSalesmanId(person.get(0).getRowId());
            if (!StringUtils.isNotBlank((CharSequence)vo.getSalesmanId()) || !StringUtils.isNotBlank((CharSequence)vo.getStoreCustomerThirdPartyId()) || !StringUtils.isNotBlank((CharSequence)vo.getCustomerThirdPartyId())) continue;
            List<TbPersonPartnerRelRespDto> personPartnerRelRespDtoLists = personRowIdStoreThirdPartyIdCustomerThirdPartyIdMap.get(vo.getSalesmanId() + "-" + vo.getStoreCustomerThirdPartyId() + "-" + vo.getCustomerThirdPartyId());
            if (CollectionUtils.isEmpty(personPartnerRelRespDtoLists)) {
                errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u5f53\u524d\u7ecf\u9500\u5546\u4e0d\u5b58\u5728\u8be5\u4e1a\u52a1\u5458"));
                vo.setSkipFlag(true);
                continue;
            }
            vo.setSalesmanName(personPartnerRelRespDtoLists.get(0).getName());
            vo.setSalesmanType(personPartnerRelRespDtoLists.get(0).getRoleType());
            vo.setSalesmanTypeName(personPartnerRelRespDtoLists.get(0).getRoleTypeName());
            vo.setSalesmanPhone(personPartnerRelRespDtoLists.get(0).getPhoneNumber());
        }
        return importList;
    }

    private static List<CustomerCheckRelationExportReqDto> batchBindStoreAndSalesmanRelation_V2_before_check_v1(List<CustomerCheckRelationExportReqDto> importList, BizChannelEnum bizChannelEnum, List<CustomerCheckRelationBindErrorRespDto> errorList) {
        Map<String, List<CustomerCheckRelationExportReqDto>> repeatSoreNoMap = importList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getStoreNo())).collect(Collectors.groupingBy(CustomerCheckRelationExportReqDto::getStoreNo));
        if (repeatSoreNoMap.entrySet().size() > 0) {
            repeatSoreNoMap.forEach((storeNo, value) -> {
                if (value.size() > 1) {
                    for (CustomerCheckRelationExportReqDto dto : value) {
                        errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(dto, "\u5bfc\u5165\u4eba\u5e97\u8003\u6838\u5173\u7cfb\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4!\u95e8\u5e97\u7f16\u7801:" + storeNo));
                        dto.setSkipFlag(true);
                    }
                }
            });
        }
        for (CustomerCheckRelationExportReqDto vo : importList) {
            if (vo.isSkipFlag()) continue;
            if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)bizChannelEnum)) {
                if (StringUtils.isNotBlank((CharSequence)vo.getCustomerCode())) {
                    vo.setCustomerCode(vo.getCustomerCode().trim());
                } else {
                    errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u8bf7\u586b\u5199\u7ecf\u9500\u5546\u7f16\u7801"));
                    vo.setSkipFlag(true);
                    continue;
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)vo.getStoreNo())) {
                errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u8bf7\u586b\u5199\u95e8\u5e97\u7f16\u7801"));
                vo.setSkipFlag(true);
                continue;
            }
            vo.setStoreNo(vo.getStoreNo().trim());
            if (!StringUtils.isNotBlank((CharSequence)vo.getSalesmanCode())) {
                errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u8bf7\u586b\u5199\u4eba\u5458\u7f16\u7801"));
                vo.setSkipFlag(true);
                continue;
            }
            vo.setSalesmanCode(vo.getSalesmanCode().trim());
            if (StringUtils.isNotBlank((CharSequence)vo.getOperateType())) {
                vo.setOperateType(vo.getOperateType().trim());
                if (null != CustomerCheckRelationExportOperateTypeEnum.getEnumOfName((String)vo.getOperateType())) continue;
                errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u64cd\u4f5c\u65b9\u5f0f\u4e0d\u5b58\u5728\uff01"));
                vo.setSkipFlag(true);
                continue;
            }
            errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u8bf7\u586b\u64cd\u4f5c\u65b9\u5f0f"));
            vo.setSkipFlag(true);
        }
        return importList;
    }

    private List<CustomerCheckRelationExportReqDto> batchBindStoreAndSalesmanRelation_V2_add_operate_type(List<CustomerCheckRelationExportReqDto> importList, List<CustomerExtRespDto> customerExtRespDtoList) {
        List<CustomerCheckRelationExportReqDto> importAddOrUpdateList = importList.stream().filter(i -> CustomerCheckRelationExportOperateTypeEnum.ADD_OR_UPDATE.getName().equals(i.getOperateType()) && StringUtils.isNotBlank((CharSequence)i.getStoreId()) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)i.getOrgId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(importAddOrUpdateList)) {
            this.thisCustomerCheckRelationServiceImpl.batchBindStoreAndSalesmanRelation_V2_add_operateType_checkStoreIdsDisable(importAddOrUpdateList);
            this.thisCustomerCheckRelationServiceImpl.batchBindStoreAndSalesmanRelation_V2_add_operateType_check_exist_person(importAddOrUpdateList, customerExtRespDtoList);
            this.thisCustomerCheckRelationServiceImpl.batchBindStoreAndSalesmanRelation_V2_add_operateType_check_store_other_person(importAddOrUpdateList);
        }
        return importList;
    }

    private List<CustomerCheckRelationExportReqDto> batchBindStoreAndSalesmanRelation_V2_add_operateType_check_pattern_type(List<CustomerCheckRelationExportReqDto> importAddOrUpdateList, List<CustomerCheckRelationBindErrorRespDto> errorList, BizChannelEnum bizChannelEnum) {
        List customerCheckRelationList = Lists.newArrayList();
        CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
        customerCheckRelationReqDto.setStoreIds(importAddOrUpdateList.stream().map(CustomerCheckRelationExportReqDto::getStoreId).distinct().collect(Collectors.toList()));
        customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        customerCheckRelationList = this.queryByPage(JSON.toJSONString((Object)customerCheckRelationReqDto), 1, Integer.MAX_VALUE).getList();
        List<Object> customerRespDtoList = Lists.newArrayList();
        Map<Object, Object> checkRelationStoreIdOrgIdStatusMap = new HashMap(16);
        if (CollectionUtils.isNotEmpty((Collection)customerCheckRelationList)) {
            checkRelationStoreIdOrgIdStatusMap = customerCheckRelationList.stream().collect(Collectors.groupingBy(c -> c.getStoreId()));
            List orgIds = customerCheckRelationList.stream().filter(a -> org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)a.getOrgId())).map(c -> c.getOrgId()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(orgIds)) {
                customerRespDtoList = this.customerQueryService.queryCustomerByOrgId(orgIds.stream().distinct().collect(Collectors.toList()));
            }
        }
        Map<Object, Object> customerOrgInfoIdMap = new HashMap(16);
        if (CollectionUtils.isNotEmpty((Collection)customerRespDtoList)) {
            customerOrgInfoIdMap = customerRespDtoList.stream().collect(Collectors.toMap(CustomerRespDto::getOrgInfoId, obj -> obj, (o, n) -> o));
        }
        block5: for (CustomerCheckRelationExportReqDto vo : importAddOrUpdateList) {
            List dbList = (List)checkRelationStoreIdOrgIdStatusMap.get(vo.getStoreId());
            switch (vo.getCheckPatternTypeEnum()) {
                case ALONE_CHECK: {
                    if (!CollectionUtils.isNotEmpty((Collection)dbList)) continue block5;
                    CustomerRespDto customer = (CustomerRespDto)customerOrgInfoIdMap.get(((CustomerCheckRelationRespDto)dbList.get(0)).getOrgId());
                    errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)((CustomerCheckRelationRespDto)dbList.get(0)).getBizType().toString()).getDesc(), customer.getName())));
                    vo.setSkipFlag(true);
                    continue block5;
                }
                case SEPARATE_CHECK: {
                    List<CustomerCheckRelationRespDto> notByHealthList;
                    if (!CollectionUtils.isNotEmpty((Collection)dbList) || !CollectionUtils.isNotEmpty(notByHealthList = dbList.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType()))).collect(Collectors.toList()))) continue block5;
                    Map<Object, Object> finalCustomerOrgInfoIdMap = customerOrgInfoIdMap;
                    notByHealthList.forEach(eo -> {
                        CustomerRespDto customer2 = (CustomerRespDto)finalCustomerOrgInfoIdMap.get(eo.getOrgId());
                        if (String.valueOf(vo.getMerchantId()).equals(String.valueOf(eo.getBizType()))) {
                            errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)eo.getBizType().toString()).getDesc(), customer2.getName())));
                            vo.setSkipFlag(true);
                            return;
                        }
                        CustomerCheckPatternReqDto reqDto = new CustomerCheckPatternReqDto();
                        reqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{customer2.getCode()}));
                        List patternEoList = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(reqDto);
                        if (CollectionUtils.isNotEmpty((Collection)patternEoList)) {
                            patternEoList.forEach(patternEo -> {
                                if (String.valueOf(CheckPatternTypeEnum.MERGE_CHECK.getType()).equals(String.valueOf(patternEo.getPatternType()))) {
                                    errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)eo.getBizType().toString()).getDesc(), customer2.getName())));
                                    vo.setSkipFlag(true);
                                    return;
                                }
                            });
                        }
                    });
                    break;
                }
                case MERGE_CHECK: {
                    if (!CollectionUtils.isNotEmpty((Collection)dbList)) continue block5;
                    Map<Object, Object> finalCustomerOrgInfoIdMap1 = customerOrgInfoIdMap;
                    dbList.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType()))).forEach(eo -> {
                        CustomerRespDto customer3 = (CustomerRespDto)finalCustomerOrgInfoIdMap1.get(eo.getOrgId());
                        if (eo.getOrgId().equals(vo.getOrgId())) {
                            errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u95e8\u5e97\u53ea\u53ef\u4ee5\u7ed1\u5b9a\u4e00\u4e2a\u4eba\u5458\u8fdb\u884c\u8003\u6838\uff0c\u7ed1\u5b9a\u540e\u82e5\u9700\u8c03\u6574\uff0c\u9700\u89e3\u9664\u7ed1\u5b9a\u540e\u624d\u53ef\u8fdb\u884c\u9009\u62e9"));
                            vo.setSkipFlag(true);
                            return;
                        }
                        ArrayList orgIds = Lists.newArrayList();
                        CustomerCheckPatternReqDto reqDto = new CustomerCheckPatternReqDto();
                        reqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{vo.getCustomerCode()}));
                        List patternEoList = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(reqDto);
                        if (CollectionUtils.isNotEmpty((Collection)patternEoList)) {
                            orgIds.addAll(patternEoList.stream().map(c -> c.getOrgId()).collect(Collectors.toList()));
                            orgIds.addAll(patternEoList.stream().map(c -> c.getMergeOrgId()).collect(Collectors.toList()));
                        }
                        if (!orgIds.contains(eo.getOrgId())) {
                            errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)eo.getBizType().toString()).getDesc(), customer3.getName())));
                            vo.setSkipFlag(true);
                            return;
                        }
                        CustomerCheckPatternConfigReqDto customerCheckPatternConfigReqDto = new CustomerCheckPatternConfigReqDto();
                        customerCheckPatternConfigReqDto.setOrganizationIds((List)orgIds);
                        List configList = this.customerCheckPatternConfigService.queryByPage(JSON.toJSONString((Object)customerCheckPatternConfigReqDto), 1, Integer.MAX_VALUE).getList();
                        if (CollectionUtils.isEmpty((Collection)configList)) {
                            errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)eo.getBizType().toString()).getDesc(), customer3.getName())));
                            vo.setSkipFlag(true);
                            return;
                        }
                        List<String> storeIdList = this.calculateStoreIds(configList);
                        if (CollectionUtils.isEmpty(storeIdList)) {
                            errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u5f53\u524d\u7ecf\u9500\u5546\u7ba1\u8f96\u5b58\u5728\u5f02\u5e38"));
                            vo.setSkipFlag(true);
                            return;
                        }
                        SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(vo.getOrgId()));
                        List<StoreSellerRelateRespDto> storeSellerRelateRespDtos = this.storeSellerRelateService.queryStoreSellerRelateBySellerId(sellerRespDto.getId(), storeIdList);
                        if (storeSellerRelateRespDtos.stream().map(c -> c.getStoreId()).distinct().collect(Collectors.toList()).contains(vo.getStoreId())) {
                            errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)eo.getBizType().toString()).getDesc(), customer3.getName())));
                            vo.setSkipFlag(true);
                            return;
                        }
                    });
                    break;
                }
                default: {
                    errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u4e0d\u5b58\u5728\u5f53\u524d\u64cd\u4f5c\u7c7b\u578b"));
                    vo.setSkipFlag(true);
                    continue block5;
                }
            }
        }
        return importAddOrUpdateList;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void batchBindStoreAndSalesmanRelation_V2_add_operateType_check_store_other_person(List<CustomerCheckRelationExportReqDto> importAddOrUpdateList) {
        ArrayList updateList = Lists.newArrayList();
        List customerCheckRelationList = Lists.newArrayList();
        CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
        customerCheckRelationReqDto.setStoreIds(importAddOrUpdateList.stream().map(CustomerCheckRelationExportReqDto::getStoreId).distinct().collect(Collectors.toList()));
        customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        customerCheckRelationList = this.queryByPage(JSON.toJSONString((Object)customerCheckRelationReqDto), 1, Integer.MAX_VALUE).getList();
        List<Object> salesmanIds = Lists.newArrayList();
        List<Object> orgIds = Lists.newArrayList();
        List<Object> storeThirdPartyIds = Lists.newArrayList();
        List<Object> customerThirdPartyIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)customerCheckRelationList)) {
            salesmanIds = customerCheckRelationList.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType())) && StringUtils.isNotBlank((CharSequence)a.getSalesmanId())).map(c -> c.getSalesmanId()).collect(Collectors.toList());
            orgIds = customerCheckRelationList.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType())) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)a.getOrgId())).map(c -> c.getOrgId()).collect(Collectors.toList());
            storeThirdPartyIds = customerCheckRelationList.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType())) && StringUtils.isNotBlank((CharSequence)a.getStoreThirdPartyId())).map(c -> c.getStoreThirdPartyId()).collect(Collectors.toList());
        }
        List customerList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)orgIds)) {
            customerList = (List)this.customerExtThreeService.queryByOrgIdList(orgIds).getData();
        }
        HashMap customerOrgIdThirdPartyIdmap = new HashMap(16);
        if (CollectionUtils.isNotEmpty((Collection)customerList)) {
            customerThirdPartyIds = customerList.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getThirdPartyId())).map(CustomerRespDto::getThirdPartyId).collect(Collectors.toList());
            customerList.stream().filter(a -> org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)a.getOrgInfoId()) && StringUtils.isNotBlank((CharSequence)a.getThirdPartyId())).forEach(c -> customerOrgIdThirdPartyIdmap.put(c.getOrgInfoId(), c.getThirdPartyId()));
        }
        List personInfoList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)salesmanIds) && CollectionUtils.isNotEmpty((Collection)storeThirdPartyIds) && CollectionUtils.isNotEmpty((Collection)customerThirdPartyIds)) {
            TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
            tbPersonPartnerRelReqDto.setRowIds((List)salesmanIds);
            tbPersonPartnerRelReqDto.setMasterOuIds((List)customerThirdPartyIds);
            tbPersonPartnerRelReqDto.setStoreThirdPartyIds((List)storeThirdPartyIds);
            personInfoList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.tbPersonPartnerRelQueryApi.queryByPage(JSON.toJSONString((Object)tbPersonPartnerRelReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)))).getList();
        }
        if (CollectionUtils.isEmpty((Collection)personInfoList) && CollectionUtils.isNotEmpty(customerCheckRelationList)) {
            customerCheckRelationList.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType()))).forEach(c -> {
                c.setStatus(CustomerCheckStatusEnum.DISABLE.getStatus());
                c.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.DISABLE_EMPLOYEE.getType());
                CustomerCheckRelationEo update = new CustomerCheckRelationEo();
                BeanUtils.copyProperties((Object)c, (Object)update);
                updateList.add(update);
            });
            Map<String, List<TbPersonPartnerRelRespDto>> personMap = personInfoList.stream().collect(Collectors.groupingBy(p -> p.getRowId() + "-" + p.getCustomerId() + "-" + p.getMasterOuId()));
            customerCheckRelationList.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType()))).forEach(c -> {
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)customerOrgIdThirdPartyIdmap.get(c.getOrgId()))) && CollectionUtils.isEmpty((Collection)((Collection)personMap.get(c.getSalesmanId() + "-" + (String)customerOrgIdThirdPartyIdmap.get(c.getOrgId()) + "-" + c.getStoreThirdPartyId())))) {
                    c.setStatus(CustomerCheckStatusEnum.DISABLE.getStatus());
                    c.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.DISABLE_EMPLOYEE.getType());
                    CustomerCheckRelationEo update = new CustomerCheckRelationEo();
                    BeanUtils.copyProperties((Object)c, (Object)update);
                    updateList.add(update);
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
            log.info("batchBindStoreAndSalesmanRelation_V2_add_operateType_check_store_other_person updateList:" + JSON.toJSONString((Object)updateList));
            this.customerCheckRelationDas.updateBatch((List)updateList);
        }
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void batchBindStoreAndSalesmanRelation_V2_add_operateType_check_exist_person(List<CustomerCheckRelationExportReqDto> importAddOrUpdateList, List<CustomerExtRespDto> customerExtRespDtoList) {
        ArrayList updateList = Lists.newArrayList();
        List storeIds = importAddOrUpdateList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getStoreId())).map(CustomerCheckRelationExportReqDto::getStoreId).collect(Collectors.toList());
        List customerCheckRelationList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(storeIds)) {
            CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
            customerCheckRelationReqDto.setStoreIds(importAddOrUpdateList.stream().map(CustomerCheckRelationExportReqDto::getStoreId).distinct().collect(Collectors.toList()));
            customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
            customerCheckRelationList = this.queryByPage(JSON.toJSONString((Object)customerCheckRelationReqDto), 1, Integer.MAX_VALUE).getList();
        }
        List<Object> salesmanIds = Lists.newArrayList();
        List<Object> storeThirdPartyIds = Lists.newArrayList();
        List<Object> customerOrgIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)customerCheckRelationList)) {
            salesmanIds = customerCheckRelationList.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getSalesmanId())).map(a -> a.getSalesmanId()).collect(Collectors.toList());
            storeThirdPartyIds = customerCheckRelationList.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getStoreThirdPartyId())).map(a -> a.getStoreThirdPartyId()).collect(Collectors.toList());
            customerOrgIds = customerCheckRelationList.stream().filter(c -> org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)c.getOrgId())).map(c -> c.getOrgId()).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty((Collection)customerCheckRelationList)) {
            List customerExtRespDtoList2 = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)customerOrgIds)) {
                customerOrgIds = customerOrgIds.stream().distinct().collect(Collectors.toList());
                customerExtRespDtoList2 = (List)this.customerExtThreeService.queryByOrgIdList(customerOrgIds).getData();
            }
            List<Object> customerThirdPartyIds = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(customerExtRespDtoList)) {
                customerThirdPartyIds = customerExtRespDtoList2.stream().map(c -> c.getThirdPartyId()).collect(Collectors.toList());
            }
            List personList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)salesmanIds) && CollectionUtils.isNotEmpty((Collection)storeThirdPartyIds) && CollectionUtils.isNotEmpty((Collection)customerThirdPartyIds)) {
                salesmanIds = salesmanIds.stream().distinct().collect(Collectors.toList());
                storeThirdPartyIds = storeThirdPartyIds.stream().distinct().collect(Collectors.toList());
                customerThirdPartyIds = customerThirdPartyIds.stream().distinct().collect(Collectors.toList());
                TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
                tbPersonPartnerRelReqDto.setRowIds((List)salesmanIds);
                tbPersonPartnerRelReqDto.setStoreThirdPartyIds((List)storeThirdPartyIds);
                tbPersonPartnerRelReqDto.setMasterOuIds((List)customerThirdPartyIds);
                personList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.tbPersonPartnerRelQueryApi.queryByPage(JSON.toJSONString((Object)tbPersonPartnerRelReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)))).getList();
            }
            if (CollectionUtils.isNotEmpty((Collection)personList)) {
                List rowIds = personList.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getRowId())).map(TbPersonPartnerRelRespDto::getRowId).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(rowIds)) {
                    List finalRowIds = rowIds = rowIds.stream().distinct().collect(Collectors.toList());
                    customerCheckRelationList.forEach(c -> {
                        if (!finalRowIds.contains(c.getSalesmanId())) {
                            c.setStatus(CustomerCheckStatusEnum.DISABLE.getStatus());
                            c.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.DISABLE_STORE_REL.getType());
                            CustomerCheckRelationEo update = new CustomerCheckRelationEo();
                            BeanUtils.copyProperties((Object)c, (Object)update);
                            updateList.add(update);
                        }
                        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                            for (CustomerCheckRelationEo customerCheckRelationEo : updateList) {
                                CustomerCheckRelationRespDto dto = new CustomerCheckRelationRespDto();
                                BeanUtils.copyProperties((Object)customerCheckRelationEo, (Object)dto);
                            }
                        }
                    });
                }
            } else {
                log.error("batchBindStoreAndSalesmanRelation_V2_add_operateType_check_exist_person \u6ca1\u6709\u4eba\u5458\u7ed1\u5b9a\u5b58\u5728\u4fe1\u606f,\u5220\u9664\u5df2\u7ecf\u5b58\u5728\u7ed1\u5b9a\u7684\u8003\u6838\u5173\u7cfb\u5217\u8868:" + JSON.toJSONString(customerCheckRelationList));
                customerCheckRelationList.forEach(c -> {
                    c.setStatus(CustomerCheckStatusEnum.DISABLE.getStatus());
                    c.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.DISABLE_STORE_REL.getType());
                    CustomerCheckRelationEo update = new CustomerCheckRelationEo();
                    BeanUtils.copyProperties((Object)c, (Object)update);
                    updateList.add(update);
                });
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
            log.error("batchBindStoreAndSalesmanRelation_V2_add_operateType_check_exist_person.updateList \u66f4\u65b0\u5df2\u7ecf\u5b58\u5728\u7ed1\u5b9a\u7684\u8003\u6838\u5173\u7cfb\u5217\u8868:" + JSON.toJSONString((Object)updateList));
            this.customerCheckRelationDas.updateBatch((List)updateList);
        }
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void batchBindStoreAndSalesmanRelation_V2_add_operateType_checkStoreIdsDisable(List<CustomerCheckRelationExportReqDto> importAddOrUpdateList) {
        List storeIdList = importAddOrUpdateList.stream().map(CustomerCheckRelationExportReqDto::getStoreId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(storeIdList)) {
            CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
            customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
            customerCheckRelationReqDto.setStoreIds(storeIdList);
            List customerCheckRelationList = this.queryByPage(JSON.toJSONString((Object)customerCheckRelationReqDto), 1, Integer.MAX_VALUE).getList();
            if (CollectionUtils.isNotEmpty((Collection)customerCheckRelationList)) {
                this.customerRelationCheckStoreDisable(customerCheckRelationList);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public List<CustomerCheckRelationExportReqDto> batchBindStoreAndSalesmanRelation_V2_delete_operate_type(List<CustomerCheckRelationExportReqDto> importList, List<CustomerCheckRelationBindErrorRespDto> errorList, String userName) {
        ArrayList updateList = Lists.newArrayList();
        List importDeleteTypeList = importList.stream().filter(i -> CustomerCheckRelationExportOperateTypeEnum.DELETE.getName().equals(i.getOperateType()) && StringUtils.isNotBlank((CharSequence)i.getStoreId()) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)i.getOrgId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(importDeleteTypeList)) {
            CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
            customerCheckRelationReqDto.setStoreIds(importDeleteTypeList.stream().map(CustomerCheckRelationExportReqDto::getStoreId).distinct().collect(Collectors.toList()));
            customerCheckRelationReqDto.setOrgIds(importDeleteTypeList.stream().map(CustomerCheckRelationExportReqDto::getOrgId).distinct().collect(Collectors.toList()));
            List<CustomerCheckRelationRespDto> dbRespList = this.customerCheckRelationService.queryByStoreIds(customerCheckRelationReqDto);
            Map<Object, Object> listMap = new HashMap();
            if (CollectionUtils.isNotEmpty(dbRespList)) {
                listMap = dbRespList.stream().collect(Collectors.groupingBy(c -> c.getStoreId() + "-" + c.getOrgId() + "-" + c.getStatus()));
            }
            for (CustomerCheckRelationExportReqDto vo : importDeleteTypeList) {
                List list = (List)listMap.get(vo.getStoreId() + "-" + vo.getOrgId() + "-" + CustomerCheckStatusEnum.BOUND.getStatus());
                if (CollectionUtils.isEmpty((Collection)list)) {
                    errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u8003\u6838\u95e8\u5e97\u5173\u7cfb\u5b58\u5728\u5f02\u5e38"));
                    vo.setSkipFlag(true);
                    continue;
                }
                CustomerCheckRelationRespDto customerCheckRelation = (CustomerCheckRelationRespDto)list.stream().findFirst().get();
                if (!customerCheckRelation.getOrgId().equals(vo.getOrgId())) {
                    errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u5f53\u524d\u89e3\u7ed1\u5173\u7cfb\u4e0e\u6240\u5c5e\u516c\u53f8\u4e0d\u4e00\u81f4"));
                    vo.setSkipFlag(true);
                    continue;
                }
                if (!customerCheckRelation.getStoreId().equals(vo.getStoreId())) {
                    errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u89e3\u7ed1\u95e8\u5e97\u4e0e\u5f53\u524d\u7ed1\u5b9a\u95e8\u5e97\u4e0d\u4e00\u81f4"));
                    vo.setSkipFlag(true);
                    continue;
                }
                if (!customerCheckRelation.getSalesmanId().equals(vo.getSalesmanId())) {
                    errorList.add(CustomerCheckRelationServiceImpl.getCustomerCheckRelationBindErrorRespDto(vo, "\u89e3\u7ed1\u4e1a\u52a1\u5458\u4e0e\u5f53\u524d\u7ed1\u5b9a\u4e1a\u52a1\u5458\u4e0d\u4e00\u81f4"));
                    vo.setSkipFlag(true);
                    continue;
                }
                CustomerCheckRelationEo updateEo = new CustomerCheckRelationEo();
                BeanUtils.copyProperties((Object)customerCheckRelation, (Object)updateEo);
                updateEo.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
                updateEo.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.EXCEL.getType());
                updateEo.setUpdatePerson(userName);
                updateEo.setUpdateTime(new Date());
                updateList.add(updateEo);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
            log.info(userName + "batchBindStoreAndSalesmanRelation_V2_delete_operateType updateList:" + JSON.toJSONString((Object)updateList));
            this.customerCheckRelationDas.updateBatch((List)updateList);
        }
        return importList;
    }

    @NotNull
    private static CustomerCheckRelationBindErrorRespDto getCustomerCheckRelationBindErrorRespDto(CustomerCheckRelationExportReqDto dto, String reason) {
        CustomerCheckRelationBindErrorRespDto respDto = new CustomerCheckRelationBindErrorRespDto();
        respDto.setCustomerCode(dto.getCustomerCode());
        respDto.setCustomerName(dto.getCustomerName());
        respDto.setStoreNo(dto.getStoreNo());
        respDto.setStoreName(dto.getStoreName());
        respDto.setSalesmanCode(dto.getSalesmanCode());
        respDto.setOperateType(dto.getOperateType());
        respDto.setResultMsg(reason);
        return respDto;
    }

    private List<CustomerCheckRelationBindErrorRespDto> handleBatchBindStoreAndSalesmanRelation(List<CustomerCheckRelationReqDto> addReqDtoList) {
        ArrayList respDtoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(addReqDtoList)) {
            return null;
        }
        List<Object> customerRespDtoList = Lists.newArrayList();
        HashMap<Long, CustomerRespDto> CustomerOrgIdMap = new HashMap(16);
        List<Long> orgIds = addReqDtoList.stream().filter(a -> org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)a.getOrgId())).map(a -> a.getOrgId()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orgIds)) {
            orgIds = orgIds.stream().distinct().collect(Collectors.toList());
            customerRespDtoList = this.customerQueryService.queryCustomerByOrgId(orgIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)customerRespDtoList)) {
            CustomerOrgIdMap = customerRespDtoList.stream().collect(Collectors.toMap(CustomerRespDto::getOrgInfoId, obj -> obj, (o, n) -> o));
        }
        List<String> thirdPartyIds = addReqDtoList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getThirdPartyId())).map(c -> c.getThirdPartyId()).collect(Collectors.toList());
        List<String> salesmanIds = addReqDtoList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getSalesmanId())).map(c -> c.getSalesmanId()).collect(Collectors.toList());
        List storeIds = addReqDtoList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getStoreId())).map(c -> c.getStoreId()).collect(Collectors.toList());
        Map<Object, Object> customerCheckRelationStoreIdOrgIdMap = new HashMap(16);
        if (CollectionUtils.isNotEmpty(orgIds) && CollectionUtils.isNotEmpty(storeIds)) {
            storeIds = storeIds.stream().distinct().collect(Collectors.toList());
            CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
            customerCheckRelationReqDto.setStoreIds(storeIds);
            customerCheckRelationReqDto.setOrgIds(orgIds);
            List customerCheckRelationList = this.queryByPage(JSON.toJSONString((Object)customerCheckRelationReqDto), 1, Integer.MAX_VALUE).getList();
            if (CollectionUtils.isNotEmpty((Collection)customerCheckRelationList)) {
                customerCheckRelationStoreIdOrgIdMap = customerCheckRelationList.stream().collect(Collectors.groupingBy(c -> c.getStoreId() + "-" + c.getOrgId() + "-" + c.getStatus()));
            }
        }
        ArrayList customerThirdPartyIds = Lists.newArrayList();
        HashMap<String, BizChannelEnum> thirdPartyIdBizChannelEnumMap = new HashMap<String, BizChannelEnum>(16);
        this.batchBindStoreAndSalesmanRelationCheckBefore_V1(addReqDtoList, respDtoList, CustomerOrgIdMap, customerThirdPartyIds, thirdPartyIdBizChannelEnumMap);
        if (addReqDtoList.size() == respDtoList.size()) {
            return respDtoList;
        }
        ArrayList insertList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        Map<String, List<TbPersonPartnerRelRespDto>> personPartnerRelRespDtoMap = new HashMap<String, List<TbPersonPartnerRelRespDto>>(16);
        Map<String, List<TbPersonPartnerRelRespDto>> finalPersonPartnerRelRespDtoMap = personPartnerRelRespDtoMap = this.getPersonPartnerRelRespDtoMap(salesmanIds, thirdPartyIds, customerThirdPartyIds, personPartnerRelRespDtoMap);
        HashMap finalCustomerCheckRelationStoreIdOrgIdMap = customerCheckRelationStoreIdOrgIdMap;
        HashMap<Long, CustomerRespDto> finalCustomerOrgIdMap = CustomerOrgIdMap;
        addReqDtoList.stream().filter(a -> !a.isSkipFlag()).forEach(reqDto -> {
            List personPartnerList = (List)finalPersonPartnerRelRespDtoMap.get(reqDto.getSalesmanId() + "-" + reqDto.getThirdPartyId() + "-" + reqDto.getMasterOuId());
            if (CollectionUtils.isEmpty((Collection)personPartnerList)) {
                respDtoList.add(this.getErrorRespDto((CustomerCheckRelationReqDto)reqDto, "\u5f53\u524d\u7ecf\u9500\u5546\u4e0d\u5b58\u5728\u8be5\u4e1a\u52a1\u5458"));
                reqDto.setSkipFlag(true);
            }
            if (!CustomerCheckStatusEnum.BOUND.getStatus().equals(reqDto.getStatus()) && CustomerCheckStatusEnum.NOT_BOUND.getStatus().equals(reqDto.getStatus())) {
                respDtoList.add(this.getErrorRespDto((CustomerCheckRelationReqDto)reqDto, "\u4e0d\u5b58\u5728\u5f53\u524d\u64cd\u4f5c\u7c7b\u578b"));
                reqDto.setSkipFlag(true);
            }
            if (!reqDto.isSkipFlag()) {
                this.handleBond((CustomerCheckRelationReqDto)reqDto, (Map<Long, CustomerRespDto>)finalCustomerOrgIdMap, thirdPartyIdBizChannelEnumMap, insertList);
                this.handleUnBond((CustomerCheckRelationReqDto)reqDto, finalCustomerCheckRelationStoreIdOrgIdMap, respDtoList, updateList);
            }
        });
        this.customerCheckRelationInsertBatch(insertList);
        this.customerCheckRelationUpdateBatch(updateList);
        return respDtoList;
    }

    private void batchBindStoreAndSalesmanRelationCheckBefore_V1(List<CustomerCheckRelationReqDto> addReqDtoList, List<CustomerCheckRelationBindErrorRespDto> respDtoList, Map<Long, CustomerRespDto> CustomerOrgIdMap, List<String> customerThirdPartyIds, HashMap<String, BizChannelEnum> thirdPartyIdBizChannelEnumMap) {
        for (CustomerCheckRelationReqDto reqDto : addReqDtoList) {
            if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)reqDto.getOrgId())) {
                respDtoList.add(this.getErrorRespDto(reqDto, "\u7ec4\u7ec7ID\u4e3a\u7a7a"));
                reqDto.setSkipFlag(true);
                continue;
            }
            CustomerRespDto customerRespDto = CustomerOrgIdMap.get(reqDto.getOrgId());
            if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)customerRespDto)) {
                respDtoList.add(this.getErrorRespDto(reqDto, "\u5f53\u524d\u5ba2\u6237\u4e0d\u5b58\u5728"));
                reqDto.setSkipFlag(true);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)customerRespDto.getThirdPartyId())) {
                respDtoList.add(this.getErrorRespDto(reqDto, "\u5f53\u524d\u5ba2\u6237thirdPartyId\u4e0d\u5b58\u5728"));
                reqDto.setSkipFlag(true);
                continue;
            }
            customerThirdPartyIds.add(customerRespDto.getThirdPartyId());
            reqDto.setMasterOuId(customerRespDto.getThirdPartyId());
            if (!CustomerStatusExtEnum.ENABLED.getCode().equals(customerRespDto.getStatusId())) {
                respDtoList.add(this.getErrorRespDto(reqDto, "\u5f53\u524d\u5ba2\u6237\u975e\u5408\u6cd5\u72b6\u6001"));
                reqDto.setSkipFlag(true);
                continue;
            }
            if (ObjectUtils.isEmpty((Object)reqDto.getStoreId())) {
                respDtoList.add(this.getErrorRespDto(reqDto, "\u95e8\u5e97ID\u4e3a\u7a7a"));
                reqDto.setSkipFlag(true);
                continue;
            }
            if (ObjectUtils.isEmpty((Object)reqDto.getSalesmanId())) {
                respDtoList.add(this.getErrorRespDto(reqDto, "\u4e1a\u52a1\u5458ID\u4e3a\u7a7a"));
                reqDto.setSkipFlag(true);
                continue;
            }
            if (ObjectUtils.isEmpty((Object)reqDto.getThirdPartyId())) {
                respDtoList.add(this.getErrorRespDto(reqDto, "\u7ecf\u9500\u5546ID\u4e3a\u7a7a"));
                reqDto.setSkipFlag(true);
                continue;
            }
            if (ObjectUtils.isEmpty((Object)reqDto.getStatus())) {
                respDtoList.add(this.getErrorRespDto(reqDto, "\u8003\u6838\u5173\u7cfb\u72b6\u6001\u4e3a\u7a7a"));
                reqDto.setSkipFlag(true);
                continue;
            }
            CustomerCheckStatusEnum customerCheckStatusEnum = CustomerCheckStatusEnum.enumOfStatus((Integer)reqDto.getStatus());
            if (ObjectUtils.isEmpty((Object)customerCheckStatusEnum)) {
                respDtoList.add(this.getErrorRespDto(reqDto, "\u4e0d\u5b58\u5728\u5f53\u524d\u4e1a\u52a1\u65b9\u5f0f"));
                reqDto.setSkipFlag(true);
                continue;
            }
            BizChannelEnum bizChannelEnum = this.storeAndSalesmanHelper.calculateBizChannel(reqDto.getThirdPartyId());
            if (!org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)bizChannelEnum)) continue;
            thirdPartyIdBizChannelEnumMap.put(reqDto.getThirdPartyId(), bizChannelEnum);
        }
    }

    private Map<String, List<TbPersonPartnerRelRespDto>> getPersonPartnerRelRespDtoMap(List<String> salesmanIds, List<String> thirdPartyIds, List<String> customerThirdPartyIds, Map<String, List<TbPersonPartnerRelRespDto>> personPartnerRelRespDtoMap) {
        if (CollectionUtils.isNotEmpty(salesmanIds) && CollectionUtils.isNotEmpty(thirdPartyIds) && CollectionUtils.isNotEmpty(customerThirdPartyIds)) {
            salesmanIds = salesmanIds.stream().distinct().collect(Collectors.toList());
            thirdPartyIds = thirdPartyIds.stream().distinct().collect(Collectors.toList());
            customerThirdPartyIds = customerThirdPartyIds.stream().distinct().collect(Collectors.toList());
            TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
            tbPersonPartnerRelReqDto.setRowIds(salesmanIds);
            tbPersonPartnerRelReqDto.setStoreThirdPartyIds(thirdPartyIds);
            tbPersonPartnerRelReqDto.setMasterOuIds(customerThirdPartyIds);
            List personPartnerRelRespDtoList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.tbPersonPartnerRelQueryApi.queryByPage(JSON.toJSONString((Object)tbPersonPartnerRelReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)))).getList();
            if (CollectionUtils.isNotEmpty((Collection)personPartnerRelRespDtoList)) {
                personPartnerRelRespDtoMap = personPartnerRelRespDtoList.stream().collect(Collectors.groupingBy(p -> p.getRowId() + "-" + p.getCustomerId() + "-" + p.getMasterOuId()));
            }
        }
        return personPartnerRelRespDtoMap;
    }

    private void handleBond(CustomerCheckRelationReqDto reqDto, Map<Long, CustomerRespDto> finalCustomerOrgIdMap, HashMap<String, BizChannelEnum> thirdPartyIdBizChannelEnumMap, List<CustomerCheckRelationEo> insertList) {
        if (CustomerCheckStatusEnum.BOUND.getStatus().equals(reqDto.getStatus())) {
            this.checkStoreIdsDisable(reqDto.getStoreId());
            CustomerRespDto customerRespDto = finalCustomerOrgIdMap.get(reqDto.getOrgId());
            this.checkPersonPartnerDisable(reqDto.getOrgId(), reqDto, customerRespDto);
            BizChannelEnum bizChannelEnum = thirdPartyIdBizChannelEnumMap.get(reqDto.getThirdPartyId());
            this.verifyRelation(reqDto, bizChannelEnum);
            if (!reqDto.isSkipFlag()) {
                CustomerCheckRelationEo eo = CustomerCheckRelationServiceImpl.getCustomerCheckRelationEo(reqDto, bizChannelEnum);
                insertList.add(eo);
            }
        }
    }

    private void handleUnBond(CustomerCheckRelationReqDto reqDto, Map<String, List<CustomerCheckRelationRespDto>> finalCustomerCheckRelationStoreIdOrgIdMap, List<CustomerCheckRelationBindErrorRespDto> respDtoList, List<CustomerCheckRelationEo> updateList) {
        if (CustomerCheckStatusEnum.NOT_BOUND.getStatus().equals(reqDto.getStatus())) {
            CustomerCheckRelationRespDto customerCheckRelation;
            List<CustomerCheckRelationRespDto> dbList = finalCustomerCheckRelationStoreIdOrgIdMap.get(reqDto.getStoreId() + "-" + reqDto.getOrgId() + "-" + reqDto.getStatus());
            if (CollectionUtils.isEmpty(dbList)) {
                respDtoList.add(this.getErrorRespDto(reqDto, "\u8003\u6838\u95e8\u5e97\u5173\u7cfb\u5b58\u5728\u5f02\u5e38"));
                reqDto.setSkipFlag(true);
            }
            if (!(customerCheckRelation = (CustomerCheckRelationRespDto)dbList.stream().findFirst().get()).getOrgId().equals(reqDto.getOrgId())) {
                respDtoList.add(this.getErrorRespDto(reqDto, "\u5f53\u524d\u89e3\u7ed1\u5173\u7cfb\u4e0e\u6240\u5c5e\u516c\u53f8\u4e0d\u4e00\u81f4"));
                reqDto.setSkipFlag(true);
            }
            if (!customerCheckRelation.getStoreId().equals(reqDto.getStoreId())) {
                respDtoList.add(this.getErrorRespDto(reqDto, "\u89e3\u7ed1\u95e8\u5e97\u4e0e\u5f53\u524d\u7ed1\u5b9a\u95e8\u5e97\u4e0d\u4e00\u81f4"));
                reqDto.setSkipFlag(true);
            }
            if (!customerCheckRelation.getSalesmanId().equals(reqDto.getSalesmanId())) {
                respDtoList.add(this.getErrorRespDto(reqDto, "\u89e3\u7ed1\u4e1a\u52a1\u5458\u4e0e\u5f53\u524d\u7ed1\u5b9a\u4e1a\u52a1\u5458\u4e0d\u4e00\u81f4"));
                reqDto.setSkipFlag(true);
            }
            if (!reqDto.isSkipFlag()) {
                CustomerCheckRelationEo updateEo = CustomerCheckRelationServiceImpl.getCustomerCheckRelationUpdateEo(reqDto, dbList);
                updateList.add(updateEo);
            }
        }
    }

    private void customerCheckRelationUpdateBatch(List<CustomerCheckRelationEo> updateList) {
        Map<String, List<CustomerCheckRelationEo>> map;
        AtomicReference updateMutex = null;
        if (CollectionUtils.isNotEmpty(updateList) && (map = updateList.stream().collect(Collectors.groupingBy(a -> a.getOrgId() + "-" + a.getStoreId() + "-" + a.getStatus()))).entrySet().size() > 0) {
            map.forEach((key, list) -> {
                String orgId = key.split("-")[0];
                String storeId = key.split("-")[1];
                String status = key.split("-")[2];
                String lockKey = orgId + "-" + storeId + "-" + status;
                try {
                    updateMutex.set(this.lockService.lock("bindStoreAndSalesmanRelation", lockKey, 10, 5, TimeUnit.MINUTES));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.lockService.unlock((Mutex)updateMutex.get());
                }
                this.customerCheckRelationDas.updateBatch(list);
            });
        }
    }

    private void customerCheckRelationInsertBatch(List<CustomerCheckRelationEo> insertList) {
        Map<String, List<CustomerCheckRelationEo>> map;
        AtomicReference mutex = null;
        if (CollectionUtils.isNotEmpty(insertList) && (map = insertList.stream().collect(Collectors.groupingBy(a -> a.getOrgId() + "-" + a.getStoreId() + "-" + a.getStatus()))).entrySet().size() > 0) {
            map.forEach((key, list) -> {
                String orgId = key.split("-")[0];
                String storeId = key.split("-")[1];
                String status = key.split("-")[2];
                String lockKey = orgId + "-" + storeId + "-" + status;
                try {
                    mutex.set(this.lockService.lock("bindStoreAndSalesmanRelation", lockKey, 10, 5, TimeUnit.MINUTES));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.lockService.unlock((Mutex)mutex.get());
                }
                this.customerCheckRelationDas.insertBatch(list);
            });
        }
    }

    @NotNull
    private static CustomerCheckRelationEo getCustomerCheckRelationUpdateEo(CustomerCheckRelationReqDto reqDto, List<CustomerCheckRelationRespDto> dbList) {
        CustomerCheckRelationRespDto relationRespDto = dbList.get(0);
        CustomerCheckRelationEo updateEo = new CustomerCheckRelationEo();
        BeanUtils.copyProperties((Object)relationRespDto, (Object)updateEo);
        updateEo.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
        updateEo.setSourceOperateType(StringUtils.isNotBlank((CharSequence)reqDto.getSourceOperateType()) ? reqDto.getSourceOperateType() : CustomerCheckRelationSourceOperateTypeEnum.MANUAL.getType());
        return updateEo;
    }

    private static CustomerCheckRelationEo getCustomerCheckRelationEo(CustomerCheckRelationReqDto reqDto, BizChannelEnum bizChannelEnum) {
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerCheckRelationEo);
        customerCheckRelationEo.setBizType(Long.valueOf(bizChannelEnum.getChannelCode()));
        customerCheckRelationEo.setStoreId(reqDto.getStoreId());
        customerCheckRelationEo.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        customerCheckRelationEo.setStoreThirdPartyId(reqDto.getThirdPartyId());
        customerCheckRelationEo.setSourceOperateType(StringUtils.isNotBlank((CharSequence)reqDto.getSourceOperateType()) ? reqDto.getSourceOperateType() : CustomerCheckRelationSourceOperateTypeEnum.MANUAL.getType());
        return customerCheckRelationEo;
    }

    private CustomerCheckRelationBindErrorRespDto getErrorRespDto(CustomerCheckRelationReqDto reqDto, String errorDesc) {
        CustomerCheckRelationBindErrorRespDto respDto = new CustomerCheckRelationBindErrorRespDto();
        respDto.setStoreNo(reqDto.getStoreNo());
        respDto.setSalesmanCode(reqDto.getSalesmanCode());
        respDto.setResultMsg(errorDesc);
        return respDto;
    }

    private void insertCustomerCheckRelationEo(CustomerCheckRelationReqDto addReqDto, BizChannelEnum bizChannelEnum) {
        CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerCheckRelationEo);
        customerCheckRelationEo.setBizType(Long.valueOf(bizChannelEnum.getChannelCode()));
        customerCheckRelationEo.setStoreId(addReqDto.getStoreId());
        customerCheckRelationEo.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        customerCheckRelationEo.setStoreThirdPartyId(addReqDto.getThirdPartyId());
        customerCheckRelationEo.setSourceOperateType(StringUtils.isNotBlank((CharSequence)addReqDto.getSourceOperateType()) ? addReqDto.getSourceOperateType() : CustomerCheckRelationSourceOperateTypeEnum.MANUAL.getType());
        this.customerCheckRelationDas.insert((BaseEo)customerCheckRelationEo);
    }

    private void checkStoreIdsDisable(String StoreId) {
        CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
        customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        customerCheckRelationReqDto.setStoreId(StoreId);
        List customerCheckRelationList = this.queryByPage(JSON.toJSONString((Object)customerCheckRelationReqDto), 1, Integer.MAX_VALUE).getList();
        if (CollectionUtils.isNotEmpty((Collection)customerCheckRelationList)) {
            this.customerRelationCheckStoreDisable(customerCheckRelationList);
        }
    }

    @Override
    public void disableRelationByOrgId(String orgId) {
        AssertUtil.isTrue((!org.springframework.util.StringUtils.isEmpty((Object)orgId) ? 1 : 0) != 0, (String)"\u7ec4\u7ec7ID\u4e3a\u7a7a");
        CustomerCheckRelationEo customerCheckRelation = new CustomerCheckRelationEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.eq((String)"org_id", (Object)orgId));
        sqlFilters.add(SqlFilter.ne((String)"status", (Object)CustomerCheckStatusEnum.NOT_BOUND.getStatus()));
        customerCheckRelation.setSqlFilters((List)sqlFilters);
        customerCheckRelation.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
        customerCheckRelation.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.MANUAL.getType());
        int result = this.customerCheckRelationDas.updateSelectiveSqlFilter((BaseEo)customerCheckRelation);
        AssertUtil.isTrue((result >= 0 ? 1 : 0) != 0, (String)("\u5931\u6548[" + orgId + "]\u7ec4\u7ec7\u4eba\u5e97\u5173\u7cfb\u5931\u8d25"));
    }

    private void checkPersonPartnerDisable(Long orgId, CustomerCheckRelationReqDto addReqDto, CustomerRespDto customerRespDto) {
        List rowIds;
        CustomerCheckRelationEo customerCheckRelationReqDto = new CustomerCheckRelationEo();
        customerCheckRelationReqDto.setStoreId(addReqDto.getStoreId());
        customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        customerCheckRelationReqDto.setOrgId(orgId);
        List dbList = this.customerCheckRelationDas.select((BaseEo)customerCheckRelationReqDto);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
            tbPersonPartnerRelReqDto.setRowIds(dbList.stream().map(CustomerCheckRelationEo::getSalesmanId).collect(Collectors.toList()));
            tbPersonPartnerRelReqDto.setCustomerId(addReqDto.getThirdPartyId());
            tbPersonPartnerRelReqDto.setMasterOuId(customerRespDto.getThirdPartyId());
            PageInfo tbPersonPartnerRelRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tbPersonPartnerRelQueryApi.queryByPage(JSON.toJSONString((Object)tbPersonPartnerRelReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
            if (CollectionUtils.isNotEmpty((Collection)tbPersonPartnerRelRespDtoPageInfo.getList())) {
                rowIds = tbPersonPartnerRelRespDtoPageInfo.getList().stream().map(TbPersonPartnerRelRespDto::getRowId).collect(Collectors.toList());
                dbList.forEach(c -> {
                    if (!rowIds.contains(c.getSalesmanId())) {
                        c.setStatus(CustomerCheckStatusEnum.DISABLE.getStatus());
                        c.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.DISABLE_STORE_REL.getType());
                        int result = this.customerCheckRelationDas.update((BaseEo)c);
                        AssertUtil.isTrue((result > 0 ? 1 : 0) != 0, (String)"\u8003\u6838\u5173\u7cfb\u53d8\u66f4\u5931\u8d25\uff01");
                    }
                });
            } else {
                log.error("checkPersonPartnerDisable \u5220\u9664\u5df2\u7ecf\u5b58\u5728\u7ed1\u5b9a\u7684\u8003\u6838\u5173\u7cfb\u5217\u8868:" + JSON.toJSONString((Object)dbList));
                dbList.forEach(c -> {
                    c.setStatus(CustomerCheckStatusEnum.DISABLE.getStatus());
                    c.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.DISABLE_STORE_REL.getType());
                    int result = this.customerCheckRelationDas.update((BaseEo)c);
                    AssertUtil.isTrue((result > 0 ? 1 : 0) != 0, (String)"\u8003\u6838\u5173\u7cfb\u53d8\u66f4\u5931\u8d25\uff01");
                });
            }
        }
        CustomerCheckRelationEo reqDto = new CustomerCheckRelationEo();
        reqDto.setStoreId(addReqDto.getStoreId());
        reqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        log.info("\u6821\u9a8c\u8be5\u95e8\u5e97\u662f\u5426\u7ed1\u5b9a\u4e86\u5176\u4ed6\u7ecf\u9500\u5546\u4e0b\u7684\u4e1a\u52a1\u5458, \u5224\u65ad\u662f\u5426\u5df2\u7ecf\u5931\u6548.... \u8bf7\u6c42\u53c2\u6570:" + JSON.toJSONString((Object)reqDto));
        List dbList2 = this.customerCheckRelationDas.select((BaseEo)reqDto);
        if (CollectionUtils.isNotEmpty((Collection)dbList2)) {
            rowIds = dbList2.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType())) && StringUtils.isNotBlank((CharSequence)a.getSalesmanId())).map(c -> c.getSalesmanId()).collect(Collectors.toList());
            List<Long> orgIds = dbList2.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType())) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)a.getOrgId())).map(c -> c.getOrgId()).collect(Collectors.toList());
            List storeThirdPartyIds = dbList2.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType())) && StringUtils.isNotBlank((CharSequence)a.getStoreThirdPartyId())).map(c -> c.getStoreThirdPartyId()).collect(Collectors.toList());
            ArrayList masterOuIds = new ArrayList();
            HashMap map = new HashMap(16);
            List<Object> customerRespDtoList = new ArrayList();
            if (CollectionUtils.isNotEmpty(orgIds)) {
                customerRespDtoList = this.customerQueryService.queryCustomerByOrgId(orgIds);
            }
            if (CollectionUtils.isNotEmpty(customerRespDtoList)) {
                masterOuIds.addAll(customerRespDtoList.stream().map(a -> a.getThirdPartyId()).collect(Collectors.toList()));
                customerRespDtoList.stream().filter(a -> org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)a.getOrgInfoId()) && StringUtils.isNotBlank((CharSequence)a.getThirdPartyId())).forEach(c -> map.put(c.getOrgInfoId(), c.getThirdPartyId()));
            }
            if (CollectionUtils.isNotEmpty(rowIds) && CollectionUtils.isNotEmpty(storeThirdPartyIds) && CollectionUtils.isNotEmpty(masterOuIds)) {
                TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
                tbPersonPartnerRelReqDto.setRowIds(rowIds);
                tbPersonPartnerRelReqDto.setMasterOuIds(masterOuIds);
                tbPersonPartnerRelReqDto.setStoreThirdPartyIds(storeThirdPartyIds);
                log.info("\u6821\u9a8c\u8be5\u95e8\u5e97\u662f\u5426\u7ed1\u5b9a\u4e86\u5176\u4ed6\u7ecf\u9500\u5546\u4e0b\u7684\u4e1a\u52a1\u5458, \u5224\u65ad\u62a5\u8868\u4e2d\u5fc3\u4eba\u5458\u662f\u5426\u5df2\u7ecf\u5b58\u5728.... \u8bf7\u6c42\u53c2\u6570:" + JSON.toJSONString((Object)tbPersonPartnerRelReqDto));
                List personInfoList = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.tbPersonPartnerRelQueryApi.queryByPage(JSON.toJSONString((Object)tbPersonPartnerRelReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)))).getList();
                if (CollectionUtils.isEmpty((Collection)personInfoList)) {
                    dbList2.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType()))).forEach(c -> {
                        c.setStatus(CustomerCheckStatusEnum.DISABLE.getStatus());
                        c.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.DISABLE_EMPLOYEE.getType());
                        int result = this.customerCheckRelationDas.update((BaseEo)c);
                        AssertUtil.isTrue((result > 0 ? 1 : 0) != 0, (String)"\u8003\u6838\u5173\u7cfb\u53d8\u66f4\u5931\u8d25\uff01");
                        log.info("bindStoreAndSalesmanRelation.checkPersonPartnerDisable \u7ed1\u5b9a\u65b0\u589e\u8003\u6838\u4eba\u5458,\u67e5\u8be2\u6821\u9a8c\u4e1a\u52a1\u5458\u662f\u5426\u5b58\u5728,(\u90fd\u4e0d\u5b58\u5728),\u5220\u9664\u4eba\u5e97\u7ed1\u5b9a\u5173\u7cfb:" + JSON.toJSONString((Object)c));
                    });
                } else {
                    Map<String, List<TbPersonPartnerRelRespDto>> personMap = personInfoList.stream().collect(Collectors.groupingBy(p -> p.getMasterOuId() + "-" + p.getCustomerId() + "-" + p.getRowId()));
                    dbList2.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType()))).forEach(c -> {
                        String key;
                        List partnerRelRespDtoList;
                        String customerThirdPartyId = (String)map.get(c.getOrgId());
                        if (StringUtils.isNotBlank((CharSequence)customerThirdPartyId) && CollectionUtils.isEmpty((Collection)(partnerRelRespDtoList = (List)personMap.get(key = customerThirdPartyId + "-" + c.getStoreThirdPartyId() + "-" + c.getSalesmanId())))) {
                            c.setStatus(CustomerCheckStatusEnum.DISABLE.getStatus());
                            c.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.DISABLE_EMPLOYEE.getType());
                            int result = this.customerCheckRelationDas.update((BaseEo)c);
                            AssertUtil.isTrue((result > 0 ? 1 : 0) != 0, (String)"\u8003\u6838\u5173\u7cfb\u53d8\u66f4\u5931\u8d25\uff01");
                            log.info("bindStoreAndSalesmanRelation.checkPersonPartnerDisable \u7ed1\u5b9a\u65b0\u589e\u8003\u6838\u4eba\u5458,\u67e5\u8be2\u6821\u9a8c\u4e1a\u52a1\u5458\u662f\u5426\u5b58\u5728,(\u4eba\u5458\u5931\u6548),\u5220\u9664\u4eba\u5e97\u7ed1\u5b9a\u5173\u7cfb:" + JSON.toJSONString((Object)c));
                        }
                    });
                }
            }
        }
    }

    private void verifyRelation(CustomerCheckRelationReqDto addReqDto, BizChannelEnum bizChannelEnum) {
        CustomerCheckRelationEo customerCheckRelationReqDto = new CustomerCheckRelationEo();
        customerCheckRelationReqDto.setStoreId(addReqDto.getStoreId());
        customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        log.info("verifyRelation \u67e5\u8be2\u5f53\u524d\u95e8\u5e97\u662f\u5426\u7ed1\u5b9a\u4e86\u5176\u4ed6\u7ecf\u9500\u5546\u4e0b\u7684\u4eba\u5e97\u8003\u6838\u5173\u7cfb...... \u8bf7\u6c42\u53c2\u6570:" + JSON.toJSONString((Object)customerCheckRelationReqDto));
        List dbList = this.customerCheckRelationDas.select((BaseEo)customerCheckRelationReqDto);
        CustomerRespDto theCustomerRespDto = this.customerQueryService.queryByOrgInfoId(addReqDto.getOrgId());
        CustomerCheckPatternReqDto customerCheckPatternReqDto = new CustomerCheckPatternReqDto();
        customerCheckPatternReqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{theCustomerRespDto.getCode()}));
        List customerCheckPatternEos = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(customerCheckPatternReqDto);
        AssertUtil.isTrue((!org.springframework.util.CollectionUtils.isEmpty((Collection)customerCheckPatternEos) ? 1 : 0) != 0, (String)"\u5f53\u524d\u5ba2\u6237\u672a\u6307\u5b9a\u8003\u6838\u65b9\u5f0f\uff01");
        log.info("\u68c0\u6d4b\u662f\u5426\u5b58\u5728\u5408\u5e76\u8003\u6838\u7ecf\u9500\u5546 result => {} ", (Object)JSON.toJSONString((Object)customerCheckPatternEos));
        CustomerCheckPatternEo customerCheckPatternEo = (CustomerCheckPatternEo)customerCheckPatternEos.stream().findFirst().get();
        CheckPatternTypeEnum checkPatternTypeEnum = CheckPatternTypeEnum.enumOfType((Integer)customerCheckPatternEo.getPatternType());
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)checkPatternTypeEnum) ? 1 : 0) != 0, (String)"\u8003\u6838\u6a21\u5f0f\u4e0d\u5b58\u5728\uff01");
        AssertUtil.isTrue((boolean)bizChannelEnum.getCheckPatternTypes().contains(checkPatternTypeEnum), (String)"\u5f53\u524d\u4e1a\u52a1\u7ebf\u4e0d\u5b58\u5728\u8be5\u8003\u6838\u6a21\u5f0f");
        switch (checkPatternTypeEnum) {
            case ALONE_CHECK: {
                if (!CollectionUtils.isNotEmpty((Collection)dbList)) break;
                dbList.stream().filter(a -> BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType()))).forEach(eo -> {
                    CustomerRespDto customerRespDto = this.customerQueryService.queryByOrgInfoId(eo.getOrgId());
                    AssertUtil.isTrue((boolean)false, (String)String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)eo.getBizType().toString()).getDesc(), customerRespDto.getName()));
                });
                break;
            }
            case SEPARATE_CHECK: {
                List<CustomerCheckRelationEo> notByHealthList;
                if (!CollectionUtils.isNotEmpty((Collection)dbList) || !CollectionUtils.isNotEmpty(notByHealthList = dbList.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType()))).collect(Collectors.toList()))) break;
                notByHealthList.forEach(eo -> {
                    CustomerRespDto customerRespDto = this.customerQueryService.queryByOrgInfoId(eo.getOrgId());
                    AssertUtil.isTrue((!bizChannelEnum.getChannelCode().equals(String.valueOf(eo.getBizType())) ? 1 : 0) != 0, (String)String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)eo.getBizType().toString()).getDesc(), customerRespDto.getName()));
                    CustomerCheckPatternReqDto reqDto = new CustomerCheckPatternReqDto();
                    reqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{customerRespDto.getCode()}));
                    List patternEoList = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(reqDto);
                    patternEoList.forEach(patternEo -> AssertUtil.isTrue((!String.valueOf(CheckPatternTypeEnum.MERGE_CHECK.getType()).equals(String.valueOf(patternEo.getPatternType())) ? 1 : 0) != 0, (String)String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)eo.getBizType().toString()).getDesc(), customerRespDto.getName())));
                });
                break;
            }
            case MERGE_CHECK: {
                if (!CollectionUtils.isNotEmpty((Collection)dbList)) break;
                dbList.stream().filter(a -> !BizChannelEnum.BY_HEALTH.getChannelCode().equals(String.valueOf(a.getBizType()))).forEach(eo -> this.verifyMergeCheckRule(theCustomerRespDto, (CustomerCheckRelationEo)eo, addReqDto.getStoreId()));
                break;
            }
            default: {
                throw new BizException("0001", "\u4e0d\u5b58\u5728\u5f53\u524d\u64cd\u4f5c\u7c7b\u578b");
            }
        }
    }

    private void verifyMergeCheckRule(CustomerRespDto customerRespDto, CustomerCheckRelationEo customerCheckRelationEo, String storeId) {
        AssertUtil.isTrue((!customerCheckRelationEo.getOrgId().equals(customerRespDto.getOrgInfoId()) ? 1 : 0) != 0, (String)"\u95e8\u5e97\u53ea\u53ef\u4ee5\u7ed1\u5b9a\u4e00\u4e2a\u4eba\u5458\u8fdb\u884c\u8003\u6838\uff0c\u7ed1\u5b9a\u540e\u82e5\u9700\u8c03\u6574\uff0c\u9700\u89e3\u9664\u7ed1\u5b9a\u540e\u624d\u53ef\u8fdb\u884c\u9009\u62e9");
        CustomerCheckPatternReqDto reqDto = new CustomerCheckPatternReqDto();
        reqDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{customerRespDto.getCode()}));
        List patternEoList = this.customerCheckPatternDas.selectCustomerCheckPatternByCode(reqDto);
        ArrayList orgIds = Lists.newArrayList();
        orgIds.addAll(patternEoList.stream().map(c -> c.getOrgId()).collect(Collectors.toList()));
        orgIds.addAll(patternEoList.stream().map(c -> c.getMergeOrgId()).collect(Collectors.toList()));
        CustomerRespDto theCustomerRespDto = this.customerQueryService.queryByOrgInfoId(customerCheckRelationEo.getOrgId());
        AssertUtil.isTrue((boolean)orgIds.contains(customerCheckRelationEo.getOrgId()), (String)String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)customerCheckRelationEo.getBizType().toString()).getDesc(), theCustomerRespDto.getName()));
        CustomerCheckPatternConfigReqDto customerCheckPatternConfigReqDto = new CustomerCheckPatternConfigReqDto();
        customerCheckPatternConfigReqDto.setOrganizationIds((List)orgIds);
        PageInfo<CustomerCheckPatternConfigRespDto> customerCheckPatternConfigRespDtoPageInfo = this.customerCheckPatternConfigService.queryByPage(JSON.toJSONString((Object)customerCheckPatternConfigReqDto), 1, Integer.MAX_VALUE);
        AssertUtil.isTrue((!org.springframework.util.CollectionUtils.isEmpty((Collection)customerCheckPatternConfigRespDtoPageInfo.getList()) ? 1 : 0) != 0, (String)String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)customerCheckRelationEo.getBizType().toString()).getDesc(), theCustomerRespDto.getName()));
        List<String> storeIds = this.calculateStoreIds(customerCheckPatternConfigRespDtoPageInfo.getList());
        AssertUtil.isTrue((!org.springframework.util.CollectionUtils.isEmpty(storeIds) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7ecf\u9500\u5546\u7ba1\u8f96\u5b58\u5728\u5f02\u5e38");
        SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(customerRespDto.getOrgInfoId()));
        List<StoreSellerRelateRespDto> storeSellerRelateRespDtos = this.storeSellerRelateService.queryStoreSellerRelateBySellerId(sellerRespDto.getId(), storeIds);
        AssertUtil.isTrue((boolean)storeSellerRelateRespDtos.stream().map(c -> c.getStoreId()).distinct().collect(Collectors.toList()).contains(storeId), (String)String.format(StoreCheckErrorEnum.IS_EXIT_STORE_CHECK_RELATION.getDesc(), BizChannelEnum.enumOfChannelCode((String)customerCheckRelationEo.getBizType().toString()).getDesc(), theCustomerRespDto.getName()));
    }

    @Override
    public List<String> calculateStoreIds(List<CustomerCheckPatternConfigRespDto> customerCheckPatternConfigRespDtos) {
        if (org.springframework.util.CollectionUtils.isEmpty(customerCheckPatternConfigRespDtos)) {
            return Lists.newArrayList();
        }
        Map<String, List<CustomerCheckPatternConfigRespDto>> collect = customerCheckPatternConfigRespDtos.stream().collect(Collectors.groupingBy(CustomerCheckPatternConfigRespDto::getConfigType));
        ArrayList storeIds = Lists.newArrayList();
        storeIds.addAll(this.storeService.queryByArea(collect.getOrDefault(StoreGovernTypeEnum.AREA.getCode(), Lists.newArrayList()).stream().map(c -> c.getConfigContent()).collect(Collectors.toList())));
        List<String> storeParents = collect.getOrDefault(StoreGovernTypeEnum.STORE_PARENT.getCode(), Lists.newArrayList()).stream().map(c -> c.getConfigContent()).collect(Collectors.toList());
        List<StoreRespDto> storeRespDtos = this.storeService.queryListByIds(storeParents);
        if (!org.springframework.util.CollectionUtils.isEmpty(storeRespDtos)) {
            List creditNums = storeRespDtos.stream().map(c -> c.getSocialCreditNum()).collect(Collectors.toList());
            StoreQueryReqDto storeQueryReqDto = new StoreQueryReqDto();
            storeQueryReqDto.setParentSocialCreditNums(creditNums);
            storeQueryReqDto.setPageNum(1);
            storeQueryReqDto.setPageSize(Integer.MAX_VALUE);
            PageInfo<StoreRespDto> storeRespDtoPageInfo = this.storeService.queryPage(storeQueryReqDto);
            storeIds.addAll(org.springframework.util.CollectionUtils.isEmpty((Collection)storeRespDtoPageInfo.getList()) ? Lists.newArrayList() : (Collection)storeRespDtoPageInfo.getList().stream().map(c -> c.getStoreId()).collect(Collectors.toSet()));
        }
        storeIds.addAll(collect.getOrDefault(StoreGovernTypeEnum.STORE.getCode(), Lists.newArrayList()).stream().map(c -> c.getConfigContent()).collect(Collectors.toList()));
        storeIds.removeAll(collect.getOrDefault(StoreGovernTypeEnum.BLACKLIST.getCode(), Lists.newArrayList()).stream().map(c -> c.getConfigContent()).collect(Collectors.toList()));
        return storeIds;
    }

    @Override
    public void customerRelationToTenantScope(Long orgId, List<String> enableRecord) {
        CustomerCheckRelationReqDto customerCheckRelationReqDto = new CustomerCheckRelationReqDto();
        customerCheckRelationReqDto.setOrgId(orgId);
        customerCheckRelationReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        List<CustomerCheckRelationRespDto> customerCheckRelationRespDtos = this.customerCheckRelationService.queryByStoreIds(customerCheckRelationReqDto);
        List disableStoreIds = customerCheckRelationRespDtos.stream().filter(c -> !enableRecord.contains(c.getStoreId())).map(c -> c.getStoreId()).distinct().collect(Collectors.toList());
        if (!org.springframework.util.CollectionUtils.isEmpty(disableStoreIds)) {
            ArrayList sqlFilters = Lists.newArrayList();
            CustomerCheckRelationEo customerCheckRelation = new CustomerCheckRelationEo();
            sqlFilters.add(SqlFilter.eq((String)"org_id", (Object)orgId));
            sqlFilters.add(SqlFilter.in((String)"store_id", disableStoreIds));
            customerCheckRelation.setSqlFilters((List)sqlFilters);
            customerCheckRelation.setStatus(CustomerCheckStatusEnum.NOT_BOUND.getStatus());
            customerCheckRelation.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.DISABLE_STORE_REL.getType());
            int result = this.customerCheckRelationDas.updateSelectiveSqlFilter((BaseEo)customerCheckRelation);
            AssertUtil.isTrue((result >= 0 ? 1 : 0) != 0, (String)("\u5931\u6548[" + orgId + "]\u7ec4\u7ec7\u4eba\u5e97\u5173\u7cfb\u5931\u8d25"));
        }
    }

    @NotNull
    private CustomerCheckStatusEnum verifyBindRelationParams(CustomerCheckRelationReqDto addReqDto, CustomerRespDto customerRespDto) {
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)addReqDto.getOrgId()) ? 1 : 0) != 0, (String)"\u7ec4\u7ec7ID\u4e3a\u7a7a!");
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)addReqDto.getStoreId()) ? 1 : 0) != 0, (String)"\u95e8\u5e97ID\u4e3a\u7a7a!");
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)addReqDto.getSalesmanId()) ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u5458ID\u4e3a\u7a7a!");
        AssertUtil.isTrue((!org.springframework.util.StringUtils.isEmpty((Object)addReqDto.getThirdPartyId()) ? 1 : 0) != 0, (String)"\u7ecf\u9500\u5546ID\u4e3a\u7a7a!");
        AssertUtil.isTrue((!org.springframework.util.StringUtils.isEmpty((Object)addReqDto.getStatus()) ? 1 : 0) != 0, (String)"\u8003\u6838\u5173\u7cfb\u72b6\u6001\u4e3a\u7a7a!");
        CustomerCheckStatusEnum customerCheckStatusEnum = CustomerCheckStatusEnum.enumOfStatus((Integer)addReqDto.getStatus());
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)customerCheckStatusEnum) ? 1 : 0) != 0, (String)"\u4e0d\u5b58\u5728\u5f53\u524d\u4e1a\u52a1\u65b9\u5f0f\uff01");
        TbPersonPartnerRelReqDto tbPersonPartnerRelReqDto = new TbPersonPartnerRelReqDto();
        tbPersonPartnerRelReqDto.setRowIds(Arrays.asList(addReqDto.getSalesmanId()));
        tbPersonPartnerRelReqDto.setCustomerId(addReqDto.getThirdPartyId());
        tbPersonPartnerRelReqDto.setMasterOuId(customerRespDto.getThirdPartyId());
        PageInfo tbPersonPartnerRelRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.tbPersonPartnerRelQueryApi.queryByPage(JSON.toJSONString((Object)tbPersonPartnerRelReqDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        AssertUtil.isTrue((!ObjectUtils.isEmpty((Object)tbPersonPartnerRelRespDtoPageInfo.getList()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7ecf\u9500\u5546\u4e0d\u5b58\u5728\u8be5\u4e1a\u52a1\u5458");
        return customerCheckStatusEnum;
    }

    @Override
    public void customerRelationCheckStoreDisable(List<CustomerCheckRelationRespDto> checkRelationRespDtoList) {
        log.info("\u4eba\u5e97\u8003\u6838\u5173\u7cfb---->\u8c03\u5ea6\u5220\u9664  customerRelationCheckStoreDisable Star ");
        Map<Object, Object> map = new HashMap(16);
        if (CollectionUtils.isNotEmpty(checkRelationRespDtoList)) {
            List storeIds = checkRelationRespDtoList.stream().filter(a -> org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)a.getStoreId())).map(c -> c.getStoreId()).collect(Collectors.toList());
            List orgIds = checkRelationRespDtoList.stream().filter(a -> org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)a.getOrgId())).map(c -> c.getOrgId()).collect(Collectors.toList());
            CustomerStoreReqDto customerStoreReqDto = new CustomerStoreReqDto();
            customerStoreReqDto.setStoreIds(storeIds);
            customerStoreReqDto.setMerchantIds(orgIds);
            List customerStoreResponseDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerDistributorsQueryApi.queryCustomerStoreByPost(customerStoreReqDto));
            if (CollectionUtils.isNotEmpty((Collection)customerStoreResponseDtos)) {
                map = customerStoreResponseDtos.stream().collect(Collectors.groupingBy(a -> a.getMerchantId() + "-" + a.getStoreId()));
            } else {
                checkRelationRespDtoList.forEach(c -> {
                    CustomerCheckRelationEo updateEo = new CustomerCheckRelationEo();
                    DtoHelper.dto2Eo((BaseVo)c, (BaseEo)updateEo);
                    updateEo.setStatus(CustomerCheckStatusEnum.DISABLE.getStatus());
                    updateEo.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.DISABLE_STORE_REL.getType());
                    int result = this.customerCheckRelationDas.update((BaseEo)updateEo);
                    AssertUtil.isTrue((result > 0 ? 1 : 0) != 0, (String)"\u8003\u6838\u5173\u7cfb\u53d8\u66f4\u5931\u8d25\uff01");
                    log.info("[bindStoreAndSalesmanRelation.customerRelationCheckStoreDisable]\u95e8\u5e97\u5217\u8868\u5931\u6548[\u5168\u4e0d\u5b58\u5728],\u5220\u9664\u4eba\u5e97\u7ed1\u5b9a\u5173\u7cfb:" + JSON.toJSONString((Object)c));
                });
            }
            HashMap finalMap = map;
            checkRelationRespDtoList.forEach(c -> {
                List list = (List)finalMap.get(c.getOrgId() + "-" + c.getStoreId());
                if (CollectionUtils.isEmpty((Collection)list)) {
                    CustomerCheckRelationEo updateEo = new CustomerCheckRelationEo();
                    DtoHelper.dto2Eo((BaseVo)c, (BaseEo)updateEo);
                    updateEo.setStatus(CustomerCheckStatusEnum.DISABLE.getStatus());
                    updateEo.setSourceOperateType(CustomerCheckRelationSourceOperateTypeEnum.DISABLE_STORE_REL.getType());
                    int result = this.customerCheckRelationDas.update((BaseEo)updateEo);
                    AssertUtil.isTrue((result > 0 ? 1 : 0) != 0, (String)"\u8003\u6838\u5173\u7cfb\u53d8\u66f4\u5931\u8d25\uff01");
                    log.info("[bindStoreAndSalesmanRelation.customerRelationCheckStoreDisable]\u95e8\u5e97\u5217\u8868\u5931\u6548,\u5220\u9664\u4eba\u5e97\u7ed1\u5b9a\u5173\u7cfb:" + JSON.toJSONString((Object)c));
                }
            });
            log.info("\u4eba\u5e97\u8003\u6838\u5173\u7cfb---->\u8c03\u5ea6\u5220\u9664  customerRelationCheckStoreDisable End ");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void DetectionInsiderCheckRel() {
        ValidInsiderCheckRelReqDto validInsiderCheckRelReqDto = new ValidInsiderCheckRelReqDto();
        validInsiderCheckRelReqDto.setStatus(CustomerCheckStatusEnum.BOUND.getStatus());
        validInsiderCheckRelReqDto.setIsException(YesOrNoEnum.YES.getCode());
        List validInsiderCheckRelRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerDistributorsQueryApi.queryValidInsiderCheckRel(validInsiderCheckRelReqDto));
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)validInsiderCheckRelRespDtos)) {
            log.info("\u76ee\u524d\u4e0d\u5b58\u5728\u7ed1\u5b9a\u6570\u636e\u4e0d\u4e00\u81f4\u8003\u6838\u5173\u7cfb");
            return;
        }
        validInsiderCheckRelRespDtos.forEach(rel -> {
            CustomerCheckRelationEo customerCheckRelationEo = new CustomerCheckRelationEo();
            customerCheckRelationEo.setStoreThirdPartyId(rel.getCustomerId());
            customerCheckRelationEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"id", (Object)rel.getRelId())}));
            int result = this.customerCheckRelationDas.updateSelectiveSqlFilter((BaseEo)customerCheckRelationEo);
            AssertUtil.isTrue((result >= 0 ? 1 : 0) != 0, (String)"\u68c0\u67e5\u66f4\u65b0\u8003\u6838\u5173\u7cfb\u5173\u8054\u5ba2\u6237\u4fe1\u606f\u5931\u8d25");
        });
        List relIds = validInsiderCheckRelRespDtos.stream().map(c -> c.getRelId()).collect(Collectors.toList());
        List customerCheckRelationEos = this.customerCheckRelationDas.selectByIds(relIds);
        ArrayList checkRelationRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)customerCheckRelationEos, (Collection)checkRelationRespDtoList, CustomerCheckRelationRespDto.class);
        this.customerRelationCheckStoreDisable(checkRelationRespDtoList);
    }
}

