/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.customer.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerAreaExtExportRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerAreaImportDto;
import com.dtyunxi.yundt.cube.center.customer.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerAreaDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerAreaMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.RCustomerRegionMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerAreaEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerAreaEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdRCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerAreaDto;
import com.dtyunxi.yundt.cube.center.user.api.util.BeanPropertyNullUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.customer.api.dto.request.CustomerAreaExtReqDto;
import com.yx.tcbj.center.customer.biz.service.ICustomerAreaExtService;
import com.yx.tcbj.center.shop.api.ISellerExpandApi;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customerAreaExtServiceImpl")
public class CustomerAreaExtServiceImpl
implements ICustomerAreaExtService {
    Logger logger = LoggerFactory.getLogger(CustomerAreaExtServiceImpl.class);
    @Resource
    private CustomerAreaDas customerAreaDas;
    @Resource
    private RCustomerRegionMapper rCustomerRegionMapper;
    @Resource
    private CustomerAreaMapper customerAreaMapper;
    @Resource
    private ISellerExpandApi sellerExpandApi;
    @Resource
    private HttpServletRequest request;

    @Override
    public void addCustomerArea(CustomerAreaExtReqDto customerAreaExtReqDto) {
        this.logger.info("\u65b0\u589e\u9500\u552e\u533a\u57df\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)customerAreaExtReqDto));
        this.validaData(customerAreaExtReqDto);
        CustomerAreaEo queryCustomerAreaEo = new CustomerAreaEo();
        queryCustomerAreaEo.setCode(customerAreaExtReqDto.getCode());
        CustomerAreaEo customerAreaEo1 = (CustomerAreaEo)this.customerAreaDas.selectOne((BaseEo)queryCustomerAreaEo);
        if (customerAreaEo1 != null) {
            CustomerAreaExtReqDto customerUpdateReqDto = new CustomerAreaExtReqDto();
            this.updateCustomerArea(customerUpdateReqDto);
        }
        CustomerAreaEo customerAreaEo = new CustomerAreaEo();
        customerAreaEo.setExtension("1");
        DtoHelper.dto2Eo((BaseVo)customerAreaExtReqDto, (BaseEo)customerAreaEo);
        int count = this.customerAreaDas.insert((BaseEo)customerAreaEo);
        if (count != NumberUtils.INTEGER_ONE) {
            throw new BizException("\u65b0\u589e\u9500\u552e\u533a\u57df\u6570\u636e\u5931\u8d25\uff0c\u63d2\u5165\u6570\u636e\u5f02\u5e38");
        }
    }

    @Override
    public void updateCustomerArea(CustomerAreaExtReqDto customerAreaExtReqDto) {
        this.logger.info("\u66f4\u65b0\u9500\u552e\u533a\u57df\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)customerAreaExtReqDto));
        this.validaData(customerAreaExtReqDto);
        CustomerAreaEo areaQueryEo = new CustomerAreaEo();
        areaQueryEo.setCode(customerAreaExtReqDto.getCode());
        List customerAreaEos = this.customerAreaDas.select((BaseEo)areaQueryEo);
        if (CollectionUtils.isEmpty((Collection)customerAreaEos)) {
            throw new BizException("\u66f4\u65b0\u9500\u552e\u533a\u57df\u6570\u636e\u5931\u8d25\uff0c\u8be5\u7f16\u7801\u5bf9\u5e94\u533a\u57df\u4e0d\u5b58\u5728:" + customerAreaExtReqDto.getCode());
        }
        if (customerAreaEos.size() > NumberUtils.INTEGER_ONE) {
            throw new BizException("\u66f4\u65b0\u9500\u552e\u533a\u57df\u6570\u636e\u5931\u8d25\uff0c\u8be5\u7f16\u7801\u5bf9\u5e94\u591a\u4e2a\u533a\u57df");
        }
        CustomerAreaEo customerAreaEo = new CustomerAreaEo();
        DtoHelper.dto2Eo((BaseVo)customerAreaExtReqDto, (BaseEo)customerAreaEo);
        customerAreaEo.setId(((CustomerAreaEo)customerAreaEos.get(0)).getId());
        customerAreaEo.setExtension("2");
        int count = this.customerAreaDas.update((BaseEo)customerAreaEo);
        if (count != NumberUtils.INTEGER_ONE) {
            throw new BizException("\u66f4\u65b0\u9500\u552e\u533a\u57df\u6570\u636e\u5931\u8d25, \u66f4\u65b0\u6570\u636e\u5f02\u5e38");
        }
    }

    private void validaData(CustomerAreaExtReqDto customerAreaExtReqDto) {
        if (customerAreaExtReqDto == null) {
            throw new BizException("\u9500\u552e\u533a\u57df\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Assert.notNull((Object)customerAreaExtReqDto.getCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)customerAreaExtReqDto.getParentCode(), (String)"\u7236\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)customerAreaExtReqDto.getName(), (String)"\u533a\u57df\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    public Map<Long, List<CustomerAreaRespDto>> getCustomerAreaByCustomerIdMap(List<Long> customerIdList) {
        HashMap<Long, List<CustomerAreaRespDto>> resultMap = new HashMap<Long, List<CustomerAreaRespDto>>();
        if (CollectionUtils.isEmpty(customerIdList)) {
            return resultMap;
        }
        QueryWrapper queryEo = new QueryWrapper();
        queryEo.eq((Object)"dr", (Object)0);
        queryEo.in((Object)"customer_id", customerIdList);
        List customerRegionEos = this.rCustomerRegionMapper.selectList((Wrapper)queryEo);
        if (CollectionUtils.isEmpty((Collection)customerRegionEos)) {
            return resultMap;
        }
        List regionCodeList = customerRegionEos.stream().map(StdRCustomerRegionEo::getRegionCode).distinct().collect(Collectors.toList());
        QueryWrapper areaEo = new QueryWrapper();
        areaEo.eq((Object)"dr", (Object)0);
        areaEo.in((Object)"code", regionCodeList);
        List customerAreaEos = this.customerAreaMapper.selectList((Wrapper)areaEo);
        if (CollectionUtils.isEmpty((Collection)customerAreaEos)) {
            return resultMap;
        }
        Map<Long, List<RCustomerRegionEo>> customerRegionMap = customerRegionEos.stream().collect(Collectors.groupingBy(StdRCustomerRegionEo::getCustomerId));
        Map customerAreaEoMap = customerAreaEos.stream().collect(Collectors.toMap(StdCustomerAreaEo::getCode, Function.identity(), (k1, k2) -> k1));
        for (Long customerId : customerRegionMap.keySet()) {
            ArrayList list = Lists.newArrayList();
            for (RCustomerRegionEo regionEo : customerRegionMap.get(customerId)) {
                if (!customerAreaEoMap.containsKey(regionEo.getRegionCode())) continue;
                CustomerAreaEo customerAreaEo = (CustomerAreaEo)customerAreaEoMap.get(regionEo.getRegionCode());
                CustomerAreaRespDto respDto = new CustomerAreaRespDto();
                DtoHelper.eo2Dto((BaseEo)customerAreaEo, (BaseVo)respDto);
                list.add(respDto);
            }
            resultMap.put(customerId, list);
        }
        return resultMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdateSaleArea(List<CustomerAreaExtReqDto> addAreaList) {
        AssertUtil.assertNotEmpty(addAreaList, (String)"\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a");
        Long orgInfoId = addAreaList.get(0).getOrgInfoId();
        List areaNameList = addAreaList.stream().map(CustomerAreaExtReqDto::getName).distinct().collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"org_info_id", (Object)orgInfoId);
        queryWrapper.in((Object)"name", areaNameList);
        List customerAreaEos = this.customerAreaMapper.selectList((Wrapper)queryWrapper);
        Map<Object, Object> customerAreaEoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)customerAreaEos)) {
            customerAreaEoMap = customerAreaEos.stream().collect(Collectors.toMap(StdCustomerAreaEo::getName, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList sellerAreaDtoList = Lists.newArrayList();
        int i = 0;
        String parentCode = "";
        Long topId = null;
        for (CustomerAreaExtReqDto areaExtReqDto : addAreaList) {
            SellerAreaDto areaDto;
            String name = areaExtReqDto.getName();
            if (customerAreaEoMap.isEmpty() || !customerAreaEoMap.containsKey(name)) {
                CustomerAreaEo addAreaEo = new CustomerAreaEo();
                String code = IdUtil.fastSimpleUUID();
                addAreaEo.setCode(code);
                addAreaEo.setName(name);
                addAreaEo.setOrgInfoId(orgInfoId);
                addAreaEo.setSort(Integer.valueOf(1));
                addAreaEo.setInstanceId(areaExtReqDto.getInstanceId());
                addAreaEo.setTenantId(areaExtReqDto.getTenantId());
                if (i == 0) {
                    addAreaEo.setLevel(Integer.valueOf(i));
                    addAreaEo.setParentCode("0");
                    addAreaEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                    addAreaEo.setTopId(addAreaEo.getId());
                    parentCode = code;
                    topId = addAreaEo.getId();
                } else {
                    addAreaEo.setLevel(Integer.valueOf(i));
                    addAreaEo.setParentCode(parentCode);
                    addAreaEo.setTopId(topId);
                    parentCode = code;
                }
                this.customerAreaDas.insert((BaseEo)addAreaEo);
                areaDto = new SellerAreaDto();
                areaDto.setSellerId(areaExtReqDto.getSellerId());
                areaDto.setAreaCode(addAreaEo.getCode());
                areaDto.setAreaLevel(addAreaEo.getLevel() + "");
                sellerAreaDtoList.add(areaDto);
            } else {
                CustomerAreaEo editAreaEo = (CustomerAreaEo)customerAreaEoMap.get(name);
                Long oldTopId = editAreaEo.getTopId();
                editAreaEo.setInstanceId(areaExtReqDto.getInstanceId());
                editAreaEo.setTenantId(areaExtReqDto.getTenantId());
                if (i == 0) {
                    editAreaEo.setLevel(Integer.valueOf(i));
                    editAreaEo.setParentCode("0");
                    editAreaEo.setTopId(editAreaEo.getId());
                    parentCode = editAreaEo.getCode();
                    topId = editAreaEo.getId();
                } else {
                    editAreaEo.setLevel(Integer.valueOf(i));
                    editAreaEo.setParentCode(parentCode);
                    editAreaEo.setTopId(topId);
                    parentCode = editAreaEo.getCode();
                }
                areaDto = new SellerAreaDto();
                areaDto.setSellerId(areaExtReqDto.getSellerId());
                areaDto.setAreaCode(editAreaEo.getCode());
                areaDto.setAreaLevel(editAreaEo.getLevel() + "");
                sellerAreaDtoList.add(areaDto);
                CustomerAreaEo areaQueryEo = new CustomerAreaEo();
                areaQueryEo.setTopId(oldTopId);
                areaQueryEo.setOrgInfoId(editAreaEo.getOrgInfoId());
                List<CustomerAreaEo> topIdAreaList = this.customerAreaDas.select((BaseEo)areaQueryEo);
                topIdAreaList = topIdAreaList.stream().sorted(Comparator.comparing(StdCustomerAreaEo::getLevel)).collect(Collectors.toList());
                ArrayList childAllList = Lists.newArrayList();
                this.doChildAreaList(topIdAreaList, childAllList, editAreaEo.getCode());
                Map<String, List<CustomerAreaEo>> childAreaGroupMap = childAllList.stream().collect(Collectors.groupingBy(StdCustomerAreaEo::getParentCode));
                for (List<CustomerAreaEo> areaEos : childAreaGroupMap.values()) {
                    int level = i + 1;
                    for (CustomerAreaEo customerAreaEo : areaEos) {
                        customerAreaEo.setTopId(topId);
                        customerAreaEo.setLevel(Integer.valueOf(level));
                        this.customerAreaDas.update((BaseEo)customerAreaEo);
                        SellerAreaDto childAreaDto = new SellerAreaDto();
                        childAreaDto.setSellerId(areaExtReqDto.getSellerId());
                        childAreaDto.setAreaCode(customerAreaEo.getCode());
                        childAreaDto.setAreaLevel(customerAreaEo.getLevel() + "");
                        childAreaDto.setInstanceId(customerAreaEo.getInstanceId());
                        childAreaDto.setTenantId(customerAreaEo.getTenantId());
                        sellerAreaDtoList.add(areaDto);
                    }
                }
                this.customerAreaDas.update((BaseEo)editAreaEo);
            }
            ++i;
        }
        if (CollectionUtils.isNotEmpty((Collection)sellerAreaDtoList)) {
            this.sellerExpandApi.updateSellerAreaBatch((List)sellerAreaDtoList);
        }
    }

    private boolean doChildAreaList(List<CustomerAreaEo> topIdAreaList, List<CustomerAreaEo> childAllList, String code) {
        List childList = topIdAreaList.stream().filter(dto -> dto.getParentCode().equals(code)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(childList)) {
            return true;
        }
        childAllList.addAll(childList);
        for (CustomerAreaEo customerAreaEo : childList) {
            boolean flag = this.doChildAreaList(topIdAreaList, childAllList, customerAreaEo.getCode());
            if (!flag) continue;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CustomerAreaExtExportRespDto importCustomerArea(String url) {
        List customerAreaEoList;
        List customerAreaEoList2;
        List importDtos;
        CustomerAreaExtExportRespDto exportRespDto = new CustomerAreaExtExportRespDto();
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        try {
            URL u = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            InputStream is = conn.getInputStream();
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel(is, 0, 1, CustomerAreaImportDto.class);
            importDtos = objectExcelImportResult.getList();
            importDtos = BeanPropertyNullUtil.getAllFieldNullList((List)importDtos);
        }
        catch (Exception e) {
            throw new BizException("\u5bfc\u5165\u5ba2\u6237\u533a\u57df\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        this.logger.info("\u5bfc\u5165\u7684\u6570\u636e==>{}", (Object)JSONObject.toJSONString((Object)importDtos));
        if (CollectionUtils.isEmpty((Collection)importDtos)) {
            throw new BizException("\u5bfc\u5165\u7684\u8868\u683c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8868\u683c\u540e\u91cd\u65b0\u5bfc\u5165");
        }
        List oneAreaNameList = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getOneAreaName())).map(CustomerAreaImportDto::getOneAreaName).distinct().collect(Collectors.toList());
        List oneAreaEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerAreaDas.filter().in((Object)"name", oneAreaNameList)).eq((Object)"org_info_id", (Object)organizationId)).list();
        Map<Object, Object> oneAreaEoMap = Maps.newHashMap();
        if (CollUtil.isNotEmpty((Collection)oneAreaEos)) {
            oneAreaEoMap = oneAreaEos.stream().collect(Collectors.toMap(StdCustomerAreaEo::getName, Function.identity(), (v1, v2) -> v1));
        }
        List twoAreaNameList = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getTwoAreaName())).map(CustomerAreaImportDto::getTwoAreaName).distinct().collect(Collectors.toList());
        Map<Object, Object> towAreaEoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(twoAreaNameList) && CollUtil.isNotEmpty((Collection)(customerAreaEoList2 = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerAreaDas.filter().in((Object)"name", twoAreaNameList)).eq((Object)"org_info_id", (Object)organizationId)).list()))) {
            towAreaEoMap = customerAreaEoList2.stream().collect(Collectors.toMap(StdCustomerAreaEo::getName, Function.identity(), (v1, v2) -> v1));
        }
        List threeAreaNameList = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getThreeAreaName())).map(CustomerAreaImportDto::getThreeAreaName).distinct().collect(Collectors.toList());
        Map<Object, Object> threeAreaEoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(threeAreaNameList) && CollUtil.isNotEmpty((Collection)(customerAreaEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerAreaDas.filter().in((Object)"name", threeAreaNameList)).eq((Object)"org_info_id", (Object)organizationId)).list()))) {
            threeAreaEoMap = customerAreaEoList.stream().collect(Collectors.toMap(StdCustomerAreaEo::getName, Function.identity(), (v1, v2) -> v1));
        }
        ArrayList successList = Lists.newArrayList();
        ArrayList errorList = Lists.newArrayList();
        Long successNum = 0L;
        for (CustomerAreaImportDto importDto : importDtos) {
            Object threeAreaEo;
            CustomerAreaEo customerAreaEo;
            if (StringUtils.isEmpty((CharSequence)importDto.getOneAreaName())) {
                importDto.setFailMsg("\u4e00\u7ea7\u533a\u57df\u4e3a\u7a7a");
                errorList.add(importDto);
                continue;
            }
            if (oneAreaEoMap.containsKey(importDto.getOneAreaName())) {
                Object parentCode;
                customerAreaEo = (CustomerAreaEo)oneAreaEoMap.get(importDto.getOneAreaName());
                if (StrUtil.isEmpty((CharSequence)importDto.getTwoAreaName())) {
                    importDto.setFailMsg("\u4e8c\u7ea7\u533a\u57df\u4e3a\u7a7a");
                    errorList.add(importDto);
                    continue;
                }
                if (towAreaEoMap.containsKey(importDto.getTwoAreaName()) && StrUtil.isEmpty((CharSequence)importDto.getThreeAreaName())) {
                    importDto.setFailMsg("\u4e8c\u7ea7\u533a\u57df\u5df2\u5b58\u5728");
                    errorList.add(importDto);
                    continue;
                }
                if (towAreaEoMap.containsKey(importDto.getTwoAreaName()) && StrUtil.isNotBlank((CharSequence)importDto.getThreeAreaName()) && threeAreaEoMap.containsKey(importDto.getThreeAreaName())) {
                    importDto.setFailMsg("\u4e09\u7ea7\u533a\u57df\u5df2\u5b58\u5728");
                    errorList.add(importDto);
                    continue;
                }
                if (!towAreaEoMap.containsKey(importDto.getTwoAreaName())) {
                    CustomerAreaEo twoAreaEo = new CustomerAreaEo();
                    twoAreaEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                    twoAreaEo.setTopId(customerAreaEo.getId());
                    twoAreaEo.setCode(UUID.randomUUID().toString().replace("-", ""));
                    twoAreaEo.setParentCode(customerAreaEo.getCode());
                    twoAreaEo.setName(importDto.getTwoAreaName());
                    twoAreaEo.setLevel(Integer.valueOf(1));
                    twoAreaEo.setOrgInfoId(Long.valueOf(organizationId));
                    twoAreaEo.setSort(Integer.valueOf(1));
                    successList.add(twoAreaEo);
                    parentCode = twoAreaEo.getCode();
                } else {
                    parentCode = ((CustomerAreaEo)towAreaEoMap.get(importDto.getTwoAreaName())).getCode();
                }
                if (StrUtil.isNotBlank((CharSequence)importDto.getThreeAreaName())) {
                    threeAreaEo = new CustomerAreaEo();
                    threeAreaEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                    threeAreaEo.setTopId(customerAreaEo.getId());
                    threeAreaEo.setCode(UUID.randomUUID().toString().replace("-", ""));
                    threeAreaEo.setParentCode((String)parentCode);
                    threeAreaEo.setName(importDto.getThreeAreaName());
                    threeAreaEo.setLevel(Integer.valueOf(2));
                    threeAreaEo.setOrgInfoId(Long.valueOf(organizationId));
                    threeAreaEo.setSort(Integer.valueOf(1));
                    successList.add(threeAreaEo);
                }
                parentCode = successNum;
                successNum = successNum + 1L;
                threeAreaEo = successNum;
                continue;
            }
            if (StrUtil.isEmpty((CharSequence)importDto.getTwoAreaName())) {
                if (StrUtil.isNotBlank((CharSequence)importDto.getThreeAreaName())) {
                    importDto.setFailMsg("\u4e8c\u7ea7\u533a\u57df\u4e3a\u7a7a");
                    errorList.add(importDto);
                    continue;
                }
            } else {
                if (towAreaEoMap.containsKey(importDto.getTwoAreaName())) {
                    importDto.setFailMsg("\u4e8c\u7ea7\u533a\u57df\u5df2\u5b58\u5728");
                    errorList.add(importDto);
                    continue;
                }
                if (StrUtil.isNotBlank((CharSequence)importDto.getThreeAreaName()) && threeAreaEoMap.containsKey(importDto.getThreeAreaName())) {
                    importDto.setFailMsg("\u4e09\u7ea7\u533a\u57df\u5df2\u5b58\u5728");
                    errorList.add(importDto);
                    continue;
                }
            }
            customerAreaEo = new CustomerAreaEo();
            customerAreaEo.setLevel(Integer.valueOf(0));
            customerAreaEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
            customerAreaEo.setTopId(customerAreaEo.getId());
            customerAreaEo.setCode(UUID.randomUUID().toString().replace("-", ""));
            customerAreaEo.setParentCode("0");
            customerAreaEo.setName(importDto.getOneAreaName());
            customerAreaEo.setOrgInfoId(Long.valueOf(organizationId));
            customerAreaEo.setSort(Integer.valueOf(1));
            successList.add(customerAreaEo);
            if (StrUtil.isNotBlank((CharSequence)importDto.getTwoAreaName())) {
                CustomerAreaEo twoAreaEo = new CustomerAreaEo();
                twoAreaEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                twoAreaEo.setTopId(customerAreaEo.getId());
                twoAreaEo.setCode(UUID.randomUUID().toString().replace("-", ""));
                twoAreaEo.setParentCode(customerAreaEo.getCode());
                twoAreaEo.setName(importDto.getTwoAreaName());
                twoAreaEo.setLevel(Integer.valueOf(1));
                twoAreaEo.setOrgInfoId(Long.valueOf(organizationId));
                twoAreaEo.setSort(Integer.valueOf(1));
                successList.add(twoAreaEo);
                if (StrUtil.isNotBlank((CharSequence)importDto.getThreeAreaName())) {
                    threeAreaEo = new CustomerAreaEo();
                    threeAreaEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                    threeAreaEo.setTopId(customerAreaEo.getId());
                    threeAreaEo.setCode(UUID.randomUUID().toString().replace("-", ""));
                    threeAreaEo.setParentCode(twoAreaEo.getCode());
                    threeAreaEo.setName(importDto.getThreeAreaName());
                    threeAreaEo.setLevel(Integer.valueOf(2));
                    threeAreaEo.setOrgInfoId(Long.valueOf(organizationId));
                    threeAreaEo.setSort(Integer.valueOf(1));
                    successList.add(threeAreaEo);
                }
            }
            Long l = successNum;
            Long l2 = successNum = Long.valueOf(successNum + 1L);
        }
        exportRespDto.setFailNum(Long.valueOf(errorList.size()));
        exportRespDto.setSuccessNum(successNum);
        exportRespDto.setTotal(Long.valueOf(importDtos.size()));
        if (CollectionUtil.isNotEmpty((Collection)successList)) {
            this.customerAreaDas.insertBatch((List)successList);
        }
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            String title = "\u5bfc\u5165\u5ba2\u6236\u533a\u57df\u5931\u8d25\u6587\u4ef6";
            String fileName = title + System.currentTimeMillis();
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(errorList, CustomerAreaImportDto.class, title, fileName, "xls");
                exportRespDto.setFailFileUrl(exportUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BizException("\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        return exportRespDto;
    }
}

