/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.customer.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.IdUtil;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerAreaExtExportRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerAreaImportDto;
import com.dtyunxi.yundt.cube.center.customer.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerAreaDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerAreaMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.RCustomerRegionMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerAreaEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerAreaEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdRCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerAreaDto;
import com.dtyunxi.yundt.cube.center.user.api.util.BeanPropertyNullUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.customer.api.dto.request.CustomerAreaExtReqDto;
import com.yx.tcbj.center.customer.biz.service.ICustomerAreaExtService;
import com.yx.tcbj.center.shop.api.ISellerExpandApi;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customerAreaExtServiceImpl")
public class CustomerAreaExtServiceImpl
implements ICustomerAreaExtService {
    Logger logger = LoggerFactory.getLogger(CustomerAreaExtServiceImpl.class);
    @Resource
    private CustomerAreaDas customerAreaDas;
    @Resource
    private RCustomerRegionMapper rCustomerRegionMapper;
    @Resource
    private CustomerAreaMapper customerAreaMapper;
    @Resource
    private ISellerExpandApi sellerExpandApi;
    @Resource
    private HttpServletRequest request;
    @Resource
    private ILockService lockService;

    @Override
    public void addCustomerArea(CustomerAreaExtReqDto customerAreaExtReqDto) {
        this.logger.info("\u65b0\u589e\u9500\u552e\u533a\u57df\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)customerAreaExtReqDto));
        this.validaData(customerAreaExtReqDto);
        CustomerAreaEo queryCustomerAreaEo = new CustomerAreaEo();
        queryCustomerAreaEo.setCode(customerAreaExtReqDto.getName());
        CustomerAreaEo customerAreaEo1 = (CustomerAreaEo)this.customerAreaDas.selectOne((BaseEo)queryCustomerAreaEo);
        if (customerAreaEo1 != null) {
            CustomerAreaExtReqDto customerUpdateReqDto = new CustomerAreaExtReqDto();
            this.updateCustomerArea(customerUpdateReqDto);
        }
        CustomerAreaEo customerAreaEo = new CustomerAreaEo();
        customerAreaEo.setExtension("1");
        DtoHelper.dto2Eo((BaseVo)customerAreaExtReqDto, (BaseEo)customerAreaEo);
        int count = this.customerAreaDas.insert((BaseEo)customerAreaEo);
        if (count != NumberUtils.INTEGER_ONE) {
            throw new BizException("\u65b0\u589e\u9500\u552e\u533a\u57df\u6570\u636e\u5931\u8d25\uff0c\u63d2\u5165\u6570\u636e\u5f02\u5e38");
        }
    }

    @Override
    public void updateCustomerArea(CustomerAreaExtReqDto customerAreaExtReqDto) {
        this.logger.info("\u66f4\u65b0\u9500\u552e\u533a\u57df\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)customerAreaExtReqDto));
        this.validaData(customerAreaExtReqDto);
        CustomerAreaEo areaQueryEo = new CustomerAreaEo();
        areaQueryEo.setCode(customerAreaExtReqDto.getCode());
        List customerAreaEos = this.customerAreaDas.select((BaseEo)areaQueryEo);
        if (CollectionUtils.isEmpty((Collection)customerAreaEos)) {
            throw new BizException("\u66f4\u65b0\u9500\u552e\u533a\u57df\u6570\u636e\u5931\u8d25\uff0c\u8be5\u7f16\u7801\u5bf9\u5e94\u533a\u57df\u4e0d\u5b58\u5728:" + customerAreaExtReqDto.getCode());
        }
        if (customerAreaEos.size() > NumberUtils.INTEGER_ONE) {
            throw new BizException("\u66f4\u65b0\u9500\u552e\u533a\u57df\u6570\u636e\u5931\u8d25\uff0c\u8be5\u7f16\u7801\u5bf9\u5e94\u591a\u4e2a\u533a\u57df");
        }
        CustomerAreaEo customerAreaEo = new CustomerAreaEo();
        DtoHelper.dto2Eo((BaseVo)customerAreaExtReqDto, (BaseEo)customerAreaEo);
        customerAreaEo.setId(((CustomerAreaEo)customerAreaEos.get(0)).getId());
        customerAreaEo.setExtension("2");
        int count = this.customerAreaDas.update((BaseEo)customerAreaEo);
        if (count != NumberUtils.INTEGER_ONE) {
            throw new BizException("\u66f4\u65b0\u9500\u552e\u533a\u57df\u6570\u636e\u5931\u8d25, \u66f4\u65b0\u6570\u636e\u5f02\u5e38");
        }
    }

    private void validaData(CustomerAreaExtReqDto customerAreaExtReqDto) {
        if (customerAreaExtReqDto == null) {
            throw new BizException("\u9500\u552e\u533a\u57df\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Assert.notNull((Object)customerAreaExtReqDto.getCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)customerAreaExtReqDto.getParentCode(), (String)"\u7236\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)customerAreaExtReqDto.getName(), (String)"\u533a\u57df\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    @Override
    public Map<Long, List<CustomerAreaRespDto>> getCustomerAreaByCustomerIdMap(List<Long> customerIdList) {
        HashMap<Long, List<CustomerAreaRespDto>> resultMap = new HashMap<Long, List<CustomerAreaRespDto>>();
        if (CollectionUtils.isEmpty(customerIdList)) {
            return resultMap;
        }
        QueryWrapper queryEo = new QueryWrapper();
        queryEo.eq((Object)"dr", (Object)0);
        queryEo.in((Object)"customer_id", customerIdList);
        List customerRegionEos = this.rCustomerRegionMapper.selectList((Wrapper)queryEo);
        if (CollectionUtils.isEmpty((Collection)customerRegionEos)) {
            return resultMap;
        }
        List regionCodeList = customerRegionEos.stream().map(StdRCustomerRegionEo::getRegionCode).distinct().collect(Collectors.toList());
        QueryWrapper areaEo = new QueryWrapper();
        areaEo.eq((Object)"dr", (Object)0);
        areaEo.in((Object)"code", regionCodeList);
        List customerAreaEos = this.customerAreaMapper.selectList((Wrapper)areaEo);
        if (CollectionUtils.isEmpty((Collection)customerAreaEos)) {
            return resultMap;
        }
        Map<Long, List<RCustomerRegionEo>> customerRegionMap = customerRegionEos.stream().collect(Collectors.groupingBy(StdRCustomerRegionEo::getCustomerId));
        Map customerAreaEoMap = customerAreaEos.stream().collect(Collectors.toMap(StdCustomerAreaEo::getCode, Function.identity(), (k1, k2) -> k1));
        for (Long customerId : customerRegionMap.keySet()) {
            ArrayList list = Lists.newArrayList();
            for (RCustomerRegionEo regionEo : customerRegionMap.get(customerId)) {
                if (!customerAreaEoMap.containsKey(regionEo.getRegionCode())) continue;
                CustomerAreaEo customerAreaEo = (CustomerAreaEo)customerAreaEoMap.get(regionEo.getRegionCode());
                CustomerAreaRespDto respDto = new CustomerAreaRespDto();
                DtoHelper.eo2Dto((BaseEo)customerAreaEo, (BaseVo)respDto);
                list.add(respDto);
            }
            resultMap.put(customerId, list);
        }
        return resultMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdateSaleArea(List<CustomerAreaExtReqDto> addAreaList) {
        AssertUtil.assertNotEmpty(addAreaList, (String)"\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a");
        Long orgInfoId = addAreaList.get(0).getOrgInfoId();
        List areaNameList = addAreaList.stream().map(CustomerAreaExtReqDto::getName).distinct().collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"org_info_id", (Object)orgInfoId);
        queryWrapper.in((Object)"name", areaNameList);
        List customerAreaEos = this.customerAreaMapper.selectList((Wrapper)queryWrapper);
        Map<Object, Object> customerAreaEoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)customerAreaEos)) {
            customerAreaEoMap = customerAreaEos.stream().collect(Collectors.toMap(StdCustomerAreaEo::getName, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList sellerAreaDtoList = Lists.newArrayList();
        int i = 0;
        String parentCode = "";
        Long topId = null;
        for (CustomerAreaExtReqDto areaExtReqDto : addAreaList) {
            SellerAreaDto areaDto;
            String name = areaExtReqDto.getName();
            if (customerAreaEoMap.isEmpty() || !customerAreaEoMap.containsKey(name)) {
                CustomerAreaEo addAreaEo = new CustomerAreaEo();
                String code = IdUtil.fastSimpleUUID();
                addAreaEo.setCode(code);
                addAreaEo.setName(name);
                addAreaEo.setOrgInfoId(orgInfoId);
                addAreaEo.setSort(Integer.valueOf(1));
                addAreaEo.setInstanceId(areaExtReqDto.getInstanceId());
                addAreaEo.setTenantId(areaExtReqDto.getTenantId());
                if (i == 0) {
                    addAreaEo.setLevel(Integer.valueOf(i));
                    addAreaEo.setParentCode("0");
                    addAreaEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                    addAreaEo.setTopId(addAreaEo.getId());
                    parentCode = code;
                    topId = addAreaEo.getId();
                } else {
                    addAreaEo.setLevel(Integer.valueOf(i));
                    addAreaEo.setParentCode(parentCode);
                    addAreaEo.setTopId(topId);
                    parentCode = code;
                }
                this.customerAreaDas.insert((BaseEo)addAreaEo);
                areaDto = new SellerAreaDto();
                areaDto.setSellerId(areaExtReqDto.getSellerId());
                areaDto.setAreaCode(addAreaEo.getCode());
                areaDto.setAreaLevel(addAreaEo.getLevel() + "");
                sellerAreaDtoList.add(areaDto);
            } else {
                CustomerAreaEo editAreaEo = (CustomerAreaEo)customerAreaEoMap.get(name);
                Long oldTopId = editAreaEo.getTopId();
                editAreaEo.setInstanceId(areaExtReqDto.getInstanceId());
                editAreaEo.setTenantId(areaExtReqDto.getTenantId());
                if (i == 0) {
                    editAreaEo.setLevel(Integer.valueOf(i));
                    editAreaEo.setParentCode("0");
                    editAreaEo.setTopId(editAreaEo.getId());
                    parentCode = editAreaEo.getCode();
                    topId = editAreaEo.getId();
                } else {
                    editAreaEo.setLevel(Integer.valueOf(i));
                    editAreaEo.setParentCode(parentCode);
                    editAreaEo.setTopId(topId);
                    parentCode = editAreaEo.getCode();
                }
                areaDto = new SellerAreaDto();
                areaDto.setSellerId(areaExtReqDto.getSellerId());
                areaDto.setAreaCode(editAreaEo.getCode());
                areaDto.setAreaLevel(editAreaEo.getLevel() + "");
                sellerAreaDtoList.add(areaDto);
                CustomerAreaEo areaQueryEo = new CustomerAreaEo();
                areaQueryEo.setTopId(oldTopId);
                areaQueryEo.setOrgInfoId(editAreaEo.getOrgInfoId());
                List<CustomerAreaEo> topIdAreaList = this.customerAreaDas.select((BaseEo)areaQueryEo);
                topIdAreaList = topIdAreaList.stream().sorted(Comparator.comparing(StdCustomerAreaEo::getLevel)).collect(Collectors.toList());
                ArrayList childAllList = Lists.newArrayList();
                this.doChildAreaList(topIdAreaList, childAllList, editAreaEo.getCode());
                Map<String, List<CustomerAreaEo>> childAreaGroupMap = childAllList.stream().collect(Collectors.groupingBy(StdCustomerAreaEo::getParentCode));
                for (List<CustomerAreaEo> areaEos : childAreaGroupMap.values()) {
                    int level = i + 1;
                    for (CustomerAreaEo customerAreaEo : areaEos) {
                        customerAreaEo.setTopId(topId);
                        customerAreaEo.setLevel(Integer.valueOf(level));
                        this.customerAreaDas.update((BaseEo)customerAreaEo);
                        SellerAreaDto childAreaDto = new SellerAreaDto();
                        childAreaDto.setSellerId(areaExtReqDto.getSellerId());
                        childAreaDto.setAreaCode(customerAreaEo.getCode());
                        childAreaDto.setAreaLevel(customerAreaEo.getLevel() + "");
                        childAreaDto.setInstanceId(customerAreaEo.getInstanceId());
                        childAreaDto.setTenantId(customerAreaEo.getTenantId());
                        sellerAreaDtoList.add(areaDto);
                    }
                }
                this.customerAreaDas.update((BaseEo)editAreaEo);
            }
            ++i;
        }
        if (CollectionUtils.isNotEmpty((Collection)sellerAreaDtoList)) {
            this.sellerExpandApi.updateSellerAreaBatch((List)sellerAreaDtoList);
        }
    }

    private boolean doChildAreaList(List<CustomerAreaEo> topIdAreaList, List<CustomerAreaEo> childAllList, String code) {
        List childList = topIdAreaList.stream().filter(dto -> dto.getParentCode().equals(code)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(childList)) {
            return true;
        }
        childAllList.addAll(childList);
        for (CustomerAreaEo customerAreaEo : childList) {
            boolean flag = this.doChildAreaList(topIdAreaList, childAllList, customerAreaEo.getCode());
            if (!flag) continue;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public CustomerAreaExtExportRespDto importCustomerArea(String url) {
        Mutex importCustomerArea = this.lockService.lock("importCustomerArea", url);
        try {
            CustomerAreaExtExportRespDto customerAreaExtExportRespDto = this.getCustomerAreaExtExportRespDto(url);
            return customerAreaExtExportRespDto;
        }
        finally {
            Optional.ofNullable(importCustomerArea).ifPresent(r -> this.lockService.unlock(importCustomerArea));
        }
    }

    @NotNull
    private CustomerAreaExtExportRespDto getCustomerAreaExtExportRespDto(String url) {
        List customerAreaEoList;
        List customerAreaEoList2;
        List importDtos;
        CustomerAreaExtExportRespDto exportRespDto = new CustomerAreaExtExportRespDto();
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        try {
            URL u = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            InputStream is = conn.getInputStream();
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel(is, 0, 1, CustomerAreaImportDto.class);
            importDtos = objectExcelImportResult.getList();
            importDtos = BeanPropertyNullUtil.getAllFieldNullList((List)importDtos);
        }
        catch (Exception e) {
            throw new BizException("\u5bfc\u5165\u5ba2\u6237\u533a\u57df\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        this.logger.info("\u5bfc\u5165\u7684\u6570\u636e==>{}", (Object)JSONObject.toJSONString((Object)importDtos));
        if (CollectionUtils.isEmpty((Collection)importDtos)) {
            throw new BizException("\u5bfc\u5165\u7684\u8868\u683c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8868\u683c\u540e\u91cd\u65b0\u5bfc\u5165");
        }
        List oneAreaNameList = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getOneAreaName())).map(CustomerAreaImportDto::getOneAreaName).distinct().collect(Collectors.toList());
        ArrayList oneAreaEos = CollectionUtils.isEmpty(oneAreaNameList) ? Lists.newArrayList() : ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerAreaDas.filter().in((Object)"name", oneAreaNameList)).eq((Object)"org_info_id", (Object)organizationId)).list();
        Map<Object, Object> oneAreaEoMap = Maps.newHashMap();
        if (CollUtil.isNotEmpty((Collection)oneAreaEos)) {
            oneAreaEoMap = oneAreaEos.stream().collect(Collectors.toMap(StdCustomerAreaEo::getName, Function.identity(), (v1, v2) -> v1));
        }
        List twoAreaNameList = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getTwoAreaName())).map(CustomerAreaImportDto::getTwoAreaName).distinct().collect(Collectors.toList());
        Map<Object, Object> towAreaEoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(twoAreaNameList) && CollUtil.isNotEmpty((Collection)(customerAreaEoList2 = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerAreaDas.filter().in((Object)"name", twoAreaNameList)).eq((Object)"org_info_id", (Object)organizationId)).list()))) {
            towAreaEoMap = customerAreaEoList2.stream().collect(Collectors.toMap(StdCustomerAreaEo::getName, Function.identity(), (v1, v2) -> v1));
        }
        List threeAreaNameList = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getThreeAreaName())).map(CustomerAreaImportDto::getThreeAreaName).distinct().collect(Collectors.toList());
        Map<Object, Object> threeAreaEoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(threeAreaNameList) && CollUtil.isNotEmpty((Collection)(customerAreaEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerAreaDas.filter().in((Object)"name", threeAreaNameList)).eq((Object)"org_info_id", (Object)organizationId)).list()))) {
            threeAreaEoMap = customerAreaEoList.stream().collect(Collectors.toMap(StdCustomerAreaEo::getName, Function.identity(), (v1, v2) -> v1));
        }
        HashMap oneToTwoAreaMap = new HashMap();
        HashMap twoToThreeAreaMap = new HashMap();
        HashSet<String> fullPathSet = new HashSet<String>();
        HashMap<String, Boolean> existingFullPathMap = new HashMap<String, Boolean>();
        if (CollUtil.isNotEmpty((Collection)oneAreaEos)) {
            for (CustomerAreaEo oneArea : oneAreaEos) {
                List twoAreas = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerAreaDas.filter().eq((Object)"parent_code", (Object)oneArea.getCode())).eq((Object)"org_info_id", (Object)organizationId)).list();
                if (CollUtil.isEmpty((Collection)twoAreas)) {
                    existingFullPathMap.put(oneArea.getName(), true);
                    continue;
                }
                for (CustomerAreaEo twoArea : twoAreas) {
                    existingFullPathMap.put(oneArea.getName() + "/" + twoArea.getName(), true);
                    List threeAreas = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerAreaDas.filter().eq((Object)"parent_code", (Object)twoArea.getCode())).eq((Object)"org_info_id", (Object)organizationId)).list();
                    if (!CollUtil.isNotEmpty((Collection)threeAreas)) continue;
                    for (CustomerAreaEo threeArea : threeAreas) {
                        existingFullPathMap.put(oneArea.getName() + "/" + twoArea.getName() + "/" + threeArea.getName(), true);
                    }
                }
            }
        }
        ArrayList successList = Lists.newArrayList();
        ArrayList errorList = Lists.newArrayList();
        Long successNum = 0L;
        for (CustomerAreaImportDto importDto : importDtos) {
            try {
                CustomerAreaEo parentAreaEo;
                boolean hasConflict;
                if (StringUtils.isEmpty((CharSequence)importDto.getOneAreaName())) {
                    importDto.setFailMsg("\u4e00\u7ea7\u533a\u57df\u4e3a\u7a7a");
                    errorList.add(importDto);
                    continue;
                }
                String oneAreaName = importDto.getOneAreaName();
                String twoAreaName = importDto.getTwoAreaName();
                String threeAreaName = importDto.getThreeAreaName();
                String fullPath = oneAreaName;
                if (StringUtils.isNotEmpty((CharSequence)twoAreaName)) {
                    fullPath = fullPath + "/" + twoAreaName;
                    if (StringUtils.isNotEmpty((CharSequence)threeAreaName)) {
                        fullPath = fullPath + "/" + threeAreaName;
                    }
                }
                if (fullPathSet.contains(fullPath)) {
                    importDto.setFailMsg("\u5bfc\u5165\u6587\u4ef6\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u533a\u57df\u8def\u5f84");
                    errorList.add(importDto);
                    continue;
                }
                if (existingFullPathMap.containsKey(fullPath)) {
                    importDto.setFailMsg("\u8be5\u533a\u57df\u8def\u5f84\u5df2\u5b58\u5728\u4e8e\u7cfb\u7edf\u4e2d");
                    errorList.add(importDto);
                    continue;
                }
                fullPathSet.add(fullPath);
                if (StringUtils.isNotEmpty((CharSequence)threeAreaName) && StringUtils.isEmpty((CharSequence)twoAreaName)) {
                    importDto.setFailMsg("\u5b58\u5728\u4e09\u7ea7\u533a\u57df\u4f46\u4e8c\u7ea7\u533a\u57df\u4e3a\u7a7a");
                    errorList.add(importDto);
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)twoAreaName)) {
                    if (!oneToTwoAreaMap.containsKey(oneAreaName)) {
                        oneToTwoAreaMap.put(oneAreaName, new HashSet());
                    }
                    if (((Set)oneToTwoAreaMap.get(oneAreaName)).contains(twoAreaName)) {
                        if (StringUtils.isNotEmpty((CharSequence)threeAreaName)) {
                            if (!twoToThreeAreaMap.containsKey(twoAreaName)) {
                                twoToThreeAreaMap.put(twoAreaName, new HashSet());
                            }
                            if (((Set)twoToThreeAreaMap.get(twoAreaName)).contains(threeAreaName)) {
                                importDto.setFailMsg("\u540c\u4e00\u4e8c\u7ea7\u533a\u57df\u4e0b\u5b58\u5728\u91cd\u590d\u7684\u4e09\u7ea7\u533a\u57df");
                                errorList.add(importDto);
                                continue;
                            }
                            ((Set)twoToThreeAreaMap.get(twoAreaName)).add(threeAreaName);
                        }
                    } else {
                        ((Set)oneToTwoAreaMap.get(oneAreaName)).add(twoAreaName);
                        if (StringUtils.isNotEmpty((CharSequence)threeAreaName)) {
                            if (!twoToThreeAreaMap.containsKey(twoAreaName)) {
                                twoToThreeAreaMap.put(twoAreaName, new HashSet());
                            }
                            ((Set)twoToThreeAreaMap.get(twoAreaName)).add(threeAreaName);
                        }
                    }
                }
                CustomerAreaEo oneAreaEo = null;
                if (!oneAreaEoMap.containsKey(oneAreaName)) {
                    oneAreaEo = new CustomerAreaEo();
                    oneAreaEo.setLevel(Integer.valueOf(0));
                    oneAreaEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                    oneAreaEo.setTopId(oneAreaEo.getId());
                    oneAreaEo.setCode(UUID.randomUUID().toString().replace("-", ""));
                    oneAreaEo.setParentCode("0");
                    oneAreaEo.setName(oneAreaName);
                    oneAreaEo.setOrgInfoId(Long.valueOf(organizationId));
                    oneAreaEo.setSort(Integer.valueOf(1));
                    successList.add(oneAreaEo);
                    oneAreaEoMap.put(oneAreaName, oneAreaEo);
                } else {
                    oneAreaEo = (CustomerAreaEo)oneAreaEoMap.get(oneAreaName);
                }
                CustomerAreaEo twoAreaEo = null;
                if (StringUtils.isNotEmpty((CharSequence)twoAreaName)) {
                    String twoFullPath = oneAreaName + "/" + twoAreaName;
                    hasConflict = false;
                    if (towAreaEoMap.containsKey(twoAreaName)) {
                        CustomerAreaEo existingTwoArea = (CustomerAreaEo)towAreaEoMap.get(twoAreaName);
                        parentAreaEo = null;
                        if (!"0".equals(existingTwoArea.getParentCode())) {
                            parentAreaEo = (CustomerAreaEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerAreaDas.filter().eq((Object)"code", (Object)existingTwoArea.getParentCode())).eq((Object)"org_info_id", (Object)organizationId)).one();
                        }
                        if (parentAreaEo != null && !parentAreaEo.getName().equals(oneAreaName)) {
                            hasConflict = true;
                        }
                        if (hasConflict || !existingTwoArea.getParentCode().equals(oneAreaEo.getCode())) {
                            importDto.setFailMsg("\u4e8c\u7ea7\u533a\u57df'" + twoAreaName + "'\u5df2\u5b58\u5728\u4e8e\u5176\u4ed6\u4e00\u7ea7\u533a\u57df\u4e0b");
                            errorList.add(importDto);
                            continue;
                        }
                        twoAreaEo = existingTwoArea;
                    } else {
                        twoAreaEo = new CustomerAreaEo();
                        twoAreaEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                        twoAreaEo.setTopId(oneAreaEo.getId());
                        twoAreaEo.setCode(UUID.randomUUID().toString().replace("-", ""));
                        twoAreaEo.setParentCode(oneAreaEo.getCode());
                        twoAreaEo.setName(twoAreaName);
                        twoAreaEo.setLevel(Integer.valueOf(1));
                        twoAreaEo.setOrgInfoId(Long.valueOf(organizationId));
                        twoAreaEo.setSort(Integer.valueOf(1));
                        successList.add(twoAreaEo);
                        towAreaEoMap.put(twoAreaName, twoAreaEo);
                        existingFullPathMap.put(twoFullPath, true);
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)threeAreaName) && twoAreaEo != null) {
                    String threeFullPath = oneAreaName + "/" + twoAreaName + "/" + threeAreaName;
                    hasConflict = false;
                    if (threeAreaEoMap.containsKey(threeAreaName)) {
                        CustomerAreaEo existingThreeArea = (CustomerAreaEo)threeAreaEoMap.get(threeAreaName);
                        parentAreaEo = null;
                        if (existingThreeArea.getParentCode() != null) {
                            parentAreaEo = (CustomerAreaEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerAreaDas.filter().eq((Object)"code", (Object)existingThreeArea.getParentCode())).eq((Object)"org_info_id", (Object)organizationId)).one();
                        }
                        if (parentAreaEo != null && !parentAreaEo.getName().equals(twoAreaName)) {
                            hasConflict = true;
                        }
                        if (hasConflict || !existingThreeArea.getParentCode().equals(twoAreaEo.getCode())) {
                            importDto.setFailMsg("\u4e09\u7ea7\u533a\u57df'" + threeAreaName + "'\u5df2\u5b58\u5728\u4e8e\u5176\u4ed6\u4e8c\u7ea7\u533a\u57df\u4e0b");
                            errorList.add(importDto);
                            continue;
                        }
                    } else {
                        CustomerAreaEo threeAreaEo = new CustomerAreaEo();
                        threeAreaEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                        threeAreaEo.setTopId(oneAreaEo.getId());
                        threeAreaEo.setCode(UUID.randomUUID().toString().replace("-", ""));
                        threeAreaEo.setParentCode(twoAreaEo.getCode());
                        threeAreaEo.setName(threeAreaName);
                        threeAreaEo.setLevel(Integer.valueOf(2));
                        threeAreaEo.setOrgInfoId(Long.valueOf(organizationId));
                        threeAreaEo.setSort(Integer.valueOf(1));
                        successList.add(threeAreaEo);
                        threeAreaEoMap.put(threeAreaName, threeAreaEo);
                        existingFullPathMap.put(threeFullPath, true);
                    }
                }
                Long l = successNum;
                Long l2 = successNum = Long.valueOf(successNum + 1L);
            }
            catch (Exception e) {
                this.logger.error("\u5904\u7406\u5bfc\u5165\u533a\u57df\u5f02\u5e38", (Throwable)e);
                importDto.setFailMsg("\u5904\u7406\u5f02\u5e38: " + e.getMessage());
                errorList.add(importDto);
            }
        }
        exportRespDto.setFailNum(Long.valueOf(errorList.size()));
        exportRespDto.setSuccessNum(successNum);
        exportRespDto.setTotal(Long.valueOf(importDtos.size()));
        if (CollectionUtil.isNotEmpty((Collection)successList)) {
            this.customerAreaDas.insertBatch((List)successList);
        }
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            String title = "\u5bfc\u5165\u5ba2\u6236\u533a\u57df\u5931\u8d25\u6587\u4ef6";
            String fileName = title + System.currentTimeMillis();
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(errorList, CustomerAreaImportDto.class, title, fileName, "xls");
                exportRespDto.setFailFileUrl(exportUrl);
                exportRespDto.setFailReason(errorList.stream().map(CustomerAreaImportDto::getFailMsg).collect(Collectors.joining(",")));
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51fa\u5931\u8d25\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
                throw new BizException("\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        return exportRespDto;
    }
}

